/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.wdr.Logger;
import com.sun.wbem.wdr.NativeDomainRetriever;
import com.sun.wbem.wdr.ResourceMessage;
import com.sun.wbem.wdr.SGSNMP;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.management.snmp.SnmpStatusException;

class SGDomain
extends Logger
implements NativeDomainRetriever {
    protected static final int m_MAX_NUMBER_OF_BOARDS = 10;
    public static final int m_MAX_NUMBER_SGDOMAINS = 4;
    public static final int m_CPU_BOARD = 3;
    public static final int m_IO_BOARD = 4;
    public static final int m_CPUWIB_BOARD = 5;
    public static final int m_IOWIB_BOARD = 6;
    public static final int m_MAX_SB_BOARD = 5;
    public static final int m_MAX_IB_BOARD = 9;
    protected static final int m_SB_BOARD_BASE = 400;
    protected static final int m_IB_BOARD_BASE = 500;
    protected static final int m_ISOLATED_DOMAIN = 1;
    protected static final int m_SLOTSTATE_UNKNOWN = 1;
    protected int m_Id;
    protected int[] m_BoardRelationship;
    static final int m_BOARD_NOT_AVAILABLE = 1;
    static final int m_BOARD_AVAILABLE = 2;
    static final int m_BOARD_ASSIGNED = 3;
    static final int m_BOARD_ACTIVE = 4;
    protected int m_KeyswitchPosition;
    protected int m_State;
    protected static final String[] keyswitchPositionToString = new String[]{"0", "Unknown", "Off", "Standby", "On", "Diag", "Secure", "Off To Standby", "Off To On", "Off To Diag", "Off To Secure", "Standby To Off", "Active To Off", "Active To Standby", "Reboot To On", "Reboot To Diag", "Reboot To Secure"};
    protected static final String[] stateToString = new String[]{"0", "Unknown", "Running Post", "Standby", "Active", "Powered Off", "Domain Idle", "Running OBP", "Booting", "Running Solaris", "Halted", "Reset", "Panic", "Debugger", "Hang Detected"};
    protected static final char[] domainNumberToLetter = new char[]{'A', 'B', 'C', 'D'};
    protected static SGSNMP m_SGSNMP = null;
    private static final String[] boardIndexToSlotID = new String[]{"SB0", "SB1", "SB2", "SB3", "SB4", "SB5", "IB6", "IB7", "IB8", "IB9"};

    SGDomain() throws CIMException {
        if (m_SGSNMP == null) {
            try {
                m_SGSNMP = new SGSNMP();
            }
            catch (UnknownHostException uhe) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)ResourceMessage.getMsg("WDR.unknownHost", new Object[]{uhe.getLocalizedMessage()}));
            }
            catch (SnmpStatusException e) {
                throw new CIMException("CIM_ERR_FAILED", (Object)ResourceMessage.getMsg("WDR.snmpFailedInSGDomain", new Object[]{e.getLocalizedMessage()}));
            }
        }
        this.m_BoardRelationship = new int[10];
    }

    public int[] getBoardRelationship() {
        return this.m_BoardRelationship;
    }

    public int getId() {
        return this.m_Id;
    }

    public int getKeyswitchPosition() {
        return this.m_KeyswitchPosition;
    }

    public boolean getResource() throws CIMException {
        return this.getResource(this.m_Id);
    }

    public boolean getResource(int Id) throws CIMException {
        StringBuffer errorMessage = new StringBuffer();
        if (Id < 0 || Id >= 4) {
            Logger.logErr("getResource called with invalid Id " + Id);
            return false;
        }
        this.setId(Id);
        try {
            int i = m_SGSNMP.searchForDomainMibItemInt(Id, "1.3.6.1.4.1.42.2.70.12.1.1.1", errorMessage);
            if (i == -1 || errorMessage.length() != 0) {
                Logger.logErr("searchForDomainMibItemInt(" + Id + ", domainIndex) failed" + " for getResource Id " + Id);
                if (errorMessage.length() != 0) {
                    Logger.logErr("Error: " + errorMessage);
                }
                return false;
            }
            int r = m_SGSNMP.getSerengetiMibItemInt(i, "1.3.6.1.4.1.42.2.70.12.1.1.14", errorMessage);
            if (r == -1 || errorMessage.length() != 0) {
                Logger.logErr("getSerengetiMibItemInt(" + i + ", domainKeyswitch) failed" + " for getResource Id " + Id);
                if (errorMessage.length() != 0) {
                    Logger.logErr("Error: " + errorMessage);
                }
                return false;
            }
            this.m_KeyswitchPosition = r;
            int aclSet = m_SGSNMP.getDomainAclSet(i, errorMessage);
            if (aclSet == -1 || errorMessage.length() != 0) {
                Logger.logErr("getDomainAclSet failed for MIB Index " + i + " and getResource Id " + Id);
                if (errorMessage.length() != 0) {
                    Logger.logErr("Error: " + errorMessage);
                }
                return false;
            }
            boolean b = this.setDomainBoardsInAcl(aclSet);
            if (!b) {
                Logger.logErr("setDomainBoardsInAcl failed for getResource Id " + Id);
                if (errorMessage.length() != 0) {
                    Logger.logErr("Error: " + errorMessage);
                }
                return false;
            }
            r = m_SGSNMP.getSerengetiMibItemInt(i, "1.3.6.1.4.1.42.2.70.12.1.1.9", errorMessage);
            if (r == -1 || errorMessage.length() != 0) {
                Logger.logErr("getSerengetiMibItemInt(" + i + ", domainStatus) failed for" + " getResource");
                if (errorMessage.length() != 0) {
                    Logger.logErr("Error: " + errorMessage);
                }
                return false;
            }
            this.m_State = r;
        }
        catch (SnmpStatusException sse) {
            throw new CIMException("CIM_ERR_FAILED", (Object)ResourceMessage.getMsg("WDR.snmpGetFailed", new Object[]{new Integer(this.m_Id), sse.getLocalizedMessage()}));
        }
        return true;
    }

    public Vector getResources() throws CIMException {
        Vector<SGDomain> v = new Vector<SGDomain>(4);
        SGDomain[] domains = new SGDomain[]{null, null, null, null};
        int i = 0;
        while (i < 4) {
            SGDomain d = domains[i];
            if (d == null && !(d = new SGDomain()).getResource(i)) {
                d = null;
            } else {
                v.add(d);
            }
            ++i;
        }
        return v;
    }

    public int getState() {
        return this.m_State;
    }

    protected String intArrayToString(int[] intArray) {
        String intArrayString = new String();
        int i = 0;
        while (i < intArray.length - 1) {
            intArrayString = String.valueOf(intArrayString) + intArray[i] + " ";
            ++i;
        }
        intArrayString = String.valueOf(intArrayString) + intArray[i];
        return intArrayString;
    }

    public void setBoardRelationship(int[] boardRelationship) {
        this.m_BoardRelationship = boardRelationship;
    }

    private boolean setDomainBoardsInAcl(int domainAclSet) throws CIMException {
        int[] toRelationship = new int[]{2, 2, 2, 3, 4};
        StringBuffer errorMessage = new StringBuffer();
        Logger.logDebug("domainAclSet = " + Integer.toHexString(domainAclSet));
        try {
            this.m_BoardRelationship = new int[10];
            int brd = 0;
            while (brd < 10) {
                int inst = brd <= 5 ? brd + 400 : brd + 500;
                int slotDomain = m_SGSNMP.getSerengetiMibItemInt(inst, "1.3.6.1.4.1.42.2.70.2.1.1.8.0", errorMessage);
                if (slotDomain - 2 == this.m_Id) {
                    int slotState = m_SGSNMP.getSerengetiMibItemInt(inst, "1.3.6.1.4.1.42.2.70.2.1.1.5.0", errorMessage);
                    if (slotState != -1 && errorMessage.length() == 0) {
                        this.m_BoardRelationship[brd] = toRelationship[slotState];
                    } else {
                        this.m_BoardRelationship[brd] = 3;
                        if (errorMessage.length() != 0) {
                            Logger.logErr("getSerengetiMibItemInt(" + inst + ", slotState0) failed for " + "setDomainBoardsInAcl");
                            Logger.logErr("Error: " + errorMessage);
                        }
                    }
                } else {
                    this.m_BoardRelationship[brd] = (domainAclSet & 1) != 0 ? 2 : 1;
                }
                domainAclSet >>= 1;
                ++brd;
            }
        }
        catch (SnmpStatusException sse) {
            throw new CIMException("CIM_ERR_FAILED", (Object)ResourceMessage.getMsg("WDR.snmpGetFailed", new Object[]{new Integer(this.m_Id), sse.getLocalizedMessage()}));
        }
        return true;
    }

    public void setId(int Id) {
        if (Id < 0 || Id >= 4) {
            Logger.logErr("setId called with invalid Id " + Id);
            return;
        }
        this.m_Id = Id;
    }

    public void setKeyswitchPosition(int keyswitchPosition) {
        this.m_KeyswitchPosition = keyswitchPosition;
    }

    public void setState(int state) {
        this.m_State = state;
    }

    private static int slotIdToBoardIndex(String slotId) {
        int boardInstance = -1;
        try {
            boardInstance = Integer.parseInt(slotId.substring(2));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        String slotIdPrefix = slotId.substring(0, 2);
        if (slotIdPrefix.equals("SB")) {
            if (boardInstance < 0 || boardInstance > 5) {
                return -1;
            }
        } else if (slotIdPrefix.equals("IB")) {
            if (boardInstance < 6 || boardInstance > 9) {
                return -1;
            }
        } else {
            return -1;
        }
        return boardInstance;
    }

    public String toString() {
        String keyswitchPositionString = "(undefined)";
        String stateString = "(undefined)";
        if (this.m_KeyswitchPosition > 0 && this.m_KeyswitchPosition < keyswitchPositionToString.length) {
            keyswitchPositionString = keyswitchPositionToString[this.m_KeyswitchPosition];
        }
        if (this.m_State > 0 && this.m_State < stateToString.length) {
            stateString = stateToString[this.m_State];
        }
        String str = "\nSGDomain:\n-----------------\nId =                " + this.m_Id + "\n" + "BoardRelationship = " + this.intArrayToString(this.m_BoardRelationship) + " (1=not,2=available,3=assigned," + "4=active)\n" + "KeyswitchPosition = " + keyswitchPositionString + " (" + this.m_KeyswitchPosition + ")\n" + "State =             " + stateString + " (" + this.m_State + ")\n" + "\n";
        return str;
    }
}

