/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMDataType;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.wdr.AttachmentPoint;
import com.sun.wbem.wdr.Logger;
import com.sun.wbem.wdr.ResourceProvider;
import com.sun.wbem.wdr.SGDomain;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class SGDomainProvider
extends ResourceProvider {
    protected String m_ProviderClass = this.getClass().getName();

    public SGDomainProvider() {
        Logger.logDebug(String.valueOf(this.m_ProviderClass) + " constructor");
    }

    private void copyKeys(CIMObjectPath op, SGDomain domain) {
        CIMProperty property = (CIMProperty)op.getKeys().elementAt(0);
        CIMValue value = property.getValue();
        UnsignedInt32 domainId = (UnsignedInt32)value.getValue();
        domain.setId(domainId.intValue());
    }

    public Vector enumInstances(CIMObjectPath op, boolean deep, CIMClass cc) throws CIMException {
        Logger.logDebug("enumInstances called with out localOnly");
        Logger.logDebug(" ObjectPath - " + op);
        Logger.logDebug("Deep - " + deep);
        Logger.logDebug("Cc - " + cc.getName());
        Vector<CIMObjectPath> copVector = new Vector<CIMObjectPath>();
        Vector resVector = new Vector();
        CIMValue providerCls = cc.getQualifier("Provider").getValue();
        if (providerCls.contains((Object)this.m_ProviderClass)) {
            SGDomain domain = new SGDomain();
            resVector = domain.getResources();
            Iterator resIter = ((AbstractList)resVector).iterator();
            domain = null;
            while (resIter.hasNext()) {
                domain = (SGDomain)resIter.next();
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                cop.addKey("Id", new CIMValue((Object)new UnsignedInt32((long)domain.getId())));
                copVector.add(cop);
            }
            Logger.logDebug("Number of domains - " + copVector.size());
        } else {
            Logger.logDebug("Unmatch provider class.");
        }
        return copVector;
    }

    public Vector enumInstances(CIMObjectPath op, boolean deep, CIMClass cc, boolean localOnly) throws CIMException {
        Logger.logDebug("enumInstances called with localOnly");
        Logger.logDebug(" ObjectPath - " + op);
        Logger.logDebug("Deep - " + deep);
        Logger.logDebug("Cc - " + cc.getName());
        Vector<CIMInstance> instVector = new Vector<CIMInstance>();
        Vector resVector = new Vector();
        CIMValue providerCls = cc.getQualifier("Provider").getValue();
        if (providerCls.contains((Object)this.m_ProviderClass)) {
            SGDomain domain = new SGDomain();
            resVector = domain.getResources();
            Iterator resIter = ((AbstractList)resVector).iterator();
            domain = null;
            CIMInstance inst = null;
            while (resIter.hasNext()) {
                domain = (SGDomain)resIter.next();
                inst = cc.newInstance();
                this.updateInstance(cc, inst, domain);
                if (localOnly) {
                    inst = inst.localElements();
                }
                instVector.add(inst);
            }
            Logger.logDebug("Number of domains - " + instVector.size());
        } else {
            Logger.logErr("Unmatched provider class.");
        }
        return instVector;
    }

    public CIMInstance getInstance(CIMObjectPath op, CIMClass cc, boolean localOnly) throws CIMException {
        this.validateDomainName(op);
        CIMInstance inst = null;
        Logger.logDebug(String.valueOf(this.m_ProviderClass) + ".getInstance called");
        Logger.logDebug("Object - " + op);
        CIMValue providerCls = cc.getQualifier("Provider").getValue();
        if (providerCls.contains((Object)this.m_ProviderClass)) {
            SGDomain domain = new SGDomain();
            this.copyKeys(op, domain);
            if (!domain.getResource()) {
                Logger.logErr("getResource failed");
            } else {
                Logger.logDebug("Domain - " + domain.toString());
                inst = cc.newInstance();
                this.updateInstance(cc, inst, domain);
                if (localOnly) {
                    inst = inst.localElements();
                }
                Logger.logDebug("Updated inst - " + inst);
            }
        }
        return inst;
    }

    private Vector intArrayToVector(int[] intArray) {
        Vector<Integer> intVec = new Vector<Integer>(intArray.length);
        int i = 0;
        while (i < intArray.length) {
            intVec.add(new Integer(intArray[i]));
            ++i;
        }
        return intVec;
    }

    protected void updateInstance(CIMClass cc, CIMInstance inst, SGDomain domain) {
        Logger.logDebug("updateInstance(cc, inst, domain)");
        inst.setProperty("Id", new CIMValue((Object)new UnsignedInt32((long)domain.getId())));
        Logger.logDebug("setting BoardRelationship");
        Vector boardRelVec = this.intArrayToVector(domain.getBoardRelationship());
        CIMDataType cdt = new CIMDataType(19);
        Logger.logDebug("creating CIMValue");
        CIMValue cv = new CIMValue(boardRelVec, cdt);
        Logger.logDebug("cv.toMOF= " + cv.toMOF());
        Logger.logDebug("cv.getType().toMOF= " + cv.getType().toMOF());
        inst.setProperty("BoardRelationship", cv);
        inst.setProperty("KeyswitchPosition", new CIMValue((Object)new UnsignedInt32((long)domain.getKeyswitchPosition())));
        inst.setProperty("State", new CIMValue((Object)new UnsignedInt32((long)domain.getState())));
    }

    public void validateDomainName(CIMObjectPath op) throws CIMException {
        CIMProperty property = (CIMProperty)op.getKeys().elementAt(0);
        CIMValue value = property.getValue();
        int domainID = ((UnsignedInt32)value.getValue()).intValue();
        AttachmentPoint.validateDomainID(domainID);
    }
}

