/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.wdr.Logger;
import com.sun.wbem.wdr.ResourceMessage;
import com.sun.wbem.wdr.SMSEvent;
import java.util.StringTokenizer;

public class XCEvent
extends Logger
implements SMSEvent {
    protected int m_Source;
    protected int m_Code;
    protected int m_Priority;
    protected String m_Text;
    protected int m_TimeStamp;

    public XCEvent(String eventString) throws CIMException {
        Logger.logDebug(String.valueOf(this.getClass().getName()) + " constructor");
        this.parseEventString(eventString);
    }

    public int getCode() {
        return this.m_Code;
    }

    public int getPriority() {
        return this.m_Priority;
    }

    public int getSource() {
        return this.m_Source;
    }

    public String getText() {
        return this.m_Text;
    }

    public int getTimeStamp() {
        return this.m_TimeStamp;
    }

    protected void parseEventString(String eventString) throws CIMException {
        String delimiter = "|";
        boolean sourceFieldIndex = false;
        boolean codeFieldIndex = true;
        int priorityFieldIndex = 2;
        int textFieldIndex = 3;
        int timeStampFieldIndex = 4;
        int eventFieldCnt = 5;
        int i = 0;
        String[] fields = new String[5];
        StringTokenizer st = new StringTokenizer(eventString, "|");
        i = 0;
        while (i < 5 && st.hasMoreTokens()) {
            fields[i] = st.nextToken();
            ++i;
        }
        if (i < 5) {
            throw new CIMException(ResourceMessage.getMsg("WDR.malformedSMSEvent"));
        }
        this.m_Source = Integer.parseInt(fields[0]);
        this.m_Code = Integer.parseInt(fields[1]);
        this.m_Priority = Integer.parseInt(fields[2]);
        this.m_Text = fields[3];
        this.m_TimeStamp = Integer.parseInt(fields[4]);
    }

    public String toString() {
        String codeString;
        String sourceString;
        Logger.logDebug("m_Source = " + this.m_Source);
        Logger.logDebug("m_Code = " + this.m_Code);
        if (this.m_Source >= 3 && this.m_Source <= 5) {
            sourceString = SMSEvent.eventSources[this.m_Source];
            codeString = this.m_Code < SMSEvent.eventStrings[this.m_Source].length ? SMSEvent.eventStrings[this.m_Source][this.m_Code] : String.valueOf(this.m_Code);
        } else {
            sourceString = String.valueOf(this.m_Source);
            codeString = String.valueOf(this.m_Code);
        }
        String str = "\n" + this.getClass().getName() + ":\n" + "-----------------\n" + "source - " + sourceString + "\n" + "code - " + codeString + "\n" + "priority - " + this.m_Priority + "\n" + "text - " + this.m_Text + "\n" + "timestamp - " + this.m_TimeStamp + "\n";
        return str;
    }
}

