/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.query.SelectExp;
import com.sun.wbem.wdr.Logger;
import com.sun.wbem.wdr.ResourceMessage;
import com.sun.wbem.wdr.ResourceProvider;
import com.sun.wbem.wdr.XCEvent;
import com.sun.wbem.wdr.XCEventHandler;
import java.io.IOException;
import java.util.HashMap;

public class XCEventProvider
extends ResourceProvider {
    protected static String m_ProviderClass;
    protected static String m_NameSpace;
    protected static String[] m_EventNames;
    protected XCEventHandler m_EventHandler;
    protected int m_EventFlags;
    protected HashMap m_EventMap;

    static {
        m_EventNames = new String[]{"Solaris_WDRIndication", "Solaris_XCSystemBoardConfigChange", "Solaris_XCEnvironmentalIndication", "Solaris_XCComponentRemove", "Solaris_XCComponentInsert", "Solaris_XCBoardPowerOn", "Solaris_XCBoardPowerOff", "Solaris_XCDomainIndication", "Solaris_XCDomainConfigChange", "Solaris_XCDomainUp", "Solaris_XCDomainDown", "Solaris_XCDomainStop", "Solaris_XCDomainStateChange"};
    }

    public XCEventProvider() {
        Logger.logDebug(String.valueOf(m_ProviderClass) + " constructor");
        m_ProviderClass = this.getClass().getName();
        m_NameSpace = new CIMNameSpace().getNameSpace();
        this.m_EventHandler = null;
        this.m_EventFlags = 0;
        this.m_EventMap = new HashMap(m_EventNames.length * 2);
        int i = 0;
        int val = 1;
        while (i < m_EventNames.length) {
            this.m_EventMap.put(m_EventNames[i].toLowerCase(), new Integer(val));
            ++i;
            val = 2 * val;
        }
    }

    protected void activateEvent(String eventType) {
        this.m_EventFlags |= this.getEventFlag(eventType);
        Logger.logDebug("Provider m_EventFlags is " + this.m_EventFlags);
    }

    public void activateFilter(SelectExp filter, String eventType, CIMObjectPath classPath, boolean firstActivation) throws CIMException {
        Logger.logDebug("Activation called " + classPath);
        Logger.logDebug("firstActivation " + firstActivation);
        if (firstActivation) {
            Logger.logDebug("Ok start looking for " + eventType);
            this.activateEvent(eventType);
            if (this.m_EventHandler == null) {
                try {
                    this.m_EventHandler = XCEventHandler.getReference(this);
                    this.m_EventHandler.start();
                }
                catch (IOException ioe) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)ioe.getLocalizedMessage());
                }
            }
        }
    }

    public void authorizeFilter(SelectExp filter, String eventType, CIMObjectPath classPath, String owner) throws CIMException {
        Logger.logDebug("authorizeFilter " + filter + " " + eventType + " " + classPath + " " + owner);
    }

    protected void deActivateEvent(String eventType) {
        this.m_EventFlags -= this.getEventFlag(eventType);
        Logger.logDebug("Provider m_EventFlags is " + this.m_EventFlags);
    }

    public void deActivateFilter(SelectExp filter, String eventType, CIMObjectPath classPath, boolean lastActivation) throws CIMException {
        Logger.logDebug("Deactivation called " + classPath);
        Logger.logDebug("lastActivation " + lastActivation);
        if (lastActivation) {
            Logger.logDebug("Ok stop looking for " + eventType);
            this.deActivateEvent(eventType);
            if (this.m_EventFlags == 0 && this.m_EventHandler != null) {
                try {
                    this.m_EventHandler.terminate();
                    this.m_EventHandler = null;
                }
                catch (IOException ioe) {
                    Logger.logErr("Caught exception, " + ioe);
                    throw new CIMException("CIM_ERR_FAILED", (Object)ResourceMessage.getMsg("WDR.ioExceptionOnEFESocket"));
                }
            }
        }
    }

    public void deliverEvent(CIMInstance indicationInst) {
        this.m_Provider.deliverEvent(m_NameSpace, indicationInst);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String eventToIndication(XCEvent event) {
        String indicationName = null;
        int eventSource = event.getSource();
        int eventCode = event.getCode();
        switch (eventSource) {
            case 3: {
                switch (eventCode) {
                    case 0: {
                        return "Solaris_XCComponentInsert";
                    }
                    case 1: {
                        return "Solaris_XCComponentRemove";
                    }
                    case 2: {
                        return "Solaris_XCBoardPowerOn";
                    }
                    case 3: {
                        return "Solaris_XCBoardPowerOff";
                    }
                    default: {
                        return indicationName;
                    }
                }
            }
            case 4: {
                switch (eventCode) {
                    case 1: {
                        return "Solaris_XCDomainUp";
                    }
                    case 2: {
                        return "Solaris_XCDomainStateChange";
                    }
                    case 3: {
                        return "Solaris_XCDomainDown";
                    }
                    case 4: {
                        return "Solaris_XCDomainStop";
                    }
                    default: {
                        return indicationName;
                    }
                }
            }
            case 5: {
                if (eventCode >= 1 && eventCode <= 18) {
                    return "Solaris_XCDomainConfigChange";
                }
                if (eventCode < 19) return indicationName;
                if (eventCode > 54) return indicationName;
                return "Solaris_XCSystemBoardConfigChange";
            }
        }
        return indicationName;
    }

    protected int getEventFlag(String eventType) {
        Integer eventFlag = (Integer)this.m_EventMap.get(eventType);
        int flag = 0;
        if (eventFlag != null) {
            flag = eventFlag;
        }
        return flag;
    }

    protected boolean isAWDRIndication(String eventType) {
        boolean result = false;
        int i = 0;
        while (i < m_EventNames.length) {
            if (eventType.equalsIgnoreCase(m_EventNames[i])) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public boolean isActiveEvent(String eventType) {
        return (this.getEventFlag(eventType) & this.m_EventFlags) > 0;
    }

    public boolean mustPoll(SelectExp filter, String eventType, CIMObjectPath classPath) throws CIMException {
        Logger.logDebug("mustPoll" + filter + " " + eventType + " " + classPath);
        if (this.isAWDRIndication(eventType)) {
            return false;
        }
        throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)eventType);
    }

    public String toString() {
        return new String("\n" + this.getClass().getName() + ":\n" + "-----------------------------\n" + "activeEventsSet: 0x" + Integer.toHexString(this.m_EventFlags) + "cimom: " + this.m_Provider + "\n");
    }
}

