/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cluster.sccheck;

import com.sun.cluster.sccheck.Globals;
import com.sun.cluster.sccheck.I18n;
import com.sun.cluster.sccheck.Logger;
import com.sun.cluster.sccheck.ProgressListener;
import com.sun.cluster.sccheck.ProtocolException;
import com.sun.cluster.sccheck.SCException;
import com.sun.cluster.sccheck.Server;
import com.sun.cluster.sccheck.ServerProtocol;
import com.sun.cluster.sccheck.Session;
import com.sun.cluster.sccheck.WrapperException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class ServerThread
extends Thread
implements ProgressListener,
Globals {
    private Server server = null;
    private Vector serverProts = null;
    private Session session = null;
    private int version = 0;
    private Logger logger = Logger.getLogger();

    public ServerThread(Server server, Session session, int n, ServerProtocol serverProtocol) {
        this.logger.trace("ServerThread() -- ENTER -- ");
        this.server = server;
        this.version = n;
        this.session = session;
        this.serverProts = new Vector();
        this.addServerProtocol(serverProtocol);
        this.logger.trace("ServerThread() -- EXIT -- ");
    }

    public void addServerProtocol(ServerProtocol serverProtocol) {
        this.logger.info("ServerThread.addServerProtocol() adding sprot" + serverProtocol.getID());
        this.serverProts.addElement(serverProtocol);
    }

    public void postErrMsg(String string) {
        this.logger.trace("SccheckServerThread.postErrMsg(): " + string);
        this.sendError(string);
    }

    public void postProgress(int n, String string) {
        this.logger.trace("SccheckServerThread.postProgress(): " + string);
        this.sendProgress(n, string);
    }

    public void run() {
        this.logger.trace("ServerThread.run() -- ENTER -- ");
        try {
            this.logger.info("ServerThread.run() running SessionV" + this.version);
            switch (this.version) {
                case 1: {
                    this.session.runServer(this);
                    break;
                }
                default: {
                    String string = "Unsupported Session version: " + this.version;
                    this.logger.error("ServerThread.run(): run: " + string);
                    Object[] objectArray = new Object[]{new String(String.valueOf(this.version))};
                    String string2 = I18n.getLocalized("unsupportedSessionVersion", objectArray);
                    throw new SCException(string2);
                }
            }
        }
        catch (ProtocolException protocolException) {
            this.logger.error("ServerThread.run() ProtocolException: " + protocolException.getMessage());
            this.postErrMsg(protocolException.getMessage());
        }
        catch (WrapperException wrapperException) {
            this.logger.error("ServerThread.run() WrapperException: " + wrapperException.getMessage());
            this.postErrMsg(wrapperException.getMessage());
        }
        catch (SCException sCException) {
            this.logger.error("ServerThread.run() SCException: " + sCException.getMessage());
            this.postErrMsg(sCException.getMessage());
        }
        this.logger.trace("ServerThread.run() calling server.serverExit()");
        this.server.serverExit();
    }

    private void sendError(String string) {
        this.logger.info("ServerThread.sendError() sending msg: " + string);
        Iterator iterator = ((AbstractList)this.serverProts).iterator();
        ServerProtocol serverProtocol = null;
        while (iterator.hasNext()) {
            serverProtocol = (ServerProtocol)iterator.next();
            this.logger.info("ServerThread.sendError() passing msg to sprot" + serverProtocol.getID());
            try {
                serverProtocol.sendExecErrRun(string);
            }
            catch (IOException iOException) {
                this.logger.error("SccheckServerThread.sendError() ioex: " + iOException.getMessage());
                this.logger.trace("SccheckServerThread.sendError() removing sprot" + serverProtocol.getID());
                iterator.remove();
            }
        }
    }

    private void sendProgress(int n, String string) {
        this.logger.info("ServerThread.sendProgress(v level: " + n + ") " + "sending msg: " + string);
        Iterator iterator = ((AbstractList)this.serverProts).iterator();
        ServerProtocol serverProtocol = null;
        while (iterator.hasNext()) {
            serverProtocol = (ServerProtocol)iterator.next();
            this.logger.info("ServerThread.sendProgress() passing msg to sprot" + serverProtocol.getID());
            try {
                serverProtocol.sendProgress(n, string);
            }
            catch (IOException iOException) {
                this.logger.error("SccheckServerThread.sendProgress() ioex: " + iOException.getMessage());
                this.logger.trace("SccheckServerThread.sendProgress() removing sprot" + serverProtocol.getID());
                iterator.remove();
            }
        }
    }
}

