#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2002 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
# ident	"@(#)step4.pl	1.29	03/01/07 SMI"
#
# Installation page 4

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::Install;
use Sun::Solaris::Utils qw(gettext);

# Set constants
use constant TRUE          => 0;
use constant FALSE         => 1;

# Create the html query object
my $q = new Cluster::Cgi;

# Create a install object
my $install = new Cluster::Install;

# Get the list of nodes we're installing
my @nodelist = $install->get_nodelist($q);
my $clustersize = $#nodelist + 1;

# Set empty defaults
my ($solaris, $cdrom, $ds_cdrom_path, $patch);

# Verify the hostnames and install them in the /etc/hosts files on all nodes
my (@errors, @addr_list);

if ($q->param("install_nfs") eq "yes") {
    if ($q->param("nfs_address") eq "") {
	push @errors, gettext("NFS was selected to be installed, but no logical address was specified for it."); 
    } else {
	push @addr_list, $q->param("nfs_address");
    }
}
if ($q->param("install_apache") eq "yes") {
    if ($q->param("apache_address") eq "") {
	push @errors, gettext("Apache was selected to be installed, but no logical address was specified for it."); 
    } else {
	push @addr_list, $q->param("apache_address");
    }
}

# Check for identical addresses
if ($q->param("install_apache") eq "yes" &&
    $q->param("install_nfs") eq "yes") {
	if ($q->param("nfs_address") eq $q->param("apache_address")) {
		push @errors, gettext("Different logical addresses must be " .
			    "specified for the NFS logical hostname and the Apache " .
				      "shared address.");
	}
}

# Add the ipmp test addresses
if ($q->param("install_nfs") eq "yes" ||
    $q->param("install_apache") eq "yes") {
	for (my $i=0; $i<=$#nodelist; $i++) {
		my $j = $i+1;
		my $node = $nodelist[$i];
		if ($q->param("node_$j.testaddr") eq "") {
			push @errors, sprintf(gettext("An IPMP failover " .
		 	      "group test address must be entered for " .
			      "node %s."), $node); 
		} else {
			if ($install->member($q->param("node_$j.testaddr"),
					     @addr_list) != -1) {
				push @errors, sprintf(gettext("The " .
				      "hostname %s cannot be specified " .
				      "multiple times as a logical address " .
				      "and/or IPMP failover group test " .
				      "address."),
			              $q->param("node_$j.testaddr")); 
			 } else {
				 push @addr_list,
				      $q->param("node_$j.testaddr");
			 }
		}
	}
}

# Validate the hostnames and install them in the /etc/hosts files on all nodes
if ($#addr_list > -1) {
    foreach my $node ($install->get_nodelist($q)) {
	my @result = $install->verify_logical_addresses($node, @addr_list);
	
	if ($#result > -1) {
	    push @errors, @result;
	}
    }
}    

# If we found errors, print them
if ($#errors > -1) {
    # Start the html document
    $install->header($q, [gettext("Sun Cluster Installation"),
	"/cgi-bin/installation/step0.pl",
	gettext("Data Services (Step 5 of 8)")]);
    $install->start_message_table($q, "/images/error_32.gif",
	gettext("Error"), gettext("Incorrect Logical Address Configuration"),
	gettext("The following errors occurred when validating the logical address(es):"));

    foreach my $error (@errors) {
	print $q->start_b(), $error, $q->end_b(), $q->br();
    }

    $install->end_message_table($q);
    print $q->p({class => "action-window-normal-text"});
    print gettext("Make sure that the specified logical addresses are " .
	"correct, and they have either been configured into a nameservice " .
	"reachable from all nodes of the cluster, or have been entered into " .
	"the /etc/hosts file.");


    print $q->start_form();

    $install->start_button_table($q);

    print $q->button({ value   => gettext("  < Back  "),
		       onClick => "history.back()"
		       });
    $install->end_button_table($q, "cancel");

    print $q->end_form();
    
    # End the html document
    $install->footer($q);

    # Exit gracefully
    exit(0);
}

# Start the html document
$install->header($q, [gettext("Sun Cluster Installation"),
    "/cgi-bin/installation/step0.pl",
    gettext("Paths (Step 6 of 8)")]);
print $q->p({class => "action-window-normal-text"});

# Print the form
print gettext("Enter the paths to the required CDROM Images and the " .
    "patch directory.  All nodes of the cluster must be able to access " .
    "these paths.");
print $q->br(), $q->br();
print gettext("<B>Note</B>: If you plan to install Solaris and Sun Cluster " .
    "patches manually and do not want it to be done automatically by this " .
    "installer, leave the patch path empty below. However, you must " .
    "manually add any required Solaris");

# Print the correct name for SDS depending on the OS
if ($install->is_solaris8() == TRUE) {
	print gettext (", Sun Cluster, and Solstice DiskSuite");
} else {
	print gettext (" and Sun Cluster");
}

print gettext(" patches to all nodes of the cluster.  You will be reminded " .
	      "about manually adding patches before beginning installation.");

print $q->start_form({ action => '/cgi-bin/installation/patch_step1.pl' });
print $q->start_table({	CELLPADDING => 5,
			CELLSPACING => 0,
			CLASS => "action-table"});

if ($install->is_solaris8() == TRUE &&
    $q->param("install_sds") eq "yes") {
    print $q->start_Tr();
    print $q->start_td({ NOWRAP => undef});
    
    print $q->CGI::div({CLASS => "action-window-label-text"},
	gettext("Solaris CDROM Path:"));
    
    print $q->end_td();     
    print $q->start_td();
    
    print $q->textfield({ name    => 'solaris_cdrom_path', 
			  size    => 75,
			  default => $solaris
			  });
    
    print $q->end_td();     
    print $q->end_Tr();
}

print $q->start_Tr();
print $q->start_td({ NOWRAP => undef});
print $q->CGI::div({CLASS => "action-window-label-text"},
    gettext("Sun Cluster CDROM Path: "));
print $q->end_td();     

print $q->start_td();

print $q->textfield({ name    => 'cdrom_path', 
		      size    => 75,
		      default => $cdrom
		      });

print $q->end_td();     
print $q->end_Tr();

# If we're installing any dataservices, then the user must specify the path
# to the dataservices CD.
if ($q->param('install_nfs') eq 'yes' || 
    $q->param('install_apache') eq 'yes') {

	print $q->start_Tr();
	print $q->start_td({ NOWRAP => undef});
	print $q->CGI::div({CLASS => "action-window-label-text"},
	    gettext("Sun Cluster Agents CDROM Path: "));
	print $q->end_td();     

	print $q->start_td();

	print $q->textfield({ name    => 'ds_cdrom_path', 
		      size    => 75,
		      default => $ds_cdrom_path
		      });

	print $q->end_td();     
	print $q->end_Tr();
}

print $q->start_Tr();
print $q->start_td({ NOWRAP => undef});
print $q->CGI::div({CLASS => "action-window-label-text"},
    gettext("Patch Directory Path: "));
print $q->end_td();     

print $q->start_td();

print $q->textfield({ name    => 'patch_path', 
		      size    => 75,
		      default => $patch
		      });

print $q->end_td();     
print $q->end_Tr();

print $q->end_table();

# Print the hidden cluster fields
$q->print_hidden_cluster_fields();

$install->start_button_table($q);

print $q->button({ value   => gettext("  < Back  "),
		   onClick => "history.back()"
		   });


# Put spaces between the buttons
print "&nbsp;" ;

print $q->submit({ name  => 'submit_step_4',
		   value => gettext("  Next >  ")
		   });
$install->end_button_table($q, "cancel");

# End the form
print $q->end_form();

# End the html document
$install->footer($q);
