#!/usr/bin/perl -w
#
# Copyright 2001-2002 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident	"@(#)node_status.pl	1.7	03/02/26 SMI"
#
# Node status page
#

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::Node;
use Cluster::RBAC;
use Sun::Solaris::Utils qw(gettext);

# Create the cluster objects
my $q = new Cluster::Cgi;
my $rbac = new Cluster::RBAC;
my $node = new Cluster::Node;

# Set the page title
my $title = gettext("Nodes");

# Print the query header and make the page expire now
print $q->header(-expires => "now");

# Start the document
print $q->start_html({ TITLE => gettext("Node Status"),
		       STYLE  => { 'src' => '/css/clustmgr-style.css'},
		       CLASS  => "default-body",
		       ONUNLOAD => $q->unregister_jscript(),
		       SCRIPT => "top.helpMarker=\"node_status-top\"\n" .
				$q->yoke_jscript("n") .
    $q->refresh_jscript('content', 'ESC_cluster_node_state_change')
		       });

# Check for node read authorization
if (!$rbac->check_auth($CL_AUTH_NODE_READ)) {
	$rbac->auth_error($q, $title);
	exit;
}

##############################################################################
#
# Action Bar Table
#
##############################################################################

# Start the action bar table
$q->start_action_bar_table(gettext("Nodes"));

# Print the middle of the action table
$q->mid_action_bar_table();

# End the action bar table
$q->end_action_bar_table();

##############################################################################
#
# Status table for nodes
#
##############################################################################

# Print the node status table
$node->node_status_table($q);
