#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident	"@(#)rs_view.pl	1.10	03/02/26 SMI"
#
# View resources

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Rg;
use Cluster::Cgi;
use Cluster::RBAC;
use Sun::Solaris::Utils qw(gettext);

# Create the html query object
my $q = new Cluster::Cgi;

# Create a rg object
my $rg = new Cluster::Rg;

# Create the rbac object
my $rbac = new Cluster::RBAC;

# Get the parameters
my $rg_name = $q->param("rg");
my $rs_name = $q->param("rs");
my $view = $q->param("view");

# Set the page title
my $title = gettext("Resource Groups");

# Set views
my $rs_view = "/cgi-bin/rg/rs_view.pl?rs=$rs_name&rg=$rg_name",
my $rs_detailed_view = "/cgi-bin/rg/rs_view.pl?rs=$rs_name&rg=$rg_name&view=detailed",

# Print the query header and make the page expire now
print $q->header(-expires => "now");

# Start the document
print $q->start_html({ STYLE  => { 'src' => '/css/clustmgr-style.css'},
		       TITLE  => $title,
		       CLASS  => "default-body",
                       ONUNLOAD => $q->unregister_jscript(),
		       SCRIPT => "top.helpMarker=\"rs_view-top\"\n" . $q->jump_menu_jscript() . $q->yoke_jscript("rg-rs-$rs_name") .
$q->refresh_jscript('content', 'ESC_cluster_r_')
		       });

# Check for resource read authorization
if (!$rbac->check_auth($CL_AUTH_RESOURCE_READ)) {
	$rbac->auth_error($q, $title);
	exit;
}

# Start the action bar table
$q->start_action_bar_table(
		[$title, "/cgi-bin/rg/rg_view.pl",
		$rg_name, "/cgi-bin/rg/rg_view.pl?rg=$rg_name",
		$rs_name]);

# Create the view menu links
my @viewlinks = (gettext("General Properties Table"),
		 $rs_view,
		 gettext("Detailed Properties Table"),
		 $rs_detailed_view
		 );

# Default to the detailed view of that was selected
if (defined $view && $view eq "detailed") {
	$q->view_menu(\@viewlinks, $rs_detailed_view);
} else {
	$q->view_menu(\@viewlinks, $rs_view);
}

# Print the middle of the action table
$q->mid_action_bar_table();

# Load the help markers
my @helpMarkers = $rg->rg_action_helpMarkers();
$q->load_action_helpMarkers(\@helpMarkers);

# Get the common get of links for rg pages
my @links = $rg->rg_action_links("rs", $rs_name);

# Print the actions menu
$q->actions_menu(gettext("Actions Menu"), \@links);

# End the action bar table
$q->end_action_bar_table();

# Print the resource status table
$rg->resource_status_table($q, $rs_name, $rg_name);

# Print the resource properties table
$rg->resource_properties_table($q, $rs_name, $rg_name, $view);

# End the html document
$rg->footer($q);
