#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident	"@(#)iplanet.pl	1.15	03/02/25 SMI"
#
use lib '/opt/SUNWscvw/lib/perl';
use Socket;
use Cluster::common;
use Cluster::Common;
use strict;
use Sun::Solaris::Utils qw(gettext);

&do_page("Configure Sun ONE Web Server"); # gettext("Configure Sun ONE Web Server")
exit;

sub cmd_mainpage {
    my $i;
    &wizard_start;
    print $q->_script($q->yoke_jscript("c"));
    &getscrgconfig();
    if (! $errpos) {
	if (! &checktype("SUNW.iws")) {
		return;
	}
    }

    if (! &getlh("sa")) {
	return;
    }

    &action_table_start();

    if ($errpos == 2) {
	&errmsg();
    }
    if ($FORM{"aport"} eq "") {
	$FORM{"aport"} = &freeport(8888);
    }
    &action_table_row_start(gettext("Administrative Server Port:"));
    &input("aport", 8);
    &action_table_row_end();

    if ($errpos == 21) {
	&errmsg();
    }
    &action_table_row_start(gettext("Administrative Server Password:"));
    &password("nspassword");
    &action_table_supplement(
	gettext("(password must have at least 8 characters)"));
    &action_table_row_end();

    if ($errpos == 3) {
	&errmsg();
    }
    if ($FORM{"wport"} eq "") {
	if (!portinuse(80)) {
	    $FORM{"wport"} = 80;
	} else {
	    $FORM{"wport"} = &freeport(8080);
	}
    }
    &action_table_row_start(gettext("Web Server Port:"));
    &input("wport", 8);
    &action_table_row_end();

    if ($errpos == 4) {
	&errmsg();
    }
    &action_table_row_start(gettext("Source Directory For Sun ONE Installation"));
    &input("setupdir", 35);
    &action_table_row_end();

    if ($errpos == 5) {
	&errmsg();
    }
    if ($FORM{"loc"} eq "") {
	my $i;
	for ($i = ""; $i < 10; $i++) {
	    $FORM{"loc"} = &getglobal()."/nshttp$i";
	    if (! -d $FORM{"loc"}."/https-admserv" &&
		    ! -e $FORM{"loc"}."/setup/setup.inf") {
		last;
	    }
	}
    }

    &action_table_row_start(gettext("Installation Directory:"));
    &input("loc", 35);
    &action_table_row_end();

    if ($errpos == 6) {
	&errmsg();
    }
    if ($FORM{"root"} eq "") {
	$FORM{"root"} = $FORM{"loc"}."/docs";
    }
    &action_table_row_start(gettext("Root Directory For Web Pages:"));
    &input("root", 35);
    &action_table_supplement(gettext("(global directory recommended)"));
    &action_table_row_end();

    if ($errpos == 101) {
	&errmsg();
    }
    &action_table_row_start(gettext("Network Resource:"));
    &hostnameoption("sa");
    &action_table_row_end();

    if ($errpos == 102) {
	&errmsg();
    }
    &action_table_row_start(gettext("Resource Name:"));
    if ($FORM{"rs"} eq "" || $errpos == 102) {
	# Find a resource name that is not in use
	for ($i = 1; $i<10; $i++) {
	    $FORM{"rs"} = "sows-$i";
	    if (! defined $rsdesc{$FORM{"rs"}}) {
		last;
	    }
	    $FORM{"rs"} = "";
	}
    }
    &input("rs");
    &action_table_row_end();

    if ($errpos == 103) {
	&errmsg();
    }
    if ($FORM{"rg"} eq "" || $errpos == 103) {
	# Find a resource group name that is not in use
	for ($i = 1; $i<10; $i++) {
	    $FORM{"rg"} = "sows-rg-$i";
	    if (! defined $rgdesc{$FORM{"rg"}}) {
		last;
	    }
	    $FORM{"rg"} = "";
	}
    }

    &action_table_row_start(gettext("Resource Group Name:"));
    &input("rg");
    &action_table_supplement(gettext("(only used for shared address)"));
    &action_table_row_end();

    if ($FORM{"ns"} eq "") {
	# Determine which comes first in nsswitch.conf: nis or dns
	open(IN, "grep ^host: /etc/nsswitch.conf | ");
	$_ = <IN>;
	my $i1 = index($_, "nis");
	my $i2 = index($_, "dns");
	if ($i1 < $i2 || $i2 < 0) {
	    $FORM{"ns"} = "NIS";
	} else {
	    $FORM{"ns"} = "DNS";
	}
	close(IN);
    }
    &action_table_row_start(gettext("Name Service:"));
    print "<select name=\"ns\">\n";
    &option("ns", "DNS", "DNS");
    &option("ns", "NIS", "NIS");
    print "</select>\n";
    &action_table_supplement(gettext("(affects bind)"));
    &action_table_row_end();

    &action_table_row_start(gettext("Dots Demo:"));
    &checkbox("dots", "active", "", "checked");
    print "Install &quot;dots&quot; demo";
    &action_table_row_end();
    &action_table_end();

    &submit_table_start();
    &submit("cmd_setup", gettext("Continue"));
    &submit_table_end();
    &wizard_end();
}

# Next part of configuration
sub cmd_setup {
    &wizard_start;
    print $q->_script($q->yoke_jscript("c"));
    &getscrgconfig();
    &getnodes();

    if (&isglobal($FORM{"loc"}) == 0) {
	# Make sure ports are free on all nodes, since we install on all
	my $i;
	for ($i = 0; $i <= $#nodes; $i++) {
	    &validateport("cmd_mainpage", "aport", 2, $nodes[$i]);
	    &validateport("cmd_mainpage", "wport", 3, $nodes[$i]);
	}
    } elsif (&isglobal($FORM{"loc"}) == 1) {
	&validateport("cmd_mainpage", "aport", 2, "localhost");
    } else {
	&errpage(gettext("Bad directory"), 2, "cmd_mainpage");
    }

    &validatepassword("cmd_mainpage", 8, "nspassword", 21);

    # Make sure web server port is free on $lh and localhost
    &validateport("cmd_mainpage", "wport", 3);
    &validateport("cmd_mainpage", "wport", 3, "localhost");

    if (! -d $FORM{"setupdir"}) {
	&errpage(gettext("Setup directory does not exist"), 4, "cmd_mainpage");
    }

    my $CMD;
    if (! -f $FORM{"setupdir"}."/setup") {
	&errpage(gettext("Directory does not contain \"setup\" command"), 4, "cmd_mainpage");
    }

    if ($FORM{"loc"} eq "") {
	&errpage(gettext("Sun ONE install location must be specified"), 5, "cmd_mainpage");
    }

    if (-d $FORM{"loc"}."/https-admserv" ||
	    -e $FORM{"loc"}."/setup/setup.inf" ||
	    -d $FORM{"loc"}."/docs") {
	&errpage(sprintf(gettext("Sun ONE is already installed in %s (https-admserv or setup or docs exists): remove directory or enter new directory."), $FORM{"loc"}), 5, "cmd_mainpage");
    }

    if ($FORM{"root"} eq "") {
	&errpage(gettext("Sun ONE document root must be specified."), 6, "cmd_mainpage");
    }

    &validatelh("cmd_mainpage");

    my($lh, $lhrg, $lhrs, $lhmode) = split(/:/, $FORM{"lh"});

    $FORM{"server"} = $lh;

    my $bindaddr;
    if ($FORM{"ns"} eq "DNS") {
	# Bind to logical hostname if DNS in use
	$bindaddr = $lh;
    } else {
	$bindaddr = &hosttoip($lh);
	if ($bindaddr eq "") {
	    &errpage(sprintf(gettext("Can't determine address for %s"), $lh), 101, "cmd_mainpage");
	}
    }

    my $global;
    my $confhost = "all";
    if (&isglobal($FORM{"loc"})) {
	$global = 1;
	undef @nodes;
	$nodes[0] = &Cluster::Common::get_hostname;
	$confhost = $nodes[0];
    }

    if ($global) {
	print "<h2>".sprintf(gettext("Install of Sun ONE server to global directory %s"), $FORM{"loc"})."</h2>\n";
    } else {
	print "<h2>".sprintf(gettext("Install of Sun ONE server to local directory %s"), $FORM{"loc"})."</h2>\n";
    }
    print "<p>".gettext("This may take several minutes.")."<p>\n";

    my $err;

    $CMD = "/cgi-bin/ds/iplanet-script.pl";
    $cmd_save = $FORM{"setupdir"}."/setup";
    $FORM{"mode"} = "install";

    my ($cluster);
    $cluster = new Cluster::Common;
    $err = $cluster->run_parallel($CMD, 1, \%FORM);
    if ($err =~ /Unable to bind to/) {
	&errpage(gettext("Selected port in use"), 2, "cmd_mainpage");
    } elsif ($err =~ /Login failed/) {
	&errpage(gettext("Login failed"), 100, "cmd_mainpage");
    } elsif ($err =~ /AdminSysUser not specified/) {
	&errpage(sprintf(gettext("Sun ONE is already installed in %s: remove directory or enter new directory."), $FORM{"loc"}), 5, "cmd_mainpage");
    } elsif ($err) {
	&errmsg(gettext("Install did not work"));
	return;
    }

    &getnodes();
    print "<h3>".gettext("Updating magnus.conf and obj.conf")."</h3>\n";
    my $dir = $FORM{"loc"};
    my $logdir;
    if ($global) {
	$logdir = "/var/nshttp";
    } else {
	$logdir = $dir;
    }
    $CMD = "/cgi-bin/ds/iplanet-script.pl";
    my (%args) = (mode => "update", confhost => $confhost,
	idir => "$dir/https-$lh/config",
	logdir => "$logdir/https-$lh/logs",
	bind => $bindaddr);
    $err = $cluster->run_parallel($CMD, 1, \%args);
    if ($err) {
	&errmsg("Log file update script failed");
	return;
    }

    if ($FORM{"dots"}) {
	my $localdir;
	$localdir = $FORM{"root"};
	&getnodes();
	if (&isglobal($localdir)) {
	    print "<h3>".gettext("Installing global dots demo")."</h3>\n";
	    $localdir = "/var/nshttp";
	} else {
	    print "<h3>".gettext("Installing local dots demo")."</h3>\n";
	}
	$CMD = "/cgi-bin/ds/dots-script.pl";
        %args = (docdir => $FORM{"root"}, localdir => $localdir, host => $lh,
            port => $FORM{"wport"}, nodes => join(",", @nodes));
	$err = $cluster->run_parallel($CMD, 1, \%args);
	if ($err) {
	    &errmsg(gettext("Dots installation failed"));
	    $FORM{"dots"} = "";
	}
    }

    # Pass info to the next page
    &hidden("lh");
    &hidden("root");
    &hidden("rs");
    &hidden("aport");
    &hidden("rg");
    &hidden("wport");
    &hidden("loc");
    &hidden("dots");
    &okmsg(gettext("Sun ONE installed"));
    print "<p>".gettext("Press to configure and start resource:\n");
    &submit("cmd_run", gettext("Continue"));

}

sub cmd_run {
    &wizard_start;
    print $q->_script($q->yoke_jscript("c"));
    my ($conf, $args, $status);
    my ($lh, $lhrg, $lhrs, $lhmode) = split(/:/, $FORM{"lh"});
    $conf = $FORM{"loc"}."/https-".$lh;
    $args = "-t SUNW.iws ".
	    " -x Confdir_list=$conf".
	    " -y Port_list=".$FORM{"wport"}."/tcp".
	    " -y Network_resources_used=$lh";

    $status = &createservice($args);
    if ($status) {
	return;
    }

    &webtestinfo();
    &reloadmenu();
    print $q->_script($q->yoke_jscript("rg-rs-".$FORM{"rs"}));
}
