#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident   "@(#)quorum_add.pl 1.8     03/02/26 SMI"
#
# Quorum add component pages

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::RBAC;
use Cluster::Quorum;
use Sun::Solaris::Utils qw(gettext);

# Create the html query object
my $q = new Cluster::Cgi;

# Create a quorum object
my $quorum = new Cluster::Quorum;

# Create the rbac object
my $rbac = new Cluster::RBAC;

my $qd_name = $q->param('qd_name');
my $step = $q->param('step');

# Set the page title
my $title = gettext("Add Quorum Device");

# Check if in Cluster mode
if ($quorum->is_clustermode($q) != 0) {
        # not in cluster mode
        $quorum->print_nonclustermode_error($q);
        exit;
}

# Get output of usefull commands into tmp files
$quorum->get_commandoutput();

# Print the query header
print $q->header();

# Start the document
print $q->start_html({  STYLE  => { 'src' => '/css/clustmgr-style.css'},
			TITLE  => $title,
                        CLASS  => "default-body",
                        SCRIPT => $q->jump_menu_jscript() .
				    $q->yoke_jscript("q")
                });

# Check for quorum modify authorization
if (!$rbac->check_auth($CL_AUTH_QUORUM_MODIFY)) {
	$rbac->auth_error($q, $title);
	exit;
}

$quorum->add_quorumdevice($q, $step, $qd_name);

# End the html document
$quorum->footer($q);
