#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2002 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#pragma ident   "@(#)transport_view.pl 1.26     03/02/26 SMI"
#
# Transport view page
#

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::RBAC;
use Cluster::Transport;
use Sun::Solaris::Utils qw(gettext);

# Create the cluster objects
my $q = new Cluster::Cgi;
my $rbac = new Cluster::RBAC;
my $transport = new Cluster::Transport;

my $VIEW = "/cgi-bin/transport/transport_view.pl";
my $title = gettext("Transports");

#
# Get the optional parameters
#
# Params:
# type - what type of component to display (cluster, node, adapter,
# junction or cable)
# name - the name of the displaying component (ex: phys-schost-1, hub1
# and etc.)
# view - table view or topological view
#
my $type = $q->param("type");
my $name = $q->param("name");
my $view = $q->param("view");

# Print the query header and make the page expire now
print $q->header(-expires => "now");

my $yoke_jscript;
if (defined $view && $view eq "topological") {
	$yoke_jscript = $q->yoke_jscript("t");
} else {
    if (!defined $type) {
	$yoke_jscript = $q->yoke_jscript("t");
    } elsif ($type eq "Node") {
	$yoke_jscript = $q->yoke_jscript("ta-$name");
    } elsif ($type eq "Nodes") {
	$yoke_jscript = $q->yoke_jscript("ta");
    } elsif ($type eq "Adapter") {
	my ($node, $adapter) = $transport->get_node_adp($name);
	$yoke_jscript = $q->yoke_jscript("ta-$node");
    } elsif ($type eq "Junction") {
	$yoke_jscript = $q->yoke_jscript("tj-$name");
    } elsif ($type eq "Junctions") {
	$yoke_jscript = $q->yoke_jscript("tj");
    }
}

my ($jscript) = $q->jump_menu_jscript() . $yoke_jscript;
if (!(defined $view && $view eq "topological")) {
    $jscript .= $q->refresh_jscript('content', 'ESC_cluster_tp');
}

# Start the document
print $q->start_html({  TITLE => gettext("View Transport"),
			STYLE  => { 'src' => '/css/clustmgr-style.css'},
			CLASS  => "default-body",
			ONUNLOAD => $q->unregister_jscript(),
			SCRIPT => $jscript
			});

# Check for transport read authorization
if (!$rbac->check_auth($CL_AUTH_TRANSPORT_READ)) {
	$rbac->auth_error($q, $title);
	exit;
}

# Read the configuration and status into memory if needed 
$transport->get_commandoutput();

##############################################################################
#
# Action Bar Table
#
##############################################################################

if (defined $view && $view eq "topological") {

	# Print the header
	$transport->transport_header($q, $title);

	print $q->start_script();
        print "document.actionform.viewmenu.selectedIndex=1;";
        print "top.helpMarker=\"transport_view-topo\"";
        print $q->end_script();

	my ($height, $width) = (500, 700);
	if (defined $q->param('xmax') && $q->param('xmax') > $width) {
		$width = $q->param('xmax');
	}
	if (defined $q->param('ymax') && $q->param('ymax') > $height) {
		$height = $q->param('ymax');
	}

	# Print the applet
	print $q->applet({ name => 'viewApplet', 
		       codebase => '/',
		       code => 'View.class',
		       height => $height,
		       width => $width});

	my $cName = $transport->get_clustername();
	my $nName = $transport->get_hostname();
	print $q->Param({ name => 'cName', value => $cName });
	print $q->end_Param();
	print $q->Param({ name => 'nName', value => $nName });
	print $q->Param({ name => 'mode', value => 1 });
	print $q->end_Param();
	print $q->end_applet();
} else {
	print $q->start_script();
        print "top.helpMarker=\"transport_view-tables\"";
        print $q->end_script();
	if (!defined $type) {

		# Print the header
		$transport->transport_header($q, $title);

		# Print the table of nodes/adapters 
		$transport->nodes_adapters_table($q);

		# Print the table of junctions
		$transport->junctions_table($q);

		# Print the table of transport paths
		$transport->paths_table($q);

		# Print the table of cables in cluster
		$transport->cables_table($q);

	} else {
	SWITCH: {
		if ($type eq "Node") {

			# Print the header
			$transport->transport_header($q,
			    [$title, $VIEW,
			    gettext("Nodes/Adapters"), "$VIEW?type=Nodes",
			    $name],
			    $name);

			# Print the table of adapters on the given node
			$transport->adapters_table($q, $name);
			
			# Print the table of cables attached to this node
			$transport->cables_table($q, $name, $type);

			last SWITCH;
		}
		if ($type eq "Nodes") {
			# Print the header
			$transport->transport_header($q, 
				     [$title, $VIEW,
				     gettext("Nodes/Adapters")]);
			# Print the table of nodes/adapters 
			$transport->nodes_adapters_table($q);
			last SWITCH;
		}
		if ($type eq "Adapter") {
			my ($node, $adapter) = $transport->get_node_adp($name);
			
			# Print the header
			$transport->transport_header($q, 
			     [$title, $VIEW,
			     gettext("Nodes/Adapters"), "$VIEW?type=Nodes",
			     $node, "$VIEW?type=Node&name=$node",
			     $adapter],
			     $name);
			
			# Print the table of cables attached to this adapter
			$transport->cables_table($q, $name, $type, "nolink");

			# Print the table of properties of this adapter
			$transport->properties_table($q, $name, $type); 
			
			last SWITCH;
		}
		if ($type eq "Junction") {
			# Print the header
			$transport->transport_header($q, 
			    [$title, $VIEW,
			    gettext("Junctions"), "$VIEW?type=Junctions",
				$name],
			    $name);

			# Print the table of cables attached to this junction
			$transport->cables_table($q, $name, $type, "nolink");
			
			# Print the table of properties of this junction
			$transport->properties_table($q, $name, $type); 
			last SWITCH;
		}
		if ($type eq "Junctions") {
			# Print the header
			$transport->transport_header($q, 
					 [$title, $VIEW,
					 gettext("Junctions")]);

			# Print the table of junctions
			$transport->junctions_table($q);
			last SWITCH;
		}
		}
	}
}
    
# End the html document
$transport->footer($q);
