/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.certsrv.ug;

import com.netscape.admin.certsrv.CMSAdminUtil;
import com.netscape.admin.certsrv.CMSBasePanel;
import com.netscape.admin.certsrv.CMSBaseResourceModel;
import com.netscape.admin.certsrv.EAdminException;
import com.netscape.admin.certsrv.LabelCellRenderer;
import com.netscape.admin.certsrv.connection.AdminConnection;
import com.netscape.admin.certsrv.ug.AuthImplDataModel;
import com.netscape.admin.certsrv.ug.AuthRegisterDialog;
import com.netscape.admin.certsrv.ug.CMSBaseUGTab;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.table.TableCellRenderer;
import com.sun.java.swing.table.TableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class AuthImplTab
extends CMSBaseUGTab {
    private static final String IMPL_NAME = "NAME";
    private static final String IMPL_CLASS = "CLASS";
    private static final String IMPL_DESC = "DESC";
    private static final String IMPL_TYPE = "TYPE";
    private static final String PANEL_NAME = "AUTHIMPL";
    private static final String TOKEN = ";";
    private AdminConnection mConnection;
    private String mDestination;
    protected JScrollPane mScrollPane;
    protected JTable mTable;
    protected AuthImplDataModel mDataModel;
    protected AuthRegisterDialog mEditor;
    protected JButton mRefresh;
    protected JButton mAdd;
    protected JButton mDelete;
    protected JButton mHelp;
    private static final String HELPINDEX = "authentication-certsrv-authplugin-help";

    public AuthImplTab(CMSBaseResourceModel model) {
        super(PANEL_NAME, model);
        this.mConnection = model.getServerInfo().getAdmin();
        this.mDataModel = new AuthImplDataModel();
        this.mDestination = "auths";
        this.mHelpToken = HELPINDEX;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.mRefresh)) {
            this.refresh();
        }
        if (e.getSource().equals(this.mAdd)) {
            if (this.mEditor == null) {
                this.mEditor = new AuthRegisterDialog(this.mModel.getFrame(), this.mConnection);
            }
            this.mEditor.showDialog(this.mDestination, "impl");
            if (this.mEditor.isOK()) {
                this.refresh();
            }
        }
        if (e.getSource().equals(this.mDelete)) {
            Debug.println((String)"Delete");
            if (this.mTable.getSelectedRow() < 0) {
                return;
            }
            int i = this.showConfirmDialog("DELETE");
            if (i == 0) {
                this.delete();
                Debug.println((String)"Deleted");
            }
        }
        if (e.getSource().equals(this.mHelp)) {
            this.helpCallback();
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.setButtons();
    }

    public void mouseReleased(MouseEvent e) {
        this.setButtons();
    }

    public void refresh() {
        this.mDataModel.removeAllRows();
        this.update();
        this.setButtons();
        this.mTable.invalidate();
        this.mTable.validate();
        this.mScrollPane.invalidate();
        this.mScrollPane.validate();
        this.mScrollPane.repaint(1L);
    }

    protected JPanel createButtonPanel() {
        this.mAdd = this.makeJButton("ADD");
        this.mDelete = this.makeJButton("DELETE");
        JButton[] buttons = new JButton[]{this.mAdd, this.mDelete};
        JButtonFactory.resize((JButton[])buttons);
        return CMSAdminUtil.makeJButtonVPanel((JButton[])buttons);
    }

    protected JPanel createActionPanel() {
        this.mRefresh = this.makeJButton("REFRESH");
        this.mHelp = this.makeJButton("HELP");
        JButton[] buttons = new JButton[]{this.mRefresh, this.mHelp};
        return CMSBasePanel.makeJButtonPanel((JButton[])buttons, (boolean)true);
    }

    protected JPanel createListPanel() {
        this.mListPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.mListPanel.setLayout(gb);
        this.mTable = new JTable((TableModel)this.mDataModel);
        this.mScrollPane = JTable.createScrollPaneForTable((JTable)this.mTable);
        this.mScrollPane.setHorizontalScrollBarPolicy(31);
        this.mScrollPane.setVerticalScrollBarPolicy(22);
        this.mTable.setAutoscrolls(true);
        this.mTable.sizeColumnsToFit(true);
        this.mTable.getSelectionModel().setSelectionMode(0);
        this.mTable.getSelectionModel().addListSelectionListener((ListSelectionListener)this);
        this.mScrollPane.setBackground(Color.white);
        this.mTable.addMouseListener((MouseListener)((Object)this));
        this.setLabelCellRenderer(this.mTable, 0);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = CMSBasePanel.EMPTY_INSETS;
        gbc.fill = 1;
        gb.setConstraints((Component)this.mScrollPane, gbc);
        this.mListPanel.add((Component)this.mScrollPane);
        JPanel buttonPanel = this.createButtonPanel();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = CMSBasePanel.EMPTY_INSETS;
        gb.setConstraints((Component)buttonPanel, gbc);
        this.mListPanel.add((Component)buttonPanel);
        this.refresh();
        return this.mListPanel;
    }

    protected void setLabelCellRenderer(JTable table, int index) {
        table.getColumnModel().getColumn(index).setCellRenderer((TableCellRenderer)new LabelCellRenderer(new JLabel()));
    }

    private void setButtons() {
        NameValuePairs nvp;
        String type;
        if (this.mTable.getSelectionModel().isSelectionEmpty()) {
            this.mDelete.setEnabled(false);
            return;
        }
        if (this.mDataModel.getRowCount() < 0) {
            this.mDelete.setEnabled(false);
            return;
        }
        this.mDelete.setEnabled(true);
        int index = this.mTable.getSelectedRow();
        if (index >= 0 && ((type = (nvp = (NameValuePairs)this.mDataModel.getObjectValueAt(index)).getValue(IMPL_TYPE)).equals("view") || type.equals("view"))) {
            this.mDelete.setEnabled(false);
        }
    }

    private void update() {
        NameValuePairs response;
        this.mModel.progressStart();
        try {
            response = this.mConnection.search(this.mDestination, "impl", new NameValuePairs());
        }
        catch (EAdminException e) {
            this.showErrorDialog(e.getMessage());
            this.mModel.progressStop();
            return;
        }
        Debug.println((String)response.toString());
        int i = 0;
        String[] vals = new String[response.size()];
        Hashtable<String, NameValuePairs> data = new Hashtable<String, NameValuePairs>();
        Enumeration e = response.getNames();
        while (e.hasMoreElements()) {
            String entry = ((String)e.nextElement()).trim();
            String value = response.getValue(entry);
            Debug.println((String)("AuthImplTab.java update(): entry=" + entry + "value=" + value));
            int x = value.indexOf(",");
            int y = value.indexOf(TOKEN);
            NameValuePairs obj = new NameValuePairs();
            obj.add(IMPL_NAME, entry);
            Debug.println((String)("x=" + x));
            if (x != -1) {
                Debug.println((String)("0 obj.add(IMPL_CLASS," + value.substring(0, x)));
                obj.add(IMPL_CLASS, value.substring(0, x));
                if (y == -1) {
                    Debug.println((String)("1 obj.add(IMPL_DESC," + value.substring(0, x)));
                    obj.add(IMPL_DESC, value.substring(x + 1));
                } else {
                    Debug.println((String)("1 obj.add(IMPL_DESC," + value.substring(x + 1, y)));
                    obj.add(IMPL_DESC, value.substring(x + 1, y));
                }
            } else {
                Debug.println((String)(" 2 obj.add(IMPL_CLASS," + value.substring(0, y)));
                obj.add(IMPL_CLASS, value.substring(0, y));
                Debug.println((String)" 2 obj.add(IMPL_DESC,\"\"");
                obj.add(IMPL_DESC, "");
            }
            String type = "";
            Debug.println((String)("y=" + y));
            if (y == -1) {
                type = "edit";
                obj.add(IMPL_TYPE, "edit");
            } else {
                type = value.substring(y + 1);
                obj.add(IMPL_TYPE, type);
            }
            if (!type.equals("edit")) continue;
            data.put(entry, obj);
            vals[i++] = entry;
        }
        if (i >= 1) {
            String[] valCopy = new String[i];
            System.arraycopy(vals, 0, valCopy, 0, i);
            CMSAdminUtil.bubbleSort((String[])valCopy);
            int y = 0;
            while (y < valCopy.length) {
                if (data.get(valCopy[y]) instanceof String) {
                    Debug.println((String)("processData: " + (String)data.get(valCopy[y])));
                }
                this.mDataModel.processData(data.get(valCopy[y]));
                ++y;
            }
            data.clear();
        }
        if (this.mDataModel.getRowCount() > 0) {
            this.mTable.setRowSelectionInterval(0, 0);
        }
        this.mModel.progressStop();
    }

    private void delete() {
        this.mModel.progressStart();
        NameValuePairs obj = (NameValuePairs)this.mDataModel.getObjectValueAt(this.mTable.getSelectedRow());
        try {
            this.mConnection.delete(this.mDestination, "impl", obj.getValue(IMPL_NAME));
        }
        catch (EAdminException e) {
            this.showErrorDialog(e.getMessage());
            this.mModel.progressStop();
            return;
        }
        this.mModel.progressStop();
        this.refresh();
    }
}

