/*
 * Decompiled with CFR 0.152.
 */
package crysec;

import crysec.ASN1.ASN1Header;
import crysec.Streamable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import sun.security.provider.DSAPrivateKey;

public class Utils {
    public static void setArray(byte[] arr, byte b) {
        if (arr == null) {
            return;
        }
        int i = 0;
        while (i < arr.length) {
            arr[i] = b;
            ++i;
        }
    }

    public static void setArray(int[] arr, int w) {
        int i = 0;
        while (i < arr.length) {
            arr[i] = w;
            ++i;
        }
    }

    public static String toHexString(byte[] b, int off, int len) {
        String hexDigits = "0123456789abcdef";
        StringBuffer s = new StringBuffer();
        int i = off;
        while (i < off + len) {
            s.append(hexDigits.charAt((b[i] & 0xFF) >> 4));
            s.append(hexDigits.charAt(b[i] & 0xF));
            ++i;
        }
        return s.toString();
    }

    public static byte[] fromHexString(String s) {
        byte[] bytes = new byte[s.length() / 2];
        int i = 0;
        while (i < s.length() / 2) {
            bytes[i] = (byte)Integer.parseInt(s.substring(2 * i, 2 * i + 2), 16);
            ++i;
        }
        return bytes;
    }

    public static String toHexString(byte[] b) {
        if (b == null) {
            return "";
        }
        return Utils.toHexString(b, 0, b.length);
    }

    public static int rotl(int x, int s) {
        return x << s | x >>> 32 - s;
    }

    public static int rotr(int x, int s) {
        return x >>> s | x << 32 - s;
    }

    public static int bytesToWord(byte b1, byte b2, byte b3, byte b4) {
        return b4 & 0xFF | (b3 & 0xFF) << 8 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 24;
    }

    public static short bytesToShort(byte b1, byte b2) {
        return (short)(b2 & 0xFF | (b1 & 0xFF) << 8);
    }

    public static int inputWord(InputStream in) throws IOException {
        byte[] b = new byte[4];
        Utils.inputByteArray(b, in);
        return Utils.bytesToWord(b[0], b[1], b[2], b[3]);
    }

    public static int input24bit(InputStream in) throws IOException {
        byte[] b = new byte[3];
        Utils.inputByteArray(b, in);
        return Utils.bytesToWord((byte)0, b[0], b[1], b[2]);
    }

    public static short inputShort(InputStream in) throws IOException {
        byte[] b = new byte[2];
        Utils.inputByteArray(b, in);
        return Utils.bytesToShort(b[0], b[1]);
    }

    public static byte inputByte(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            throw new IOException("End of input");
        }
        return (byte)b;
    }

    public static byte[] inputByteArray(byte[] buf, InputStream is) throws IOException {
        int cnt = 0;
        while (cnt < buf.length) {
            int b = is.read(buf, cnt, buf.length - cnt);
            if (b == -1) {
                throw new IOException("End of input");
            }
            cnt += b;
        }
        return buf;
    }

    public static void bytesToWords(byte[] b, int bOff, int[] w, int wOff, int wLen) {
        int i = wOff;
        int j = bOff;
        while (i < wOff + wLen) {
            w[i] = (b[j++] & 0xFF) << 24 | (b[j++] & 0xFF) << 16 | (b[j++] & 0xFF) << 8 | b[j++] & 0xFF;
            ++i;
        }
    }

    public static void bytesToWords(byte[] b, int[] w) {
        Utils.bytesToWords(b, 0, w, 0, w.length);
    }

    public static void bytesToShorts(byte[] b, short[] s) {
        int i = 0;
        int j = 0;
        while (i < s.length) {
            s[i] = (short)((b[j++] & 0xFF) << 8 | b[j++] & 0xFF);
            ++i;
        }
    }

    public static byte[] longToBytes(long l) {
        byte[] b = new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
        return b;
    }

    public static byte[] wordToBytes(int w) {
        byte[] b = new byte[]{(byte)(w >> 24), (byte)(w >> 16), (byte)(w >> 8), (byte)w};
        return b;
    }

    public static byte[] shortToBytes(short s) {
        byte[] b = new byte[]{(byte)(s >> 8), (byte)s};
        return b;
    }

    public static void output(long l, OutputStream out) throws IOException {
        Utils.outputLong(l, out);
    }

    public static void output(int w, OutputStream out) throws IOException {
        Utils.outputWord(w, out);
    }

    public static void output(short s, OutputStream out) throws IOException {
        Utils.outputShort(s, out);
    }

    public static void output(BigInteger n, OutputStream out) throws IOException {
        Utils.outputBignum(n, out);
    }

    public static void outputLong(long l, OutputStream out) throws IOException {
        out.write((byte)(l >> 56));
        out.write((byte)(l >> 48));
        out.write((byte)(l >> 40));
        out.write((byte)(l >> 32));
        out.write((byte)(l >> 24));
        out.write((byte)(l >> 16));
        out.write((byte)(l >> 8));
        out.write((byte)l);
    }

    public static void outputWord(int w, OutputStream out) throws IOException {
        out.write((byte)(w >> 24));
        out.write((byte)(w >> 16));
        out.write((byte)(w >> 8));
        out.write((byte)w);
    }

    public static void output24bit(int w, OutputStream out) throws IOException {
        out.write((byte)(w >> 16));
        out.write((byte)(w >> 8));
        out.write((byte)w);
    }

    public static void outputShort(short s, OutputStream out) throws IOException {
        out.write((byte)(s >> 8));
        out.write((byte)s);
    }

    public static void longsToBytes(long[] l, byte[] b) {
        int i = 0;
        int j = 0;
        while (i < l.length) {
            b[j++] = (byte)(l[i] >> 56);
            b[j++] = (byte)(l[i] >> 48);
            b[j++] = (byte)(l[i] >> 40);
            b[j++] = (byte)(l[i] >> 32);
            b[j++] = (byte)(l[i] >> 24);
            b[j++] = (byte)(l[i] >> 16);
            b[j++] = (byte)(l[i] >> 8);
            b[j++] = (byte)l[i];
            ++i;
        }
    }

    public static void wordsToBytes(int[] w, int wOff, byte[] b, int bOff, int wLen) {
        int i = wOff;
        int j = bOff;
        while (i < wOff + wLen) {
            b[j++] = (byte)(w[i] >> 24);
            b[j++] = (byte)(w[i] >> 16);
            b[j++] = (byte)(w[i] >> 8);
            b[j++] = (byte)w[i];
            ++i;
        }
    }

    public static void wordsToBytes(int[] w, byte[] b) {
        Utils.wordsToBytes(w, 0, b, 0, w.length);
    }

    public static void shortsToBytes(short[] s, byte[] b) {
        int i = 0;
        int j = 0;
        while (i < s.length) {
            b[j++] = (byte)(s[i] >> 8);
            b[j++] = (byte)s[i];
            ++i;
        }
    }

    public static void charsToBytes(char[] c, byte[] b) {
        int i = 0;
        int j = 0;
        while (i < c.length) {
            b[j++] = (byte)(c[i] >> 8);
            b[j++] = (byte)c[i];
            ++i;
        }
    }

    public static byte[] toBytes(Streamable o) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            o.output(os);
            return os.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    public static Streamable inputFile(Streamable o, File f) throws IOException, FileNotFoundException {
        FileInputStream is = new FileInputStream(f);
        o.input(is);
        return o;
    }

    public static void outputBignum(BigInteger val, OutputStream os) throws IOException {
        os.write(Utils.toByteArray(val));
    }

    public static BigInteger inputBignum(int nBytes, InputStream is) throws IOException {
        byte[] buf = new byte[nBytes];
        Utils.inputByteArray(buf, is);
        BigInteger val = BigInteger.valueOf(0L);
        try {
            val = new BigInteger(1, buf);
        }
        catch (NumberFormatException e) {
            throw new IOException(e.toString());
        }
        return val;
    }

    public static byte[] toByteArray(BigInteger val) {
        byte[] buf = val.toByteArray();
        if (buf[0] == 0) {
            byte[] buf2 = new byte[buf.length - 1];
            System.arraycopy(buf, 1, buf2, 0, buf2.length);
            return buf2;
        }
        return buf;
    }

    public static int length(BigInteger val) {
        int nBits = val.bitLength();
        if (nBits == 0) {
            return 1;
        }
        return (nBits - 1) / 8 + 1;
    }

    public static void outputString(String s, OutputStream os) throws IOException {
        os.write(s.getBytes());
    }

    public static PrivateKey inputDSAPrivateKey(InputStream is) throws IOException {
        ASN1Header h = new ASN1Header();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        h.input(is);
        h.output(os);
        os.write(h.readBody(is));
        try {
            return new DSAPrivateKey(os.toByteArray());
        }
        catch (InvalidKeyException e) {
            throw new IOException(e.toString());
        }
    }

    public static PrivateKey inputDSAPrivateKey(File f) throws IOException {
        return Utils.inputDSAPrivateKey(new FileInputStream(f));
    }
}

