/*
 * Decompiled with CFR 0.152.
 */
package crysec;

import crysec.ASN1.ASN1Header;
import crysec.ASN1.ASN1Utils;
import crysec.Entity;
import crysec.Streamable;
import crysec.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class X500Name
extends Entity
implements Streamable {
    protected String countryName;
    protected String stateName;
    protected String localityName;
    protected String organizationName;
    protected String orgUnitName;
    protected String email;
    protected byte[] contents;

    public void input(InputStream is) throws IOException {
        ASN1Header h = new ASN1Header();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        h.input(is);
        h.output(os);
        os.write(h.readBody(is));
        this.contents = os.toByteArray();
        ByteArrayInputStream is2 = new ByteArrayInputStream(this.contents);
        while (is2.available() > 0) {
            h.input(is2);
            if (h.tag != 6) continue;
            int[] attr = ASN1Utils.inputASN1ObjectID(h, is2);
            h.input(is2);
            if (h.tag != 28 && h.tag != 19 && h.tag != 22 && h.tag != 20) continue;
            String value = ASN1Utils.inputASN1String(h, is2);
            this.parseAttr(attr, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseAttr(int[] attr, String value) {
        if (ASN1Utils.isPrefix(ASN1Utils.attrTypeID, attr)) {
            switch (attr[ASN1Utils.attrTypeID.length]) {
                case 3: {
                    this.name = value;
                    return;
                }
                case 6: {
                    this.countryName = value;
                    return;
                }
                case 7: {
                    this.localityName = value;
                    return;
                }
                case 8: {
                    this.stateName = value;
                    return;
                }
                case 10: {
                    this.organizationName = value;
                    return;
                }
                case 11: {
                    this.orgUnitName = value;
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (!ASN1Utils.isPrefix(ASN1Utils.pkcsID, attr) || attr[ASN1Utils.pkcsID.length] != 9 || attr[ASN1Utils.pkcsID.length + 1] != 1) return;
        this.email = value;
    }

    public void output(OutputStream os) throws IOException {
        if (this.contents == null) {
            this.generateContents();
        }
        os.write(this.contents);
    }

    void generateContents() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ByteArrayOutputStream os2 = new ByteArrayOutputStream();
            this.writeX500Attr(this.name, 3, os2);
            this.writeX500Attr(this.countryName, 6, os2);
            this.writeX500Attr(this.localityName, 7, os2);
            this.writeX500Attr(this.stateName, 8, os2);
            this.writeX500Attr(this.organizationName, 10, os2);
            this.writeX500Attr(this.orgUnitName, 11, os2);
            this.writePKCS9Attr(this.email, 1, os2);
            byte[] attrs = os2.toByteArray();
            ASN1Utils.structHeader(attrs.length).output(os);
            os.write(attrs);
            this.contents = os.toByteArray();
        }
        catch (IOException iOException) {}
    }

    void writeX500Attr(String val, int attr, OutputStream os) throws IOException {
        if (val == null) {
            return;
        }
        int[] id = new int[ASN1Utils.attrTypeID.length + 1];
        System.arraycopy(ASN1Utils.attrTypeID, 0, id, 0, id.length - 1);
        id[id.length - 1] = attr;
        this.writeAttr(val, id, os);
    }

    void writePKCS9Attr(String val, int attr, OutputStream os) throws IOException {
        if (val == null) {
            return;
        }
        int[] id = new int[ASN1Utils.pkcsID.length + 2];
        System.arraycopy(ASN1Utils.pkcsID, 0, id, 0, id.length - 2);
        id[id.length - 2] = 9;
        id[id.length - 1] = attr;
        this.writeAttr(val, id, os);
    }

    void writeAttr(String val, int[] id, OutputStream os) throws IOException {
        if (val == null) {
            return;
        }
        ASN1Header attrType = ASN1Utils.objectIDHeader(id);
        ASN1Header attrVal = ASN1Utils.IA5StringHeader(val);
        ASN1Header assertion = ASN1Utils.structHeader(attrType.totalLength() + attrVal.totalLength());
        ASN1Header rdn = ASN1Utils.setHeader(assertion.totalLength());
        rdn.output(os);
        assertion.output(os);
        attrType.output(os);
        ASN1Utils.outputASN1ObjectID(id, os);
        attrVal.output(os);
        Utils.outputString(val, os);
    }

    public int length() {
        if (this.contents == null) {
            this.generateContents();
        }
        return this.contents.length;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.countryName != null) {
            buf.append("C=" + this.countryName + " ");
        }
        if (this.stateName != null) {
            buf.append("SP=" + this.stateName + " ");
        }
        if (this.localityName != null) {
            buf.append("L=" + this.localityName + " ");
        }
        if (this.organizationName != null) {
            buf.append("O=" + this.organizationName + " ");
        }
        if (this.orgUnitName != null) {
            buf.append("OU=" + this.orgUnitName + " ");
        }
        if (this.name != null) {
            buf.append("CN=" + this.name + " ");
        }
        if (this.email != null) {
            buf.append("Email=" + this.email + " ");
        }
        return buf.toString();
    }

    public String getCountryName() {
        return this.countryName;
    }

    public String getStateName() {
        return this.stateName;
    }

    public String getLocalityName() {
        return this.localityName;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public String getOrgUnitName() {
        return this.orgUnitName;
    }

    public String getEmail() {
        return this.email;
    }
}

