/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.BaseConfigPanel;
import com.netscape.management.admserv.config.ConfigPanelException;
import com.netscape.management.admserv.config.EditMonitor;
import com.netscape.management.admserv.config.FilteredInputDocument;
import com.netscape.management.admserv.config.GBC;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.PluginConfigPanel;
import com.netscape.management.admserv.config.RemoteRequestException;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.AdminConfigData;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonGroup;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JPasswordField;
import com.sun.java.swing.JRadioButton;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.JToggleButton;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.JTextComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;

public class UGDirectoryConfigPanel
extends PluginConfigPanel
implements SuiConstants {
    IConfigDataModel _configData;
    String _defaultPort = "389";
    String _defaultSSLPort = "636";
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nLdapURL = _resource.getString("ldapds", "LdapURL");
    static String _i18nUseGlobal;
    static String _i18nOverrideGlobal;
    static String _i18nBindDN;
    static String _i18nBindPW;
    static String _i18nBindPWAgain;
    static String _i18nEnterBindDN;
    static String _i18nEnterBindPW;
    static String _i18nPasswordMismatch;
    static String _i18nHost;
    static String _i18nPort;
    static String _i18nUseSSL;
    static String _i18nBaseDN;
    static String _i18nUGGroupbox;
    static String _i18nEnterLdapHost;
    static String _i18nEnterLdapPort;
    static String _i18nEnterBaseDN;
    static String _i18nPortRange;
    static String _i18nWarnCert;
    Help _help;
    JLabel _lblGlobalLdapURL;
    JLabel _lblGlobalLdapURLValue;
    JLabel _lblBindDN;
    JLabel _lblBindPW1;
    JLabel _lblBindPW2;
    JRadioButton _rbUseGlobal;
    JRadioButton _rbOverrideGlobal;
    JTextField _txtBindDN;
    JPasswordField _txtBindPW1;
    JPasswordField _txtBindPW2;
    JLabel _lblPort;
    JLabel _lblHost;
    JLabel _lblBaseDN;
    JTextField _txtPort;
    JTextField _txtHost;
    JTextField _txtBaseDN;
    JCheckBox _cbSSL;
    ItemListener _rbListener = new 1();
    ActionListener _cbSSLListener = new 2();

    public UGDirectoryConfigPanel(String title, IConfigDataModel data) {
        super(title);
        this._configData = data;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)this.makeConfigPanel(), "North");
        this._help = new Help(_resource);
    }

    public void showHelp() {
        this._help.help("ugLdapHelp");
    }

    public IConfigDataModel getDataModel() {
        return this._configData;
    }

    public void setDataModel(IConfigDataModel data) {
        this._configData = data;
        if (this._configData.isLoaded()) {
            this.setPanelContent(this._configData);
        }
    }

    public void initialize() throws RemoteRequestException {
        if (!this._configData.isLoaded()) {
            this._configData.load();
        }
        this._rbUseGlobal.addItemListener(this._rbListener);
        this._rbOverrideGlobal.addItemListener(this._rbListener);
        this._cbSSL.addActionListener(this._cbSSLListener);
        this.setPanelContent(this._configData);
    }

    public void resetContent() {
        this.setPanelContent(this._configData);
    }

    public void applyChanges() throws ConfigPanelException {
        this.getPanelContent(this._configData);
    }

    public void registerEditComponents(EditMonitor editMonitor) {
        editMonitor.monitor((JTextComponent)this._txtPort);
        editMonitor.monitor((JTextComponent)this._txtHost);
        editMonitor.monitor((JToggleButton)this._cbSSL);
        editMonitor.monitor((JTextComponent)this._txtBindDN);
        editMonitor.monitor((JTextComponent)this._txtBindPW1);
        editMonitor.monitor((JTextComponent)this._txtBindPW2);
        editMonitor.monitor((JToggleButton)this._rbUseGlobal);
        editMonitor.monitor((JToggleButton)this._rbOverrideGlobal);
    }

    public void setPanelContent(IConfigDataModel data) {
        boolean useGlobal;
        String inforef = data.getAttribute("ugdsconfig.inforef");
        Debug.println((String)("inforef=" + inforef));
        this.setGlobalLdapURL(data.getAttribute("ugdsconfig.globaldirurl"));
        boolean bl = useGlobal = inforef != null && inforef.length() > 0;
        if (useGlobal) {
            this._rbUseGlobal.setSelected(true);
            this.setLdapHost("");
            this.setLdapPort("");
            this._cbSSL.setEnabled(false);
            this.setBindDN("");
            this.setBindPW1("");
            this.setBindPW2("");
        } else {
            this._rbOverrideGlobal.setSelected(true);
            this.setLdapURL(data.getAttribute("ugdsconfig.dirurl"));
            this.setBindDN(data.getAttribute("ugdsconfig.binddn"));
            this.setBindPW1(data.getAttribute("ugdsconfig.bindpw"));
            this.setBindPW2(data.getAttribute("ugdsconfig.bindpw"));
        }
    }

    public void setLdapHost(String host) {
        this._txtHost.setText(host != null ? host : "");
    }

    public void setLdapPort(String port) {
        this._txtPort.setText(port != null ? port : "");
    }

    public void setBaseDN(String dn) {
        if (dn == null) {
            this._txtBaseDN.setText("");
        } else if (dn.startsWith("/")) {
            this._txtBaseDN.setText(dn.substring(1));
        } else {
            this._txtBaseDN.setText(dn);
        }
    }

    public void setLdapURL(String url) {
        String parse;
        if (url.startsWith("ldaps://")) {
            this._cbSSL.setSelected(true);
            parse = url.substring(5);
        } else if (url.startsWith("ldap://")) {
            this._cbSSL.setSelected(false);
            parse = url.substring(4);
        } else {
            Debug.println((String)("ERROR: Bad Ldap url " + url));
            return;
        }
        Debug.println((String)("parse=" + parse));
        try {
            URL parseurl = new URL("http" + parse);
            this.setLdapHost(parseurl.getHost());
            this.setLdapPort(new Integer(parseurl.getPort()).toString());
            this.setBaseDN(parseurl.getFile());
        }
        catch (Exception exception) {
            Debug.println((String)("ERROR: Bad Ldap url " + url));
            return;
        }
    }

    private String getLdapURL() throws ValidationException {
        String host = this._txtHost.getText().trim();
        String port = this._txtPort.getText().trim();
        String baseDN = this._txtBaseDN.getText().trim();
        if (host.length() == 0) {
            throw new ValidationException("", _i18nEnterLdapHost);
        }
        if (port.length() == 0) {
            throw new ValidationException("", _i18nEnterLdapPort);
        }
        if (baseDN.length() == 0) {
            throw new ValidationException("", _i18nEnterBaseDN);
        }
        try {
            int portNum = Integer.parseInt(port);
            if (portNum < 1 || portNum > 65535) {
                throw new ValidationException("", _i18nPortRange);
            }
        }
        catch (Exception exception) {
            throw new ValidationException("", _i18nPortRange);
        }
        String url = String.valueOf(this._txtHost.getText().trim()) + ":" + this._txtPort.getText().trim() + "/" + this._txtBaseDN.getText().trim();
        if (this._cbSSL.isSelected()) {
            return "ldaps://" + url;
        }
        return "ldap://" + url;
    }

    public void setGlobalLdapURL(String url) {
        this._lblGlobalLdapURLValue.setText(url != null ? url : "");
        this._lblGlobalLdapURLValue.repaint();
    }

    void setBindDN(String binddn) {
        this._txtBindDN.setText(binddn == null ? "" : binddn);
    }

    void setBindPW1(String bindPW) {
        this._txtBindPW1.setText(bindPW == null ? "" : bindPW);
    }

    void setBindPW2(String bindPW) {
        this._txtBindPW2.setText(bindPW == null ? "" : bindPW);
    }

    public void getPanelContent(IConfigDataModel data) throws ConfigPanelException {
        if (this._rbOverrideGlobal.isSelected()) {
            String url = this.getLdapURL();
            String bindDN = this._txtBindDN.getText().trim();
            String pw1 = this._txtBindPW1.getText().trim();
            String pw2 = this._txtBindPW2.getText().trim();
            boolean modified = !data.getAttribute("ugdsconfig.dirurl").equals("");
            modified = modified || !url.equals(data.getAttribute("ugdsconfig.dirurl"));
            modified = modified || !bindDN.equals(data.getAttribute("ugdsconfig.binddn"));
            boolean bl = modified = modified || !pw1.equals(data.getAttribute("ugdsconfig.bindpw"));
            if (!modified) {
                return;
            }
            if (!(pw1.length() == 0 && pw2.length() == 0 || pw1.equals(pw2))) {
                throw new ValidationException("", _i18nPasswordMismatch);
            }
            if (bindDN.length() == 0 && pw1.length() != 0) {
                throw new ValidationException("", _i18nEnterBindDN);
            }
            this.connectAndValidate();
            data.setAttribute("ugdsconfig.dirurl", url);
            data.setAttribute("ugdsconfig.binddn", bindDN);
            data.setAttribute("ugdsconfig.bindpw", pw1);
            data.setAttribute("ugdsconfig.inforef", "");
        } else {
            data.setAttribute("ugdsconfig.inforef", "default");
        }
        if (data instanceof AdminConfigData) {
            ((AdminConfigData)data).setDialogParent((Component)((Object)this));
        }
    }

    private void connectAndValidate() throws ConfigPanelException {
        String host = this._txtHost.getText().trim();
        String port = this._txtPort.getText().trim();
        String baseDN = this._txtBaseDN.getText().trim();
        String bindPWD = this._txtBindPW1.getText().trim();
        String bindDN = this._txtBindDN.getText().trim();
        boolean ssl = this._cbSSL.isSelected();
        int portNum = -1;
        try {
            portNum = Integer.parseInt(port);
        }
        catch (Exception exception) {
            throw new ValidationException("", _i18nPortRange);
        }
        try {
            LDAPUtil.validateLDAPParams((String)host, (int)portNum, (boolean)ssl, (String)bindDN, (String)bindPWD, (String)baseDN);
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("", e.getMessage());
        }
    }

    protected JComponent makeConfigPanel() {
        JPanel p = new JPanel();
        GBC gbc = new GBC();
        int row = 0;
        int groupIndent = 20;
        p.setBorder(BaseConfigPanel.createGroupBorder((String)_i18nUGGroupbox));
        GridBagLayout gbl = new GridBagLayout();
        p.setLayout(gbl);
        JLabel refLabel = new JLabel();
        gbc.setInsets(0, 6, 9, 0);
        gbc.setGrid(0, row, 3, 1);
        gbc.setSpace(1.0, 0.0, 17, 1);
        MultilineLabel mll = new MultilineLabel(_i18nWarnCert, 1, 999);
        p.add((Component)mll, gbc);
        mll.setFont(refLabel.getFont());
        this._rbUseGlobal = new JRadioButton(_i18nUseGlobal, false);
        gbc.setInsets(0, 0, 0, 0);
        gbc.setGrid(0, ++row, 3, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        p.add((Component)this._rbUseGlobal, gbc);
        this._lblGlobalLdapURL = new JLabel(_i18nLdapURL);
        gbc.setInsets(0, groupIndent, 0, 0);
        gbc.setGrid(0, ++row, 1, 1);
        gbc.setSpace(0.0, 0.0, 13, 0);
        p.add((Component)this._lblGlobalLdapURL, gbc);
        this._lblGlobalLdapURLValue = new JLabel(".");
        gbc.setInsets(0, 9, 0, 0);
        gbc.setGrid(1, row, 2, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        p.add((Component)this._lblGlobalLdapURLValue, gbc);
        this._rbOverrideGlobal = new JRadioButton(_i18nOverrideGlobal, false);
        gbc.setInsets(9, 0, 0, 0);
        gbc.setGrid(0, ++row, 3, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        p.add((Component)this._rbOverrideGlobal, gbc);
        this._lblHost = new JLabel(_i18nHost);
        gbc.setInsets(0, groupIndent, 0, 0);
        gbc.setGrid(0, ++row, 1, 1);
        gbc.setSpace(0.0, 0.0, 13, 0);
        p.add((Component)this._lblHost, gbc);
        this._txtHost = new JTextField(22);
        gbc.setInsets(0, 9, 0, 0);
        gbc.setGrid(1, row, 2, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        p.add((Component)this._txtHost, gbc);
        this._lblPort = new JLabel(_i18nPort);
        gbc.setInsets(6, 0, 0, 0);
        gbc.setGrid(0, ++row, 1, 1);
        gbc.setSpace(0.0, 0.0, 13, 0);
        p.add((Component)this._lblPort, gbc);
        this._txtPort = new JTextField("389", 6);
        this._txtPort.setMinimumSize(this._txtPort.getPreferredSize());
        this._txtPort.setDocument((Document)FilteredInputDocument.allowDigitsOnly());
        gbc.setInsets(6, 9, 0, 0);
        gbc.setGrid(1, row, 1, 1);
        gbc.setSpace(0.0, 0.0, 17, 0);
        p.add((Component)this._txtPort, gbc);
        this._cbSSL = new JCheckBox(_i18nUseSSL, false);
        gbc.setInsets(6, 18, 0, 0);
        gbc.setGrid(2, row, 1, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        p.add((Component)this._cbSSL, gbc);
        this._lblBaseDN = new JLabel(_i18nBaseDN);
        this._lblBaseDN.setFont(BaseConfigPanel.getLabelFont());
        gbc.setInsets(6, 0, 0, 0);
        gbc.setGrid(0, ++row, 1, 1);
        gbc.setSpace(0.0, 0.0, 13, 0);
        p.add((Component)this._lblBaseDN, gbc);
        this._txtBaseDN = new JTextField(22);
        gbc.setInsets(6, 9, 0, 0);
        gbc.setGrid(1, row, 2, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        p.add((Component)this._txtBaseDN, gbc);
        this._lblBindDN = new JLabel(_i18nBindDN);
        gbc.setInsets(6, groupIndent, 0, 0);
        gbc.setGrid(0, ++row, 1, 1);
        gbc.setSpace(0.0, 0.0, 13, 0);
        p.add((Component)this._lblBindDN, gbc);
        this._txtBindDN = new JTextField(22);
        gbc.setInsets(6, 9, 0, 0);
        gbc.setGrid(1, row, 2, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        p.add((Component)this._txtBindDN, gbc);
        this._lblBindPW1 = new JLabel(_i18nBindPW);
        gbc.setInsets(6, groupIndent, 0, 0);
        gbc.setGrid(0, ++row, 1, 1);
        gbc.setSpace(0.0, 0.0, 13, 0);
        p.add((Component)this._lblBindPW1, gbc);
        this._txtBindPW1 = new JPasswordField(22);
        gbc.setInsets(6, 9, 0, 0);
        gbc.setGrid(1, row, 2, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        p.add((Component)this._txtBindPW1, gbc);
        this._lblBindPW2 = new JLabel(_i18nBindPWAgain);
        gbc.setInsets(6, groupIndent, 0, 0);
        gbc.setGrid(0, ++row, 1, 1);
        gbc.setSpace(0.0, 0.0, 13, 0);
        p.add((Component)this._lblBindPW2, gbc);
        this._txtBindPW2 = new JPasswordField(22);
        gbc.setInsets(6, 9, 0, 0);
        gbc.setGrid(1, row, 2, 1);
        gbc.setSpace(1.0, 0.0, 18, 2);
        p.add((Component)this._txtBindPW2, gbc);
        ++row;
        ButtonGroup rbGroup = new ButtonGroup();
        rbGroup.add((AbstractButton)this._rbUseGlobal);
        rbGroup.add((AbstractButton)this._rbOverrideGlobal);
        return p;
    }

    static {
        _i18nBindDN = _resource.getString("ldapds", "BindDN");
        _i18nBindPW = _resource.getString("ldapds", "BindPW");
        _i18nBindPWAgain = _resource.getString("ldapds", "BindPWAgain");
        _i18nUseGlobal = _resource.getString("ldapds", "UseGlobal");
        _i18nOverrideGlobal = _resource.getString("ldapds", "OverrideGlobal");
        _i18nEnterBindDN = _resource.getString("ldapds", "EnterBindDN");
        _i18nEnterBindPW = _resource.getString("ldapds", "EnterBindPW");
        _i18nPasswordMismatch = _resource.getString("ldapds", "PasswordMismatch");
        _i18nHost = _resource.getString("ldapds", "Host");
        _i18nPort = _resource.getString("ldapds", "Port");
        _i18nUseSSL = _resource.getString("ldapds", "UseSSL");
        _i18nBaseDN = _resource.getString("ldapds", "BaseDN");
        _i18nUGGroupbox = _resource.getString("ldapds", "UGGroupbox");
        _i18nEnterLdapHost = _resource.getString("ldapds", "EnterLdapHost");
        _i18nEnterLdapPort = _resource.getString("ldapds", "EnterLdapPort");
        _i18nEnterBaseDN = _resource.getString("ldapds", "EnterBaseDN");
        _i18nPortRange = _resource.getString("common", "PortRange");
        _i18nWarnCert = _resource.getString("ldapds", "WarnCert");
    }

    private final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            boolean enable = true;
            if (e.getSource() == UGDirectoryConfigPanel.this._rbUseGlobal && UGDirectoryConfigPanel.this._rbUseGlobal.isSelected()) {
                enable = false;
            }
            UGDirectoryConfigPanel.this._lblHost.setEnabled(enable);
            UGDirectoryConfigPanel.this._lblHost.repaint();
            UGDirectoryConfigPanel.this._lblPort.setEnabled(enable);
            UGDirectoryConfigPanel.this._lblPort.repaint();
            UGDirectoryConfigPanel.this._lblBaseDN.setEnabled(enable);
            UGDirectoryConfigPanel.this._lblBaseDN.repaint();
            UGDirectoryConfigPanel.this._lblBindDN.setEnabled(enable);
            UGDirectoryConfigPanel.this._lblBindDN.repaint();
            UGDirectoryConfigPanel.this._lblBindPW1.setEnabled(enable);
            UGDirectoryConfigPanel.this._lblBindPW1.repaint();
            UGDirectoryConfigPanel.this._lblBindPW2.setEnabled(enable);
            UGDirectoryConfigPanel.this._lblBindPW2.repaint();
            UGDirectoryConfigPanel.this._txtHost.setEnabled(enable);
            UGDirectoryConfigPanel.this._txtPort.setEnabled(enable);
            UGDirectoryConfigPanel.this._txtBaseDN.setEnabled(enable);
            UGDirectoryConfigPanel.this._txtBindDN.setEnabled(enable);
            UGDirectoryConfigPanel.this._txtBindPW1.setEnabled(enable);
            UGDirectoryConfigPanel.this._txtBindPW2.setEnabled(enable);
            UGDirectoryConfigPanel.this._cbSSL.setEnabled(enable);
            Color enableBackground = UIManager.getColor((Object)(enable ? "window" : "control"));
            UGDirectoryConfigPanel.this._txtHost.setBackground(enableBackground);
            UGDirectoryConfigPanel.this._txtPort.setBackground(enableBackground);
            UGDirectoryConfigPanel.this._txtBaseDN.setBackground(enableBackground);
            UGDirectoryConfigPanel.this._txtBindDN.setBackground(enableBackground);
            UGDirectoryConfigPanel.this._txtBindPW1.setBackground(enableBackground);
            UGDirectoryConfigPanel.this._txtBindPW2.setBackground(enableBackground);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (UGDirectoryConfigPanel.this._cbSSL.isSelected() && UGDirectoryConfigPanel.this._txtPort.getText().equals(UGDirectoryConfigPanel.this._defaultPort)) {
                UGDirectoryConfigPanel.this._txtPort.setText(UGDirectoryConfigPanel.this._defaultSSLPort);
            } else if (!UGDirectoryConfigPanel.this._cbSSL.isSelected() && UGDirectoryConfigPanel.this._txtPort.getText().equals(UGDirectoryConfigPanel.this._defaultSSLPort)) {
                UGDirectoryConfigPanel.this._txtPort.setText(UGDirectoryConfigPanel.this._defaultPort);
            }
        }

        /* synthetic */ 2() {
        }
    }
}

