/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import com.netscape.management.client.components.ComponentFactory;
import com.netscape.management.client.components.DirModel;
import com.netscape.management.client.components.DirNode;
import com.netscape.management.client.components.DirNodeEvent;
import com.netscape.management.client.components.DirTree;
import com.netscape.management.client.components.GenericDialog;
import com.netscape.management.client.components.IDirModel;
import com.netscape.management.client.components.IDirNode;
import com.netscape.management.client.components.IDirNodeListener;
import com.netscape.management.client.console.ConsoleHelp;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPConnection;

public class DirBrowserDialog
extends GenericDialog {
    private LDAPConnection ldc = null;
    private String baseDN = null;
    private JPanel selectionPanel;
    private JTextField selectionField;
    public DirTree tree;
    private static ResourceSet resource = new ResourceSet("com.netscape.management.client.components.components");

    private static String i18n(String string) {
        return resource.getString("dirBrowser", string);
    }

    public DirBrowserDialog(JFrame jFrame, LDAPConnection lDAPConnection) {
        this(jFrame, DirBrowserDialog.i18n("title"), lDAPConnection, null);
    }

    public DirBrowserDialog(JFrame jFrame, String string, LDAPConnection lDAPConnection) {
        this(jFrame, string, lDAPConnection, null);
    }

    public DirBrowserDialog(JFrame jFrame, String string, LDAPConnection lDAPConnection, String string2) {
        super(jFrame, string);
        this.ldc = lDAPConnection;
        this.baseDN = string2;
        this.setOKButtonEnabled(false);
        this.getContentPane().add(this.createPanel());
        this.setMinimumSize(this.getContentPane().getPreferredSize());
    }

    protected JPanel createPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        DirModel dirModel = new DirModel(this.ldc);
        dirModel.setShowsPrivateSuffixes(true);
        dirModel.setAllowsLeafNodes(true);
        dirModel.setReferralsEnabled(true);
        dirModel.initialize(this.baseDN != null ? new DirNode((IDirModel)dirModel, this.baseDN) : null);
        this.tree = new DirTree(dirModel){

            public void expandPath(TreePath treePath) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                super.expandPath(treePath);
                this.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.tree.addDirNodeListener(new DirNodeListener());
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (DirBrowserDialog.this.tree.isSelectionEmpty()) {
                    DirBrowserDialog.this.setOKButtonEnabled(false);
                    DirBrowserDialog.this.selectionField.setText("");
                } else {
                    DirBrowserDialog.this.setOKButtonEnabled(true);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        JPanel jPanel2 = ComponentFactory.createLabelComponent(DirBrowserDialog.i18n("treeLabel"), jScrollPane);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.selectionField = new JTextField("");
        this.selectionField.setEditable(false);
        this.selectionField.setBackground(UIManager.getColor("control"));
        this.selectionPanel = ComponentFactory.createLabelComponent(DirBrowserDialog.i18n("selectionField"), this.selectionField);
        this.selectionPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.selectionPanel, gridBagConstraints);
        jPanel.add(this.selectionPanel);
        jPanel.setPreferredSize(new Dimension(250, 300));
        return jPanel;
    }

    public IDirModel getDirModel() {
        return (IDirModel)this.tree.getModel();
    }

    public void setDirModel(IDirModel iDirModel) {
        this.tree.setModel(iDirModel);
    }

    public void setBaseDN(String string) {
        this.baseDN = string;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public void setLDAPConnection(LDAPConnection lDAPConnection) {
        this.ldc = lDAPConnection;
    }

    public LDAPConnection getLDAPConnection() {
        return this.ldc;
    }

    public void setSelectionFieldVisible(boolean bl) {
        this.selectionPanel.setVisible(bl);
    }

    public boolean isSelectionFieldVisible() {
        return this.selectionPanel.isVisible();
    }

    public String getSelectedDN() {
        return this.selectionField.getText();
    }

    public void helpInvoked() {
        ConsoleHelp.showContextHelp("directoryBrowser");
    }

    class DirNodeListener
    implements IDirNodeListener {
        DirNodeListener() {
        }

        public void selectionChanged(IDirNode[] iDirNodeArray) {
            if (iDirNodeArray.length > 1) {
                DirBrowserDialog.this.selectionField.setText("multi-selected");
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer("" + iDirNodeArray[0], "<");
                String string = "";
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                }
                if ((stringTokenizer = new StringTokenizer(string, ">")).hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                }
                if (string.equals(">")) {
                    string = "";
                }
                DirBrowserDialog.this.selectionField.setText(string);
            }
        }

        public void actionInvoked(DirNodeEvent dirNodeEvent) {
        }
    }
}

