/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ug;

import com.netscape.management.client.Framework;
import com.netscape.management.client.StatusItemProgress;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.ug.CancelSearchDialog;
import com.netscape.management.client.ug.SearchThread;
import com.netscape.management.client.ug.VLDirectoryTable;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPUrl;

public class SearchResultPanel
extends JPanel {
    private static final String PREFERENCES_RESULT_TABLE = "SearchResultTable";
    public static final String PREFERENCE_COLUMN_COUNT = "ColumnCount";
    public static final String PREFERENCE_COLUMN_ATTRIBUTE_PREFIX = "Attribute";
    public static final String PREFERENCE_COLUMN_LABEL_PREFIX = "Label";
    ResourceSet _resource = new ResourceSet("com.netscape.management.client.ug.PickerEditorResource");
    VLDirectoryTable _resultList;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$com$netscape$management$client$Framework;

    public SearchResultPanel(ActionListener actionListener) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector<String> vector = new Vector<String>();
        PreferenceManager preferenceManager = PreferenceManager.getPreferenceManager("Console", "4.0");
        Preferences preferences = preferenceManager.getPreferences(PREFERENCES_RESULT_TABLE);
        int n = preferences.getInt(PREFERENCE_COLUMN_COUNT, -1);
        if (n == -1) {
            n = Integer.parseInt(this._resource.getString("SearchResultPanel", "ColumnLabelCount"));
            preferences.set(PREFERENCE_COLUMN_COUNT, n);
            int n2 = 0;
            while (n2 < n) {
                String string = this._resource.getString("SearchResultPanel", "ColumnLabel" + n2);
                int n3 = string.indexOf(44);
                String string2 = string.substring(0, n3).toLowerCase();
                String string3 = string.substring(n3 + 1);
                preferences.set(PREFERENCE_COLUMN_ATTRIBUTE_PREFIX + n2, string2);
                preferences.set(PREFERENCE_COLUMN_LABEL_PREFIX + n2, string3);
                hashtable.put(string2, string3);
                vector.addElement(string2);
                ++n2;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                String string = preferences.getString(PREFERENCE_COLUMN_ATTRIBUTE_PREFIX + n4);
                String string4 = preferences.getString(PREFERENCE_COLUMN_LABEL_PREFIX + n4);
                if (string != null && string4 != null) {
                    hashtable.put(string, string4);
                    vector.addElement(string);
                }
                ++n4;
            }
        }
        this._resultList = new VLDirectoryTable(hashtable, vector, preferences);
        this._resultList.getAccessibleContext().setAccessibleDescription(this._resource.getString("SearchResultPanel", "table_tt"));
        this.setLayout(new BorderLayout());
        this.add("Center", this._resultList);
    }

    public SearchResultPanel(ConsoleInfo consoleInfo, ActionListener actionListener) {
        this(actionListener);
        this._resultList.setConsoleInfo(consoleInfo);
    }

    public void setColumnInfo(Vector vector, Vector vector2) {
        this._resultList.setColumnInfo(vector, vector2);
    }

    public int getMaxResults() {
        return this._resultList.getMaxResults();
    }

    public void setMaxResults(int n) {
        this._resultList.setMaxResults(n);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this._resultList.addListSelectionListener(listSelectionListener);
    }

    public void addTableMouseListener(MouseListener mouseListener) {
        this._resultList.addTableMouseListener(mouseListener);
    }

    public void doSearch(LDAPConnection lDAPConnection, LDAPUrl lDAPUrl) {
        this.doSearch(lDAPConnection, lDAPUrl.getDN(), lDAPUrl.getScope(), lDAPUrl.getFilter());
    }

    public void doSearch(LDAPConnection lDAPConnection, String string, String string2) {
        this.doSearch(lDAPConnection, string, 2, string2);
    }

    public void doSearch(LDAPConnection lDAPConnection, String string, int n, String string2) {
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = SearchResultPanel.class$("java.awt.Frame")) : class$java$awt$Frame, this);
        this.setProgressIndicator(this._resource.getString("SearchResultPanel", "CancelSearchLabel"));
        CancelSearchDialog cancelSearchDialog = new CancelSearchDialog(frame, this._resource.getString("SearchResultPanel", "CancelSearchTitle"), this._resource.getString("SearchResultPanel", "CancelSearchLabel"));
        SearchThread searchThread = new SearchThread(this._resultList, lDAPConnection, string, n, string2, cancelSearchDialog);
        cancelSearchDialog.setWorkThread(searchThread);
        searchThread.start();
        ((Component)cancelSearchDialog).setVisible(true);
        if (cancelSearchDialog.isCancel()) {
            this._resultList.cancelSearch();
            Debug.println("SearchResultPanel: search cancelled");
        }
        cancelSearchDialog.dispose();
        this.clearProgressIndicator();
    }

    private void setProgressIndicator(String string) {
        Framework framework = (Framework)SwingUtilities.getAncestorOfClass(class$com$netscape$management$client$Framework == null ? (class$com$netscape$management$client$Framework = SearchResultPanel.class$("com.netscape.management.client.Framework")) : class$com$netscape$management$client$Framework, this);
        if (framework == null) {
            return;
        }
        framework.setBusyCursor(true);
        framework.changeStatusItemState("StatusItemText", string);
        framework.changeStatusItemState("StatusItemProgress", StatusItemProgress.STATE_BUSY);
    }

    private void clearProgressIndicator() {
        Framework framework = (Framework)SwingUtilities.getAncestorOfClass(class$com$netscape$management$client$Framework == null ? (class$com$netscape$management$client$Framework = SearchResultPanel.class$("com.netscape.management.client.Framework")) : class$com$netscape$management$client$Framework, this);
        if (framework == null) {
            return;
        }
        framework.setBusyCursor(false);
        framework.changeStatusItemState("StatusItemText", "");
        framework.changeStatusItemState("StatusItemProgress", new Integer(0));
    }

    public int getSelectedRowCount() {
        return this._resultList.getSelectedRowCount();
    }

    public void addElement(LDAPEntry lDAPEntry) {
        this._resultList.addRow(lDAPEntry);
    }

    public void addElement(String string) {
        this._resultList.addRow(string);
    }

    public int getListCount() {
        return this._resultList.getRowCount();
    }

    public void removeAllElement() {
        this._resultList.deleteAllRows();
    }

    public void removeAllElements() {
        this._resultList.deleteAllRows();
    }

    public void deleteRows(Vector vector) {
        this._resultList.deleteRows(vector);
    }

    public LDAPEntry getSelectedItem() {
        return this._resultList.getRow(this._resultList.getSelectedRow());
    }

    public void updatedSelectedItem(LDAPEntry lDAPEntry) {
        this._resultList.replaceRow(lDAPEntry, this._resultList.getSelectedRow());
    }

    public Vector getSelectedEntries() {
        return this._resultList.getSelectedEntries();
    }

    public int rowAtPoint(Point point) {
        return this._resultList.rowAtPoint(point);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

