/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.ActionMonitorPanel;
import com.netscape.management.admserv.config.ConfigErrorDialog;
import com.netscape.management.admserv.config.RemoteRequestException;
import com.netscape.management.admserv.panel.IAdminOperationListener;
import com.netscape.management.admserv.panel.IRestartControl;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.Permissions;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JPanel;

public class AdminOperation {
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nStatus = _resource.getString("adminop", "Status");
    static String _i18nFailureStatus = _resource.getString("adminop", "FailureStatus");
    static String _i18nWarningStatus = _resource.getString("adminop", "WarningStatus");
    static String _i18nCanNotConnect = _resource.getString("adminop", "CanNotConnect");
    static String _i18nServerShutdown = _resource.getString("adminop", "ServerShutdown");
    static String _i18nOperationDone = _resource.getString("adminop", "OperationDone");
    static String _i18nOperationFailed = _resource.getString("adminop", "OperationFailed");
    protected ConsoleInfo _consoleInfo;
    protected boolean _actionPerformed;
    protected Hashtable _resultData;
    protected int _resultStatus;
    protected String _taskURL;
    protected IAdminOperationListener _listener;
    protected ActionMonitorPanel _actionPanel;
    protected AdmTask _task;

    public AdminOperation(ConsoleInfo consoleInfo, String taskURL) {
        this._consoleInfo = consoleInfo;
        this._taskURL = taskURL;
    }

    public JPanel getPanel() {
        return this._actionPanel;
    }

    public Hashtable getConsoleInfo() {
        return this._consoleInfo;
    }

    public Dialog getDialog() {
        Container c = this._actionPanel;
        Dialog dialog = null;
        while ((c = c.getParent()) != null) {
            if (!(c instanceof Dialog)) continue;
            dialog = (Dialog)c;
            break;
        }
        return dialog;
    }

    public Frame getFrame() {
        Container c = this._actionPanel;
        Frame frame = null;
        while ((c = c.getParent()) != null) {
            if (!(c instanceof Frame)) continue;
            frame = (Frame)c;
            break;
        }
        return frame;
    }

    protected void closeDialog() {
        Dialog dialog = this.getDialog();
        if (dialog != null) {
            ((Component)dialog).setVisible(false);
            dialog.dispose();
            ModalDialogUtil.sleep();
        }
    }

    protected void createActionPanel(boolean multilined) {
        this._actionPanel = new ActionMonitorPanel(multilined);
    }

    public void monitorOperation(String description) {
        this.monitorOperation(description, null);
    }

    public void monitorOperation(String description, IAdminOperationListener listener) {
        Method m;
        if (ActionMonitorPanel.getActiveInstance() != null) {
            this._actionPanel = ActionMonitorPanel.getActiveInstance();
            this._actionPanel.setStatusText(description);
            try {
                this.performOperation(listener);
            }
            catch (RemoteRequestException e) {
                ConfigErrorDialog.showDialog(this._actionPanel, e);
            }
            return;
        }
        if (this._actionPanel == null) {
            this.createActionPanel(false);
        }
        if ((m = Permissions.getEnablePrivilegeMethod()) != null) {
            Object[] args = new Object[]{"UniversalThreadGroupAccess"};
            try {
                m.invoke(null, args);
            }
            catch (Exception e) {
                Debug.println((String)("AdminOperation:monitorOperation():unable to grant ThreadGroup privileges:" + e));
            }
        }
        final ThreadGroup tg = new ThreadGroup("LongActionTG");
        final String status = description;
        final IAdminOperationListener listenerObject = listener;
        Thread t = new Thread(tg, "LongAction"){
            ActionListener _stopAction = new ActionListener(this){
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    1.access$000(this.this$1).closeDialog();
                }
            };

            /*
             * Loose catch block
             */
            public void run() {
                block12: {
                    boolean noError = true;
                    AdminOperation.this._actionPanel.monitorProgressStart(status, tg, this._stopAction);
                    AdminOperation.this.performOperation(listenerObject);
                    Object var4_2 = null;
                    if (noError && AdminOperation.this._actionPanel.isMultilined()) {
                        AdminOperation.this._actionPanel.monitorProgressWaitForClose();
                        return;
                    }
                    AdminOperation.this._actionPanel.monitorProgressStop(AdminOperation.this._actionPerformed ? _i18nOperationDone : _i18nOperationFailed);
                    try {
                        Thread.currentThread();
                        Thread.sleep(500L);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    AdminOperation.this.closeDialog();
                    {
                        break block12;
                        catch (RemoteRequestException e) {
                            ConfigErrorDialog.showDialog(AdminOperation.this._actionPanel, e);
                            noError = false;
                            Object var4_3 = null;
                            if (noError && AdminOperation.this._actionPanel.isMultilined()) {
                                AdminOperation.this._actionPanel.monitorProgressWaitForClose();
                                return;
                            }
                            AdminOperation.this._actionPanel.monitorProgressStop(AdminOperation.this._actionPerformed ? _i18nOperationDone : _i18nOperationFailed);
                            try {
                                Thread.currentThread();
                                Thread.sleep(500L);
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                            AdminOperation.this.closeDialog();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (noError && AdminOperation.this._actionPanel.isMultilined()) {
                            AdminOperation.this._actionPanel.monitorProgressWaitForClose();
                            return;
                        }
                        AdminOperation.this._actionPanel.monitorProgressStop(AdminOperation.this._actionPerformed ? _i18nOperationDone : _i18nOperationFailed);
                        try {
                            Thread.currentThread();
                            Thread.sleep(500L);
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        AdminOperation.this.closeDialog();
                        throw throwable;
                    }
                }
            }

            static /* synthetic */ AdminOperation access$000(1 x0) {
                return x0.AdminOperation.this;
            }
        };
        t.start();
    }

    public void performOperation(IAdminOperationListener listener) throws RemoteRequestException {
        this.performOperationalTask(this._consoleInfo, this._taskURL);
        if (listener != null) {
            listener.cgiRequestCompleted(this._consoleInfo);
        }
    }

    protected void createTask(ConsoleInfo ci, String adminURL) throws RemoteRequestException {
        try {
            this._task = new AdmTask(new URL(adminURL), ci.getAuthenticationDN(), ci.getAuthenticationPassword());
        }
        catch (MalformedURLException e) {
            Debug.println((String)("" + e));
            throw new RemoteRequestException(e);
        }
    }

    public void performOperationalTask(ConsoleInfo ci, String taskURL) throws RemoteRequestException {
        String adminURL = ci.getAdminURL() + taskURL;
        this.createTask(ci, adminURL);
        this._task.exec();
        this._resultStatus = this._task.getStatus();
        this._resultData = this._task.getResult();
        this._actionPerformed = this._resultStatus == 0 || this._resultStatus == 3;
        this.processAdmTaskStatus(adminURL);
    }

    public boolean isActionPerformed() {
        return this._actionPerformed;
    }

    public int getResultStatus() {
        return this._resultStatus;
    }

    public Hashtable getResultData() {
        return this._resultData;
    }

    protected void processAdmTaskStatus(String url) throws RemoteRequestException {
        AdminOperation.processAdmTaskStatus(url, this._task, this._consoleInfo);
    }

    public static void processAdmTaskStatus(String url, AdmTask task, ConsoleInfo ci) throws RemoteRequestException {
        int status = task.getStatus();
        if (status == 0 || status == 3) {
            return;
        }
        if (status < 0) {
            Debug.println((String)("HTTP Exception status=" + status + " " + task.getException()));
            if (task.getException() != null && task.getException() instanceof SocketException) {
                IRestartControl serverStatus = (IRestartControl)ci.get("RESTART_CONTROL");
                if (serverStatus != null) {
                    if (serverStatus.isServerShutdown()) {
                        throw new RemoteRequestException("", _i18nServerShutdown);
                    }
                } else {
                    Debug.println((String)"StopOperation: restart activator not in ConsoleInfo");
                }
                throw new RemoteRequestException(url, _i18nCanNotConnect + " " + task.getException().getMessage());
            }
            if (task.getException() != null) {
                throw new RemoteRequestException(task.getException());
            }
            throw new RemoteRequestException(url, _i18nStatus + status);
        }
        String type = status == 1 ? _i18nStatus + _i18nFailureStatus : (status == 2 ? _i18nStatus + _i18nWarningStatus : _i18nStatus + " " + status);
        String msg = "";
        Hashtable result = task.getResult();
        if (result != null) {
            Enumeration e = result.elements();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                msg = msg + key + "\n";
            }
        }
        Debug.println((String)("CGI error " + type + "\n" + msg));
        throw new RemoteRequestException(url, type + "\n" + msg);
    }
}

