/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.DSExportImport;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.IEntryChangeListener;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPExtendedOperation;

public class BulkImport
implements IEntryChangeListener,
Runnable,
ActionListener {
    String _currentBackend;
    private GenericProgressDialog _dlg;
    private String[] _backends;
    private String _importPath;
    private String _rejects;
    private boolean _continue = true;
    private boolean _done = false;
    private DSExportImport _ds;
    private int _result = 0;
    private IDSModel _model;
    private static final ResourceSet _resource = DSUtil._resource;
    private static final String CANCEL = "cancel";
    private static final String CLOSE = "close";
    private final String START_BULK_IMPORT_OID = "2.16.840.1.113730.3.5.7";
    private final String FINISH_BULK_IMPORT_OID = "2.16.840.1.113730.3.5.8";
    private static final String _section = "import";

    public BulkImport(String[] stringArray, String string, String string2, IDSModel iDSModel, GenericProgressDialog genericProgressDialog) {
        this._backends = stringArray;
        this._importPath = string;
        this._rejects = string2;
        this._model = iDSModel;
        this._dlg = genericProgressDialog;
        this.setupDialog();
    }

    protected void setupDialog() {
        this._dlg.addStep(_resource.getString(_section, "LDAPMode-firstStep-title"));
        this._dlg.addStep(_resource.getString(_section, "LDAPMode-secondStep-title"));
        this._dlg.addStep(_resource.getString(_section, "LDAPMode-thirdStep-title"));
        this._dlg.addActionListener(this);
        this._dlg.setLabelRows(2);
        this._dlg.setTextInTextAreaLabel(_resource.getString(_section, "status-progressdialog-label"));
        this._dlg.setTextAreaRows(5);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Cancel-GenericProgressDialog")) {
            this._continue = false;
            this._dlg.disableCancelButton();
            this._dlg.setTextInLabel(_resource.getString(_section, "LDAPMode-cancelled-title"));
            if (this._done) {
                this._dlg.closeCallBack();
            }
        } else if (actionEvent.getActionCommand().equals("Close-GenericProgressDialog")) {
            this._continue = false;
            if (this._done) {
                this._dlg.closeCallBack();
            }
        }
    }

    public boolean entryChanged(String string, String string2) {
        if (this._continue && string != null) {
            if (this._ds.getCurrentEntry() % 5 == 0) {
                String[] stringArray = new String[]{String.valueOf(this._ds.getCurrentEntry()), DSUtil.abreviateString(string, 60)};
                this._dlg.setTextInLabel(_resource.getString(_section, "addingentrynumber-label", stringArray));
            }
            if (string2 != null) {
                if (!string.trim().equals("")) {
                    this._dlg.appendTextToTextArea(DSUtil.abreviateString(string, 30) + ": " + string2 + "\n");
                } else {
                    this._dlg.appendTextToTextArea(string2 + "\n");
                }
            }
            return true;
        }
        return false;
    }

    public boolean entryChanged(String string) {
        return this.entryChanged(string, null);
    }

    public void run() {
        try {
            Thread.sleep(400L);
        }
        catch (Exception exception) {
            Debug.println((String)("BulkImport.run: " + exception));
            exception.printStackTrace();
        }
        this.executeBulkImport(this._backends, this._importPath, this._rejects);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeBulkImport(String[] stringArray, String string, String string2) {
        LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
        String string3 = _resource.getString(_section, "title");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < stringArray.length) {
            block48: {
                block50: {
                    String[] stringArray2;
                    String string4;
                    String string5;
                    block49: {
                        boolean bl;
                        block46: {
                            LDAPExtendedOperation lDAPExtendedOperation;
                            LDAPExtendedOperation lDAPExtendedOperation2;
                            String[] stringArray3;
                            block47: {
                                String string6;
                                this._currentBackend = stringArray[n2];
                                this._result = 0;
                                this._dlg.reset();
                                string5 = MappingUtils.getSuffixForBackend(lDAPConnection, this._currentBackend);
                                if (stringArray.length > 1) {
                                    stringArray3 = new String[]{DSUtil.inverseAbreviateString(string, 40), DSUtil.abreviateString(this._currentBackend, 30), String.valueOf(n2 + 1), String.valueOf(stringArray.length)};
                                    string6 = _resource.getString(_section, "LDAPMode-progresslabel-title", stringArray3);
                                } else {
                                    stringArray3 = new String[]{DSUtil.inverseAbreviateString(string, 40), DSUtil.abreviateString(this._currentBackend, 30)};
                                    string6 = _resource.getString(_section, "LDAPMode-progresslabel-one-partition-title", stringArray3);
                                }
                                this._dlg.setTextInLabel(string6);
                                try {
                                    stringArray3 = (String[])string5.getBytes("UTF8");
                                    lDAPExtendedOperation2 = new LDAPExtendedOperation("2.16.840.1.113730.3.5.7", (byte[])stringArray3);
                                    lDAPExtendedOperation = lDAPConnection.extendedOperation(lDAPExtendedOperation2);
                                    if (lDAPExtendedOperation == null) {
                                        Debug.println((String)"BulkImport.executeBulkImport(): the answer to the extended operation is null");
                                        this._dlg.appendTextToTextArea(_resource.getString(_section, "BulkAddError-ExtendedOperationError-NoResponse-msg") + "\n");
                                        this._result = -1;
                                    }
                                    if (!lDAPExtendedOperation.getID().equals("2.16.840.1.113730.3.5.7")) {
                                        Debug.println((String)"BulkImport.executeBulkImport(): the answer to the extended operation is NO GOOD");
                                        this._dlg.appendTextToTextArea(_resource.getString(_section, "BulkAddError-ExtendedOperationError-NoGoodResponse-msg") + "\n");
                                        this._result = -1;
                                    }
                                }
                                catch (LDAPException lDAPException) {
                                    Debug.println((String)("BulkImport.executeBulkImport(): LDAPException" + (Object)((Object)lDAPException)));
                                    this._dlg.appendTextToTextArea(lDAPException.errorCodeToString() + "\n");
                                    this._result = -1;
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    Debug.println((String)"BulkImport.executeBulkImport(): Error: UTF8 not supported");
                                }
                                if (this._result != -1) break block47;
                                if (n2 < stringArray.length - 1) {
                                    try {
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            public void run() {
                                                int n = DSUtil.showConfirmationDialog((Component)BulkImport.this._dlg, "LDAPMode-unsuccessful-wantToCancel", BulkImport.this._currentBackend, BulkImport._section);
                                                if (n != 0) {
                                                    BulkImport.this._continue = false;
                                                }
                                            }
                                        });
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (!this._continue) {
                                        this._dlg.closeCallBack();
                                        break;
                                    }
                                    break block48;
                                } else {
                                    this._dlg.setTextInLabel(_resource.getString(_section, "LDAPMode-endError-title"));
                                    this._continue = false;
                                    this._dlg.closeCallBack();
                                    break;
                                }
                            }
                            this._dlg.stepCompleted(0);
                            stringArray3 = new String[]{string5};
                            if (stringArray3[0] != null) {
                                boolean bl2 = true;
                                this._ds = new DSExportImport(lDAPConnection, string, true, bl2, string2);
                                this._ds.addEntryChangeListener(this);
                                this._ds.run();
                                boolean bl3 = this._ds.getStatus();
                                if (!bl3) {
                                    if (this._ds.getError() == 3) {
                                        Debug.println((String)"BulkImport.executeBulkImport(): Error: status unwritable)");
                                        String[] stringArray4 = new String[2];
                                        stringArray4[0] = this._rejects;
                                        stringArray4[1] = Integer.toString(3);
                                        String[] stringArray5 = stringArray4;
                                        this._dlg.appendTextToTextArea(_resource.getString(_section, "unwritable-msg", stringArray5) + "\n");
                                    } else if (this._ds.getError() == 4) {
                                        String[] stringArray6 = new String[2];
                                        stringArray6[0] = DSUtil.abreviateString(this._ds.getLastDN(), 45);
                                        stringArray6[1] = Integer.toString(4);
                                        String[] stringArray7 = stringArray6;
                                        this._dlg.appendTextToTextArea(_resource.getString("general", "BulkAddError-ldifSyntaxError-msg", stringArray7) + "\n");
                                    } else if (this._ds.getError() == 5) {
                                        int n3 = this._ds.getEntryCount() + this._ds.getRejectCount() + 1;
                                        string4 = this._ds.getLastDN();
                                        if (string4 == null) {
                                            String[] stringArray8 = new String[2];
                                            stringArray8[0] = Integer.toString(n3);
                                            stringArray8[1] = Integer.toString(5);
                                            stringArray2 = stringArray8;
                                            this._dlg.appendTextToTextArea(_resource.getString(_section, "malformed-expression-error-number-msg", stringArray2) + "\n");
                                        } else {
                                            String[] stringArray9 = new String[2];
                                            stringArray9[0] = DSUtil.abreviateString(string4, 45);
                                            stringArray9[1] = Integer.toString(5);
                                            stringArray2 = stringArray9;
                                            this._dlg.appendTextToTextArea(_resource.getString(_section, "malformed-expression-error-dn-msg", stringArray2) + "\n");
                                        }
                                    } else {
                                        Debug.println((String)"BulkImport.executeBulkImport(): Error in status");
                                        String[] stringArray10 = new String[]{Integer.toString(this._ds.getError())};
                                        this._dlg.appendTextToTextArea(_resource.getString(_section, "failed-msg", stringArray10));
                                    }
                                    this._result = -1;
                                    this._dlg.setTextInLabel(_resource.getString(_section, "error-partition-wait-title"));
                                }
                                this._dlg.stepCompleted(1);
                            } else {
                                String[] stringArray11 = new String[]{this._currentBackend};
                                this._dlg.appendTextToTextArea(_resource.getString(_section, "suffix-not-found-error-msg", stringArray11));
                                this._dlg.setTextInLabel(_resource.getString(_section, "error-partition-wait-title"));
                                this._result = -1;
                            }
                            bl = false;
                            try {
                                byte[] byArray = string5.getBytes("UTF8");
                                lDAPExtendedOperation2 = new LDAPExtendedOperation("2.16.840.1.113730.3.5.8", byArray);
                                lDAPExtendedOperation = lDAPConnection.extendedOperation(lDAPExtendedOperation2);
                                if (lDAPExtendedOperation == null) {
                                    Debug.println((String)"BulkImport.executeBulkImport()): the answer to the STOP extended operation is null");
                                    this._dlg.appendTextToTextArea(_resource.getString(_section, "failed"));
                                    this._result = -1;
                                    bl = true;
                                    break block46;
                                }
                                if (!lDAPExtendedOperation.getID().equals("2.16.840.1.113730.3.5.8")) {
                                    Debug.println((String)"BulkImport.executeBulkImport(): the answer to the STOP extended operation is NO GOOD");
                                    this._dlg.appendTextToTextArea(_resource.getString(_section, "failed"));
                                    this._result = -1;
                                    bl = true;
                                }
                            }
                            catch (LDAPException lDAPException) {
                                Debug.println((String)("BulkImport.executeBulkImport(): in STOP LDAPException " + (Object)((Object)lDAPException)));
                                this._dlg.appendTextToTextArea(lDAPException.errorCodeToString());
                                this._result = -1;
                                bl = true;
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                Debug.println((String)"BulkImport.executeBulkImport(): Error: UTF8 not supported");
                                this._dlg.appendTextToTextArea(_resource.getString(_section, "failed"));
                                this._result = -1;
                                bl = true;
                            }
                        }
                        if (!bl) {
                            this._dlg.stepCompleted(1);
                            this._dlg.stepCompleted(2);
                        }
                        if (this._result == 0 || !this._continue) break block49;
                        if (n2 < stringArray.length - 1) {
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    public void run() {
                                        int n = DSUtil.showConfirmationDialog((Component)BulkImport.this._dlg, "LDAPMode-unsuccessful-wantToCancel", BulkImport.this._currentBackend, BulkImport._section);
                                        if (n != 0) {
                                            BulkImport.this._continue = false;
                                        }
                                    }
                                });
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (!this._continue) {
                                this._dlg.setTextInLabel(_resource.getString(_section, "LDAPMode-cancelled-title"));
                            }
                        }
                        break block50;
                    }
                    if (this._result == 0 && !this._continue) {
                        try {
                            final String[] stringArray12 = new String[]{this._currentBackend};
                            this._dlg.setTextInLabel(_resource.getString(_section, "LDAPMode-backend-cleanup-label", stringArray12));
                            boolean bl = this.cleanUpBackend(lDAPConnection, string5);
                            if (!bl) {
                                try {
                                    SwingUtilities.invokeAndWait(new Runnable(){

                                        public void run() {
                                            DSUtil.showErrorDialog((Component)BulkImport.this._dlg, "LDAPMode-backend-cleanup-error-title", "LDAPMode-backend-cleanup-error-msg", stringArray12, BulkImport._section);
                                        }
                                    });
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                        catch (LDAPException lDAPException) {
                            String string7 = lDAPException.errorCodeToString();
                            string4 = lDAPException.getLDAPErrorMessage();
                            if (string4 != null && string4.length() > 0) {
                                string7 = string7 + ". " + string4;
                            }
                            stringArray2 = new String[]{this._currentBackend, string7};
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    public void run() {
                                        DSUtil.showErrorDialog((Component)BulkImport.this._dlg, "LDAPMode-backend-cleanup-ldaperror-title", "LDAPMode-backend-cleanup-ldaperror-msg", stringArray2, BulkImport._section);
                                    }
                                });
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }
                if (!this._continue) {
                    this._dlg.closeCallBack();
                    break;
                }
            }
            ++n2;
        }
        this._done = true;
        this._dlg.waitForClose();
        if (this._result == 0) {
            this._dlg.setTextInLabel(_resource.getString(_section, "LDAPMode-finished-title"));
            return;
        }
        this._dlg.setTextInLabel(_resource.getString(_section, "LDAPMode-endError-title"));
    }

    public int getResult() {
        return this._result;
    }

    private IDSModel getModel() {
        return this._model;
    }

    private boolean cleanUpBackend(LDAPConnection lDAPConnection, String string) throws LDAPException {
        LDAPExtendedOperation lDAPExtendedOperation;
        LDAPExtendedOperation lDAPExtendedOperation2;
        if (string == null || lDAPConnection == null) {
            throw new IllegalArgumentException("The suffix of the connection are null");
        }
        boolean bl = false;
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        if (byArray != null && (lDAPExtendedOperation2 = lDAPConnection.extendedOperation(lDAPExtendedOperation = new LDAPExtendedOperation("2.16.840.1.113730.3.5.7", byArray))) != null && lDAPExtendedOperation2.getID().equals("2.16.840.1.113730.3.5.7") && (lDAPExtendedOperation2 = lDAPConnection.extendedOperation(lDAPExtendedOperation = new LDAPExtendedOperation("2.16.840.1.113730.3.5.8", byArray))) != null && lDAPExtendedOperation2.getID().equals("2.16.840.1.113730.3.5.8")) {
            bl = true;
        }
        return bl;
    }
}

