/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.Clipboard;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JFrame;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

class Paster
implements Runnable,
ActionListener {
    boolean _isCancelled = false;
    JFrame _frame;
    GenericProgressDialog _progressDialog;
    Clipboard _clipboard;
    Vector _pastedRootEntries;
    int _numberPastedObjects = 0;
    String _startDn;
    LDAPConnection _ldc;

    public Paster(LDAPConnection lDAPConnection, String string, JFrame jFrame, Clipboard clipboard) {
        this._frame = jFrame;
        this._ldc = lDAPConnection;
        this._startDn = string;
        this._clipboard = clipboard;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Cancel-GenericProgressDialog")) {
            this._isCancelled = true;
            this._progressDialog.disableCancelButton();
        } else if (actionEvent.getActionCommand().equals("Close-GenericProgressDialog")) {
            this._progressDialog.closeCallBack();
        }
    }

    public void execute() {
        if (this._startDn.equals("") && this._clipboard.getSize() > 0) {
            DSUtil.showErrorDialog((Component)this._frame, "paste-in-root-error-title", "paste-in-root-error-msg", (String[])null, "browser");
        } else {
            this.createPasteProgressDialog();
            Thread thread = new Thread(this);
            thread.start();
            this._progressDialog.packAndShow();
        }
    }

    public void run() {
        this._pastedRootEntries = new Vector();
        boolean bl = this.pasteTree(this._ldc, this._startDn, this._pastedRootEntries);
        this.updateProgressDialogForEnd(bl);
    }

    public Vector getPastedRootEntries() {
        return this._pastedRootEntries;
    }

    private boolean pasteTree(LDAPConnection lDAPConnection, String string, Vector vector) {
        Vector vector2 = new Vector();
        boolean bl = true;
        int n = 0;
        while (n < this._clipboard.getSize() && !this._isCancelled) {
            LDAPEntry lDAPEntry = this._clipboard.getEntryAt(n);
            LDAPEntry lDAPEntry2 = this.getEntryToPaste(lDAPEntry, string, vector2);
            try {
                String string2;
                DN dN;
                lDAPConnection.add(lDAPEntry2);
                if (this._numberPastedObjects % 5 == 0) {
                    dN = new DN[]{DSUtil.abreviateString(lDAPEntry2.getDN(), 45)};
                    string2 = DSUtil._resource.getString("browser", "pasting-object-label", (String[])dN);
                    this._progressDialog.setTextInLabel(string2);
                }
                ++this._numberPastedObjects;
                dN = (DN)vector2.elementAt(vector2.size() - 1);
                if (dN.equals((DN)(string2 = new DN(lDAPEntry.getDN())))) {
                    vector.addElement(lDAPEntry2.getDN());
                }
            }
            catch (LDAPException lDAPException) {
                bl = false;
                Debug.println((String)("Paster.pasteTree: error pasting entry=" + lDAPEntry2.getDN() + ":" + (Object)((Object)lDAPException)));
                this._progressDialog.appendTextToTextArea(lDAPEntry2.getDN() + ": " + (Object)((Object)lDAPException) + "\n");
            }
            ++n;
        }
        return bl;
    }

    private LDAPEntry getEntryToPaste(LDAPEntry lDAPEntry, String string, Vector vector) {
        LDAPAttributeSet lDAPAttributeSet;
        DN dN = new DN(lDAPEntry.getDN());
        String[] stringArray = LDAPDN.explodeDN((String)lDAPEntry.getDN(), (boolean)false);
        String string2 = "";
        boolean bl = false;
        int n = 0;
        while (n < vector.size() && !bl) {
            if (dN.isDescendantOf((DN)vector.elementAt(n))) {
                bl = true;
                lDAPAttributeSet = (DN)vector.elementAt(n);
                int n2 = lDAPAttributeSet.countRDNs();
                int n3 = dN.countRDNs();
                int n4 = 0;
                while (n4 <= n3 - n2) {
                    string2 = string2 + stringArray[n4] + ", ";
                    ++n4;
                }
                string2 = string2 + string;
            }
            ++n;
        }
        if (!bl) {
            vector.addElement(dN);
            string2 = stringArray[0] + ", " + string;
        }
        lDAPAttributeSet = lDAPEntry.getAttributeSet();
        LDAPEntry lDAPEntry2 = new LDAPEntry(string2, lDAPAttributeSet);
        return lDAPEntry2;
    }

    private void updateProgressDialogForEnd(boolean bl) {
        if (this._isCancelled || this._numberPastedObjects < 2 && bl) {
            this._progressDialog.closeCallBack();
        } else {
            String[] stringArray = new String[]{String.valueOf(this._numberPastedObjects)};
            this._progressDialog.setTextInLabel(DSUtil._resource.getString("browser", "pasted-objects-label", stringArray));
            this._progressDialog.waitForClose();
        }
    }

    private void createPasteProgressDialog() {
        String string = DSUtil._resource.getString("browser", "paste-objects-title");
        this._progressDialog = new GenericProgressDialog(this._frame, true, 7, string, null, null);
        this._progressDialog.setTextInTextAreaLabel(DSUtil._resource.getString("browser", "non-pasted-objects-label"));
        this._progressDialog.setTextAreaRows(3);
        this._progressDialog.setLabelColumns(50);
        this._progressDialog.addActionListener(this);
    }
}

