/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.node;

import com.netscape.admin.dirserv.DSResourceModel;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.node.DSResourceObject;
import com.netscape.admin.dirserv.node.DataRootResourceObject;
import com.netscape.admin.dirserv.node.LogConfigResourceObject;
import com.netscape.admin.dirserv.node.PluginResourceObject;
import com.netscape.admin.dirserv.node.SchemaResourceObject;
import com.netscape.admin.dirserv.panel.RootPanel;
import com.netscape.admin.dirserv.panel.replication.ReplicationResourceObject;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class RootResourceObject
extends DSResourceObject
implements ActionListener,
IMenuInfo {
    protected String[] _categoryID;
    protected IMenuItem[] _contextMenuItems;
    protected IMenuItem[] _objectMenuItems;
    private boolean _isLoaded = false;
    private static final String serverIconName = "directory.gif";
    private static final String serverIconNameL = "directm.gif";
    private ReplicationResourceObject _repNode = null;

    public RootResourceObject(IDSModel iDSModel) {
        super(iDSModel.getServerInfo().getHost() + ":" + iDSModel.getServerInfo().getPort(), DSUtil.getPackageImage(serverIconName), DSUtil.getPackageImage(serverIconNameL), iDSModel);
        this.reload();
        this.refreshTree();
        this._model.setSelectedNode((IResourceObject)this);
    }

    private void makeTree() {
        ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)new DataRootResourceObject(this._model)));
        this._repNode = new ReplicationResourceObject(DSResourceObject._resource.getString("resourcepage", "ReplicationAgreements"), DSResourceObject.groupIcon, DSResourceObject.groupIconL, this._model);
        ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)this._repNode));
        ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)new SchemaResourceObject(this._model)));
        ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)new LogConfigResourceObject(this._model)));
        ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)new PluginResourceObject(this._model)));
    }

    public Component getCustomPanel() {
        if (this._panel == null) {
            this._panel = new RootPanel(this._model);
        }
        return this._panel;
    }

    public ReplicationResourceObject getReplicationObject() {
        return this._repNode;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("refresh")) {
            this.reload();
            this.refreshTree();
            this._model.setSelectedNode((IResourceObject)this);
        }
    }

    public String[] getMenuCategoryIDs() {
        if (this._categoryID == null) {
            this._categoryID = new String[]{"OBJECT", "CONTEXT"};
        }
        return this._categoryID;
    }

    public IMenuItem[] getMenuItems(String string) {
        if (string.equals("CONTEXT")) {
            if (this._contextMenuItems == null) {
                this._contextMenuItems = this.createMenuItems();
            }
            return this._contextMenuItems;
        }
        if (string.equals("OBJECT")) {
            if (this._objectMenuItems == null) {
                this._objectMenuItems = this.createMenuItems();
            }
            return this._objectMenuItems;
        }
        return null;
    }

    private IMenuItem[] createMenuItems() {
        return new IMenuItem[]{new MenuItemText("refresh", DSUtil._resource.getString("menu", "refresh"), DSUtil._resource.getString("menu", "refresh-description"))};
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if (iMenuItem.getID().equals("refresh")) {
            ((DSResourceModel)this._model).actionMenuSelected(iPage, iMenuItem);
        }
    }

    void refreshTree() {
        this._model.fireTreeStructureChanged(this);
    }

    void reload() {
        this.cleanTree();
        this.makeTree();
        this._isLoaded = true;
    }

    public boolean isLoaded() {
        return this._isLoaded;
    }

    private void cleanTree() {
        ((DefaultMutableTreeNode)((Object)this)).removeAllChildren();
    }

    public void select(IPage iPage) {
        if (!this.isLoaded()) {
            this.reload();
        }
        super.select(iPage);
    }

    public boolean run(IPage iPage) {
        Debug.println((String)("RootResourceObject.run(" + iPage.getClass().getName() + ")"));
        this.reload();
        if (super.getChildCount() != 0) {
            this.expandPath((ResourcePage)iPage);
        }
        this.refreshTree();
        return true;
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        return this.run(iPage);
    }

    private void expandPath(ResourcePage resourcePage) {
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)((Object)this)).getPath());
        resourcePage.expandTreePath(treePath);
    }

    public boolean isLeaf() {
        return false;
    }
}

