/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.panel.DSEntry;
import java.util.Enumeration;
import java.util.Hashtable;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class ConfigEntry {
    private LDAPEntry _configEntry = null;
    private String _configDN;
    private LDAPConnection _ldc;
    private LDAPAttribute[] _addAttrs = null;
    private Hashtable _attrTable = new Hashtable();

    public ConfigEntry(String string, LDAPConnection lDAPConnection) {
        this._configDN = string;
        this._ldc = lDAPConnection;
    }

    public void addAttribute(String string, DSEntry dSEntry) {
        this._attrTable.put(string, dSEntry);
    }

    public void setAddAttributes(LDAPAttribute[] lDAPAttributeArray) {
        this._addAttrs = lDAPAttributeArray;
    }

    public void read() throws LDAPException {
        Enumeration enumeration;
        LDAPEntry lDAPEntry;
        block7: {
            lDAPEntry = null;
            int n = this._attrTable.size();
            if (n == 0) {
                return;
            }
            String[] stringArray = new String[n];
            enumeration = this._attrTable.keys();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                stringArray[n2] = (String)enumeration.nextElement();
                ++n2;
            }
            try {
                lDAPEntry = this._ldc.read(this._configDN, stringArray);
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) break block7;
                throw lDAPException;
            }
        }
        this._configEntry = lDAPEntry;
        enumeration = this._attrTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            DSEntry dSEntry = (DSEntry)this._attrTable.get(string);
            if (lDAPEntry != null) {
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
                dSEntry.remoteToLocal(lDAPAttribute.getStringValues());
            } else {
                dSEntry.remoteToLocal("");
            }
            dSEntry.show();
        }
    }

    public void write() throws LDAPException {
        if (this._configEntry == null) {
            this._configEntry = this.addEntry();
        } else {
            this.modifyEntry();
        }
    }

    public void delete() throws LDAPException {
        this._ldc.delete(this._configDN);
    }

    private LDAPEntry addEntry() throws LDAPException {
        DSEntry dSEntry;
        LDAPAttributeSet lDAPAttributeSet = this._addAttrs != null ? new LDAPAttributeSet(this._addAttrs) : new LDAPAttributeSet();
        Enumeration enumeration = this._attrTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            dSEntry = (DSEntry)this._attrTable.get(string);
            dSEntry.store();
            String[] stringArray = dSEntry.localToRemote();
            LDAPAttribute lDAPAttribute = new LDAPAttribute(string, stringArray);
            lDAPAttributeSet.add(lDAPAttribute);
        }
        LDAPEntry lDAPEntry = new LDAPEntry(this._configDN, lDAPAttributeSet);
        try {
            this._ldc.add(lDAPEntry);
        }
        catch (LDAPException lDAPException) {
            lDAPEntry = null;
            throw lDAPException;
        }
        Enumeration enumeration2 = this._attrTable.elements();
        while (enumeration2.hasMoreElements()) {
            dSEntry = (DSEntry)enumeration2.nextElement();
            dSEntry.reset();
        }
        return lDAPEntry;
    }

    private void modifyEntry() throws LDAPException {
        DSEntry dSEntry;
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        Enumeration enumeration = this._attrTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            dSEntry = (DSEntry)this._attrTable.get(string);
            dSEntry.store();
            if (!dSEntry.getDirty()) continue;
            String[] stringArray = dSEntry.localToRemote();
            LDAPAttribute lDAPAttribute = new LDAPAttribute(string, stringArray);
            lDAPModificationSet.add(2, lDAPAttribute);
        }
        this._ldc.modify(this._configDN, lDAPModificationSet);
        Enumeration enumeration2 = this._attrTable.elements();
        while (enumeration2.hasMoreElements()) {
            dSEntry = (DSEntry)enumeration2.nextElement();
            dSEntry.reset();
        }
    }
}

