/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.logging.DSLogViewerModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.components.Table;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class DSLogViewer
extends BlankPanel
implements TableModelListener {
    private JTable _table = null;
    private boolean _initialized = false;
    private int _y = 0;
    private JTextField _tfLines;
    private JTextField _tfFilter;
    private JComboBox _cbFilename;
    private String _configDN = null;
    private String _configAttr = null;
    private String _configListAttr = null;
    private ResourceSet _resource = DSUtil._resource;
    private static final String _section = "logcontent";

    public DSLogViewer(IDSModel iDSModel, DSLogViewerModel dSLogViewerModel, String string, String string2, String string3) {
        super(iDSModel, false);
        this._configDN = string;
        this._configAttr = string2;
        this._configListAttr = string3;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        if (string != null && string2 != null) {
            this.createFileSelectionArea(jPanel);
        }
        this.createLineCountArea(jPanel);
        this._table = this.createTable(dSLogViewerModel);
        this._table.setFont(new Font("Monospaced", 0, 10));
        JScrollPane jScrollPane = new JScrollPane(this._table);
        jScrollPane.setMinimumSize(new Dimension(300, 200));
        this._myPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        this._myPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this._myPanel.add((Component)jScrollPane, gridBagConstraints);
        this.refreshFileSelector();
    }

    public DSLogViewer(IDSModel iDSModel, DSLogViewerModel dSLogViewerModel) {
        this(iDSModel, dSLogViewerModel, null, null, null);
    }

    protected boolean refreshFileSelector() {
        block8: {
            this._cbFilename.removeItemListener(this);
            this._cbFilename.removeAllItems();
            LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
            String[] stringArray = new String[]{this._configAttr, this._configListAttr};
            try {
                LDAPEntry lDAPEntry = lDAPConnection.read(this._configDN, stringArray);
                if (lDAPEntry != null) {
                    Enumeration enumeration;
                    LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(stringArray[0]);
                    if (lDAPAttribute != null) {
                        enumeration = lDAPAttribute.getStringValues();
                        while (enumeration.hasMoreElements()) {
                            this._cbFilename.addItem((String)enumeration.nextElement());
                        }
                    }
                    if ((lDAPAttribute = lDAPEntry.getAttribute(stringArray[1])) != null) {
                        enumeration = lDAPAttribute.getStringValues();
                        while (enumeration.hasMoreElements()) {
                            this._cbFilename.addItem((String)enumeration.nextElement());
                        }
                    }
                    break block8;
                }
                return false;
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("AccessLogContentPanel.refreshFileSelector: " + (Object)((Object)lDAPException)));
                return false;
            }
        }
        this._cbFilename.setSelectedIndex(0);
        if (this._table != null) {
            ((DSLogViewerModel)this._table.getModel()).setLogFileName((String)this._cbFilename.getSelectedItem());
        }
        this._cbFilename.addItemListener(this);
        return true;
    }

    private void createFileSelectionArea(JPanel jPanel) {
        this._cbFilename = this.makeJComboBox();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JLabel jLabel = this.makeJLabel(_section, "selectlog");
        jLabel.setLabelFor(this._cbFilename);
        this._myPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        jPanel2.add(Box.createHorizontalStrut(UIFactory.getComponentSpace()), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this._cbFilename, gridBagConstraints);
        gridBagConstraints = this.getGBC();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this._y++;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jPanel2, gridBagConstraints);
    }

    private void createLineCountArea(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        int n = UIFactory.getComponentSpace();
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        gridBagConstraints.anchor = 17;
        JLabel jLabel = this.makeJLabel(_section, "lines");
        jPanel2.add((Component)jLabel, gridBagConstraints);
        jPanel2.add(Box.createHorizontalStrut(n), gridBagConstraints);
        this._tfLines = this.makeJTextField(_section, "lines");
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        jLabel.setLabelFor(this._tfLines);
        jPanel2.add((Component)this._tfLines, gridBagConstraints);
        jPanel2.add(Box.createHorizontalStrut(n), gridBagConstraints);
        jPanel2.add(Box.createHorizontalStrut(n), gridBagConstraints);
        jLabel = this.makeJLabel(_section, "filter");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        jPanel2.add(Box.createHorizontalStrut(n), gridBagConstraints);
        this._tfFilter = this.makeJTextField(_section, "filter");
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jLabel.setLabelFor(this._tfFilter);
        jPanel2.add((Component)this._tfFilter, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints = this.getGBC();
        gridBagConstraints.gridheight = this._y + 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this._y++;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jPanel2, gridBagConstraints);
    }

    private JTable createTable(DSLogViewerModel dSLogViewerModel) {
        Table table = new Table((TableModel)dSLogViewerModel);
        table.setAutoCreateColumnsFromModel(true);
        table.setShowGrid(true);
        table.getTableHeader().setReorderingAllowed(false);
        table.setRowSelectionAllowed(false);
        table.getAccessibleContext().setAccessibleDescription(this._resource.getString(_section, "table-description"));
        table.getModel().addTableModelListener(this);
        return table;
    }

    protected int getTotalColumnWidth(JTable jTable) {
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            n += tableColumn.getWidth();
        }
        return n;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    public JTable getTable() {
        return this._table;
    }

    public boolean refresh() {
        this.refreshFileSelector();
        return this.updateContents();
    }

    public void scrollToEnd() {
        Rectangle rectangle = this._table.getCellRect(this._table.getRowCount() - 1, 0, false);
        this._table.scrollRectToVisible(rectangle);
    }

    boolean updateContents() {
        DSLogViewerModel dSLogViewerModel = (DSLogViewerModel)this.getTable().getModel();
        Debug.println((String)("DSLogViewer.updateContents: " + dSLogViewerModel.getLogFileName()));
        String string = this._tfFilter.getText();
        if (string.length() < 1) {
            string = null;
        }
        dSLogViewerModel.setFilter(string);
        String string2 = this._tfLines.getText();
        if (string2.length() > 0) {
            int n;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            if (n >= 1) {
                dSLogViewerModel.setLineCount(n);
            } else {
                this._tfLines.setText(Integer.toString(dSLogViewerModel.getLineCount()));
            }
        }
        dSLogViewerModel.updateNow();
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this._cbFilename)) {
            String string;
            int n = this._cbFilename.getSelectedIndex();
            if (n >= 0 && (string = (String)this._cbFilename.getItemAt(n)) != null && this._table != null) {
                DSLogViewerModel dSLogViewerModel = (DSLogViewerModel)this._table.getModel();
                dSLogViewerModel.setLogFileName(string);
                this.updateContents();
            }
        } else {
            super.itemStateChanged(itemEvent);
        }
    }
}

