/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.SchemaUtility;
import com.netscape.admin.dirserv.panel.replication.AgreementWizardInfo;
import com.netscape.admin.dirserv.panel.replication.AttrCellRenderer;
import com.netscape.admin.dirserv.panel.replication.IAgreementPanel;
import com.netscape.admin.dirserv.panel.replication.ITabPanel;
import com.netscape.admin.dirserv.panel.replication.ReplicationAgreement;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPSchema;

public class AgreementAttributePanel
extends BlankPanel
implements ActionListener,
ITabPanel {
    private IAgreementPanel _parent;
    private ReplicationAgreement _agreement;
    private boolean _initialized = false;
    private IDSModel _model;
    private JTabbedPane _tabbedPanel;
    private int _index;
    private Color _activeColor;
    private JScrollPane _rightScroll;
    private JScrollPane _leftScroll;
    private DefaultListModel _attrBoxModel = new DefaultListModel();
    private DefaultListModel _repBoxModel = new DefaultListModel();
    private JList _attrBox;
    private JList _repBox;
    private JPanel _entriesPanel;
    private JPanel _attrPanel;
    private JCheckBox _allAttr;
    private JRadioButton _allEntries;
    private JRadioButton _filterEntries;
    private JButton _addButton;
    private JButton _removeButton;
    private JButton _addAllButton;
    private JButton _removeAllButton;
    private JTextField _filterText;
    private JPanel _leftPanel;
    private JPanel _rightPanel;
    private static final Dimension BUTTON_MIN_SIZE = new Dimension(100, 25);
    public static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");

    public AgreementAttributePanel(IAgreementPanel iAgreementPanel, int n) {
        super(iAgreementPanel.getModel());
        this.setTitle(_resource.getString("replication-attribute-tab", "label"));
        this._parent = iAgreementPanel;
        this._agreement = (ReplicationAgreement)iAgreementPanel.getAgreement();
        this._index = n;
        this._model = iAgreementPanel.getModel();
        this._tabbedPanel = iAgreementPanel.getTabbedPane();
    }

    public void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ReplicationTool.resetGBC(gridBagConstraints);
        this._myPanel.setLayout(gridBagLayout);
        this._myPanel.setBackground(this.getBackground());
        this._myPanel.setPreferredSize(ReplicationTool.DEFAULT_PANEL_SIZE);
        this._myPanel.setMaximumSize(ReplicationTool.DEFAULT_PANEL_SIZE);
        this._entriesPanel = new GroupPanel(_resource.getString("replication-attribute-entries", "label"));
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this._entriesPanel.setLayout(gridBagLayout2);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this._entriesPanel, gridBagConstraints);
        this._myPanel.add(this._entriesPanel);
        ButtonGroup buttonGroup = new ButtonGroup();
        this._allEntries = this.makeJRadioButton(_resource.getString("replication-attribute-entriesAll", "label"));
        buttonGroup.add(this._allEntries);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        gridBagLayout2.setConstraints(this._allEntries, gridBagConstraints);
        this._entriesPanel.add(this._allEntries);
        this._filterEntries = this.makeJRadioButton(_resource.getString("replication-attribute-matchFilter", "label"));
        buttonGroup.add(this._filterEntries);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        gridBagLayout2.setConstraints(this._filterEntries, gridBagConstraints);
        this._entriesPanel.add(this._filterEntries);
        this._filterText = this.makeJTextField("");
        this._activeColor = this._filterText.getBackground();
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 30, 0, 5);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout2.setConstraints(this._filterText, gridBagConstraints);
        this._entriesPanel.add(this._filterText);
        this._attrPanel = new GroupPanel(_resource.getString("replication-attribute-attribute", "label"));
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        this._attrPanel.setLayout(gridBagLayout3);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this._attrPanel, gridBagConstraints);
        this._myPanel.add(this._attrPanel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        gridBagLayout3.setConstraints(jPanel, gridBagConstraints);
        this._attrPanel.add(jPanel);
        this._allAttr = this.makeJCheckBox(_resource.getString("replication-attribute-attributeAll", "label"));
        jPanel.add("West", this._allAttr);
        this._leftPanel = new GroupPanel(_resource.getString("replication-attribute-attributeAttr", "label"));
        this._leftPanel.setLayout(new BorderLayout());
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.5;
        gridBagLayout3.setConstraints(this._leftPanel, gridBagConstraints);
        this._attrPanel.add(this._leftPanel);
        this._attrBox = this.createListBox(this._attrBoxModel, 10);
        this._leftScroll = this.createScrollPane(this._attrBox);
        this._leftPanel.add("Center", this._leftScroll);
        this._rightPanel = new GroupPanel(_resource.getString("replication-attribute-attributeReplica", "label"));
        this._rightPanel.setLayout(new BorderLayout());
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout3.setConstraints(this._rightPanel, gridBagConstraints);
        this._attrPanel.add(this._rightPanel);
        this._repBox = this.createListBox(this._repBoxModel, 10);
        this._rightScroll = this.createScrollPane(this._repBox);
        this._rightPanel.add("Center", this._rightScroll);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout4);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout3.setConstraints(jPanel2, gridBagConstraints);
        this._attrPanel.add(jPanel2);
        this._addAllButton = this.makeJButton(_resource.getString("replication-attribute-attributeAddAllButton", "label"));
        this._addAllButton.setSize(BUTTON_MIN_SIZE);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagLayout4.setConstraints(this._addAllButton, gridBagConstraints);
        jPanel2.add(this._addAllButton);
        this._addButton = this.makeJButton(_resource.getString("replication-attribute-attributeAddButton", "label"));
        this._addButton.setSize(BUTTON_MIN_SIZE);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagLayout4.setConstraints(this._addButton, gridBagConstraints);
        jPanel2.add(this._addButton);
        this._removeButton = this.makeJButton(_resource.getString("replication-attribute-attributeRemoveButton", "label"));
        this._removeButton.setSize(BUTTON_MIN_SIZE);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagLayout4.setConstraints(this._removeButton, gridBagConstraints);
        jPanel2.add(this._removeButton);
        this._removeAllButton = this.makeJButton(_resource.getString("replication-attribute-attributeRemoveAllButton", "label"));
        this._removeAllButton.setSize(BUTTON_MIN_SIZE);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout4.setConstraints(this._removeAllButton, gridBagConstraints);
        jPanel2.add(this._removeAllButton);
        this.populateData();
        this._initialized = true;
    }

    public boolean refresh() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this._initialized) {
            int n;
            Object[] objectArray;
            Debug.println((String)("AgreementAttributePanel: actionPerformed()" + actionEvent.toString()));
            if (actionEvent.getSource().equals(this._allEntries)) {
                this.setDirtyFlag();
                this._filterText.setEditable(false);
                this._filterText.setBackground(this.getBackground());
                this._filterText.repaint(1L);
            }
            if (actionEvent.getSource().equals(this._filterEntries)) {
                this.setDirtyFlag();
                this._filterText.setEditable(true);
                this._filterText.setBackground(this._activeColor);
                this._filterText.repaint(1L);
            }
            if (actionEvent.getSource().equals(this._allAttr)) {
                this.setDirtyFlag();
                if (this._allAttr.isSelected()) {
                    this.populateAttrList(false);
                    this.disableAttrSelection();
                } else {
                    this.enableAttrSelection();
                }
            }
            if (actionEvent.getSource().equals(this._addAllButton)) {
                this.setDirtyFlag();
                this.populateAttrList(false);
            }
            if (actionEvent.getSource().equals(this._addButton)) {
                this.setDirtyFlag();
                objectArray = this._attrBox.getSelectedValues();
                if (objectArray.length > 0) {
                    n = 0;
                    while (n < objectArray.length) {
                        SchemaUtility.InsertElement(this._repBoxModel, objectArray[n]);
                        this._attrBoxModel.removeElement(objectArray[n]);
                        ++n;
                    }
                }
                this._attrBox.invalidate();
                this._attrBox.validate();
                this._attrBox.repaint(1L);
            }
            if (actionEvent.getSource().equals(this._removeButton)) {
                this.setDirtyFlag();
                objectArray = this._repBox.getSelectedValues();
                if (objectArray.length > 0) {
                    n = 0;
                    while (n < objectArray.length) {
                        SchemaUtility.InsertElement(this._attrBoxModel, objectArray[n]);
                        this._repBoxModel.removeElement(objectArray[n]);
                        ++n;
                    }
                }
                this._repBox.invalidate();
                this._repBox.validate();
                this._repBox.repaint(1L);
            }
            if (actionEvent.getSource().equals(this._removeAllButton)) {
                this.setDirtyFlag();
                this.populateAttrList(true);
            }
        }
    }

    public void okCallback() {
        Debug.println((String)"okCallback()");
        this.clearDirtyFlag();
    }

    public void resetCallback() {
        Debug.println((String)"resetCallback()");
        this.populateData();
        this.clearDirtyFlag();
    }

    public void helpCallback() {
        Debug.println((String)"helpCallback()");
    }

    public boolean validateEntries() {
        if (this._filterEntries.isSelected() && this._filterText.getText().equals("")) {
            String string = _resource.getString("replication-attribute-dialog", "filterEmpty");
            DSUtil.showErrorDialog((Component)this._parent.getFrame(), "error", string, "replication-attribute-dialog");
            return false;
        }
        if (this._repBoxModel.size() == 0) {
            String string = _resource.getString("replication-attribute-dialog", "noAttr");
            DSUtil.showErrorDialog((Component)this._parent.getFrame(), "error", string, "replication-attribute-dialog");
            return false;
        }
        return true;
    }

    public void getUpdateInfo(Object object) {
        AgreementWizardInfo agreementWizardInfo = (AgreementWizardInfo)object;
        if (this._filterEntries.isSelected()) {
            agreementWizardInfo.setFilter(this._filterText.getText());
        } else {
            agreementWizardInfo.setFilter("");
        }
        Vector vector = new Vector();
        if (!this._allAttr.isSelected()) {
            if (this._attrBoxModel.size() == 0) {
                this._allAttr.setSelected(true);
                agreementWizardInfo.setAttrType(0);
                this.disableAttrSelection();
            } else if (this._repBoxModel.size() <= this._attrBoxModel.size()) {
                int n = 0;
                while (n < this._repBoxModel.size()) {
                    vector.addElement(this._repBoxModel.getElementAt(n));
                    ++n;
                }
                agreementWizardInfo.setAttrType(1);
            } else {
                int n = 0;
                while (n < this._attrBoxModel.size()) {
                    vector.addElement(this._attrBoxModel.getElementAt(n));
                    ++n;
                }
                agreementWizardInfo.setAttrType(2);
            }
        } else {
            agreementWizardInfo.setAttrType(0);
        }
        agreementWizardInfo.setSelectedAttr(vector);
    }

    private void populateData() {
        if (this._agreement.getEntryFilter() == null || this._agreement.getEntryFilter().equals("")) {
            this._allEntries.setSelected(true);
            this._filterText.setEditable(false);
            this._filterText.setBackground(this.getBackground());
        } else {
            this._filterEntries.setSelected(true);
            this._filterText.setEditable(true);
            this._filterText.setBackground(this._activeColor);
            this._filterText.setText(this._agreement.getEntryFilter());
        }
        if (this._agreement.getSelectedAttributes() == null) {
            this.populateAttrList(false);
            this._allAttr.setSelected(true);
            this.disableAttrSelection();
        } else {
            this.populateAttrList(true);
            this._allAttr.setSelected(false);
            Enumeration enumeration = this._agreement.getSelectedAttributes().elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this._attrBoxModel.removeElement(string);
                SchemaUtility.InsertElement(this._repBoxModel, string);
            }
            this.enableAttrSelection();
        }
    }

    private void populateAttrList(boolean bl) {
        this._attrBoxModel.removeAllElements();
        this._repBoxModel.removeAllElements();
        LDAPSchema lDAPSchema = this.getModel().getSchema();
        if (lDAPSchema == null) {
            return;
        }
        LDAPSchema lDAPSchema2 = lDAPSchema;
        synchronized (lDAPSchema2) {
            Enumeration enumeration = lDAPSchema.getAttributes();
            while (enumeration.hasMoreElements()) {
                LDAPAttributeSchema lDAPAttributeSchema = (LDAPAttributeSchema)enumeration.nextElement();
                if (bl) {
                    SchemaUtility.InsertElement(this._attrBoxModel, lDAPAttributeSchema.getName());
                    continue;
                }
                SchemaUtility.InsertElement(this._repBoxModel, lDAPAttributeSchema.getName());
            }
        }
    }

    private void disableAttrSelection() {
        this._leftPanel.setEnabled(false);
        this._leftScroll.setEnabled(false);
        this._rightPanel.setEnabled(false);
        this._rightScroll.setEnabled(false);
        this._attrBox.setEnabled(false);
        this._repBox.setEnabled(false);
        this._addAllButton.setEnabled(false);
        this._addButton.setEnabled(false);
        this._removeButton.setEnabled(false);
        this._removeAllButton.setEnabled(false);
    }

    private void enableAttrSelection() {
        this._leftPanel.setEnabled(true);
        this._leftScroll.setEnabled(true);
        this._rightPanel.setEnabled(true);
        this._rightScroll.setEnabled(true);
        this._attrBox.setEnabled(true);
        this._repBox.setEnabled(true);
        this._addAllButton.setEnabled(true);
        this._addButton.setEnabled(true);
        this._removeButton.setEnabled(true);
        this._removeAllButton.setEnabled(true);
    }

    protected void setDirtyFlag() {
        super.setDirtyFlag();
        super.setValidFlag();
        if (this._tabbedPanel != null && this._tabbedPanel.getIconAt(this._index) == null) {
            this._tabbedPanel.setIconAt(this._index, (Icon)ReplicationTool.getImage("red-ball-small.gif"));
            this._tabbedPanel.repaint();
        }
    }

    protected void clearDirtyFlag() {
        super.clearDirtyFlag();
        if (this._tabbedPanel != null && this._tabbedPanel.getIconAt(this._index) != null) {
            this._tabbedPanel.setIconAt(this._index, null);
            this._tabbedPanel.repaint();
        }
    }

    JList createListBox(DefaultListModel defaultListModel, int n) {
        JList<String> jList = new JList<String>(defaultListModel);
        jList.setCellRenderer(new AttrCellRenderer());
        jList.setSelectionModel(new DefaultListSelectionModel());
        jList.setPrototypeCellValue("1234567890 1234567890");
        jList.setVisibleRowCount(n);
        return jList;
    }

    JScrollPane createScrollPane(JList jList) {
        JScrollPane jScrollPane = new JScrollPane(jList, 22, 31);
        jScrollPane.setBackground(this.getBackground());
        jScrollPane.setAlignmentX(0.0f);
        jScrollPane.setAlignmentY(0.0f);
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        return jScrollPane;
    }
}

