/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class HostInfoDialog
extends AbstractDialog
implements ActionListener,
MouseMotionListener {
    private boolean _isOk = false;
    private int _port = -1;
    private JButton _bOk;
    private JButton _bCancel;
    private JButton _bHelp;
    private JTextField _hostText;
    private JTextField _portText;
    private String _fqHostName = null;
    private boolean _waiting = false;
    private static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");
    private static final String _section = "replication-destination-dialog";
    private static final String _helpToken = "configuration-replication-host-dbox-help";

    public HostInfoDialog(JFrame jFrame, String string) {
        this(jFrame, string, null, 0);
    }

    public HostInfoDialog(JFrame jFrame, String string, String string2, int n) {
        super((Frame)jFrame, true);
        ((Window)((Object)this)).setLocationRelativeTo(jFrame);
        this._fqHostName = string2;
        this._port = n;
        this.init();
        ((Dialog)((Object)this)).setTitle(string);
    }

    private void init() {
        ((JComponent)((JDialog)((Object)this)).getRootPane()).setDoubleBuffered(true);
        this.getContentPane().setLayout(new BorderLayout());
        int n = UIFactory.getComponentSpace();
        int n2 = UIFactory.getDifferentSpace();
        int n3 = 20;
        JPanel jPanel = new JPanel();
        this.getContentPane().add("Center", jPanel);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = UIFactory.makeJLabel(_section, "hostInfo", _resource);
        jLabel.setLabelFor((Component)((Object)this));
        ((JDialog)((Object)this)).getAccessibleContext().setAccessibleDescription(jLabel.getText());
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(n, n3, n, n2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = UIFactory.makeJLabel(_section, "hostName", _resource);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, n3, n, n);
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this._hostText = this._fqHostName != null ? UIFactory.makeJTextField(null, this._fqHostName) : UIFactory.makeJTextField(null, "");
        jLabel2.setLabelFor(this._hostText);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, n, n2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.7;
        jPanel.add((Component)this._hostText, gridBagConstraints);
        JLabel jLabel3 = UIFactory.makeJLabel(_section, "hostPort", _resource);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, n3, n, n);
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this._portText = UIFactory.makeJTextField(null, "", 5);
        if (this._port != -1) {
            this._portText.setText(Integer.toString(this._port));
        }
        jLabel3.setLabelFor(this._portText);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, n, n2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this._portText, gridBagConstraints);
        this._bOk = UIFactory.makeJButton((Object)this, "general", "OK");
        this._bCancel = UIFactory.makeJButton((Object)this, "general", "Cancel");
        this._bHelp = UIFactory.makeJButton((Object)this, "general", "Help");
        JButton[] jButtonArray = new JButton[]{this._bOk, this._bCancel, this._bHelp};
        JPanel jPanel2 = UIFactory.makeJButtonPanel(jButtonArray, true);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add("Center", jPanel2);
        jPanel3.add("South", Box.createVerticalStrut(UIFactory.getDifferentSpace()));
        jPanel3.add("North", Box.createVerticalStrut(UIFactory.getDifferentSpace()));
        jPanel3.add("East", Box.createHorizontalStrut(UIFactory.getDifferentSpace()));
        jPanel3.add("West", Box.createHorizontalStrut(UIFactory.getDifferentSpace()));
        this.getContentPane().add("South", jPanel3);
        this.pack();
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.doValidate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.doValidate();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.doValidate();
            }

            private void doValidate() {
                boolean bl = false;
                if (HostInfoDialog.this._hostText.getText().trim().length() > 0) {
                    try {
                        int n = Integer.parseInt(HostInfoDialog.this._portText.getText());
                        bl = n > 0 && n <= 65553;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                HostInfoDialog.this._bOk.setEnabled(bl);
            }
        };
        ((Component)((Object)this)).addMouseMotionListener(this);
        jPanel.addMouseMotionListener(this);
        jLabel2.addMouseMotionListener(this);
        jLabel3.addMouseMotionListener(this);
        this._portText.addMouseMotionListener(this);
        this._hostText.addMouseMotionListener(this);
        this._portText.getDocument().addDocumentListener(documentListener);
        this._hostText.getDocument().addDocumentListener(documentListener);
        this._bOk.addMouseMotionListener(this);
        this._bCancel.addMouseMotionListener(this);
        this._bHelp.addMouseMotionListener(this);
        jPanel2.addMouseMotionListener(this);
        jPanel3.addMouseMotionListener(this);
        boolean bl = false;
        if (this._hostText.getText().trim().length() > 0) {
            try {
                int n4 = Integer.parseInt(this._portText.getText());
                bl = n4 > 0 && n4 <= 65553;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._bOk.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource().equals(this._bOk)) {
                if (this._fqHostName == null) {
                    this._waiting = true;
                    this._bOk.setEnabled(false);
                    this._bCancel.setEnabled(false);
                    this._bHelp.setEnabled(false);
                    this._fqHostName = ReplicationTool.fullyQualifyHostName(this._hostText.getText());
                    if (this._fqHostName == null) {
                        this._fqHostName = new String("");
                    }
                }
                try {
                    this._port = Integer.parseInt(this._portText.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                this._isOk = true;
                ((Component)((Object)this)).setVisible(false);
                this.dispose();
                DSUtil.dialogCleanup();
            }
            if (actionEvent.getSource().equals(this._bCancel)) {
                ((Component)((Object)this)).setVisible(false);
                this.dispose();
                DSUtil.dialogCleanup();
            }
            if (actionEvent.getSource().equals(this._bHelp)) {
                DSUtil.help(_helpToken);
            }
        }
        catch (NullPointerException nullPointerException) {
            Debug.println((String)nullPointerException.toString());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this._waiting && mouseEvent.getSource() instanceof Component) {
            ((Component)mouseEvent.getSource()).setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public boolean isOk() {
        return this._isOk;
    }

    public String getHost() {
        return this._fqHostName;
    }

    public int getPort() {
        return this._port;
    }
}

