/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.IDSContentListener;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.panel.replication.AgreementWizardInfo;
import com.netscape.admin.dirserv.panel.replication.MMRAgreement;
import com.netscape.admin.dirserv.panel.replication.ReplicationAgreement;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.admin.dirserv.panel.replication.SIRAgreement;
import com.netscape.admin.dirserv.panel.replication.WAgreementPanel;
import com.netscape.admin.dirserv.wizard.IWizardPanel;
import com.netscape.admin.dirserv.wizard.WizardInfo;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class WAgreementSummaryPanel
extends WAgreementPanel
implements IWizardPanel {
    private Color _activeColor;
    private AgreementWizardInfo _wizardInfo;
    private ConsoleInfo _serverInfo;
    private boolean _initialized = false;
    private String _error = "WAgreementSummaryPanel: error message";
    private JTextArea _list;

    public WAgreementSummaryPanel() {
        this._helpToken = "replication-wizard-summary-help";
        this._section = "replication-summary";
    }

    public void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ReplicationTool.resetGBC(gridBagConstraints);
        this.setLayout(gridBagLayout);
        JTextArea jTextArea = UIFactory.makeMultiLineLabel(5, 30, WAgreementPanel._resource.getString("replication-agreementWizard", "summary-label"));
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 20, 5, 10);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jTextArea, gridBagConstraints);
        this.add(jTextArea);
        this._list = new JTextArea();
        this._list.setEditable(false);
        this._list.setCaretColor(Color.white);
        JScrollPane jScrollPane = new JScrollPane(this._list);
        jScrollPane.setAlignmentX(0.0f);
        jScrollPane.setAlignmentY(0.0f);
        jScrollPane.setBorder(ReplicationTool.LOWERED_BORDER);
        jScrollPane.setPreferredSize(new Dimension(200, 1));
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 20, 5, 10);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
        this._initialized = true;
    }

    public boolean initializePanel(WizardInfo wizardInfo) {
        Debug.println((String)"WAgreementSummaryPanel: initialize()");
        this._wizardInfo = (AgreementWizardInfo)wizardInfo;
        this._serverInfo = this._wizardInfo.getServerInfo();
        if (!this._initialized) {
            this.init();
        }
        this.populateData();
        return true;
    }

    public boolean validatePanel() {
        Debug.println((String)"WAgreementSummaryPanel: conclude()");
        return true;
    }

    public boolean concludePanel(WizardInfo wizardInfo) {
        ReplicationAgreement replicationAgreement;
        Object object;
        Debug.println((String)"WAgreementSummaryPanel: conclude()");
        if (this._wizardInfo.getAgreementType().equals("MMR")) {
            object = new MMRAgreement(this._serverInfo, null, this._wizardInfo.getReplicaEntry());
            replicationAgreement = object;
            ((ReplicationAgreement)object).setNickname(this._wizardInfo.getNickName());
            ((ReplicationAgreement)object).setDescription(this._wizardInfo.getDescription());
            ((ReplicationAgreement)object).setReplicatedSubtree(this._wizardInfo.getSubtree());
            ((ReplicationAgreement)object).setConsumerHost(this._wizardInfo.getToServer().getHost());
            ((ReplicationAgreement)object).setConsumerPort(this._wizardInfo.getToServer().getPort());
            if (this._wizardInfo.getSSL()) {
                ((ReplicationAgreement)object).setUseSSL(true);
                if (this._wizardInfo.getSSLAuth()) {
                    ((ReplicationAgreement)object).setUseSSLAuth(true);
                }
            }
            if (!this._wizardInfo.getBindDN().equals("")) {
                ((ReplicationAgreement)object).setBindDN(this._wizardInfo.getBindDN());
                ((ReplicationAgreement)object).setBindCredentials(this._wizardInfo.getBindPWD());
            }
            ((ReplicationAgreement)object).setUpdateSchedule(this._wizardInfo.getDate());
            int n = ((ReplicationAgreement)object).writeAgreementToServer();
            if (n != 0) {
                ReplicationTool.displayError(n);
                return false;
            }
        } else {
            object = new SIRAgreement(this._serverInfo, null, this._wizardInfo.getReplicaEntry());
            replicationAgreement = object;
            ((ReplicationAgreement)object).setNickname(this._wizardInfo.getNickName());
            ((ReplicationAgreement)object).setReplicatedSubtree(this._wizardInfo.getSubtree());
            ((ReplicationAgreement)object).setConsumerHost(this._wizardInfo.getToServer().getHost());
            ((ReplicationAgreement)object).setConsumerPort(this._wizardInfo.getToServer().getPort());
            if (this._wizardInfo.getSSL()) {
                ((ReplicationAgreement)object).setUseSSL(true);
            }
            if (!this._wizardInfo.getBindDN().equals("")) {
                ((ReplicationAgreement)object).setBindDN(this._wizardInfo.getBindDN());
                ((ReplicationAgreement)object).setBindCredentials(this._wizardInfo.getBindPWD());
            }
            ((ReplicationAgreement)object).setUpdateSchedule(this._wizardInfo.getDate());
            int n = ((ReplicationAgreement)object).writeAgreementToServer();
            if (n != 0) {
                ReplicationTool.displayError(n);
                return false;
            }
        }
        this.saveReplica(replicationAgreement);
        if (this._wizardInfo.getParentNode() != null) {
            object = (IDSContentListener)this._wizardInfo.getParentNode();
            object.contentChanged();
        }
        return true;
    }

    public void getUpdateInfo(WizardInfo wizardInfo) {
        Debug.println((String)"WAgreementSummaryPanel: getUpdateInfo()");
    }

    public String getErrorMessage() {
        return this._error;
    }

    private void saveReplica(ReplicationAgreement replicationAgreement) {
        String string = this._wizardInfo.getLDIFFilename();
        if (string != null) {
            if (!replicationAgreement.populateLDIFFile(string)) {
                String string2 = WAgreementPanel._resource.getString("replication-initialize", "error-1");
                ReplicationTool.displayError(string2);
            }
        } else if (this._wizardInfo.getInitialize()) {
            replicationAgreement.initializeConsumer();
        }
    }

    private void populateData() {
        this._list.setText(this._wizardInfo.prettyPrint());
    }
}

