/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.propedit;

import com.netscape.admin.dirserv.AttributeAlias;
import com.netscape.admin.dirserv.DSSchemaHelper;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.DefaultResourceModel;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.SuiScrollPane;
import com.netscape.admin.dirserv.attredit.AttributeEditor;
import com.netscape.admin.dirserv.attredit.AttributeEditorFactory;
import com.netscape.admin.dirserv.attredit.IAttributeEditor;
import com.netscape.admin.dirserv.attredit.StringAttributeEditor;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.propedit.DSPropertyModel;
import com.netscape.admin.dirserv.propedit.EntryPageDescription;
import com.netscape.admin.dirserv.propedit.NewAttributePanel;
import com.netscape.admin.dirserv.propedit.RenameDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class DSEntryPanel
extends JPanel
implements ActionListener,
FocusListener {
    private RenameDialog _renameDialog;
    private Hashtable _namingAttributeIndexes = new Hashtable();
    private JRadioButton _rbAttributeName;
    private JRadioButton _rbAttributeDescription;
    private JCheckBox _cbAttributeWithValues;
    private JCheckBox _cbShowDN;
    private JButton _bRefresh;
    private JButton _bAddValue;
    private JButton _bDeleteValue;
    private JButton _bAddAttribute;
    private JButton _bDeleteAttribute;
    private JButton _bChangeNamingAttribute;
    private Component _glue;
    static final String DELETE_ATTRIBUTE = "delete attribute";
    static final String DELETE_VALUE = "delete value";
    static final String ADD_ATTRIBUTE = "add attribute";
    static final String ADD_VALUE = "add value";
    static final String SHOW_ATTRIBUTES_WITH_VALUES = "show attributes with values";
    static final String SHOW_NAMES = "show attribute names";
    static final String SHOW_DESCRIPTIONS = "show attribute descriptions";
    static final String SHOW_DN = "show dn";
    static final String REFRESH = "refresh";
    static final String CHANGE_NAMING_ATTRIBUTE = "change naming attribute";
    private JLabel _dnLabel;
    private JLabel _lNamingAttribute;
    private String[] _namingAttributes;
    private String[] _saveNamingValues;
    private String[] _saveNamingAttributes;
    private String[] _namingValues;
    private DN _dn;
    private int _options;
    public static final int SHOWINGDN_NONAMING = 0;
    public static final int SHOWINGDN_NAMING = 1;
    public static final int NOSHOWINGDN = 2;
    private String[] FORBIDDEN_NAMING_ATTRIBUTES;
    final String OBJECTCLASS = "objectclass";
    final String EXTENSIBLEOBJECT = "extensibleobject";
    private Vector _entries = new Vector();
    private Vector _allAttributes = null;
    private Hashtable _visible = new Hashtable();
    private DSPropertyModel _dataModel;
    private LDAPConnection _ldc;
    private Vector _toDelete = new Vector();
    private Vector _toAdd = new Vector();
    private JPanel _page = null;
    private JComponent _centerPane = null;
    private GridBagConstraints _cons = new GridBagConstraints();
    private boolean _showingAll = false;
    private boolean _showingNames = false;
    private static final int buttonWidth = 85;
    private static final int unitHeight = 23;
    private static final int buttonHeight = 23;
    private static final int fieldWidth = 250;
    private static final int fieldHeight = 23;
    private static final int labelHeight = 23;
    private static final int labelWidth = 180;
    private static final int margin = 0;
    private static final String _helpToken = "property-main-help";
    static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.propedit.propedit");
    static final String _section = "DSEntryPanel";

    public DSEntryPanel(DSPropertyModel dSPropertyModel) {
        this(dSPropertyModel, 0);
    }

    public DSEntryPanel(DSPropertyModel dSPropertyModel, int n) {
        this(dSPropertyModel, n, null);
    }

    public DSEntryPanel(DSPropertyModel dSPropertyModel, int n, LDAPConnection lDAPConnection) {
        this._dataModel = dSPropertyModel;
        this._options = n;
        this._ldc = lDAPConnection;
        this.createListOfForbiddenNamingAttributes();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(9, 9, 9, 9));
        this.createDNLabel();
        this._centerPane = this.initialize();
        JPanel jPanel = this.createActionPanel();
        this.add("East", jPanel);
        this.add("Center", this._centerPane);
    }

    private void createListOfForbiddenNamingAttributes() {
        String[] stringArray = DSSchemaHelper.getOperationalAttributes(this._dataModel.getSchema());
        Vector<String> vector = new Vector<String>();
        vector.addElement("objectclass");
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (!stringArray[n].equals("nsuniqueid")) {
                    vector.addElement(stringArray[n]);
                }
                ++n;
            }
        }
        this.FORBIDDEN_NAMING_ATTRIBUTES = new String[vector.size()];
        vector.copyInto(this.FORBIDDEN_NAMING_ATTRIBUTES);
    }

    private Window getOwnerWindow() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Window) {
                return (Window)container;
            }
            container = container.getParent();
        }
        return null;
    }

    private Frame getOwnerFrame() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = container.getParent();
        }
        return null;
    }

    private IAttributeEditor getEditorForType(String string, String string2, Rectangle rectangle) {
        IAttributeEditor iAttributeEditor = AttributeEditorFactory.makeEditor(string, string2, rectangle, DSPropertyModel.isSingleValued(string), DSPropertyModel.getAttributeType(string));
        if (iAttributeEditor != null) {
            iAttributeEditor.setParent(this);
            if (string.equalsIgnoreCase("objectclass")) {
                Vector<Object> vector = new Vector<Object>();
                Enumeration enumeration = this._dataModel.getSchema().getObjectClassNames();
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                Object[] objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                this.sortStrings((String[])objectArray);
                int n = 0;
                while (n < objectArray.length) {
                    vector.setElementAt(objectArray[n], n);
                    ++n;
                }
                iAttributeEditor.setAllowedValues(vector);
                iAttributeEditor.setSchema(this._dataModel.getSchema());
            }
        }
        return iAttributeEditor;
    }

    /*
     * Unable to fully structure code
     */
    private IAttributeEditor makeField(Rectangle var1_1, String var2_2, String var3_3, Vector var4_4) {
        block7: {
            var5_5 = this.getEditorForType(var2_2, var3_3, var1_1);
            try {
                if (var4_4 == null || var4_4.size() < 1) {
                    var5_5.addValue("");
                } else {
                    var6_6 = 0;
                    while (var6_6 < var4_4.size()) {
                        var5_5.addValue(var4_4.elementAt(var6_6));
                        ++var6_6;
                    }
                }
                break block7;
            }
            catch (Exception var6_7) {
                Debug.println((String)("DSEntryPanel.makeField: " + var6_7));
                if (var4_4 == null) {
                    Debug.println((String)("... name = " + var2_2 + ", labelText = " + var3_3 + ", v = null"));
                    break block7;
                }
                Debug.println((String)("... name = " + var2_2 + ", labelText = " + var3_3 + ", nValues = " + var4_4.size()));
                var7_8 = 0;
                ** while (var7_8 < var4_4.size())
            }
lbl-1000:
            // 1 sources

            {
                Debug.println((String)("... " + var4_4.elementAt(var7_8)));
                ++var7_8;
                continue;
            }
        }
        return var5_5;
    }

    private JComponent initialize() {
        Object object;
        Object object2;
        int n = 0;
        int n2 = this._dataModel.getItemCount(n);
        IAttributeEditor[] iAttributeEditorArray = new IAttributeEditor[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Rectangle rectangle = new Rectangle(n3, n4, 180, 23);
        int n6 = 0;
        while (n6 < n2) {
            object2 = this._dataModel.getItemName(n, n6);
            Object object3 = this._showingNames ? object2 : AttributeAlias.getAlias((String)object2);
            object = this._dataModel.getItemValues(n, n6);
            if (object != null) {
                n5 += ((Vector)object).size();
            }
            iAttributeEditorArray[n6] = this.makeField(rectangle, (String)object2, (String)object3, (Vector)object);
            this._entries.addElement(iAttributeEditorArray[n6]);
            iAttributeEditorArray[n6].setDirty(false);
            this.setVisible(iAttributeEditorArray[n6]);
            rectangle.y += 28;
            ++n6;
        }
        Debug.println((String)("Added " + n2 + " attributes, " + n5 + " values" + " height " + 23));
        this._page = new JPanel();
        object2 = new GridBagLayout();
        this._cons.insets = new Insets(0, 0, 1, 0);
        this._cons.fill = 2;
        this._cons.gridwidth = 0;
        this._cons.weightx = 1.0;
        this._cons.weighty = 0.0;
        this._cons.anchor = 18;
        this._page.setLayout((LayoutManager)object2);
        int n7 = 0;
        while (n7 < n2) {
            this._page.add((Component)((JComponent)this._entries.elementAt(n7)), this._cons);
            ++n7;
        }
        this._cons.weighty = 1.0;
        this._cons.fill = 1;
        this._glue = Box.createGlue();
        this._page.add(this._glue, this._cons);
        this._cons.weighty = 0.0;
        this._cons.fill = 2;
        object = new SuiScrollPane(this._page);
        ((JScrollPane)object).getVerticalScrollBar().setUnitIncrement(23);
        ((JScrollPane)object).getHorizontalScrollBar().setUnitIncrement(8);
        ((JComponent)object).setBorder(new EmptyBorder(0, 0, 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)object, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        this._dnLabel.setVisible(true);
        jPanel.add((Component)this._dnLabel, gridBagConstraints);
        this._dnLabel.setLabelFor(jPanel);
        if (this._options != 2) {
            this.updateNamingIndexes();
        }
        return jPanel;
    }

    public LDAPModificationSet getChanges() {
        Object object;
        Object object2;
        IAttributeEditor iAttributeEditor;
        LDAPModificationSet lDAPModificationSet = null;
        int n = 0;
        while (n < this._entries.size()) {
            IAttributeEditor iAttributeEditor2 = (IAttributeEditor)this._entries.elementAt(n);
            if (this._toAdd.indexOf(iAttributeEditor2) >= 0) {
                Debug.println((String)("Not replacing " + iAttributeEditor2 + " since it is new"));
            } else if (iAttributeEditor2.isDirty()) {
                Debug.println((String)("Replacing " + iAttributeEditor2));
                if (lDAPModificationSet == null) {
                    lDAPModificationSet = new LDAPModificationSet();
                }
                iAttributeEditor = new LDAPAttribute(iAttributeEditor2.getName());
                object2 = iAttributeEditor2.getValues();
                int n2 = 0;
                while (n2 < ((Vector)object2).size()) {
                    object = ((Vector)object2).elementAt(n2);
                    if (object instanceof String) {
                        if (((String)object).length() > 0) {
                            iAttributeEditor.addValue((String)object);
                        }
                    } else {
                        iAttributeEditor.addValue((byte[])object);
                    }
                    ++n2;
                }
                Debug.println((String)("To replace: " + iAttributeEditor));
                lDAPModificationSet.add(2, (LDAPAttribute)iAttributeEditor);
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < this._toAdd.size()) {
            iAttributeEditor = (IAttributeEditor)this._toAdd.elementAt(n3);
            object2 = iAttributeEditor.getName();
            if (lDAPModificationSet == null) {
                lDAPModificationSet = new LDAPModificationSet();
            }
            Vector vector = iAttributeEditor.getValues();
            object = new LDAPAttribute((String)object2);
            int n4 = 0;
            while (n4 < vector.size()) {
                Object e = vector.elementAt(n4);
                if (e instanceof String) {
                    if (((String)e).length() > 0) {
                        object.addValue((String)e);
                    }
                } else {
                    object.addValue((byte[])e);
                }
                ++n4;
            }
            if (object.getByteValues().hasMoreElements()) {
                Debug.println((String)("To add: " + object));
                lDAPModificationSet.add(0, object);
            }
            ++n3;
        }
        int n5 = 0;
        while (n5 < this._toDelete.size()) {
            object2 = (IAttributeEditor)this._toDelete.elementAt(n5);
            if (lDAPModificationSet == null) {
                lDAPModificationSet = new LDAPModificationSet();
            }
            LDAPAttribute lDAPAttribute = new LDAPAttribute(object2.getName());
            Debug.println((String)("To delete: " + lDAPAttribute));
            lDAPModificationSet.add(1, lDAPAttribute);
            ++n5;
        }
        return lDAPModificationSet;
    }

    public LDAPAttributeSet getAttributes() {
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        int n = 0;
        while (n < this._entries.size()) {
            IAttributeEditor iAttributeEditor = (IAttributeEditor)this._entries.elementAt(n);
            LDAPAttribute lDAPAttribute = new LDAPAttribute(iAttributeEditor.getName());
            Vector vector = iAttributeEditor.getValues();
            int n2 = 0;
            while (n2 < vector.size()) {
                Object e = vector.elementAt(n2);
                if (e instanceof String) {
                    if (((String)e).length() > 0) {
                        lDAPAttribute.addValue((String)e);
                    }
                } else if (((byte[])e).length > 0) {
                    lDAPAttribute.addValue((byte[])e);
                }
                ++n2;
            }
            if (lDAPAttribute.size() > 0) {
                lDAPAttributeSet.add(lDAPAttribute);
            }
            ++n;
        }
        return lDAPAttributeSet;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        int n;
        Object object2;
        Object object3;
        Window window = this.getOwnerWindow();
        if (window == null) {
            Debug.println((String)"DSEntryPanel.actionPerformed: no owner window");
            return;
        }
        Debug.println((String)("DSEntryPanel.actionPerformed: owner window = " + window));
        Component component = window.getFocusOwner();
        IAttributeEditor iAttributeEditor = this.getSelectedEditor();
        if (component != null && iAttributeEditor == null) {
            if (component instanceof AttributeEditor) {
                iAttributeEditor = (IAttributeEditor)((Object)component);
            } else {
                object3 = component.getParent();
                while (object3 != null) {
                    if (object3 instanceof IAttributeEditor) {
                        iAttributeEditor = (IAttributeEditor)object3;
                        break;
                    }
                    object3 = ((Component)object3).getParent();
                }
            }
            Debug.println((String)("DSEntryPanel.actionPerformed: " + component.getClass().getName() + " has focus, command = " + actionEvent.getActionCommand()));
        } else {
            Debug.println((String)"DSEntryPanel.actionPerformed: no focus component");
        }
        if (iAttributeEditor == null) {
            object3 = this._visible.keys();
            while (object3.hasMoreElements()) {
                IAttributeEditor iAttributeEditor2 = (IAttributeEditor)this._visible.get(object3.nextElement());
                if (!iAttributeEditor2.isSelected()) continue;
                iAttributeEditor = iAttributeEditor2;
                Debug.println((String)("DSEntryPanel.actionPerformed: using as focus component - " + iAttributeEditor.getClass().getName() + " has focus, command = " + actionEvent.getActionCommand()));
                break;
            }
        }
        object3 = null;
        if (iAttributeEditor != null) {
            object3 = iAttributeEditor.getName();
            component = iAttributeEditor.getFocusField();
            Debug.println((String)("DSEntryPanel.actionPerformed: focus is on <" + component + "> within " + (String)object3));
        }
        boolean bl = false;
        if (actionEvent.getActionCommand().equals(SHOW_DN)) {
            this.setDNVisible(this._cbShowDN.isSelected());
        } else if (actionEvent.getActionCommand().equals(DELETE_ATTRIBUTE)) {
            if (iAttributeEditor != null && iAttributeEditor.isDeletable()) {
                boolean bl2 = false;
                object2 = this.getNamingAttributes();
                if (object2 != null) {
                    n = 0;
                    while (n < ((String[])object2).length) {
                        if (((String)object3).equals(object2[n])) {
                            bl2 = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (bl2) {
                    DSUtil.showErrorDialog((Component)this.getOwnerFrame(), "namingattribute-deleted", "");
                    Debug.println((String)"DSEntryPanel.actionPerformed: the naming attribute can't be deleted");
                } else {
                    this._page.remove((Component)((Object)iAttributeEditor));
                    this._entries.removeElement(iAttributeEditor);
                    if (this._toAdd.indexOf(iAttributeEditor) >= 0) {
                        this._toAdd.removeElement(iAttributeEditor);
                    } else {
                        this._toDelete.addElement(iAttributeEditor);
                    }
                    this._visible.remove(object3);
                    this.validate();
                }
            }
            object3 = null;
        } else if (actionEvent.getActionCommand().equals(DELETE_VALUE)) {
            if (iAttributeEditor != null) {
                boolean bl3 = false;
                object2 = this.getNamingAttributes();
                if (object2 != null) {
                    n = 0;
                    while (n < ((Object)object2).length) {
                        if (((String)object3).equals(object2[n])) {
                            bl3 = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (bl3 && iAttributeEditor.getValueCount() < 2) {
                    DSUtil.showErrorDialog((Component)this.getOwnerFrame(), "namingattribute-deleted", "");
                    Debug.println((String)"DSEntryPanel.actionPerformed: the naming attribute can't be deleted");
                } else {
                    Serializable serializable;
                    n = iAttributeEditor.getFieldIndex(component);
                    iAttributeEditor.deleteValue(component);
                    if (((String)object3).equalsIgnoreCase("objectclass")) {
                        serializable = iAttributeEditor.getValues();
                        this._dataModel.updateObjectClasses((Vector)serializable);
                        this._allAttributes = null;
                        this.getAllAttributes();
                        this.validateEditors((Vector)serializable);
                        bl = true;
                        if (this.updateNamingAttributes()) {
                            DSUtil.showInformationDialog(this.getOwnerFrame(), "naming-attrs-modified", null, _section, _resource);
                        }
                    }
                    if (bl3) {
                        serializable = (Integer)this._namingAttributeIndexes.get(object3);
                        int n2 = 0;
                        if (serializable != null) {
                            n2 = (Integer)serializable;
                        }
                        if (n <= n2) {
                            if (--n2 < 0) {
                                n2 = 0;
                            }
                            this._namingAttributeIndexes.put(object3, new Integer(n2));
                        }
                        this.updateNamingValue((String)object3);
                        if (iAttributeEditor.getValueCount() > 1) {
                            this._bDeleteValue.setEnabled(true);
                        } else {
                            this._bDeleteValue.setEnabled(false);
                        }
                    }
                    this.validate();
                }
            }
        } else if (actionEvent.getActionCommand().equals(ADD_ATTRIBUTE)) {
            this.addAttribute();
        } else if (actionEvent.getActionCommand().equals(ADD_VALUE)) {
            if (iAttributeEditor != null) {
                try {
                    iAttributeEditor.addValue();
                    if (((String)object3).equalsIgnoreCase("objectclass")) {
                        Vector vector = iAttributeEditor.getValues();
                        this._dataModel.updateObjectClasses(vector);
                        this._allAttributes = null;
                        this.getAllAttributes();
                        this.validateEditors(vector);
                        bl = true;
                    }
                    boolean bl4 = false;
                    object2 = this.getNamingAttributes();
                    if (object2 != null) {
                        n = 0;
                        while (n < ((Object)object2).length) {
                            if (((String)object3).equals(object2[n])) {
                                bl4 = true;
                                break;
                            }
                            ++n;
                        }
                    }
                    if (bl4 && iAttributeEditor.getValueCount() > 1) {
                        this._bDeleteValue.setEnabled(true);
                    }
                    this.invalidate();
                    this.validate();
                }
                catch (Exception exception) {
                    Debug.println((String)("DSEntryPanel.actionPerformed: ADD_VALUE, " + exception));
                    exception.printStackTrace();
                }
            } else {
                Debug.println((String)"DSEntryPanel.actionPerformed: no editor has focus for ADD_VALUE");
            }
        } else if (actionEvent.getActionCommand().equals(SHOW_ATTRIBUTES_WITH_VALUES)) {
            this._showingAll = !this._showingAll;
            bl = true;
        } else if (actionEvent.getActionCommand().equals(SHOW_NAMES)) {
            if (!this._showingNames) {
                this._showingNames = true;
                Enumeration enumeration = this._entries.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (IAttributeEditor)enumeration.nextElement();
                    object2.setLabelText(object2.getName());
                }
                bl = true;
            }
        } else if (actionEvent.getActionCommand().equals(SHOW_DESCRIPTIONS)) {
            if (this._showingNames) {
                this._showingNames = false;
                Enumeration enumeration = this._entries.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (IAttributeEditor)enumeration.nextElement();
                    object2.setLabelText(AttributeAlias.getAlias(object2.getName()));
                }
                bl = true;
            }
        } else if (actionEvent.getActionCommand().equals(REFRESH)) {
            Thread thread = new Thread(new Refresher());
            try {
                thread.start();
                return;
            }
            catch (Exception exception) {
                Debug.println((String)("DSEntryPanel.actionPerformed " + exception));
            }
        } else if (actionEvent.getActionCommand().equals(CHANGE_NAMING_ATTRIBUTE)) {
            this.actionChangeNamingAttribute();
        }
        if (bl) {
            this.showAllAttributes(this._showingAll);
        }
        if (object3 != null && (object = this.getVisible((String)object3)) != null && object instanceof JComponent) {
            object2 = (JComponent)object;
            ((JComponent)object2).requestFocus();
            Dimension dimension = ((Component)object2).getSize();
            ((JComponent)object2).scrollRectToVisible(new Rectangle(0, 0, dimension.width, dimension.height));
        }
        this.updateButtons();
    }

    private void updateSelection(Component component) {
        Debug.println((int)9, (String)("DSEntryPanel.updateSelection: comp = " + component));
        while (component != null) {
            if (component instanceof IAttributeEditor) {
                Enumeration enumeration = this._visible.keys();
                while (enumeration.hasMoreElements()) {
                    IAttributeEditor iAttributeEditor = (IAttributeEditor)this._visible.get(enumeration.nextElement());
                    if (!iAttributeEditor.isSelected() || iAttributeEditor.equals(component)) continue;
                    iAttributeEditor.setSelected(false);
                    Debug.println((int)9, (String)("DSEntryPanel.updateSelection: deselected editor " + iAttributeEditor));
                    break;
                }
                if (((IAttributeEditor)((Object)component)).isSelected()) break;
                ((IAttributeEditor)((Object)component)).setSelected(true);
                Debug.println((int)9, (String)("DSEntryPanel.updateSelection: selected editor " + component));
                break;
            }
            if (!(component instanceof Container)) break;
            component = ((Container)component).getParent();
        }
    }

    private void updateButtons() {
        IAttributeEditor iAttributeEditor = this.getSelectedEditor();
        if (iAttributeEditor != null) {
            String string = iAttributeEditor.getName();
            this._bAddValue.setEnabled(true);
            this._bAddAttribute.setEnabled(true);
            boolean bl = false;
            String[] stringArray = this.getNamingAttributes();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    if (string.equals(stringArray[n])) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            if (bl) {
                if (iAttributeEditor.getValueCount() < 2) {
                    this._bDeleteValue.setEnabled(false);
                } else {
                    this._bDeleteValue.setEnabled(true);
                }
                this._bDeleteAttribute.setEnabled(false);
            } else if (iAttributeEditor.getName().equalsIgnoreCase("objectclass")) {
                Component component = iAttributeEditor.getFocusField();
                String string2 = "";
                if (component instanceof JTextField) {
                    string2 = ((JTextField)component).getText();
                }
                this._bDeleteAttribute.setEnabled(false);
                if (iAttributeEditor.getValueCount() < 3 || string2.equalsIgnoreCase("top")) {
                    this._bDeleteValue.setEnabled(false);
                } else {
                    this._bDeleteValue.setEnabled(true);
                }
            } else {
                if (iAttributeEditor.getValueCount() > 0) {
                    this._bDeleteValue.setEnabled(true);
                } else {
                    this._bDeleteValue.setEnabled(false);
                }
                if (iAttributeEditor.isDeletable()) {
                    this._bDeleteAttribute.setEnabled(true);
                } else {
                    this._bDeleteAttribute.setEnabled(false);
                    if (iAttributeEditor.getValueCount() < 2) {
                        this._bDeleteValue.setEnabled(false);
                    }
                }
            }
        } else {
            this._bDeleteValue.setEnabled(false);
            this._bAddValue.setEnabled(false);
            this._bAddAttribute.setEnabled(true);
            this._bDeleteAttribute.setEnabled(false);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.updateSelection(focusEvent.getComponent());
        this.updateButtons();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    private IAttributeEditor getEditor(String string) {
        String string2 = this._showingNames ? string : AttributeAlias.getAlias(string);
        Rectangle rectangle = new Rectangle(0, 0, 180, 23);
        IAttributeEditor iAttributeEditor = this.getEditorForType(string, string2, rectangle);
        return iAttributeEditor;
    }

    private void addAttribute() {
        Vector vector = this.getAllAttributes();
        if (vector.size() < 1) {
            return;
        }
        NewAttributePanel newAttributePanel = new NewAttributePanel((IDSModel)new DefaultResourceModel(), vector, this._visible);
        SimpleDialog simpleDialog = new SimpleDialog(this.getOwnerFrame(), newAttributePanel);
        ((JDialog)((Object)simpleDialog)).getAccessibleContext().setAccessibleDescription(_resource.getString(_section, "newattribute-description"));
        ((Window)((Object)simpleDialog)).setLocationRelativeTo(this.getOwnerWindow());
        simpleDialog.packAndShow();
        String[] stringArray = newAttributePanel.getSelectedAttributes();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                IAttributeEditor iAttributeEditor;
                boolean bl = false;
                int n2 = 0;
                while (n2 < this._toDelete.size()) {
                    iAttributeEditor = (IAttributeEditor)this._toDelete.elementAt(n2);
                    if (stringArray[n].equals(iAttributeEditor.getName())) {
                        bl = true;
                        this._toDelete.removeElementAt(n2);
                        break;
                    }
                    ++n2;
                }
                iAttributeEditor = this.getEditor(stringArray[n]);
                iAttributeEditor.addValue(iAttributeEditor.getDefaultValue());
                iAttributeEditor.setDirty(true);
                if (!bl) {
                    this._toAdd.addElement(iAttributeEditor);
                }
                int n3 = this._entries.size();
                IAttributeEditor[] iAttributeEditorArray = new IAttributeEditor[n3 + 1];
                int n4 = 0;
                while (n4 < n3) {
                    iAttributeEditorArray[n4] = (IAttributeEditor)this._entries.elementAt(n4);
                    ++n4;
                }
                iAttributeEditorArray[n3] = iAttributeEditor;
                this.replaceSortedEditors(iAttributeEditorArray);
                this.validate();
                ++n;
            }
        }
    }

    private void showAllAttributes(boolean bl) {
        Object[] objectArray;
        if (bl) {
            Vector vector = this.getAllAttributes();
            int n = vector.size();
            int n2 = this._entries.size();
            int n3 = 0;
            while (n3 < n2) {
                IAttributeEditor iAttributeEditor = (IAttributeEditor)this._entries.elementAt(n3);
                String string = iAttributeEditor.getName().toLowerCase();
                if (vector.indexOf(string) < 0) {
                    ++n;
                }
                ++n3;
            }
            objectArray = new IAttributeEditor[n];
            int n4 = 0;
            while (n4 < n2) {
                objectArray[n4] = (IAttributeEditor)this._entries.elementAt(n4);
                ++n4;
            }
            int n5 = 0;
            Vector vector2 = this.getInvisibleAttributes();
            n5 = vector2.size();
            int n6 = 0;
            while (n6 < n5) {
                String string = (String)vector2.elementAt(n6);
                IAttributeEditor iAttributeEditor = this.getEditor(string);
                objectArray[n6 + n2] = iAttributeEditor;
                ++n6;
            }
        } else {
            Vector<IAttributeEditor> vector = new Vector<IAttributeEditor>();
            Enumeration enumeration = this._entries.elements();
            while (enumeration.hasMoreElements()) {
                IAttributeEditor iAttributeEditor = (IAttributeEditor)enumeration.nextElement();
                if (iAttributeEditor.getValueCount() <= 0) continue;
                vector.addElement(iAttributeEditor);
            }
            int n = vector.size();
            objectArray = new IAttributeEditor[n];
            vector.copyInto(objectArray);
        }
        this.replaceSortedEditors((IAttributeEditor[])objectArray);
        this.validate();
        this.repaint();
    }

    private Vector getAllAttributes() {
        if (this._allAttributes == null) {
            Enumeration enumeration = this._dataModel.getAttributeNames();
            this._allAttributes = new Vector();
            while (enumeration.hasMoreElements()) {
                this._allAttributes.addElement(enumeration.nextElement());
            }
            String[] stringArray = DSSchemaHelper.getEditableOperationalAttributes(this._dataModel.getSchema());
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    this._allAttributes.addElement(stringArray[n]);
                    ++n;
                }
            }
            Object[] objectArray = new String[this._allAttributes.size()];
            this._allAttributes.copyInto(objectArray);
            this.sortStrings((String[])objectArray);
            int n = 0;
            while (n < objectArray.length) {
                this._allAttributes.setElementAt(objectArray[n], n);
                ++n;
            }
        }
        return this._allAttributes;
    }

    private Vector getInvisibleAttributes() {
        this.getAllAttributes();
        Vector vector = new Vector();
        int n = 0;
        while (n < this._allAttributes.size()) {
            if (this._visible.get(this._allAttributes.elementAt(n)) == null) {
                vector.addElement(this._allAttributes.elementAt(n));
            }
            ++n;
        }
        return vector;
    }

    private void addMissingAttributes(Hashtable hashtable, Hashtable hashtable2, Vector vector, boolean bl) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = ((String)enumeration.nextElement()).toLowerCase();
            if (hashtable2.get(string) != null) continue;
            IAttributeEditor iAttributeEditor = this.getEditor(string);
            if (bl) {
                boolean bl2 = false;
                int n = 0;
                while (n < this._toDelete.size()) {
                    IAttributeEditor iAttributeEditor2 = (IAttributeEditor)this._toDelete.elementAt(n);
                    if (string.equals(iAttributeEditor2.getName())) {
                        bl2 = true;
                        this._toDelete.removeElementAt(n);
                        break;
                    }
                    ++n;
                }
                if (!bl2) {
                    this._toAdd.addElement(iAttributeEditor);
                }
                iAttributeEditor.addValue();
            }
            vector.addElement(iAttributeEditor);
        }
    }

    private void validateEditors(Vector vector) {
        Object[] objectArray;
        Object object;
        LDAPObjectClassSchema lDAPObjectClassSchema;
        Hashtable<LDAPObjectClassSchema, LDAPObjectClassSchema> hashtable = new Hashtable<LDAPObjectClassSchema, LDAPObjectClassSchema>();
        Hashtable hashtable2 = new Hashtable();
        LDAPSchema lDAPSchema = this._dataModel.getSchema();
        boolean bl = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            lDAPObjectClassSchema = lDAPSchema.getObjectClass((String)enumeration.nextElement());
            if (lDAPObjectClassSchema == null) continue;
            DSSchemaHelper.allOptionalAttributes(lDAPObjectClassSchema, lDAPSchema, hashtable);
            DSSchemaHelper.allRequiredAttributes(lDAPObjectClassSchema, lDAPSchema, hashtable2);
            object = lDAPObjectClassSchema.getName();
            if (!((String)object).equalsIgnoreCase("extensibleobject")) continue;
            bl = true;
        }
        lDAPObjectClassSchema = DSSchemaHelper.getEditableOperationalAttributes(this._dataModel.getSchema());
        if (lDAPObjectClassSchema != null) {
            int n = 0;
            while (n < ((LDAPObjectClassSchema)lDAPObjectClassSchema).length) {
                hashtable.put(lDAPObjectClassSchema[n], lDAPObjectClassSchema[n]);
                ++n;
            }
        }
        if (bl) {
            this._cbAttributeWithValues.setSelected(true);
            this._cbAttributeWithValues.setEnabled(false);
            this._showingAll = false;
            this.showAllAttributes(this._showingAll);
        } else {
            this._cbAttributeWithValues.setEnabled(true);
        }
        object = new Vector();
        enumeration = this._entries.elements();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            String string = objectArray.getName();
            if (hashtable2.get(string) != null || hashtable.get(string) != null) {
                ((Vector)object).addElement(objectArray);
                hashtable3.put(objectArray.getName(), objectArray.getName());
                continue;
            }
            if (this._toAdd.indexOf(objectArray) >= 0) {
                this._toAdd.removeElement(objectArray);
                continue;
            }
            this._toDelete.addElement(objectArray);
        }
        this.addMissingAttributes(hashtable2, hashtable3, (Vector)object, true);
        if (this._showingAll) {
            this.addMissingAttributes(hashtable, hashtable3, (Vector)object, false);
        }
        objectArray = new IAttributeEditor[((Vector)object).size()];
        ((Vector)object).copyInto(objectArray);
        this.replaceSortedEditors((IAttributeEditor[])objectArray);
        this.validate();
    }

    private void sortStrings(String[] stringArray) {
        DSUtil.bubbleSort(stringArray, true);
    }

    private void sortEditors(IAttributeEditor[] iAttributeEditorArray) {
        Collator collator = Collator.getInstance();
        int n = iAttributeEditorArray.length;
        int n2 = 0;
        while (n2 < n - 1) {
            int n3 = n2 + 1;
            while (n3 < n) {
                if (collator.compare(iAttributeEditorArray[n2].getLabelText(), iAttributeEditorArray[n3].getLabelText()) > 0) {
                    IAttributeEditor iAttributeEditor = iAttributeEditorArray[n2];
                    iAttributeEditorArray[n2] = iAttributeEditorArray[n3];
                    iAttributeEditorArray[n3] = iAttributeEditor;
                }
                ++n3;
            }
            ++n2;
        }
    }

    private void removeAllEditors() {
        int n = this._entries.size();
        int n2 = 0;
        while (n2 < n) {
            this._page.remove((JComponent)this._entries.elementAt(n2));
            ++n2;
        }
        this._entries.removeAllElements();
        this._visible.clear();
        this._page.remove(this._glue);
    }

    private void replaceSortedEditors(IAttributeEditor[] iAttributeEditorArray) {
        int n = iAttributeEditorArray.length;
        this.sortEditors(iAttributeEditorArray);
        this.removeAllEditors();
        int n2 = 0;
        while (n2 < n) {
            this.setVisible(iAttributeEditorArray[n2]);
            this._page.add((Component)((JComponent)((Object)iAttributeEditorArray[n2])), this._cons);
            this._entries.addElement(iAttributeEditorArray[n2]);
            ++n2;
        }
        this._cons.weighty = 1.0;
        this._cons.fill = 1;
        this._page.add(this._glue, this._cons);
        this._cons.weighty = 0.0;
        this._cons.fill = 2;
        this.validate();
    }

    private void setVisible(IAttributeEditor iAttributeEditor) {
        String string = iAttributeEditor.getName().toLowerCase();
        this._visible.put(string, iAttributeEditor);
    }

    private Object getVisible(String string) {
        return this._visible.get(string.toLowerCase());
    }

    private IAttributeEditor getSelectedEditor() {
        IAttributeEditor iAttributeEditor = null;
        Enumeration enumeration = this._entries.elements();
        while (iAttributeEditor == null && enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof IAttributeEditor) || !((IAttributeEditor)e).isSelected()) continue;
            iAttributeEditor = (IAttributeEditor)e;
        }
        return iAttributeEditor;
    }

    protected void setDNVisible(boolean bl) {
        this._dnLabel.setVisible(bl);
        this.validate();
    }

    public void updateNamingValue(String string) {
        IAttributeEditor iAttributeEditor;
        if (this._options != 2 && (iAttributeEditor = (IAttributeEditor)this._visible.get(string)) != null) {
            Integer n = (Integer)this._namingAttributeIndexes.get(string);
            int n2 = 0;
            if (n != null) {
                n2 = n;
            }
            Vector vector = iAttributeEditor.getValues();
            String string2 = (String)vector.elementAt(n2);
            String[] stringArray = this.getNamingAttributes();
            boolean bl = false;
            boolean bl2 = false;
            int n3 = 0;
            while (n3 < stringArray.length & !bl) {
                if (stringArray[n3].equals(string)) {
                    bl = true;
                    if (!this._namingValues[n3].equals(string2)) {
                        this._namingValues[n3] = string2;
                        bl2 = true;
                    }
                }
                ++n3;
            }
            if (bl2) {
                this.updateDNValue(this.getNamingAttributes(), this.getNamingValues());
            }
        }
    }

    public void updateDNValue(String[] stringArray, String[] stringArray2) {
        String string;
        int n = 0;
        while (n < this.FORBIDDEN_NAMING_ATTRIBUTES.length) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals(this.FORBIDDEN_NAMING_ATTRIBUTES[n])) {
                    DSUtil.showErrorDialog((Component)this.getOwnerFrame(), "namingattribute-forbiddenattribute", stringArray[n2]);
                    return;
                }
                ++n2;
            }
            ++n;
        }
        String string2 = "";
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray2[n3].indexOf(44) >= 0) {
                string = MappingUtils.unQuote(stringArray2[n3]);
                string2 = n3 > 0 ? string2 + " + " + stringArray[n3] + "=\"" + string + "\"" : stringArray[n3] + "=\"" + string + "\"";
            } else {
                string2 = n3 > 0 ? string2 + " + " + stringArray[n3] + "=" + stringArray2[n3] : stringArray[n3] + "=" + stringArray2[n3];
            }
            ++n3;
        }
        Debug.println((String)("DSEntryPanel.updateDNValue: rdn = " + string2));
        string = new RDN(string2);
        DN dN = this._dn.getParent();
        if (!dN.toRFCString().trim().equals("")) {
            dN.addRDN((RDN)string);
        } else {
            dN = new DN(string2);
        }
        this._dn = dN;
        String string3 = string2 + ", " + this._dn.getParent();
        Debug.println((String)("DSEntryPanel.updateDNValue: dn = " + string3));
        if (string3 != null) {
            this._dnLabel.setText("dn: " + string3);
        }
        this._namingAttributes = stringArray;
        this._namingValues = stringArray2;
        if (this._lNamingAttribute != null) {
            String string4 = stringArray[0];
            int n4 = 1;
            while (n4 < stringArray.length) {
                string4 = string4 + ", " + stringArray[n4];
                ++n4;
            }
            string4 = DSUtil.abreviateString(string4, 15);
            Debug.println((String)("DSEntryPanel.updateDNValue: naming attributes = " + string4));
            this._lNamingAttribute.setText(_resource.getString(_section, "namingattribute") + " " + string4);
        }
        this.validate();
        this.repaint();
    }

    public boolean isValidDN() {
        boolean bl = false;
        if (this.getDN().trim().equals("")) {
            return true;
        }
        String[] stringArray = LDAPDN.explodeDN((String)this.getDN(), (boolean)false);
        if (stringArray == null || stringArray[0] == null || !DN.isDN((String)this.getDN())) {
            Debug.println((String)"DSEntryPanel.isValidDN():  the rdn is not a good RDN");
            DSUtil.showErrorDialog((Component)this.getOwnerFrame(), "namingattribute-syntaxerror", "");
            return false;
        }
        RDN rDN = new RDN(stringArray[0]);
        String[] stringArray2 = rDN.getValues();
        String[] stringArray3 = rDN.getTypes();
        LDAPAttributeSet lDAPAttributeSet = this.getAttributes();
        int n = 0;
        while (n < stringArray3.length) {
            block7: {
                block8: {
                    block5: {
                        block6: {
                            bl = true;
                            LDAPAttribute lDAPAttribute = lDAPAttributeSet.getAttribute(stringArray3[n]);
                            if (lDAPAttribute == null) break block5;
                            boolean bl2 = false;
                            String string = stringArray2[n];
                            Enumeration enumeration = lDAPAttribute.getStringValues();
                            if (enumeration == null) break block6;
                            while (enumeration.hasMoreElements()) {
                                String string2 = (String)enumeration.nextElement();
                                if (!string.equals(string2) && !string.equals('\"' + string2 + '\"')) continue;
                                bl2 = true;
                                break;
                            }
                            if (bl2) break block7;
                            bl = false;
                            break block8;
                        }
                        bl = false;
                        break block8;
                    }
                    bl = false;
                }
                if (!bl) break;
            }
            ++n;
        }
        if (!bl) {
            DSUtil.showErrorDialog((Component)this.getOwnerFrame(), "namingattribute-unknowerror", "");
        }
        return bl;
    }

    public String[] getNamingAttributes() {
        return this._namingAttributes;
    }

    public String[] getNamingValues() {
        return this._namingValues;
    }

    public String[] getNamingAttributesFor(String string) {
        if (string == null) {
            return null;
        }
        DN dN = new DN(string);
        String string2 = dN.explodeDN(false)[0];
        RDN rDN = new RDN(string2);
        return rDN.getTypes();
    }

    public String[] getNamingValuesFor(String string) {
        if (string == null) {
            return null;
        }
        DN dN = new DN(string);
        String string2 = dN.explodeDN(false)[0];
        RDN rDN = new RDN(string2);
        return rDN.getValues();
    }

    public String getDN() {
        return this._dn.toRFCString();
    }

    public int getOptions() {
        return this._options;
    }

    public void createDNLabel() {
        this._dn = new DN(this._dataModel.getTitle());
        if (this._dataModel.getTitle() != null) {
            this._dnLabel = new JLabel("dn: " + this._dataModel.getTitle());
            this._saveNamingAttributes = this.getNamingAttributesFor(this._dataModel.getTitle());
            this._namingAttributes = new String[this._saveNamingAttributes.length];
            int n = 0;
            while (n < this._saveNamingAttributes.length) {
                this._namingAttributes[n] = this._saveNamingAttributes[n];
                ++n;
            }
            this._saveNamingValues = this.getNamingValuesFor(this._dataModel.getTitle());
            this._namingValues = new String[this._saveNamingValues.length];
            int n2 = 0;
            while (n2 < this._saveNamingValues.length) {
                this._namingValues[n2] = this._saveNamingValues[n2];
                ++n2;
            }
        } else {
            this._dnLabel = new JLabel("");
            this._options = 2;
        }
        if (this._saveNamingAttributes == null) {
            Debug.println((String)"DSEntryPanel.createDNLabel(): could not create the defaultNamingAttribute");
        }
    }

    public JPanel createActionPanel() {
        int n;
        int n2;
        GridBagConstraints gridBagConstraints;
        GroupPanel groupPanel;
        GroupPanel groupPanel2;
        JPanel jPanel;
        block8: {
            Serializable serializable;
            jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            groupPanel2 = new GroupPanel(_resource.getString(_section, "view"), true);
            groupPanel = new GroupPanel(_resource.getString(_section, "edit"), true);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 0;
            n2 = UIFactory.getComponentSpace();
            gridBagConstraints.insets = new Insets(0, n2, 0, n2);
            gridBagConstraints.gridwidth = 0;
            jPanel.add((Component)groupPanel2, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            jPanel.add((Component)groupPanel, gridBagConstraints);
            if (this._options != 2) {
                gridBagConstraints.anchor = 18;
                serializable = this.createNamingAttributePanel();
                jPanel.add((Component)serializable, gridBagConstraints);
            }
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = 3;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 0;
            jPanel.add(Box.createGlue(), gridBagConstraints);
            this._rbAttributeName = UIFactory.makeJRadioButton(this, _section, "rbattributename", false, _resource);
            this._rbAttributeName.setActionCommand(SHOW_NAMES);
            this._rbAttributeName.setSelected(this._showingNames);
            this._rbAttributeDescription = UIFactory.makeJRadioButton(this, _section, "rbattributedescription", true, _resource);
            this._rbAttributeDescription.setActionCommand(SHOW_DESCRIPTIONS);
            this._rbAttributeDescription.setSelected(!this._showingNames);
            serializable = new ButtonGroup();
            ((ButtonGroup)serializable).add(this._rbAttributeName);
            ((ButtonGroup)serializable).add(this._rbAttributeDescription);
            this._cbAttributeWithValues = UIFactory.makeJCheckBox(this, _section, "cbattributewithvalues", true, _resource);
            this._cbAttributeWithValues.setActionCommand(SHOW_ATTRIBUTES_WITH_VALUES);
            this._cbAttributeWithValues.setSelected(true);
            IAttributeEditor iAttributeEditor = (IAttributeEditor)this._visible.get("objectclass");
            Vector vector = iAttributeEditor.getValues();
            if (vector != null) {
                n = 0;
                while (n < vector.size()) {
                    if (((String)vector.elementAt(n)).equalsIgnoreCase("extensibleobject")) {
                        this._cbAttributeWithValues.setEnabled(false);
                        break;
                    }
                    ++n;
                }
            }
            this._cbShowDN = UIFactory.makeJCheckBox(this, _section, "cbshowdn", this._dnLabel.isVisible(), _resource);
            this._cbShowDN.setActionCommand(SHOW_DN);
            this._cbShowDN.setSelected(this._dnLabel.isVisible());
            this._bRefresh = UIFactory.makeJButton(this, _section, "brefresh", _resource);
            this._bRefresh.setActionCommand(REFRESH);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, n2, 0, n2);
            groupPanel2.add((Component)this._rbAttributeName, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            groupPanel2.add((Component)this._rbAttributeDescription, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            groupPanel2.add(Box.createVerticalStrut(10), gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            groupPanel2.add((Component)this._cbAttributeWithValues, gridBagConstraints);
            if (this._options != 2) {
                groupPanel2.add((Component)this._cbShowDN, gridBagConstraints);
            }
            gridBagConstraints.gridwidth = 0;
            groupPanel2.add(Box.createVerticalStrut(10), gridBagConstraints);
            n = 0;
            try {
                DSUtil.readEntry(this._ldc, this.getDN(), null, (LDAPSearchConstraints)this._ldc.getSearchConstraints().clone());
                n = 1;
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) break block8;
                Debug.println((String)("DSEntryPanel.createActionPanel " + (Object)((Object)lDAPException)));
            }
        }
        if (n != 0) {
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(0, 2 * n2, n2, 2 * n2);
            gridBagConstraints.weightx = 1.0;
            groupPanel2.add((Component)this._bRefresh, gridBagConstraints);
        }
        this._bAddValue = UIFactory.makeJButton(this, _section, "baddvalue", _resource);
        this._bAddValue.setActionCommand(ADD_VALUE);
        this._bDeleteValue = UIFactory.makeJButton(this, _section, "bdeletevalue", _resource);
        this._bDeleteValue.setActionCommand(DELETE_VALUE);
        this._bAddAttribute = UIFactory.makeJButton(this, _section, "baddattribute", _resource);
        this._bAddAttribute.setActionCommand(ADD_ATTRIBUTE);
        this._bDeleteAttribute = UIFactory.makeJButton(this, _section, "bdeleteattribute", _resource);
        this._bDeleteAttribute.setActionCommand(DELETE_ATTRIBUTE);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 2 * n2, n2, 2 * n2);
        gridBagConstraints.weightx = 1.0;
        groupPanel.add((Component)this._bAddValue, gridBagConstraints);
        groupPanel.add((Component)this._bDeleteValue, gridBagConstraints);
        groupPanel.add((Component)this._bAddAttribute, gridBagConstraints);
        groupPanel.add((Component)this._bDeleteAttribute, gridBagConstraints);
        this.updateButtons();
        return jPanel;
    }

    private JPanel createNamingAttributePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(6, 9, 6, 9));
        this._namingValues = this.getNamingValuesFor(this._dataModel.getTitle());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String[] stringArray = this.getNamingAttributes();
        if (stringArray != null) {
            String string = stringArray[0];
            int n = 1;
            while (n < stringArray.length) {
                string = string + ", " + stringArray[n];
                ++n;
            }
            string = DSUtil.abreviateString(string, 15);
            this._lNamingAttribute = new JLabel(_resource.getString(_section, "namingattribute") + " " + string);
            gridBagConstraints.gridwidth = this._options == 1 ? -1 : 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 18;
            jPanel.add((Component)this._lNamingAttribute, gridBagConstraints);
            gridBagConstraints.anchor = 12;
            gridBagConstraints.insets.left = 6;
            if (this._options == 1) {
                this._bChangeNamingAttribute = UIFactory.makeJButton(this, _section, "bchangenamingattribute", _resource);
                this._bChangeNamingAttribute.setActionCommand(CHANGE_NAMING_ATTRIBUTE);
                this._lNamingAttribute.setLabelFor(this._bChangeNamingAttribute);
                jPanel.add((Component)this._bChangeNamingAttribute, gridBagConstraints);
            } else {
                this._lNamingAttribute.setLabelFor(jPanel);
            }
        }
        return jPanel;
    }

    public boolean updateNamingAttributes() {
        boolean bl = false;
        String[] stringArray = this.getNamingAttributes();
        String[] stringArray2 = this.getNamingValues();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (this._visible.get(stringArray[n]) != null) {
                vector.addElement(stringArray[n]);
                vector2.addElement(stringArray2[n]);
            }
            ++n;
        }
        if (vector.size() != stringArray.length) {
            bl = true;
            if (vector.size() > 0) {
                this._namingAttributes = new String[vector.size()];
                vector.toArray(this._namingAttributes);
                this._namingValues = new String[vector2.size()];
                vector2.toArray(this._namingValues);
            } else {
                boolean bl2 = false;
                int n2 = 0;
                while (n2 < this._entries.size() && !bl2) {
                    IAttributeEditor iAttributeEditor = (IAttributeEditor)this._entries.elementAt(n2);
                    if (iAttributeEditor instanceof StringAttributeEditor) {
                        String string = iAttributeEditor.getName();
                        boolean bl3 = false;
                        int n3 = 0;
                        while (n3 < this.FORBIDDEN_NAMING_ATTRIBUTES.length && !bl3) {
                            if (string.equals(this.FORBIDDEN_NAMING_ATTRIBUTES[n3])) {
                                bl3 = true;
                            }
                            ++n3;
                        }
                        if (!bl3) {
                            bl2 = true;
                            this._namingAttributes = new String[1];
                            this._namingAttributes[0] = string;
                            this._namingValues = new String[1];
                            Vector vector3 = iAttributeEditor.getValues();
                            this._namingValues[0] = vector3 != null && vector3.size() > 0 ? (String)vector3.elementAt(0) : "";
                        }
                    }
                    ++n2;
                }
            }
        }
        if (bl) {
            this.updateDNValue(this.getNamingAttributes(), this.getNamingValues());
        }
        return bl;
    }

    private void actionChangeNamingAttribute() {
        if (this._renameDialog == null) {
            this._renameDialog = new RenameDialog(this.getOwnerFrame());
        }
        Hashtable hashtable = this.getValuesForNaming();
        this._renameDialog.display(this.getNamingAttributes(), this.getNamingValues(), hashtable);
        if (!this._renameDialog.isCancelled() && this._renameDialog.isModified()) {
            this.updateDNValue(this._renameDialog.getNamingAttributes(), this._renameDialog.getNamingValues());
            this.updateNamingIndexes();
        }
    }

    private void updateNamingIndexes() {
        this._namingAttributeIndexes.clear();
        String[] stringArray = this.getNamingAttributes();
        String[] stringArray2 = this.getNamingValues();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            IAttributeEditor iAttributeEditor = (IAttributeEditor)this._visible.get(stringArray[n]);
            if (iAttributeEditor != null) {
                Vector vector = iAttributeEditor.getValues();
                n2 = vector.indexOf(stringArray2[n]);
            }
            if (n2 < 0) {
                n2 = 0;
            }
            this._namingAttributeIndexes.put(stringArray[n], new Integer(n2));
            ++n;
        }
    }

    private Hashtable getValuesForNaming() {
        Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>();
        int n = 0;
        while (n < this._entries.size()) {
            IAttributeEditor iAttributeEditor = (IAttributeEditor)this._entries.elementAt(n);
            if (iAttributeEditor instanceof StringAttributeEditor) {
                String string = iAttributeEditor.getName();
                boolean bl = false;
                int n2 = 0;
                while (n2 < this.FORBIDDEN_NAMING_ATTRIBUTES.length && !bl) {
                    if (string.equals(this.FORBIDDEN_NAMING_ATTRIBUTES[n2])) {
                        bl = true;
                    }
                    ++n2;
                }
                if (!bl) {
                    hashtable.put(string, iAttributeEditor.getValues());
                }
            }
            ++n;
        }
        return hashtable;
    }

    static /* synthetic */ JButton access$200(DSEntryPanel dSEntryPanel) {
        return dSEntryPanel._bRefresh;
    }

    static /* synthetic */ JButton access$300(DSEntryPanel dSEntryPanel) {
        return dSEntryPanel._bChangeNamingAttribute;
    }

    static /* synthetic */ JCheckBox access$400(DSEntryPanel dSEntryPanel) {
        return dSEntryPanel._cbShowDN;
    }

    static /* synthetic */ JCheckBox access$500(DSEntryPanel dSEntryPanel) {
        return dSEntryPanel._cbAttributeWithValues;
    }

    static /* synthetic */ JRadioButton access$600(DSEntryPanel dSEntryPanel) {
        return dSEntryPanel._rbAttributeName;
    }

    static /* synthetic */ JRadioButton access$700(DSEntryPanel dSEntryPanel) {
        return dSEntryPanel._rbAttributeDescription;
    }

    static /* synthetic */ JButton access$800(DSEntryPanel dSEntryPanel) {
        return dSEntryPanel._bAddValue;
    }

    static /* synthetic */ JButton access$900(DSEntryPanel dSEntryPanel) {
        return dSEntryPanel._bDeleteValue;
    }

    static /* synthetic */ JButton access$1000(DSEntryPanel dSEntryPanel) {
        return dSEntryPanel._bDeleteAttribute;
    }

    static /* synthetic */ JButton access$1100(DSEntryPanel dSEntryPanel) {
        return dSEntryPanel._bAddAttribute;
    }

    static /* synthetic */ Vector access$1602(DSEntryPanel dSEntryPanel, Vector vector) {
        dSEntryPanel._entries = vector;
        return dSEntryPanel._entries;
    }

    static /* synthetic */ Hashtable access$1702(DSEntryPanel dSEntryPanel, Hashtable hashtable) {
        dSEntryPanel._visible = hashtable;
        return dSEntryPanel._visible;
    }

    static /* synthetic */ Vector access$1802(DSEntryPanel dSEntryPanel, Vector vector) {
        dSEntryPanel._toDelete = vector;
        return dSEntryPanel._toDelete;
    }

    static /* synthetic */ Vector access$1902(DSEntryPanel dSEntryPanel, Vector vector) {
        dSEntryPanel._toAdd = vector;
        return dSEntryPanel._toAdd;
    }

    static /* synthetic */ Hashtable access$2000(DSEntryPanel dSEntryPanel) {
        return dSEntryPanel._namingAttributeIndexes;
    }

    static /* synthetic */ JComponent access$002(DSEntryPanel dSEntryPanel, JComponent jComponent) {
        dSEntryPanel._centerPane = jComponent;
        return dSEntryPanel._centerPane;
    }

    static /* synthetic */ JComponent access$2100(DSEntryPanel dSEntryPanel) {
        return dSEntryPanel.initialize();
    }

    static /* synthetic */ boolean access$2202(DSEntryPanel dSEntryPanel, boolean bl) {
        dSEntryPanel._showingNames = bl;
        return dSEntryPanel._showingNames;
    }

    static /* synthetic */ Vector access$1600(DSEntryPanel dSEntryPanel) {
        return dSEntryPanel._entries;
    }

    static /* synthetic */ boolean access$2302(DSEntryPanel dSEntryPanel, boolean bl) {
        dSEntryPanel._showingAll = bl;
        return dSEntryPanel._showingAll;
    }

    static /* synthetic */ boolean access$2300(DSEntryPanel dSEntryPanel) {
        return dSEntryPanel._showingAll;
    }

    static /* synthetic */ void access$2400(DSEntryPanel dSEntryPanel, boolean bl) {
        dSEntryPanel.showAllAttributes(bl);
    }

    static /* synthetic */ JLabel access$2500(DSEntryPanel dSEntryPanel) {
        return dSEntryPanel._dnLabel;
    }

    static /* synthetic */ void access$2600(DSEntryPanel dSEntryPanel) {
        dSEntryPanel.updateButtons();
    }

    class Refresher
    implements Runnable {
        public void run() {
            LDAPAttributeSet lDAPAttributeSet;
            LDAPEntry lDAPEntry;
            JLabel jLabel;
            block8: {
                DSEntryPanel.this.remove(DSEntryPanel.this._centerPane);
                jLabel = new JLabel(_resource.getString(DSEntryPanel._section, "refresh-label"));
                SwingUtilities.invokeLater(new Runnable(this, jLabel){
                    private final /* synthetic */ JLabel val$waitingLabel;
                    private final /* synthetic */ Refresher this$1;
                    {
                        this.this$1 = refresher;
                        this.val$waitingLabel = jLabel;
                    }

                    public void run() {
                        DSEntryPanel.access$200(Refresher.access$100(this.this$1)).setEnabled(false);
                        if (DSEntryPanel.access$300(Refresher.access$100(this.this$1)) != null) {
                            DSEntryPanel.access$300(Refresher.access$100(this.this$1)).setEnabled(false);
                        }
                        DSEntryPanel.access$400(Refresher.access$100(this.this$1)).setEnabled(false);
                        DSEntryPanel.access$500(Refresher.access$100(this.this$1)).setEnabled(false);
                        DSEntryPanel.access$600(Refresher.access$100(this.this$1)).setEnabled(false);
                        DSEntryPanel.access$700(Refresher.access$100(this.this$1)).setEnabled(false);
                        DSEntryPanel.access$800(Refresher.access$100(this.this$1)).setEnabled(false);
                        DSEntryPanel.access$900(Refresher.access$100(this.this$1)).setEnabled(false);
                        DSEntryPanel.access$1000(Refresher.access$100(this.this$1)).setEnabled(false);
                        DSEntryPanel.access$1100(Refresher.access$100(this.this$1)).setEnabled(false);
                        Refresher.access$100(this.this$1).add("Center", this.val$waitingLabel);
                        Refresher.access$100(this.this$1).validate();
                        Refresher.access$100(this.this$1).repaint();
                    }
                });
                String string = DSEntryPanel.this._dataModel.getTitle();
                lDAPEntry = null;
                try {
                    lDAPAttributeSet = DSSchemaHelper.getOperationalAttributes(DSEntryPanel.this._dataModel.getSchema());
                    String[] stringArray = null;
                    if (lDAPAttributeSet == null) {
                        stringArray = new String[]{"*"};
                    } else {
                        stringArray = new String[((String[])lDAPAttributeSet).length + 1];
                        int n = 0;
                        while (n < ((LDAPAttributeSet)lDAPAttributeSet).length) {
                            stringArray[n] = lDAPAttributeSet[n];
                            ++n;
                        }
                        stringArray[((LDAPAttributeSet)lDAPAttributeSet).length] = "*";
                    }
                    lDAPEntry = DSUtil.readEntry(DSEntryPanel.this._ldc, string, stringArray, (LDAPSearchConstraints)DSEntryPanel.this._ldc.getSearchConstraints().clone());
                }
                catch (LDAPException lDAPException) {
                    Debug.println((String)("Refresher.run() " + (Object)((Object)lDAPException)));
                    if (lDAPException.getLDAPResultCode() != 32) break block8;
                    DSUtil.showErrorDialog((Component)DSEntryPanel.this.getOwnerFrame(), "editingentrywasdeleted", "");
                    DSEntryPanel.this.getOwnerWindow().dispose();
                    DSEntryPanel.this.getOwnerWindow().hide();
                }
            }
            if (lDAPEntry != null) {
                String[] stringArray;
                lDAPAttributeSet = lDAPEntry.getAttributeSet();
                int n = 0;
                Hashtable hashtable = DSUtil.getAllAttributeList(DSEntryPanel.this._dataModel.getSchema(), lDAPEntry);
                Enumeration enumeration = lDAPAttributeSet.getAttributes();
                Vector<String> vector = new Vector<String>();
                while (enumeration.hasMoreElements()) {
                    stringArray = (String[])enumeration.nextElement();
                    vector.addElement(stringArray.getName().toLowerCase());
                }
                hashtable = null;
                stringArray = new String[vector.size()];
                String[] stringArray2 = new String[vector.size()];
                n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = (String)vector.elementAt(n);
                    ++n;
                }
                AttributeAlias.getAliases(stringArray, stringArray2);
                EntryPageDescription entryPageDescription = new EntryPageDescription(stringArray, stringArray2);
                DSEntryPanel.this._dataModel = new DSPropertyModel(DSEntryPanel.this._dataModel.getSchema(), lDAPEntry, entryPageDescription);
            }
            SwingUtilities.invokeLater(new Runnable(this, jLabel){
                private final /* synthetic */ JLabel val$waitingLabel;
                private final /* synthetic */ Refresher this$1;
                {
                    this.this$1 = refresher;
                    this.val$waitingLabel = jLabel;
                }

                public void run() {
                    boolean bl = DSEntryPanel.access$600(Refresher.access$100(this.this$1)).isSelected();
                    boolean bl2 = DSEntryPanel.access$500(Refresher.access$100(this.this$1)).isSelected();
                    boolean bl3 = DSEntryPanel.access$400(Refresher.access$100(this.this$1)).isSelected();
                    DSEntryPanel.access$1602(Refresher.access$100(this.this$1), new Vector<E>());
                    DSEntryPanel.access$1702(Refresher.access$100(this.this$1), new Hashtable<K, V>());
                    DSEntryPanel.access$1802(Refresher.access$100(this.this$1), new Vector<E>());
                    DSEntryPanel.access$1902(Refresher.access$100(this.this$1), new Vector<E>());
                    DSEntryPanel.access$2000(Refresher.access$100(this.this$1)).clear();
                    Refresher.access$100(this.this$1).createDNLabel();
                    DSEntryPanel.access$002(Refresher.access$100(this.this$1), DSEntryPanel.access$2100(Refresher.access$100(this.this$1)));
                    DSEntryPanel.access$600(Refresher.access$100(this.this$1)).setSelected(bl);
                    DSEntryPanel.access$700(Refresher.access$100(this.this$1)).setSelected(!bl);
                    DSEntryPanel.access$2202(Refresher.access$100(this.this$1), bl);
                    Enumeration<E> enumeration = DSEntryPanel.access$1600(Refresher.access$100(this.this$1)).elements();
                    while (enumeration.hasMoreElements()) {
                        IAttributeEditor iAttributeEditor = (IAttributeEditor)enumeration.nextElement();
                        if (bl) {
                            iAttributeEditor.setLabelText(iAttributeEditor.getName());
                            continue;
                        }
                        iAttributeEditor.setLabelText(AttributeAlias.getAlias(iAttributeEditor.getName()));
                    }
                    DSEntryPanel.access$500(Refresher.access$100(this.this$1)).setSelected(bl2);
                    DSEntryPanel.access$2302(Refresher.access$100(this.this$1), !bl2);
                    DSEntryPanel.access$2400(Refresher.access$100(this.this$1), DSEntryPanel.access$2300(Refresher.access$100(this.this$1)));
                    DSEntryPanel.access$400(Refresher.access$100(this.this$1)).setSelected(bl3);
                    DSEntryPanel.access$2500(Refresher.access$100(this.this$1)).setVisible(bl3);
                    DSEntryPanel.access$2600(Refresher.access$100(this.this$1));
                    DSEntryPanel.access$200(Refresher.access$100(this.this$1)).setEnabled(true);
                    if (DSEntryPanel.access$300(Refresher.access$100(this.this$1)) != null) {
                        DSEntryPanel.access$300(Refresher.access$100(this.this$1)).setEnabled(true);
                    }
                    DSEntryPanel.access$400(Refresher.access$100(this.this$1)).setEnabled(true);
                    DSEntryPanel.access$500(Refresher.access$100(this.this$1)).setEnabled(true);
                    DSEntryPanel.access$600(Refresher.access$100(this.this$1)).setEnabled(true);
                    DSEntryPanel.access$700(Refresher.access$100(this.this$1)).setEnabled(true);
                    Refresher.access$100(this.this$1).remove(this.val$waitingLabel);
                    Refresher.access$100(this.this$1).add("Center", DSEntryPanel.access$000(Refresher.access$100(this.this$1)));
                    Refresher.access$100(this.this$1).validate();
                    Refresher.access$100(this.this$1).repaint();
                }
            });
        }

        static /* synthetic */ DSEntryPanel access$100(Refresher refresher) {
            return refresher.DSEntryPanel.this;
        }
    }
}

