/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.certsrv.config;

import com.netscape.admin.certsrv.CMSAdminUtil;
import com.netscape.admin.certsrv.CMSBasePanel;
import com.netscape.admin.certsrv.CMSBaseResourceModel;
import com.netscape.admin.certsrv.EAdminException;
import com.netscape.admin.certsrv.LabelCellRenderer;
import com.netscape.admin.certsrv.PasswordCellRenderer;
import com.netscape.admin.certsrv.config.PolicyConfigDialog;
import com.netscape.admin.certsrv.config.PolicyPluginSelectionDialog;
import com.netscape.admin.certsrv.config.PolicyRuleDataModel;
import com.netscape.admin.certsrv.config.PolicyRuleOrderDialog;
import com.netscape.admin.certsrv.connection.AdminConnection;
import com.netscape.admin.certsrv.ug.CMSBaseUGTab;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import com.sun.java.swing.DefaultCellEditor;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JPasswordField;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.table.TableCellEditor;
import com.sun.java.swing.table.TableCellRenderer;
import com.sun.java.swing.table.TableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class PolicyInstanceTab
extends CMSBaseUGTab {
    private static final String PANEL_NAME = "POLICYRULE";
    private static final String RULE_NAME = "RULENAME";
    private static final String RULE_STAT = "STATUS";
    private AdminConnection mConnection;
    protected JScrollPane mScrollPane;
    protected JTable mTable;
    protected PolicyRuleDataModel mDataModel;
    protected String mDestination;
    protected JButton mRefresh;
    protected JButton mEdit;
    protected JButton mAdd;
    protected JButton mDelete;
    protected JButton mOrder;
    protected JButton mHelp;
    private static final String RAHELPINDEX = "configuration-ra-policyrules-help";
    private static final String CAHELPINDEX = "configuration-ca-policyrules-help";
    private static final String KRAHELPINDEX = "configuration-kra-policyrules-help";

    public PolicyInstanceTab(CMSBaseResourceModel model, String dest) {
        super(PANEL_NAME, model);
        this.mConnection = model.getServerInfo().getAdmin();
        this.mDataModel = new PolicyRuleDataModel();
        this.mDestination = dest;
        this.mHelpToken = this.mDestination.equals("rapolicy") ? RAHELPINDEX : (this.mDestination.equals("krapolicy") ? KRAHELPINDEX : CAHELPINDEX);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.mRefresh)) {
            Debug.println((String)"Refresh");
            this.refresh();
        }
        if (e.getSource().equals(this.mEdit)) {
            NameValuePairs response;
            if (this.mTable.getSelectedRow() < 0) {
                return;
            }
            NameValuePairs data = (NameValuePairs)this.mDataModel.getObjectValueAt(this.mTable.getSelectedRow());
            this.mModel.progressStart();
            try {
                response = this.getConfig();
            }
            catch (EAdminException ex1) {
                this.showErrorDialog(ex1.getMessage());
                this.mModel.progressStop();
                return;
            }
            this.mModel.progressStop();
            Debug.println((String)response.toString());
            PolicyConfigDialog dialog = new PolicyConfigDialog(this.mModel.getFrame(), this.mDestination);
            dialog.showDialog(response, data.getValue(RULE_NAME));
            if (!dialog.isOK()) {
                return;
            }
            response = dialog.getData();
            Debug.println((String)("Return Value :" + response.toString()));
            this.mModel.progressStart();
            try {
                this.modifyPolicyRule(response, data.getValue(RULE_NAME));
            }
            catch (EAdminException ex2) {
                this.showErrorDialog(ex2.toString());
                this.mModel.progressStop();
                return;
            }
            this.mModel.progressStop();
            this.refresh();
        }
        if (e.getSource().equals(this.mAdd)) {
            Debug.println((String)"Add");
            PolicyPluginSelectionDialog dialog = new PolicyPluginSelectionDialog(this.mModel.getFrame(), this.mConnection, this.mDestination);
            dialog.showDialog();
            this.refresh();
        }
        if (e.getSource().equals(this.mDelete)) {
            Debug.println((String)"Delete");
            if (this.mTable.getSelectedRow() < 0) {
                return;
            }
            int i = this.showConfirmDialog("DELETE");
            if (i == 0) {
                this.delete();
                Debug.println((String)"Deleted");
            }
        }
        if (e.getSource().equals(this.mOrder)) {
            Debug.println((String)"Order");
            PolicyRuleOrderDialog dialog = new PolicyRuleOrderDialog(this.mModel.getFrame(), this.mConnection, this.mDestination);
            dialog.showDialog(this.mDataModel.getRules());
            this.refresh();
        }
        if (e.getSource().equals(this.mHelp)) {
            this.helpCallback();
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.setButtons();
    }

    public void mouseReleased(MouseEvent e) {
        this.setButtons();
    }

    public void refresh() {
        this.mDataModel.removeAllRows();
        this.update();
        this.setButtons();
    }

    protected JPanel createUserButtonPanel() {
        this.mOrder = this.makeJButton("ORDER");
        this.mEdit = this.makeJButton("EDIT");
        this.mAdd = this.makeJButton("ADD");
        this.mDelete = this.makeJButton("DELETE");
        JButton[] buttons = new JButton[]{this.mAdd, this.mDelete, this.mEdit, this.mOrder};
        JButtonFactory.resize((JButton[])buttons);
        return CMSAdminUtil.makeJButtonVPanel((JButton[])buttons);
    }

    protected JPanel createActionPanel() {
        this.mRefresh = this.makeJButton("REFRESH");
        this.mHelp = this.makeJButton("HELP");
        JButton[] buttons = new JButton[]{this.mRefresh, this.mHelp};
        return CMSBasePanel.makeJButtonPanel((JButton[])buttons, (boolean)true);
    }

    protected JPanel createListPanel() {
        this.mListPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.mListPanel.setLayout(gb);
        this.mTable = new JTable((TableModel)this.mDataModel);
        this.mScrollPane = JTable.createScrollPaneForTable((JTable)this.mTable);
        this.mScrollPane.setHorizontalScrollBarPolicy(31);
        this.mScrollPane.setVerticalScrollBarPolicy(22);
        this.mTable.setAutoscrolls(true);
        this.mTable.sizeColumnsToFit(true);
        this.mTable.getSelectionModel().setSelectionMode(0);
        this.mTable.getSelectionModel().addListSelectionListener((ListSelectionListener)this);
        this.mScrollPane.setBackground(Color.white);
        this.mTable.addMouseListener((MouseListener)((Object)this));
        this.setLabelCellRenderer(this.mTable, 0);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = CMSBasePanel.EMPTY_INSETS;
        gbc.fill = 1;
        gb.setConstraints((Component)this.mScrollPane, gbc);
        this.mListPanel.add((Component)this.mScrollPane);
        JPanel buttonPanel = this.createUserButtonPanel();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = CMSBasePanel.EMPTY_INSETS;
        gb.setConstraints((Component)buttonPanel, gbc);
        this.mListPanel.add((Component)buttonPanel);
        this.refresh();
        return this.mListPanel;
    }

    protected void setLabelCellRenderer(JTable table, int index) {
        table.getColumnModel().getColumn(index).setCellRenderer((TableCellRenderer)new LabelCellRenderer(new JLabel()));
    }

    protected void setLabelCellEditor(JTable table, int index) {
        table.getColumnModel().getColumn(index).setCellRenderer((TableCellRenderer)new PasswordCellRenderer());
        table.getColumnModel().getColumn(index).setCellEditor((TableCellEditor)new DefaultCellEditor((JTextField)new JPasswordField()));
    }

    private void setButtons() {
        if (this.mTable.getSelectionModel().isSelectionEmpty()) {
            this.mDelete.setEnabled(false);
            this.mEdit.setEnabled(false);
            return;
        }
        if (this.mDataModel.getRowCount() <= 0) {
            this.mDelete.setEnabled(false);
            this.mOrder.setEnabled(false);
            this.mEdit.setEnabled(false);
            return;
        }
        this.mDelete.setEnabled(true);
        this.mOrder.setEnabled(true);
        this.mEdit.setEnabled(true);
    }

    private void update() {
        NameValuePairs response;
        try {
            response = this.mConnection.search(this.mDestination, "rules", new NameValuePairs());
        }
        catch (EAdminException e) {
            this.showErrorDialog(e.getMessage());
            this.mModel.progressStop();
            return;
        }
        Debug.println((String)response.toString());
        Enumeration e = response.getNames();
        String entry = ((String)e.nextElement()).trim();
        Debug.println((String)("PolicyInstanceTab: update()- " + entry));
        StringTokenizer tokenizer = new StringTokenizer(entry, ",");
        while (tokenizer.hasMoreTokens()) {
            String nvp = tokenizer.nextToken().trim();
            int i = nvp.lastIndexOf("-");
            if (i == -1) continue;
            NameValuePairs data = new NameValuePairs();
            data.add(RULE_NAME, nvp.substring(0, i));
            data.add(RULE_STAT, nvp.substring(i + 1));
            this.mDataModel.processData((Object)data);
        }
        if (this.mDataModel.getRowCount() > 0) {
            this.mTable.setRowSelectionInterval(0, 0);
        }
        this.mTable.invalidate();
        this.mTable.validate();
        this.mTable.repaint(1L);
        this.mModel.progressStop();
    }

    private void delete() {
        this.mModel.progressStart();
        NameValuePairs data = (NameValuePairs)this.mDataModel.getObjectValueAt(this.mTable.getSelectedRow());
        try {
            this.mConnection.delete(this.mDestination, "rules", data.getValue(RULE_NAME));
        }
        catch (EAdminException e) {
            this.showErrorDialog(e.getMessage());
            this.mModel.progressStop();
            return;
        }
        this.mModel.progressStop();
        this.refresh();
    }

    private NameValuePairs getConfig() throws EAdminException {
        NameValuePairs data = (NameValuePairs)this.mDataModel.getObjectValueAt(this.mTable.getSelectedRow());
        NameValuePairs response = this.mConnection.read(this.mDestination, "rules", data.getValue(RULE_NAME), new NameValuePairs());
        return response;
    }

    private void modifyPolicyRule(NameValuePairs config, String name) throws EAdminException {
        this.mConnection.modify(this.mDestination, "rules", name, config);
    }
}

