/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.certsrv.ug;

import com.netscape.admin.certsrv.CMSAdminUtil;
import com.netscape.admin.certsrv.CMSTableModel;
import com.netscape.admin.certsrv.EAdminException;
import com.netscape.admin.certsrv.LabelCellRenderer;
import com.netscape.admin.certsrv.connection.AdminConnection;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.management.client.util.JButtonFactory;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.table.TableCellRenderer;
import com.sun.java.swing.table.TableModel;
import com.sun.java.swing.text.JTextComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class AuthBaseDialog
extends JDialog
implements ActionListener {
    protected JFrame mParentFrame;
    protected ResourceBundle mResource;
    protected CMSTableModel mDataModel;
    protected NameValuePairs mData;
    protected JScrollPane mScrollPane;
    protected JTable mTable;
    protected String mRuleName;
    protected String mPrefix;
    protected String mType;
    protected JButton mOK;
    protected JButton mCancel;
    protected JButton mHelp;
    protected JTextField mAuthName;
    protected JLabel mImplName;
    protected JLabel mAuthLabel;
    protected AdminConnection mConn;
    static /* synthetic */ Class class$com$netscape$admin$certsrv$CMSAdminResources;

    public AuthBaseDialog(JFrame parent, String type, String prefix) {
        super((Frame)parent, true);
        this.mParentFrame = parent;
        this.mPrefix = prefix;
        this.mType = type;
        this.mResource = ResourceBundle.getBundle((class$com$netscape$admin$certsrv$CMSAdminResources != null ? class$com$netscape$admin$certsrv$CMSAdminResources : (class$com$netscape$admin$certsrv$CMSAdminResources = AuthBaseDialog.class$("com.netscape.admin.certsrv.CMSAdminResources"))).getName());
        ((Component)((Object)this)).setSize(360, 316);
        ((Dialog)((Object)this)).setTitle(this.mResource.getString(String.valueOf(this.mPrefix) + "_TITLE"));
        this.setLocationRelativeTo((Component)parent);
        this.getRootPane().setDoubleBuffered(true);
    }

    public void showDialog(NameValuePairs data, String name, boolean pinDirExist, boolean userDirExist) {
        this.mDataModel.removeAllRows();
        this.mData = data;
        this.mImplName.setText(data.getValue("implName"));
        Enumeration e = data.getNames();
        while (e.hasMoreElements()) {
            String entry = ((String)e.nextElement()).trim();
            if (entry.equals("implName")) continue;
            String value = data.getValue(entry);
            Vector<String> v = new Vector<String>();
            v.addElement(entry);
            v.addElement(value);
            this.mDataModel.addRow(v);
        }
        if (name == null || name.equals("")) {
            this.mAuthName.setVisible(true);
            this.mAuthName.setText("");
            this.mAuthLabel.setVisible(false);
            String str = this.mImplName.getText().trim();
            if (!pinDirExist && str.equals("UidPwdPinDirAuth")) {
                this.mAuthName.setText("PinDirEnrollment");
            } else if (!userDirExist && str.equals("UidPwdDirAuth")) {
                this.mAuthName.setText("UserDirEnrollment");
            }
        } else {
            this.mRuleName = name;
            this.mAuthName.setVisible(false);
            this.mAuthLabel.setVisible(true);
            this.mAuthLabel.setText(name);
        }
        ((Dialog)((Object)this)).show();
    }

    protected NameValuePairs getData() {
        NameValuePairs response = new NameValuePairs();
        response.add("implName", this.mImplName.getText());
        int i = 0;
        while (i < this.mDataModel.getRowCount()) {
            response.add((String)this.mDataModel.getValueAt(i, 0), (String)this.mDataModel.getValueAt(i, 1));
            ++i;
        }
        return response;
    }

    protected String getRuleName() {
        return this.mRuleName;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this.mOK)) {
            Component component;
            if (this.mAuthName.isVisible()) {
                this.mRuleName = this.mAuthName.getText();
                if (this.mRuleName.trim().equals("")) {
                    CMSAdminUtil.showErrorDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)this.mResource.getString(String.valueOf(this.mPrefix) + "_DIALOG_NORULENAME_MESSAGE"), (int)0);
                    return;
                }
            }
            if ((component = this.mTable.getEditorComponent()) != null) {
                int col = this.mTable.getEditingColumn();
                int row = this.mTable.getEditingRow();
                if (col > -1 && row > -1) {
                    String str = ((JTextComponent)component).getText();
                    this.mTable.setValueAt((Object)str, row, col);
                }
            }
            try {
                if (this.mAuthName.isVisible()) {
                    this.addPolicyRule(this.getData(), this.getRuleName());
                } else {
                    this.modifyPolicyRule(this.getData(), this.getRuleName());
                }
            }
            catch (EAdminException e) {
                CMSAdminUtil.showErrorDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)e.toString(), (int)0);
                return;
            }
        }
        if (evt.getSource().equals(this.mOK) || evt.getSource().equals(this.mCancel)) {
            ((Window)((Object)this)).dispose();
        }
    }

    protected void setDisplay() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel center = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        center.setLayout(gb);
        JPanel content = this.makeContentPane();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gb.setConstraints((Component)content, gbc);
        center.add((Component)content);
        JPanel action = this.makeActionPane();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gb.setConstraints((Component)action, gbc);
        center.add((Component)action);
        this.getContentPane().add("Center", (Component)center);
    }

    private JPanel makeActionPane() {
        this.mOK = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.mPrefix, (String)"OK", null, (ActionListener)this);
        if (this.mType.equals("view")) {
            this.mOK.setEnabled(false);
        } else {
            this.mOK.setEnabled(true);
        }
        this.mCancel = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.mPrefix, (String)"CANCEL", null, (ActionListener)this);
        this.mHelp = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.mPrefix, (String)"HELP", null, (ActionListener)this);
        JButton[] buttons = new JButton[]{this.mOK, this.mCancel, this.mHelp};
        JButtonFactory.resize((JButton[])buttons);
        return CMSAdminUtil.makeJButtonPanel((JButton[])buttons, (boolean)true);
    }

    private JPanel makeContentPane() {
        JPanel mListPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        mListPanel.setLayout(gb);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        JLabel label1 = CMSAdminUtil.makeJLabel((ResourceBundle)this.mResource, (String)this.mPrefix, (String)"RULENAME", null);
        this.mAuthLabel = new JLabel();
        this.mAuthLabel.setVisible(false);
        this.mAuthName = new JTextField();
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        gbc.insets = new Insets(6, 6, 0, 0);
        mListPanel.add((Component)label1, gbc);
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(6, 6, 0, 6);
        mListPanel.add((Component)this.mAuthLabel, gbc);
        mListPanel.add((Component)this.mAuthName, gbc);
        JLabel dummy = new JLabel();
        dummy.setVisible(false);
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        mListPanel.add((Component)dummy, gbc);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        JLabel label3 = CMSAdminUtil.makeJLabel((ResourceBundle)this.mResource, (String)this.mPrefix, (String)"IMPLNAME", null);
        this.mImplName = new JLabel();
        CMSAdminUtil.addEntryField((JPanel)mListPanel, (JComponent)label3, (JComponent)this.mImplName, (GridBagConstraints)gbc);
        this.mTable = new JTable((TableModel)this.mDataModel);
        this.mScrollPane = JTable.createScrollPaneForTable((JTable)this.mTable);
        this.mScrollPane.setHorizontalScrollBarPolicy(31);
        this.mScrollPane.setVerticalScrollBarPolicy(22);
        this.mTable.setAutoscrolls(true);
        this.mTable.sizeColumnsToFit(true);
        this.mTable.getSelectionModel().setSelectionMode(1);
        this.mScrollPane.setBackground(Color.white);
        this.setLabelCellRenderer(this.mTable, 0);
        this.setLabelCellRenderer(this.mTable, 1);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gb.setConstraints((Component)this.mScrollPane, gbc);
        mListPanel.add((Component)this.mScrollPane);
        return mListPanel;
    }

    protected void setLabelCellRenderer(JTable table, int index) {
        JLabel label = new JLabel();
        if (this.mType.equals("view")) {
            label.setEnabled(false);
            table.getColumnModel().getColumn(index).setCellRenderer((TableCellRenderer)new CustomLabelCellRenderer(label));
        } else {
            label.setEnabled(true);
            table.getColumnModel().getColumn(index).setCellRenderer((TableCellRenderer)new LabelCellRenderer(label));
        }
    }

    protected void addPolicyRule(NameValuePairs config, String name) throws EAdminException {
        this.mConn.add("auths", "instance", name, config);
    }

    protected void modifyPolicyRule(NameValuePairs config, String name) throws EAdminException {
        this.mConn.modify("auths", "instance", name, config);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public class CustomLabelCellRenderer
    extends LabelCellRenderer {
        public CustomLabelCellRenderer(JLabel x) {
            super(x);
            AuthBaseDialog.this = AuthBaseDialog.this;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                value = table.getModel().getValueAt(row, column);
            }
            this.value.setValue(value);
            this.component.setBackground(LabelCellRenderer.WHITECOLOR);
            this.component.setForeground(LabelCellRenderer.WHITECOLOR);
            return this.component;
        }
    }
}

