/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.IContextProperties;
import com.iplanet.server.http.servlet.NSRequestDispatcher;
import com.iplanet.server.http.servlet.NSServletConfig;
import com.iplanet.server.http.servlet.NSServletLoader;
import com.iplanet.server.http.servlet.NSServletRunner;
import com.iplanet.server.http.servlet.WServletContext;
import com.iplanet.server.http.session.IWSHttpSessionManager;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class NSServletContext
extends WServletContext {
    private NSServletRunner _runner;
    private Hashtable _attrs = null;
    private String _docRoot = null;
    private IWSHttpSessionManager _sessionMgr = null;
    private String _name;
    private IContextProperties _ce;
    private Properties _initArgs;
    private NSServletLoader _classLoader = null;
    private static ResUtil _res = ResUtil.getDefaultResUtil();

    public NSServletContext(String string, NSServletRunner nSServletRunner, IWSHttpSessionManager iWSHttpSessionManager, IContextProperties iContextProperties) {
        this._name = string;
        this._runner = nSServletRunner;
        this._sessionMgr = iWSHttpSessionManager;
        this._ce = iContextProperties;
        this._initArgs = iContextProperties.getInitArgs();
        this._attrs = new Hashtable();
        this._attrs.put("javax.servlet.context.tempdir", new File(iContextProperties.getTempDir()));
    }

    public void destroyServlet(String string) {
    }

    public Object getAttribute(String string) {
        if (string == null) {
            return null;
        }
        return this._attrs.get(string);
    }

    public Enumeration getAttributeNames() {
        return this._attrs.keys();
    }

    public String getAuthDB() {
        return this._ce.getAuthDB();
    }

    NSServletLoader getClassLoader() {
        return this._classLoader;
    }

    public ServletContext getContext(String string) {
        String string2 = string;
        while (string2 != null && string2.length() > 0) {
            if (this._runner.getServletByScriptName(string2, this._ce.getHost(), this._ce.getIPAddress()) != null) {
                return this;
            }
            int n = string2.lastIndexOf(47);
            if (n <= 0) break;
            string2 = string2.substring(0, n);
        }
        return null;
    }

    public String getContextPath() {
        return "";
    }

    IContextProperties getContextProperties() {
        return this._ce;
    }

    String getDocRoot() {
        return this._docRoot;
    }

    public String getFormEncodingHint() {
        return this._ce.getFormEncodingHint();
    }

    public IWSHttpSessionManager getHttpSessionManager() {
        return this._sessionMgr;
    }

    public String getInitParameter(String string) {
        return (String)((Hashtable)this._initArgs).get(string);
    }

    public Enumeration getInitParameterNames() {
        return ((Hashtable)this._initArgs).keys();
    }

    public int getMajorVersion() {
        return 2;
    }

    public String getMimeType(String string) {
        return this._runner.getNSServletServer().getMimeType(string);
    }

    public int getMinorVersion() {
        return 1;
    }

    String getName() {
        return this._name;
    }

    public RequestDispatcher getNamedDispatcher(String string) {
        String string2 = this._runner.getURIByName(string);
        if (string2 != null) {
            return new NSRequestDispatcher(string2, this);
        }
        return null;
    }

    public String getParameterEncoding() {
        return this._ce.getParameterEncoding();
    }

    public String getRealPath() {
        return this.getDocRoot();
    }

    public String getRealPath(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            string = this._ce.getBaseURI();
        } else if (string.charAt(0) != '/') {
            string = String.valueOf(this._ce.getBaseURI()) + string;
        }
        return this._runner.getNSServletServer().getRealPath(string);
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (string == null || string.length() == 0 || string.charAt(0) != '/') {
            throw new IllegalArgumentException(_res.getProp("servlet.NSServletContext.msg_illegalArgumentException"));
        }
        return new NSRequestDispatcher(string, this);
    }

    public URL getResource(String string) throws MalformedURLException {
        if (string == null || string.length() == 0 || string.charAt(0) != '/') {
            throw new MalformedURLException(_res.getProp("servlet.NSServletContext.msg_malformedURLException"));
        }
        String string2 = this.getRealPath(string);
        if (string2 != null) {
            URL uRL = new URL("file", null, string2);
            return uRL;
        }
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = null;
        try {
            uRL = this.getResource(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        if (uRL != null) {
            try {
                return uRL.openStream();
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public int getResponseBufferSize() {
        return this._ce.getBufferSize();
    }

    public int getResponseCookieVersion() {
        return this._ce.getRespondCookieVersion();
    }

    public int getResponseFlushTimeout() {
        return this._ce.getOutputStreamFlushTimer();
    }

    NSServletRunner getRunner() {
        return this._runner;
    }

    public String getServerInfo() {
        return this._runner.getNSServletServer().getServerInfo();
    }

    public String getServerName() {
        return this._ce.getServerName();
    }

    public Servlet getServlet(String string) throws ServletException {
        return null;
    }

    public NSServletConfig getServletConfig(String string) {
        return this._runner.getServletConfig(string);
    }

    public Enumeration getServletNames() {
        return new Vector().elements();
    }

    public Enumeration getServlets() {
        return new Vector().elements();
    }

    public String getSessionCookieName() {
        return this._ce.getSessionCookie();
    }

    public boolean getSessionExpireOnClose() {
        return this._ce.getSessionExpireOnClose();
    }

    public void log(Exception exception, String string) {
        this.log(string, exception);
    }

    public void log(String string) {
        LogUtil.logInfo((String)string);
    }

    public void log(String string, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        LogUtil.logInfo((String)string);
        LogUtil.logInfo((String)stringWriter.toString());
    }

    public void removeAttribute(String string) {
        if (string != null) {
            this._attrs.remove(string);
        }
    }

    public void setAttribute(String string, Object object) {
        if (string != null) {
            this._attrs.put(string, object);
        }
    }

    void setClassLoader(NSServletLoader nSServletLoader) {
        this._classLoader = nSServletLoader;
    }

    void setDocRoot(String string) {
        this._docRoot = string;
    }

    public boolean shouldEncodeCookies() {
        return this._ce.isCookieEncoding();
    }

    public String toString() {
        return "<-context>";
    }
}

