/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.NSHttpServletRequest;
import com.iplanet.server.http.servlet.NSHttpServletResponse;
import com.iplanet.server.http.servlet.NSServletSession;
import com.iplanet.server.http.servlet.NSServletWrapper;
import com.iplanet.server.http.servlet.WServletContext;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;

public abstract class WRequestDispatcher
implements RequestDispatcher {
    private static ResUtil _res = ResUtil.getDefaultResUtil();
    protected WServletContext _context;
    protected int saveStatusCode;
    protected String saveStatusMessage;
    protected String saveQuery;
    protected WServletContext saveContext;
    protected int saveType;
    protected NSServletWrapper saveWrapper;
    protected boolean saveRespIncludeMode;

    public WRequestDispatcher(WServletContext wServletContext) {
        this._context = wServletContext;
    }

    NSServletSession checkNativeSession(int n, NSHttpServletRequest nSHttpServletRequest) throws IllegalStateException {
        NSServletSession nSServletSession = nSHttpServletRequest.getNSServletSession();
        if (n == 2 && nSServletSession.ostream_wasFlushed()) {
            throw new IllegalStateException();
        }
        return nSServletSession;
    }

    public abstract void forward(ServletRequest var1, ServletResponse var2) throws ServletException, IOException;

    NSHttpServletRequest getHttpServletRequest(int n, ServletRequest servletRequest) throws ServletException {
        NSHttpServletRequest nSHttpServletRequest;
        ServletRequest servletRequest2 = servletRequest;
        if (servletRequest instanceof ServletRequestWrapper) {
            servletRequest2 = ((ServletRequestWrapper)servletRequest).getRequest();
        }
        try {
            nSHttpServletRequest = (NSHttpServletRequest)servletRequest2;
        }
        catch (ClassCastException classCastException) {
            LogUtil.logWarning((String)_res.getProp("servlet.WRequestDispatcher.msg_invalidReqClass"));
            throw new ServletException(_res.getProp("servlet.WRequestDispatcher.msg_invalidReqClass"));
        }
        if (!nSHttpServletRequest.checkRecursionDepth()) {
            String string = n == 2 ? _res.getProp("servlet.WRequestDispatcher.msg_tooManyNestedDispatchesForward") : _res.getProp("servlet.WRequestDispatcher.msg_tooManyNestedDispatchesInclude");
            LogUtil.logWarning((String)string);
            throw new ServletException(string);
        }
        return nSHttpServletRequest;
    }

    NSHttpServletResponse getHttpServletResponse(ServletResponse servletResponse) throws ServletException {
        NSHttpServletResponse nSHttpServletResponse;
        ServletResponse servletResponse2 = servletResponse;
        if (servletResponse instanceof ServletResponseWrapper) {
            servletResponse2 = ((ServletResponseWrapper)servletResponse).getResponse();
        }
        try {
            nSHttpServletResponse = (NSHttpServletResponse)servletResponse2;
        }
        catch (ClassCastException classCastException) {
            LogUtil.logWarning((String)_res.getProp("servlet.NSRequestDispatcher.msg_invalidResClass"));
            throw new ServletException(_res.getProp("servlet.NSRequestDispatcher.msg_invalidResClass"));
        }
        return nSHttpServletResponse;
    }

    void handleIncludeForwardException(NSHttpServletRequest nSHttpServletRequest) throws IOException, ServletException {
        Exception exception = nSHttpServletRequest.getStoredException();
        if (exception != null) {
            nSHttpServletRequest.setStoredException(null);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ServletException) {
                throw (ServletException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
        }
    }

    public abstract void include(ServletRequest var1, ServletResponse var2) throws ServletException, IOException;

    void prepareDispatch(int n, NSHttpServletRequest nSHttpServletRequest, NSHttpServletResponse nSHttpServletResponse) {
        nSHttpServletRequest.incrnestCounter();
        this.saveQuery = nSHttpServletRequest.getAggregatedQueryString();
        this.saveContext = nSHttpServletRequest.getWServletContext();
        nSHttpServletRequest.setWServletContext(this._context);
        this.saveType = nSHttpServletRequest.getRequestType();
        nSHttpServletRequest.setRequestType(n);
        this.saveWrapper = nSHttpServletRequest.getServletWrapper();
        if (n == 1) {
            this.saveRespIncludeMode = nSHttpServletResponse.getIncludeFlag();
            nSHttpServletResponse.setIncludeFlag(true);
        }
    }

    void restoreDispatchState(int n, NSHttpServletRequest nSHttpServletRequest, NSHttpServletResponse nSHttpServletResponse) {
        nSHttpServletRequest.decrnestCounter();
        nSHttpServletRequest.setAggregatedQueryString(this.saveQuery);
        nSHttpServletRequest.setWServletContext(this.saveContext);
        nSHttpServletRequest.setRequestType(this.saveType);
        nSHttpServletRequest.setServletWrapper(this.saveWrapper);
        if (n == 1) {
            nSHttpServletResponse.setIncludeFlag(this.saveRespIncludeMode);
        }
    }

    void restoreNativeSessionStatus(NSServletSession nSServletSession) {
        nSServletSession.setResponseStatus(this.saveStatusCode, this.saveStatusMessage);
    }

    void saveNativeSessionStatus(NSServletSession nSServletSession) {
        this.saveStatusCode = nSServletSession.getResponseStatus();
        this.saveStatusMessage = nSServletSession.getResponseMessage();
    }
}

