/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.FormAuthenticator;
import com.iplanet.server.http.servlet.NSHttpServletRequest;
import com.iplanet.server.http.servlet.NSHttpServletResponse;
import com.iplanet.server.http.servlet.NSRequestDispatcher;
import com.iplanet.server.http.servlet.NSServletConfig;
import com.iplanet.server.http.servlet.NSServletLoader;
import com.iplanet.server.http.servlet.NSServletRunner;
import com.iplanet.server.http.servlet.NSServletSession;
import com.iplanet.server.http.servlet.NSServletWrapper;
import com.iplanet.server.http.servlet.VirtualServer;
import com.iplanet.server.http.servlet.WFilterChain;
import com.iplanet.server.http.servlet.WFilterDef;
import com.iplanet.server.http.servlet.WFilterMap;
import com.iplanet.server.http.servlet.WNamedDispatcher;
import com.iplanet.server.http.servlet.WSAXErrorHandler;
import com.iplanet.server.http.servlet.WServletConfig;
import com.iplanet.server.http.servlet.WServletContext;
import com.iplanet.server.http.servlet.WServletEntity;
import com.iplanet.server.http.servlet.WebAppConfig;
import com.iplanet.server.http.servlet.WrapperFilter;
import com.iplanet.server.http.session.IWSHttpSessionManager;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import com.iplanet.server.http.util.SlashUtil;
import com.iplanet.server.http.util.XmlConfig;
import com.iplanet.server.http.util.XmlNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.xml.sax.ErrorHandler;

public class WebApplication
extends WServletContext {
    public static final String JSP_SERVLET_NAME = "jsp";
    public static final String JSP_SERVLET_CLASS = "org.apache.jasper.servlet.JspServlet";
    public static final String JSP_SERVLET_OUTPUT_DIR = "scratchdir";
    public static final String JSP_URL_PATTERN = "*.jsp";
    public static final String SERVLET_CLASSPATH = "com.iplanet.server.http.servlet.classpath";
    public static final String SERVLET_CLASSRELOAD_INTERVAL = "com.iplanet.server.http.servlet.reload-interval";
    public static final String DEF_FILTER_NAME = "iws-wrapper-filter";
    public static final String DEF_FILTER_CLASS = "com.iplanet.server.http.servlet.WrapperFilter";
    public static final String DEF_PARAM_ENCODING = "auto";
    public static final String DEF_FORM_HINT_FIELD = "j_encoding";
    public static final String DEF_AUTH_REALM = "iWS Web Container";
    public static final String FORMAUTH_SERVLET_NAME = "iWSFormAuthServlet";
    public static final String WEBXML_PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
    public static final String WEBXML_DTD_RESOURCE = "/com/iplanet/server/http/web-app_2_2.dtd";
    private static ResUtil _res = ResUtil.getDefaultResUtil();
    private VirtualServer vs;
    private NSServletRunner runner;
    private String contextPath;
    private String appDir;
    private String webXml;
    private XmlNode vsAppConf;
    private XmlNode appConfig;
    private XmlConfig webXmlConf;
    private Hashtable servletsByName;
    private Hashtable servletInstances;
    private int servletCount;
    HashMap filtersByName;
    ArrayList urlFilterMaps;
    ArrayList servletFilterMaps;
    WFilterDef appFilterDef;
    private Hashtable contextAttrs;
    private HashMap initParams;
    private boolean initDone = false;
    private ClassLoader parentClassLoader;
    private NSServletLoader servletLoader;
    IWSHttpSessionManager sm;
    HashMap exceptionMap;
    String authMethod;
    String authRealm;
    String authDB;
    boolean requireFormLogin;
    FormAuthenticator formAuth;
    int roleMapping = 2;
    private int classReloadInterval;
    private long lastClassUpdateCheckTime;
    private boolean isTerminated;
    private int responseCookieVersion = 0;
    private int responseBufferSize = 8192;
    private int responseFlushTimeout = 0;
    private String paramEncoding = "auto";
    private String formHintField = "j_encoding";
    private boolean inputStreamLengthCheck = true;
    private boolean bTimeoutConfigured = false;
    private int snTimeout = 0;
    private boolean useSessionCookies = true;
    private boolean useSessionUrlRewriting = true;
    private boolean encodeCookies = true;
    private int errorCount = 0;
    private int exceptionCount = 0;
    private boolean isDefaultApp = false;
    private boolean isImplicitDefaultApp = false;
    private String jspOutputDir;
    private String sessionCookieDomain;
    private boolean sessionCookieIsSecure;
    private String sessionCookiePath;

    public WebApplication(NSServletRunner nSServletRunner, VirtualServer virtualServer, String string, String string2) {
        this.runner = nSServletRunner;
        this.vs = virtualServer;
        this.contextPath = string;
        this.appDir = string2;
        this.initParams = new HashMap();
        this.contextAttrs = new Hashtable();
        this.exceptionMap = new HashMap();
        this.webXml = SlashUtil.resolveNativePath((String)string2, (String)"WEB-INF/web.xml");
        if (string.length() == 0) {
            this.isDefaultApp = true;
        }
    }

    private void addJspServlet() {
        XmlNode xmlNode = this.appConfig.findConfig("jsp-servlet");
        if (xmlNode == null) {
            xmlNode = this.vs.getConfig().findConfig("/vs/jsp-servlet");
        }
        if (xmlNode == null || xmlNode.getBoolean("enable", true)) {
            String string = JSP_SERVLET_NAME;
            String string2 = JSP_SERVLET_CLASS;
            try {
                WServletEntity wServletEntity = this.addServlet(string, string2, xmlNode);
                this.vs.addServletMap(this.contextPath, JSP_URL_PATTERN, string);
                if (wServletEntity.getServletConfig().getInitParameter(JSP_SERVLET_OUTPUT_DIR) == null) {
                    wServletEntity.getServletConfig().setInitParameter(JSP_SERVLET_OUTPUT_DIR, this.getJspOutputDir());
                }
            }
            catch (ServletException servletException) {
                LogUtil.logFailure((String)this.vs.getVSId(), (String)(String.valueOf(_res.getProp("servlet.WebApplication.msg_cannotAddJspServlet")) + string + "(" + string2 + "):\n" + LogUtil.getStackTrace((Throwable)servletException)));
            }
        } else {
            LogUtil.logVerbose((String)this.vs.getVSId(), (String)"JspServlet disabled");
        }
    }

    WServletEntity addServlet(String string, String string2) throws ServletException {
        return this.addServlet(string, string2, null);
    }

    WServletEntity addServlet(String string, String string2, XmlNode xmlNode) throws ServletException {
        WServletEntity wServletEntity;
        Hashtable hashtable = this.servletsByName;
        synchronized (hashtable) {
            wServletEntity = (WServletEntity)this.servletsByName.get(string);
            if (wServletEntity == null) {
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)5, (String)(" Adding servlet '" + string + "' class '" + string2 + "'"));
                }
                WServletConfig wServletConfig = new WServletConfig(this, string, string2, null, xmlNode);
                wServletEntity = new WServletEntity(this, wServletConfig);
                this.servletsByName.put(string, wServletEntity);
            }
        }
        return wServletEntity;
    }

    NSServletWrapper addServletWrapper(String string, NSServletWrapper nSServletWrapper) {
        this.servletInstances.put(string, nSServletWrapper);
        ++this.servletCount;
        return nSServletWrapper;
    }

    public void destroyServlet(String string) {
        if (string == null) {
            return;
        }
        NSServletWrapper nSServletWrapper = (NSServletWrapper)this.servletInstances.remove(string);
        if (nSServletWrapper != null) {
            nSServletWrapper.destroy();
        }
    }

    public XmlNode getAppConfig() {
        return this.appConfig;
    }

    public Object getAttribute(String string) {
        if (string == null) {
            return null;
        }
        return this.contextAttrs.get(string);
    }

    public Enumeration getAttributeNames() {
        return this.contextAttrs.keys();
    }

    public String getAuthDB() {
        return this.authDB;
    }

    public NSServletLoader getClassLoader() {
        return this.servletLoader;
    }

    public ServletContext getContext(String string) {
        if (string == null) {
            return null;
        }
        WebApplication webApplication = this.vs.getWebAppObject(string);
        if (webApplication != null) {
            return webApplication;
        }
        return this.vs.getDefaultContext();
    }

    public String getContextPath() {
        if (this.isDefaultApp) {
            return "/";
        }
        return this.contextPath;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getExceptionCount() {
        return this.exceptionCount;
    }

    public String getExceptionPage(String string) {
        String string2 = (String)this.exceptionMap.get(string);
        if (string2 != null) {
            string2 = String.valueOf(this.contextPath) + string2;
        }
        return string2;
    }

    private WFilterChain getFilterChain(String string, String string2, String string3, NSServletWrapper nSServletWrapper) throws Exception {
        WFilterDef wFilterDef;
        WFilterMap wFilterMap;
        int n;
        WFilterChain wFilterChain = null;
        WFilterChain wFilterChain2 = null;
        WFilterChain wFilterChain3 = null;
        int n2 = 0;
        if (this.urlFilterMaps != null) {
            n = 0;
            while (n < this.urlFilterMaps.size()) {
                wFilterMap = (WFilterMap)this.urlFilterMaps.get(n);
                if (this.matchFiltersURL(wFilterMap.getURLPattern(), string3)) {
                    if (LogUtil.enableTrace) {
                        LogUtil.TRACE((int)5, (String)("Filter " + wFilterMap.getFilterName() + " matches for servletPath  '" + string3));
                    }
                    if ((wFilterDef = (WFilterDef)this.filtersByName.get(wFilterMap.getFilterName())) == null) {
                        LogUtil.logWarning((String)this.vs.getVSId(), (String)_res.getProp("servlet.WebApplication.msg_cannotFindFilterForServletPath", (Object)wFilterMap.getFilterName(), (Object)string3));
                    } else {
                        wFilterChain2 = new WFilterChain(wFilterDef, this);
                        if (wFilterChain == null) {
                            wFilterChain = wFilterChain2;
                        }
                        if (wFilterChain3 != null) {
                            wFilterChain3.setNextChain(wFilterChain2);
                        }
                        wFilterChain3 = wFilterChain2;
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (this.servletFilterMaps != null) {
            n = 0;
            while (n < this.servletFilterMaps.size()) {
                wFilterMap = (WFilterMap)this.servletFilterMaps.get(n);
                if (wFilterMap.getServletName().equals(string2)) {
                    if (LogUtil.enableTrace) {
                        LogUtil.TRACE((int)5, (String)("Filter " + wFilterMap.getFilterName() + " matches for servlet  '" + string2));
                    }
                    if ((wFilterDef = (WFilterDef)this.filtersByName.get(wFilterMap.getFilterName())) == null) {
                        LogUtil.logWarning((String)this.vs.getVSId(), (String)_res.getProp("servlet.WebApplication.msg_cannotFindFilterForServletName", (Object)wFilterMap.getFilterName(), (Object)string2));
                    } else {
                        wFilterChain2 = new WFilterChain(wFilterDef, this);
                        if (wFilterChain == null) {
                            wFilterChain = wFilterChain2;
                        }
                        if (wFilterChain3 != null) {
                            wFilterChain3.setNextChain(wFilterChain2);
                        }
                        wFilterChain3 = wFilterChain2;
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)5, (String)("Matched " + n2 + " filters for uri = " + string + " servletName = " + string2));
        }
        wFilterChain2 = new WFilterChain(this.appFilterDef, this);
        WrapperFilter wrapperFilter = (WrapperFilter)wFilterChain2.getFilter();
        wrapperFilter.setServlet(nSServletWrapper);
        if (wFilterChain == null) {
            wFilterChain = wFilterChain2;
        }
        if (wFilterChain3 != null) {
            wFilterChain3.setNextChain(wFilterChain2);
        }
        wFilterChain3 = wFilterChain2;
        ++n2;
        return wFilterChain;
    }

    public String getFormEncodingHint() {
        return this.formHintField;
    }

    private String getHttpMethods(XmlNode xmlNode) throws ServletException {
        String string = null;
        Iterator iterator = xmlNode.iterate("http-method");
        while (iterator.hasNext()) {
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            String string2 = xmlNode2.getString();
            if (string2 == null) continue;
            string = string == null ? string2 : String.valueOf(string) + "," + string2;
        }
        return string;
    }

    public IWSHttpSessionManager getHttpSessionManager() {
        return this.sm;
    }

    public String getInitParameter(String string) {
        return (String)this.initParams.get(string);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this.initParams.keySet());
    }

    public String getJspOutputDir() {
        if (this.jspOutputDir != null) {
            return this.jspOutputDir;
        }
        this.jspOutputDir = SlashUtil.resolveNativePath((String)this.runner.getServletServer().getClassCacheDir(), (String)(String.valueOf(this.vs.getVSId()) + "/" + this.contextPath));
        return this.jspOutputDir;
    }

    public int getMajorVersion() {
        return 2;
    }

    public String getMimeType(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.vs.getMimeType(String.valueOf(this.contextPath) + '/' + string);
        return string2;
    }

    public int getMinorVersion() {
        return 2;
    }

    public RequestDispatcher getNamedDispatcher(String string) {
        WServletEntity wServletEntity = (WServletEntity)this.servletsByName.get(string);
        if (wServletEntity != null) {
            return new WNamedDispatcher(this.runner, this, wServletEntity);
        }
        return null;
    }

    public String getParameterEncoding() {
        return this.paramEncoding;
    }

    public String getRealPath() {
        return this.appDir;
    }

    public String getRealPath(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.isImplicitDefaultApp) {
            return this.vs.getRealPath(string);
        }
        String string2 = SlashUtil.resolveNativePath((String)this.appDir, (String)string);
        File file = new File(string2);
        if (file != null && file.exists()) {
            return string2;
        }
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)5, (String)("getRealPath: the path " + string2 + " doesn't exist."));
        }
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (string == null || string.length() == 0 || string.charAt(0) != '/') {
            throw new IllegalArgumentException(_res.getProp("servlet.WebApplication.msg_illegalArgumentException"));
        }
        String string2 = String.valueOf(this.contextPath) + string;
        return new NSRequestDispatcher(string2, this);
    }

    public URL getResource(String string) throws MalformedURLException {
        if (string == null || string.length() == 0 || string.charAt(0) != '/') {
            throw new MalformedURLException(_res.getProp("servlet.WebApplication.msg_malformedURLException"));
        }
        String string2 = this.getRealPath(string);
        if (string2 != null) {
            URL uRL = new URL("file", null, string2);
            return uRL;
        }
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = null;
        try {
            uRL = this.getResource(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        if (uRL != null) {
            try {
                return uRL.openStream();
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public int getResponseCookieVersion() {
        return this.responseCookieVersion;
    }

    public int getResponseFlushTimeout() {
        return this.responseFlushTimeout;
    }

    public int getRoleMapping() {
        return this.roleMapping;
    }

    private String getRoleNames(XmlNode xmlNode) throws ServletException {
        String string = xmlNode.getString("auth-constraint", null);
        Iterator iterator = xmlNode.iterate("role-name");
        while (iterator.hasNext()) {
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            String string2 = xmlNode2.getString();
            if (string2 == null) continue;
            string = string == null ? string2 : String.valueOf(string) + "," + string2;
        }
        return string;
    }

    public String getServerInfo() {
        return this.runner.getNSServletServer().getServerInfo();
    }

    public String getServerName() {
        return this.vs.getVSId();
    }

    public Servlet getServlet(String string) {
        return null;
    }

    public NSServletConfig getServletConfig(String string) {
        WServletEntity wServletEntity = (WServletEntity)this.servletsByName.get(string);
        if (wServletEntity != null) {
            return wServletEntity.getServletConfig();
        }
        return null;
    }

    public int getServletCount() {
        return this.servletCount;
    }

    public Enumeration getServletNames() {
        return new Vector().elements();
    }

    NSServletWrapper getServletWrapper(String string) {
        return (NSServletWrapper)this.servletInstances.get(string);
    }

    public Enumeration getServlets() {
        return new Vector().elements();
    }

    public String getSessionCookieDomain() {
        return this.sessionCookieDomain;
    }

    public boolean getSessionCookieIsSecure() {
        return this.sessionCookieIsSecure;
    }

    public String getSessionCookiePath() {
        return this.sessionCookiePath;
    }

    public int getSessionTimeout() {
        return this.snTimeout;
    }

    public VirtualServer getVS() {
        return this.vs;
    }

    public XmlNode getVSAppConfig() {
        return this.vsAppConf;
    }

    public XmlConfig getWebXmlConfig() {
        return this.webXmlConf;
    }

    public void incrementErrorCount() {
        ResUtil resUtil = _res;
        synchronized (resUtil) {
            ++this.errorCount;
        }
    }

    public void incrementExceptionCount() {
        ResUtil resUtil = _res;
        synchronized (resUtil) {
            ++this.exceptionCount;
        }
    }

    public void init() {
        Object object;
        if (this.initDone) {
            return;
        }
        this.servletInstances = new Hashtable();
        this.servletCount = 0;
        ArrayList<WServletEntity> arrayList = new ArrayList<WServletEntity>();
        Enumeration enumeration = this.servletsByName.elements();
        while (enumeration.hasMoreElements()) {
            WServletEntity wServletEntity = (WServletEntity)enumeration.nextElement();
            object = wServletEntity.getServletConfig();
            if (((WServletConfig)object).getLoadOnStartup() == Integer.MIN_VALUE) continue;
            int n = 0;
            while (n < arrayList.size()) {
                WServletEntity wServletEntity2 = (WServletEntity)arrayList.get(n);
                WServletConfig wServletConfig = wServletEntity2.getServletConfig();
                if (((WServletConfig)object).getLoadOnStartup() < wServletConfig.getLoadOnStartup()) {
                    arrayList.add(n, wServletEntity);
                    break;
                }
                ++n;
            }
            if (n != arrayList.size()) continue;
            arrayList.add(wServletEntity);
        }
        int n = 0;
        while (n < arrayList.size()) {
            object = (WServletEntity)arrayList.get(n);
            try {
                NSServletWrapper nSServletWrapper = ((WServletEntity)object).loadAndInitServlet();
            }
            catch (ServletException servletException) {}
            ++n;
        }
        this.initFilters();
        this.initDone = true;
    }

    private void initFilters() {
        if (this.filtersByName != null) {
            try {
                this.appFilterDef.init();
            }
            catch (Exception exception) {
                LogUtil.logWarning((String)this.vs.getVSId(), (String)(String.valueOf(_res.getProp("servlet.WebApplication.msg_exceptionWhileCreateServletWrapper")) + LogUtil.getStackTrace((Throwable)exception)));
            }
            Enumeration enumeration = Collections.enumeration(this.filtersByName.values());
            while (enumeration.hasMoreElements()) {
                WFilterDef wFilterDef = (WFilterDef)enumeration.nextElement();
                try {
                    wFilterDef.init();
                }
                catch (Exception exception) {
                    LogUtil.logWarning((String)this.vs.getVSId(), (String)(String.valueOf(_res.getProp("servlet.WebApplication.msg_cannotInstantiateTheFilter")) + wFilterDef.getFilterName() + "':\n" + LogUtil.getStackTrace((Throwable)exception)));
                }
            }
        }
    }

    boolean isDefaultApp() {
        return this.isDefaultApp;
    }

    public boolean isModified() {
        long l = System.currentTimeMillis();
        if (this.servletLoader == null || this.isTerminated) {
            return true;
        }
        if (this.lastClassUpdateCheckTime + (long)this.classReloadInterval > l) {
            return false;
        }
        if (this.servletLoader.isModified()) {
            return true;
        }
        this.lastClassUpdateCheckTime = l;
        return false;
    }

    public boolean isSessionTrackingViaCookie() {
        return this.useSessionCookies;
    }

    public boolean isSessionTrackingViaURL() {
        return this.useSessionUrlRewriting;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public void log(Exception exception, String string) {
        this.log(string, exception);
    }

    public void log(String string) {
        LogUtil.logInfo((String)string);
    }

    public void log(String string, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        LogUtil.logWarning((String)this.vs.getVSId(), (String)string);
        LogUtil.logWarning((String)this.vs.getVSId(), (String)stringWriter.toString());
    }

    private boolean matchFiltersURL(String string, String string2) {
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)5, (String)("  Matching filters for request path '" + string2 + "' against mapping " + string));
        }
        if (string2 == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        if (string.equals(string2)) {
            return true;
        }
        if (string.equals("/*")) {
            return true;
        }
        if (string.endsWith("/*")) {
            String string3 = string2;
            while (true) {
                if (string.equals(String.valueOf(string3) + "/*")) {
                    return true;
                }
                int n = string3.lastIndexOf("/");
                if (n < 0) break;
                string3 = string3.substring(0, n);
            }
            return false;
        }
        if (string.startsWith("*.")) {
            int n = string2.lastIndexOf("/");
            int n2 = string2.lastIndexOf(".");
            if (n >= 0 && n2 > n) {
                return string.equals("*." + string2.substring(n2 + 1));
            }
        }
        return false;
    }

    private void parseDeploymentDescriptor() throws ServletException {
        WSAXErrorHandler wSAXErrorHandler = WSAXErrorHandler.getErrorHandler(this.vs.getVSId());
        this.webXmlConf = new XmlConfig(this.webXml, WEBXML_PUBLIC_DTD_ID, WEBXML_DTD_RESOURCE);
        try {
            try {
                this.webXmlConf.parseConfig((ErrorHandler)wSAXErrorHandler);
                wSAXErrorHandler.checkParserErrors();
            }
            catch (Exception exception) {
                if (!this.webXmlConf.fileExists()) {
                    LogUtil.logWarning((String)this.vs.getVSId(), (String)_res.getProp("servlet.WebApplication.msg_cannotFindDeploymentDesc", (Object)this.webXml));
                }
                LogUtil.logWarning((String)this.vs.getVSId(), (String)_res.getProp("servlet.WebApplication.msg_errorParsingDeploymentDesc", (Object)this.webXml, (Object)exception.getMessage()));
                ServletException servletException = new ServletException((Throwable)exception);
                throw servletException;
            }
            Object var3_4 = null;
            wSAXErrorHandler.reset();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            wSAXErrorHandler.reset();
            throw throwable;
        }
    }

    private void releaseFilterChain(String string, WFilterChain wFilterChain) {
        while (wFilterChain != null) {
            WFilterChain wFilterChain2 = wFilterChain.getNextChain();
            wFilterChain.destroy();
            wFilterChain = wFilterChain2;
        }
    }

    public void reload() {
        this.unloadClassLoader();
        this.setupClassLoaderAndDependents();
        this.init();
        this.initFilters();
        this.lastClassUpdateCheckTime = System.currentTimeMillis();
    }

    public void removeAttribute(String string) {
        if (string != null) {
            this.contextAttrs.remove(string);
        }
    }

    public int service(String string, String string2, NSServletSession nSServletSession, int n) {
        NSServletWrapper nSServletWrapper;
        NSHttpServletResponse nSHttpServletResponse;
        String string3 = nSServletSession.getServletPath();
        String string4 = nSServletSession.getPathInfo();
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)5, (String)("WebApp service: uri = " + string + " contextPath = " + this.getContextPath() + " servletPath = " + string3 + " pathInfo = " + string4 + " servletName = " + string2));
        }
        boolean bl = true;
        NSHttpServletRequest nSHttpServletRequest = nSServletSession.getHttpServletRequest();
        if (nSHttpServletRequest == null) {
            nSHttpServletRequest = new NSHttpServletRequest(this, nSServletSession);
            if (n != 0 && n != 200) {
                nSHttpServletRequest.setAttribute("javax.servlet.error.status_code", new Integer(n));
                nSHttpServletRequest.setAttribute("javax.servlet.error.message", nSServletSession.getOrigReqStatusMsg());
                nSHttpServletRequest.setAttribute("javax.servlet.error.uri", nSServletSession.getOrigReqUri());
            }
        } else {
            bl = false;
            nSHttpServletRequest.setRequestDispatcherAttrs();
        }
        if ((nSHttpServletResponse = nSServletSession.getHttpServletResponse()) == null) {
            nSHttpServletResponse = new NSHttpServletResponse(this, nSServletSession);
        }
        if (this.requireFormLogin) {
            int n2 = this.formAuth.Authenticate(nSHttpServletRequest, nSHttpServletResponse, nSServletSession);
            if (n2 != -2) {
                return n2;
            }
            if (string2.equals(FORMAUTH_SERVLET_NAME)) {
                return -2;
            }
        }
        if ((nSServletWrapper = (NSServletWrapper)this.servletInstances.get(string2)) == null) {
            String string5;
            WServletEntity wServletEntity = (WServletEntity)this.servletsByName.get(string2);
            if (wServletEntity == null) {
                try {
                    wServletEntity = this.addServlet(string2, null);
                }
                catch (ServletException servletException) {}
            }
            if ((string5 = wServletEntity.getServletConfig().getJspFile()) != null) {
                int n3 = 0;
                try {
                    if (nSHttpServletResponse.getIncludeFlag()) {
                        this.getRequestDispatcher("/" + string5).include((ServletRequest)nSHttpServletRequest, (ServletResponse)nSHttpServletResponse);
                    } else {
                        this.getRequestDispatcher("/" + string5).forward((ServletRequest)nSHttpServletRequest, (ServletResponse)nSHttpServletResponse);
                    }
                }
                catch (Exception exception) {
                    this.runner.serviceException(string, string2, null, nSHttpServletRequest, nSHttpServletResponse, nSServletSession, exception, wServletEntity.getExceptionMsg(), this, bl);
                    LogUtil.logWarning((String)_res.getProp("servlet.WebApplication.msg_CannotLoadServlet", (Object)string2, (Object)this.vs.getVSId(), (Object)this.getContextPath()));
                    n3 = -1;
                }
                return n3;
            }
            try {
                nSServletWrapper = wServletEntity.loadAndInitServlet();
            }
            catch (ServletException servletException) {
                this.runner.serviceException(string, string2, null, nSHttpServletRequest, nSHttpServletResponse, nSServletSession, (Exception)((Object)servletException), wServletEntity.getExceptionMsg(), this, bl);
                LogUtil.logWarning((String)_res.getProp("servlet.WebApplication.msg_CannotLoadServlet", (Object)string2, (Object)this.vs.getVSId(), (Object)this.getContextPath()));
                return -1;
            }
        }
        if (this.filtersByName == null || this.urlFilterMaps == null && this.servletFilterMaps == null) {
            return this.runner.invokeServletService(string, nSServletWrapper, nSHttpServletRequest, nSHttpServletResponse, nSServletSession, this, bl);
        }
        return this.serviceServletFilters(string, string2, string3, nSServletWrapper, nSHttpServletRequest, nSHttpServletResponse, nSServletSession, bl);
    }

    public int serviceServletFilters(String string, String string2, String string3, NSServletWrapper nSServletWrapper, NSHttpServletRequest nSHttpServletRequest, NSHttpServletResponse nSHttpServletResponse, NSServletSession nSServletSession, boolean bl) {
        int n = 0;
        WFilterChain wFilterChain = null;
        try {
            wFilterChain = this.getFilterChain(string, string2, string3, nSServletWrapper);
        }
        catch (Exception exception) {
            this.runner.serviceException(string, string2, nSServletWrapper, nSHttpServletRequest, nSHttpServletResponse, nSServletSession, exception, exception.toString(), this, bl);
            return -1;
        }
        if (wFilterChain == null) {
            n = this.runner.invokeServletService(string, nSServletWrapper, nSHttpServletRequest, nSHttpServletResponse, nSServletSession, this, bl);
        } else {
            Filter filter = wFilterChain.getFilter();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                block10: {
                    try {
                        Thread.currentThread().setContextClassLoader(filter.getClass().getClassLoader());
                        filter.doFilter((ServletRequest)nSHttpServletRequest, (ServletResponse)nSHttpServletResponse, (FilterChain)wFilterChain);
                    }
                    catch (Exception exception) {
                        this.runner.serviceException(string, string2, nSServletWrapper, nSHttpServletRequest, nSHttpServletResponse, nSServletSession, exception, exception.toString(), this, bl);
                        if (bl) break block10;
                        n = -1;
                    }
                }
                Object var14_15 = null;
                this.releaseFilterChain(string, wFilterChain);
                Thread.currentThread().setContextClassLoader(classLoader);
                if (bl) {
                    n = this.runner.servicePostProcess(nSHttpServletRequest, nSHttpServletResponse, nSServletSession, n);
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                this.releaseFilterChain(string, wFilterChain);
                Thread.currentThread().setContextClassLoader(classLoader);
                if (bl) {
                    n = this.runner.servicePostProcess(nSHttpServletRequest, nSHttpServletResponse, nSServletSession, n);
                }
                throw throwable;
            }
        }
        return n;
    }

    public void setAttribute(String string, Object object) {
        if (string != null && object != null) {
            this.contextAttrs.put(string, object);
        }
    }

    public void setup(XmlNode xmlNode, boolean bl) throws ServletException {
        this.vsAppConf = xmlNode;
        this.isImplicitDefaultApp = bl;
        if (!bl) {
            this.parseDeploymentDescriptor();
        }
        this.appConfig = (XmlNode)xmlNode.clone();
        if (this.webXmlConf != null) {
            this.appConfig.append(this.webXmlConf.findConfig("web-app"));
        }
        this.setupWebAppElements();
        File file = null;
        String string = this.appConfig.getString("tempdir/dir", null);
        if (string != null) {
            file = new File(string);
        } else {
            file = this.vs.getTempDir();
            if (file == null && (string = System.getProperty("java.io.tmpdir")) != null) {
                file = new File(string);
            }
        }
        this.contextAttrs.put("javax.servlet.context.tempdir", file);
        this.setupClassLoaderAndDependents();
    }

    private void setupClassLoaderAndDependents() {
        this.setupServletLoader();
        this.contextAttrs.put(SERVLET_CLASSPATH, this.getClassLoader().getClassPath());
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)5, (String)(" Effective context classpath = " + this.contextAttrs.get(SERVLET_CLASSPATH)));
        }
        this.contextAttrs.put("com.iplanet.server.http.servlet.classloader", this.getClassLoader());
        this.contextAttrs.put(SERVLET_CLASSRELOAD_INTERVAL, new Integer(this.classReloadInterval / 1000));
        this.setupSessionManager();
        if (!this.isImplicitDefaultApp) {
            this.addJspServlet();
        }
    }

    private void setupErrorPage(XmlNode xmlNode) throws ServletException {
        String string = xmlNode.getString("error-code", null);
        String string2 = xmlNode.getString("exception-type", null);
        String string3 = xmlNode.getString("location", null);
        if (string == null && string2 == null) {
            throw WebAppConfig.configException(xmlNode, _res.getProp("servlet.WebApplication.msg_errorPageDefNeedsErrorCodeOrExceptionType"));
        }
        if (string3 == null) {
            throw WebAppConfig.configException(xmlNode, _res.getProp("servlet.WebApplication.msg_errorPageDefNeedsLocation"));
        }
        if (string2 != null) {
            this.exceptionMap.put(string2, string3);
        } else if (string != null) {
            int n;
            try {
                n = Integer.parseInt(string, 10);
            }
            catch (NumberFormatException numberFormatException) {
                throw WebAppConfig.configException(xmlNode, _res.getProp("servlet.WebApplication.msg_cannotParseErrorCodeDef"));
            }
            this.vs.addErrorPage(this.contextPath, n, string3);
        }
    }

    private void setupFilterElement(XmlNode xmlNode) throws ServletException {
        String string = xmlNode.getString("filter-name", null);
        if (string == null) {
            throw WebAppConfig.configException(xmlNode, _res.getProp("servlet.WebApplication.msg_filterDefNeedsFilterName"));
        }
        String string2 = xmlNode.getString("filter-class", null);
        if (string2 == null) {
            throw WebAppConfig.configException(xmlNode, _res.getProp("servlet.WebApplication.msg_filterDefNeedsFilterClass"));
        }
        if (this.filtersByName == null) {
            this.filtersByName = new HashMap();
            this.appFilterDef = new WFilterDef(DEF_FILTER_NAME, DEF_FILTER_CLASS, null, this);
        }
        WFilterDef wFilterDef = new WFilterDef(string, string2, xmlNode, this);
        this.filtersByName.put(string, wFilterDef);
    }

    private void setupFilterMapping(XmlNode xmlNode) throws ServletException {
        String string = xmlNode.getString("filter-name", null);
        if (string == null) {
            throw WebAppConfig.configException(xmlNode, _res.getProp("servlet.WebApplication.msg_filterMappingDefNeedsFilterName"));
        }
        String string2 = xmlNode.getString("url-pattern", null);
        String string3 = xmlNode.getString("servlet-name", null);
        if (string2 == null && string3 == null) {
            throw WebAppConfig.configException(xmlNode, _res.getProp("servlet.WebApplication.msg_servletDefNeedsUrlPatternOrServletName"));
        }
        WFilterMap wFilterMap = new WFilterMap(string2, string3, string);
        if (string2 != null) {
            if (this.urlFilterMaps == null) {
                this.urlFilterMaps = new ArrayList();
            }
            if (LogUtil.enableTrace) {
                LogUtil.TRACE((int)7, (String)("Adding filter-mapping by path '" + wFilterMap.getFilterName() + "' url-pattern = '" + wFilterMap.getURLPattern() + "'"));
            }
            this.urlFilterMaps.add(wFilterMap);
        } else {
            if (this.servletFilterMaps == null) {
                this.servletFilterMaps = new ArrayList();
            }
            if (LogUtil.enableTrace) {
                LogUtil.TRACE((int)7, (String)("Adding filter-mapping by servlet '" + wFilterMap.getFilterName() + "' servlet-name = " + wFilterMap.getServletName() + "'"));
            }
            this.servletFilterMaps.add(wFilterMap);
        }
    }

    private void setupIWSWebAppElements() {
        String string;
        XmlNode xmlNode = this.appConfig.findChildNode("auth-native");
        if (xmlNode == null) {
            xmlNode = this.vs.getConfig().findConfig("/vs/auth-native");
        }
        if (xmlNode != null && (string = xmlNode.getString("authdb", null)) != null) {
            if (this.vs.isUserDBValid(string)) {
                this.authDB = string;
            } else {
                LogUtil.logWarning((String)this.vs.getVSId(), (String)_res.getProp("servlet.WebApplication.msg_userDBinvalid", (Object)string));
            }
        }
        if ((xmlNode = this.appConfig.findChildNode("cookie-encoding")) == null) {
            xmlNode = this.vs.getConfig().findConfig("/vs/cookie-encoding");
        }
        if (xmlNode != null) {
            this.encodeCookies = xmlNode.getBoolean("enable", true);
        }
        if ((xmlNode = this.appConfig.findChildNode("input-stream")) == null) {
            xmlNode = this.vs.getConfig().findConfig("/vs/input-stream");
        }
        if (xmlNode != null) {
            this.inputStreamLengthCheck = xmlNode.getBoolean("length-check", true);
        }
        if ((xmlNode = this.appConfig.findChildNode("parameter-encoding")) == null) {
            xmlNode = this.vs.getConfig().findConfig("/vs/parameter-encoding");
        }
        if (xmlNode != null) {
            this.paramEncoding = xmlNode.getString("enc", DEF_PARAM_ENCODING);
            this.formHintField = xmlNode.getString("form-hint-field", DEF_FORM_HINT_FIELD);
        }
        if ((xmlNode = this.appConfig.findChildNode("response-cookie")) == null) {
            xmlNode = this.vs.getConfig().findConfig("/vs/response-cookie");
        }
        if (xmlNode != null) {
            this.responseCookieVersion = xmlNode.getInt("version", 0);
        }
        if ((xmlNode = this.appConfig.findChildNode("response-buffer")) == null) {
            xmlNode = this.vs.getConfig().findConfig("/vs/response-buffer");
        }
        if (xmlNode != null) {
            this.responseBufferSize = xmlNode.getInt("size", this.responseBufferSize);
            this.responseFlushTimeout = xmlNode.getInt("flush-timeout", this.responseFlushTimeout);
        }
        if ((xmlNode = this.appConfig.findChildNode("role-mapping")) == null) {
            xmlNode = this.vs.getConfig().findConfig("/vs/role-mapping");
        }
        if (xmlNode != null && (string = xmlNode.getString("map-to", null)) != null) {
            if (string.equalsIgnoreCase("user")) {
                this.roleMapping = 1;
            } else if (string.equalsIgnoreCase("group")) {
                this.roleMapping = 2;
            } else if (string.equalsIgnoreCase("role")) {
                this.roleMapping = 3;
            }
        }
        if ((xmlNode = this.appConfig.findChildNode("session-tracking")) == null) {
            xmlNode = this.vs.getConfig().findConfig("/vs/session-tracking");
        }
        if (xmlNode != null) {
            if (xmlNode.findChildNode("use-cookies") != null) {
                this.useSessionCookies = xmlNode.getBoolean("use-cookies", this.useSessionCookies);
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)5, (String)("use-cookies = " + this.useSessionCookies));
                }
            }
            if (xmlNode.findChildNode("use-url-rewriting") != null) {
                this.useSessionUrlRewriting = xmlNode.getBoolean("use-url-rewriting", this.useSessionUrlRewriting);
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)5, (String)("use-url-rewriting = " + this.useSessionUrlRewriting));
                }
            }
        }
        if ((xmlNode = this.appConfig.findChildNode("session-cookie")) == null) {
            xmlNode = this.vs.getConfig().findConfig("/vs/session-cookie");
        }
        if (xmlNode != null) {
            this.sessionCookieDomain = xmlNode.getString("domain", null);
            this.sessionCookieIsSecure = xmlNode.getBoolean("is-secure", false);
            this.sessionCookiePath = xmlNode.getString("path", null);
        }
        if (this.sessionCookiePath == null) {
            this.sessionCookiePath = this.getContextPath();
        }
    }

    private void setupLoginConfig(XmlNode xmlNode) throws ServletException {
        if (xmlNode != null) {
            this.authMethod = xmlNode.getString("auth-method", null);
            this.authRealm = xmlNode.getString("realm-name", null);
        }
        if (this.authMethod != null && !(this.authMethod.equalsIgnoreCase("BASIC") || this.authMethod.equalsIgnoreCase("DIGEST") || this.authMethod.equalsIgnoreCase("FORM") || this.authMethod.equalsIgnoreCase("CLIENT-CERT"))) {
            throw WebAppConfig.configException(xmlNode, String.valueOf(this.authMethod) + _res.getProp("servlet.WebApplication.msg_notValidAuthenticationMethod"));
        }
        if (this.authRealm == null) {
            this.authRealm = DEF_AUTH_REALM;
        }
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)7, (String)("Setting up auth method=" + this.authMethod + "; realm=" + this.authRealm + "; authdb=" + this.authDB));
        }
        this.vs.configWebAppAuthentication(this.contextPath, this.authMethod, this.authRealm, this.authDB);
        if (this.authMethod != null && this.authMethod.equalsIgnoreCase("FORM")) {
            this.formAuth = new FormAuthenticator(this);
            this.requireFormLogin = true;
            XmlNode xmlNode2 = xmlNode.findChildNode("form-login-config");
            if (xmlNode2 != null) {
                String string = xmlNode2.getString("form-login-page", null);
                String string2 = xmlNode2.getString("form-error-page", null);
                if (string == null || string2 == null) {
                    throw WebAppConfig.configException(xmlNode2, _res.getProp("servlet.WebApplication.msg_formLoginConfigAndFormErrorPage"));
                }
                this.formAuth.setFormLoginPage(string);
                this.formAuth.setFormErrorPage(string2);
            } else {
                throw WebAppConfig.configException(xmlNode, _res.getProp("servlet.WebApplication.msg_formLoginConfigSpecifyLoginAndError"));
            }
        }
    }

    private void setupMimeMapping(XmlNode xmlNode) throws ServletException {
        String string = xmlNode.getString("extension", null);
        String string2 = xmlNode.getString("mime-type", null);
        if (string == null || string2 == null) {
            throw WebAppConfig.configException(xmlNode, _res.getProp("servlet.WebApplication.msg_mimeMapDefNeedsBothExtensionAndMimeType"));
        }
        this.vs.addMimeMap(this.contextPath, string, string2);
    }

    /*
     * Unable to fully structure code
     */
    private void setupSecurityConstraint(XmlNode var1_1) throws ServletException {
        var3_2 = null;
        var2_3 = var1_1.findChildNode("auth-constraint");
        if (var2_3 != null) {
            var3_2 = this.getRoleNames(var2_3);
        }
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        switch (this.roleMapping) {
            case 1: {
                var4_4 = var3_2;
                if (!LogUtil.enableTrace) break;
                LogUtil.TRACE((int)5, (String)"Mapping roles to users ids");
                break;
            }
            case 2: {
                var5_5 = var3_2;
                if (!LogUtil.enableTrace) break;
                LogUtil.TRACE((int)5, (String)"Mapping roles to group ids");
                break;
            }
            case 3: {
                var6_6 = var3_2;
                if (!LogUtil.enableTrace) break;
                LogUtil.TRACE((int)5, (String)"Mapping roles to role ids");
                break;
            }
        }
        var7_7 = var1_1.getString("user-data-constraint/transport-guarantee", null);
        if (var7_7 == null || !(var7_7.equalsIgnoreCase("NONE") != false || var7_7.equalsIgnoreCase("INTEGRAL") != false || var7_7.equalsIgnoreCase("CONFIDENTIAL") != false)) {
            var7_7 = "NONE";
        }
        if ((var8_8 = var1_1.iterate("web-resource-collection")).hasNext()) ** GOTO lbl40
        throw WebAppConfig.configException(var1_1, WebApplication._res.getProp("servlet.WebApplication.msg_securityConstraintDefNeedsWebResource"));
lbl-1000:
        // 1 sources

        {
            var2_3 = (XmlNode)var8_8.next();
            var9_9 = this.getHttpMethods(var2_3);
            var10_10 = var2_3.iterate("url-pattern");
            while (var10_10.hasNext()) {
                var2_3 = (XmlNode)var10_10.next();
                var11_11 = var2_3.getString();
                if (var11_11 == null) continue;
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)5, (String)("Setting up acl for " + var11_11 + "; methods = " + var9_9 + "; roles = " + var3_2 + "; guarantee = " + var7_7));
                }
                this.vs.configWebAppAcl(this.contextPath, var11_11, var9_9, var7_7, var6_6, var4_4, var5_5);
            }
lbl40:
            // 2 sources

            ** while (var8_8.hasNext())
        }
lbl41:
        // 1 sources

    }

    private void setupSecurityRole(XmlNode xmlNode) throws ServletException {
    }

    private void setupServletElement(XmlNode xmlNode) throws ServletException {
        String string = xmlNode.getString("servlet-name", null);
        if (string == null) {
            throw WebAppConfig.configException(xmlNode, _res.getProp("servlet.WebApplication.msg_servletDefNeedsServletName"));
        }
        String string2 = xmlNode.getString("servlet-class", null);
        String string3 = xmlNode.getString("jsp-file", null);
        if (string2 == null && string3 == null) {
            throw WebAppConfig.configException(xmlNode, _res.getProp("servlet.WebApplication.msg_servletDefNeedsServletClassOrJsp"));
        }
        WServletConfig wServletConfig = new WServletConfig(this, string, string2, string3, xmlNode);
        WServletEntity wServletEntity = new WServletEntity(this, wServletConfig);
        this.servletsByName.put(string, wServletEntity);
    }

    private void setupServletLoader() {
        this.classReloadInterval = 30000;
        XmlNode xmlNode = this.appConfig.findConfig("class-loader");
        if (xmlNode == null) {
            xmlNode = this.vs.getConfig().findConfig("/vs/class-loader");
        }
        if (xmlNode != null) {
            this.classReloadInterval = xmlNode.getInt("reload-interval", 30) * 1000;
        }
        this.servletLoader = WebAppConfig.createServletLoader(xmlNode, this.appDir, null, this.vs.getClassLoader());
    }

    private void setupServletMapping(XmlNode xmlNode) throws ServletException {
        String string = xmlNode.getString("servlet-name", null);
        String string2 = xmlNode.getString("url-pattern", null);
        if (string == null || string2 == null) {
            throw WebAppConfig.configException(xmlNode, _res.getProp("servlet.WebApplication.msg_servletMapDefNeedsBothUrlPatternAndServletName"));
        }
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)5, (String)(String.valueOf(this.vs.getVSId()) + ": adding servlet-mapping " + string2 + " servletName " + string));
        }
        this.vs.addServletMap(this.contextPath, string2, string);
    }

    private void setupSessionManager() {
        Properties properties = new Properties();
        if (this.bTimeoutConfigured) {
            ((Hashtable)properties).put("timeOut", Integer.toString(this.snTimeout));
        }
        XmlNode xmlNode = this.appConfig.findConfig("session-manager");
        String string = String.valueOf(this.vs.getVSId()) + "/" + this.contextPath;
        string = SlashUtil.de_slashes((String)string);
        ((Hashtable)properties).put("session-context-name", string);
        if (xmlNode != null) {
            String string2 = xmlNode.getString("session-data-dir", null);
            if (string2 == null) {
                string2 = SlashUtil.resolveNativePath((String)this.runner.getServletServer().getSessionDataDir(), (String)string);
            }
            ((Hashtable)properties).put("session-data-dir", string2);
            this.sm = WebAppConfig.createSessionManager(this.runner, xmlNode, properties);
        } else {
            this.sm = this.vs.getHttpSessionManager();
            if (this.sm != null) {
                this.sessionCookiePath = "/";
            } else {
                String string3 = this.runner.getDefaultSessionManagerName();
                String string4 = SlashUtil.resolveNativePath((String)this.runner.getServletServer().getSessionDataDir(), (String)string);
                ((Hashtable)properties).put("session-data-dir", string4);
                this.sm = this.runner.createSessionManager(string3, properties);
            }
        }
        if (!this.bTimeoutConfigured) {
            this.snTimeout = this.sm.getDefaultTimeOut();
        }
    }

    private void setupWebAppElements() throws ServletException {
        this.servletsByName = new Hashtable();
        XmlNode xmlNode = null;
        this.setupIWSWebAppElements();
        xmlNode = this.appConfig.findChildNode("login-config");
        this.setupLoginConfig(xmlNode);
        Iterator iterator = this.appConfig.iterate();
        while (iterator.hasNext()) {
            xmlNode = (XmlNode)iterator.next();
            if (xmlNode.getName().equals("context-param")) {
                WebAppConfig.setParams(xmlNode, this.initParams);
                continue;
            }
            if (xmlNode.getName().equals("servlet")) {
                this.setupServletElement(xmlNode);
                continue;
            }
            if (xmlNode.getName().equals("servlet-mapping")) {
                this.setupServletMapping(xmlNode);
                continue;
            }
            if (xmlNode.getName().equals("mime-mapping")) {
                this.setupMimeMapping(xmlNode);
                continue;
            }
            if (xmlNode.getName().equals("welcome-file-list")) {
                this.setupWelcomeFileList(xmlNode);
                continue;
            }
            if (xmlNode.getName().equals("error-page")) {
                this.setupErrorPage(xmlNode);
                continue;
            }
            if (xmlNode.getName().equals("security-constraint")) {
                this.setupSecurityConstraint(xmlNode);
                continue;
            }
            if (xmlNode.getName().equals("security-role")) {
                this.setupSecurityRole(xmlNode);
                continue;
            }
            if (xmlNode.getName().equals("session-config")) {
                if (xmlNode.findChildNode("session-timeout") == null) continue;
                this.bTimeoutConfigured = true;
                this.snTimeout = xmlNode.getInt("session-timeout", -1);
                if (this.snTimeout < 0) {
                    this.snTimeout = -1;
                    continue;
                }
                this.snTimeout *= 60;
                continue;
            }
            if (xmlNode.getName().equals("filter")) {
                this.setupFilterElement(xmlNode);
                continue;
            }
            if (!xmlNode.getName().equals("filter-mapping")) continue;
            this.setupFilterMapping(xmlNode);
        }
    }

    private void setupWelcomeFileList(XmlNode xmlNode) throws ServletException {
        String string = null;
        string = xmlNode.getString("welcome-file-list", null);
        Iterator iterator = xmlNode.iterate();
        while (iterator.hasNext()) {
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            if (xmlNode2.getName().equals("welcome-file")) {
                String string2 = xmlNode2.getString();
                if (string2 == null) continue;
                string2 = string2.trim();
                if (string == null) {
                    string = string2;
                    continue;
                }
                string = String.valueOf(string) + "," + string2;
                continue;
            }
            throw WebAppConfig.configException(xmlNode, _res.getProp("servlet.WebApplication.msg_elementNotPermittedInWelcomeFieList", (Object)xmlNode2.getName()));
        }
        if (string != null) {
            this.vs.addIndexFileList(this.contextPath, string);
        }
    }

    public boolean shouldEncodeCookies() {
        return this.encodeCookies;
    }

    void terminate() {
        if (this.isTerminated) {
            return;
        }
        this.isTerminated = true;
        this.unloadClassLoader();
        this.parentClassLoader = null;
        this.runner = null;
        this.jspOutputDir = null;
        this.vs = null;
        this.contextPath = null;
        this.appDir = null;
        this.exceptionCount = 0;
        this.errorCount = 0;
    }

    public String toString() {
        return "web-app " + this.contextPath;
    }

    private void unloadClassLoader() {
        int n = 0;
        Object object = this.servletInstances;
        synchronized (object) {
            Enumeration enumeration = this.servletInstances.elements();
            while (enumeration.hasMoreElements()) {
                ++n;
                NSServletWrapper nSServletWrapper = (NSServletWrapper)enumeration.nextElement();
                LogUtil.logInfo((String)this.vs.getVSId(), (String)(String.valueOf(_res.getProp("servlet.WebApplication.msg_destroyServlet")) + nSServletWrapper.getServletName()));
                nSServletWrapper.destroy();
            }
            this.servletInstances.clear();
        }
        this.servletInstances = null;
        this.servletCount = 0;
        this.initDone = false;
        LogUtil.logInfo((String)this.vs.getVSId(), (String)_res.getProp("servlet.WebApplication.msg_destroyedServletInWebapp", n, (Object)this.contextPath));
        if (this.filtersByName != null) {
            object = Collections.enumeration(this.filtersByName.values());
            while (object.hasMoreElements()) {
                WFilterDef wFilterDef = (WFilterDef)object.nextElement();
                wFilterDef.destroy();
            }
        }
        this.sm.close();
        this.sm = null;
        this.servletLoader.unloadAll();
        this.servletLoader = null;
    }

    public boolean useFormLogin() {
        return this.requireFormLogin;
    }
}

