/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.spec.DSAParameterSpec;
import org.mozilla.jss.crypto.PQGParamGenException;
import org.mozilla.jss.util.Assert;

public class PQGParams
extends DSAParameterSpec {
    private BigInteger seed;
    private int counter;
    private BigInteger H;

    public PQGParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, int n, BigInteger bigInteger5) {
        super(bigInteger, bigInteger2, bigInteger3);
        this.seed = bigInteger4;
        this.counter = n;
        this.H = bigInteger5;
    }

    public static byte[] BigIntegerToUnsignedByteArray(BigInteger bigInteger) {
        byte[] byArray;
        Assert.assert(bigInteger.signum() != -1);
        if (bigInteger.bitLength() % 8 == 0) {
            byte[] byArray2 = bigInteger.toByteArray();
            Assert.assert(byArray2[0] == 0);
            byArray = new byte[byArray2.length - 1];
            System.arraycopy(byArray2, 1, byArray, 0, byArray.length);
        } else {
            byArray = bigInteger.toByteArray();
        }
        return byArray;
    }

    public static PQGParams generate(int n) throws InvalidParameterException, PQGParamGenException {
        PQGParams pQGParams = PQGParams.generateNative(n);
        if (!pQGParams.paramsAreValid()) {
            throw new PQGParamGenException("Generated parameters did not verify correctly");
        }
        return pQGParams;
    }

    public static PQGParams generate(int n, int n2) throws InvalidParameterException, PQGParamGenException {
        PQGParams pQGParams = PQGParams.generateNative(n, n2);
        if (!pQGParams.paramsAreValid()) {
            throw new PQGParamGenException("Generated parameters did not verify correctly");
        }
        return pQGParams;
    }

    private static native PQGParams generateNative(int var0) throws InvalidParameterException, PQGParamGenException;

    private static native PQGParams generateNative(int var0, int var1) throws InvalidParameterException, PQGParamGenException;

    public int getCounter() {
        return this.counter;
    }

    public BigInteger getH() {
        return this.H;
    }

    public BigInteger getSeed() {
        return this.seed;
    }

    public boolean paramsAreValid() {
        return this.paramsAreValidNative(PQGParams.BigIntegerToUnsignedByteArray(this.getP()), PQGParams.BigIntegerToUnsignedByteArray(this.getQ()), PQGParams.BigIntegerToUnsignedByteArray(this.getG()), PQGParams.BigIntegerToUnsignedByteArray(this.seed), this.counter, PQGParams.BigIntegerToUnsignedByteArray(this.H));
    }

    private native boolean paramsAreValidNative(byte[] var1, byte[] var2, byte[] var3, byte[] var4, int var5, byte[] var6);
}

