/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class AVA
implements ASN1Value {
    private OBJECT_IDENTIFIER oid;
    private ANY value;
    public static final Tag TAG = SEQUENCE.TAG;

    private AVA() {
    }

    public AVA(OBJECT_IDENTIFIER oBJECT_IDENTIFIER, ASN1Value aSN1Value) {
        this.oid = oBJECT_IDENTIFIER;
        if (aSN1Value instanceof ANY) {
            this.value = (ANY)aSN1Value;
        } else {
            byte[] byArray = ASN1Util.encode(aSN1Value);
            try {
                this.value = (ANY)ASN1Util.decode(ANY.getTemplate(), byArray);
            }
            catch (InvalidBERException invalidBERException) {
                Assert.notReached("InvalidBERException while decoding as ANY");
            }
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(this.oid);
        sEQUENCE.addElement(this.value);
        sEQUENCE.encode(tag, outputStream);
    }

    public OBJECT_IDENTIFIER getOID() {
        return this.oid;
    }

    public Tag getTag() {
        return TAG;
    }

    public ANY getValue() {
        return this.value;
    }

    public static class Template
    implements ASN1Template {
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            SEQUENCE.Template template = new SEQUENCE.Template();
            template.addElement(new OBJECT_IDENTIFIER.Template());
            template.addElement(new ANY.Template());
            SEQUENCE sEQUENCE = (SEQUENCE)template.decode(tag, inputStream);
            Assert.assert(sEQUENCE.size() == 2);
            return new AVA((OBJECT_IDENTIFIER)sEQUENCE.elementAt(0), sEQUENCE.elementAt(1));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }
    }
}

