/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ajp.tomcat4.config;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;

public class BaseJkConfig
implements LifecycleListener {
    protected int debug = 0;
    protected File configHome = null;
    protected File workersConfig = null;
    protected File jkLog = null;
    protected String jkDebug = "emerg";
    protected String jkWorker = "ajp13";
    protected boolean noRoot = true;
    protected boolean forwardAll = true;
    protected String tomcatHome;
    protected boolean regenerate = false;
    protected boolean append = false;

    public void lifecycleEvent(LifecycleEvent evt) {
        if ("start".equals(evt.getType())) {
            this.execute(evt);
        }
    }

    public void execute(LifecycleEvent evt) {
        this.initProperties();
        PrintWriter mod_jk = null;
        try {
            mod_jk = this.getWriter();
        }
        catch (IOException iex) {
            this.log("Unable to open config file");
            return;
        }
        Lifecycle who = evt.getLifecycle();
        if (who instanceof Server) {
            this.executeServer((Server)who, mod_jk);
        } else if (who instanceof Host) {
            this.executeHost((Host)who, mod_jk);
        } else if (who instanceof Context) {
            this.executeContext((Context)who, mod_jk);
        }
        mod_jk.close();
    }

    public void executeServer(Server svr, PrintWriter mod_jk) {
        if (!this.append) {
            if (!this.generateJkHead(mod_jk)) {
                return;
            }
            this.generateSSLConfig(mod_jk);
            this.generateJkTail(mod_jk);
        }
    }

    protected void generateSSLConfig(PrintWriter mod_jk) {
    }

    protected boolean generateJkHead(PrintWriter mod_jk) {
        return true;
    }

    protected void generateJkTail(PrintWriter mod_jk) {
    }

    protected void generateVhostHead(Host host, PrintWriter mod_jk) {
    }

    protected void generateVhostTail(Host host, PrintWriter mod_jk) {
    }

    protected void executeEngine(Engine egn, PrintWriter mod_jk) {
        Container[] children = egn.findChildren();
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof Host) {
                this.executeHost((Host)children[ii], mod_jk);
            } else if (children[ii] instanceof Context) {
                this.executeContext((Context)children[ii], mod_jk);
            }
            ++ii;
        }
    }

    protected void executeHost(Host hst, PrintWriter mod_jk) {
        this.generateVhostHead(hst, mod_jk);
        Container[] children = hst.findChildren();
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof Context) {
                this.executeContext((Context)children[ii], mod_jk);
            }
            ++ii;
        }
        this.generateVhostTail(hst, mod_jk);
    }

    public void executeContext(Context context, PrintWriter mod_jk) {
        if (context.getPath().length() > 0 || !this.noRoot) {
            String docRoot = context.getServletContext().getRealPath("/");
            if (this.forwardAll || docRoot == null) {
                this.generateStupidMappings(context, mod_jk);
            } else {
                this.generateContextMappings(context, mod_jk);
            }
        }
    }

    protected void generateStupidMappings(Context context, PrintWriter mod_jk) {
    }

    protected void generateContextMappings(Context context, PrintWriter mod_jk) {
    }

    protected PrintWriter getWriter() throws IOException {
        return null;
    }

    protected Host getHost(Container child) {
        while (child != null && !(child instanceof Host)) {
            child = child.getParent();
        }
        return (Host)child;
    }

    public void setAppend(boolean apnd) {
        this.append = apnd;
    }

    public void setForwardAll(boolean b) {
        this.forwardAll = b;
    }

    public void setNoRoot(boolean b) {
        this.noRoot = b;
    }

    public void setConfigHome(String dir) {
        if (dir == null) {
            return;
        }
        File f = new File(dir);
        if (!f.isDirectory()) {
            throw new IllegalArgumentException("BaseConfig.setConfigHome(): Configuration Home must be a directory! : " + dir);
        }
        this.configHome = f;
    }

    public void setWorkersConfig(String path) {
        this.workersConfig = path == null ? null : new File(path);
    }

    public void setJkLog(String path) {
        this.jkLog = path == null ? null : new File(path);
    }

    public void setJkDebug(String level) {
        this.jkDebug = level;
    }

    public void setJkWorker(String worker) {
        this.jkWorker = worker;
    }

    protected void initProperties() {
        this.tomcatHome = System.getProperty("catalina.home");
        File tomcatDir = new File(this.tomcatHome);
        if (this.configHome == null) {
            this.configHome = tomcatDir;
        }
    }

    protected boolean addExtensionMapping(String ctxPath, String ext, PrintWriter pw) {
        return true;
    }

    protected boolean addMapping(String fullPath, PrintWriter pw) {
        return true;
    }

    protected String getAbsoluteDocBase(Context context) {
        String docBase = context.getServletContext().getRealPath("/");
        if (!BaseJkConfig.isAbsolute(docBase = docBase.substring(0, docBase.length() - 1))) {
            docBase = this.tomcatHome + "/" + docBase;
        }
        docBase = BaseJkConfig.patch(docBase);
        return docBase;
    }

    public static File getConfigFile(File base, File configDir, String defaultF) {
        File parent;
        if (base == null) {
            base = new File(defaultF);
        }
        if (!base.isAbsolute()) {
            base = configDir != null ? new File(configDir, base.getPath()) : new File(base.getAbsolutePath());
        }
        if (!(parent = new File(base.getParent())).exists() && !parent.mkdirs()) {
            throw new RuntimeException("Unable to create path to config file :" + base.getAbsolutePath());
        }
        return base;
    }

    public static String patch(String path) {
        char[] ca;
        String patchPath = path;
        if (patchPath.length() >= 3 && patchPath.charAt(0) == '/' && Character.isLetter(patchPath.charAt(1)) && patchPath.charAt(2) == ':') {
            patchPath = patchPath.substring(1, 3) + "/" + patchPath.substring(3);
        }
        if (patchPath.length() >= 2 && Character.isLetter(patchPath.charAt(0)) && patchPath.charAt(1) == ':') {
            ca = patchPath.replace('/', '\\').toCharArray();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < ca.length) {
                if (ca[i] != '\\' || ca[i] == '\\' && i > 0 && ca[i - 1] != '\\') {
                    char c = i == 0 && Character.isLetter(ca[i]) && i < ca.length - 1 && ca[i + 1] == ':' ? Character.toUpperCase(ca[i]) : ca[i];
                    sb.append(c);
                }
                ++i;
            }
            patchPath = sb.toString();
        }
        if (System.getProperty("os.name").startsWith("NetWare") && path.length() >= 3 && path.indexOf(58) > 0) {
            ca = patchPath.replace('/', '\\').toCharArray();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < ca.length) {
                if (ca[i] != '\\' || ca[i] == '\\' && i > 0 && ca[i - 1] != '\\') {
                    sb.append(ca[i]);
                }
                ++i;
            }
            patchPath = sb.toString();
        }
        return patchPath;
    }

    public static boolean isAbsolute(String path) {
        if (path.startsWith("/")) {
            return true;
        }
        if (path.startsWith(File.separator)) {
            return true;
        }
        if (path.length() >= 3 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
            return true;
        }
        return System.getProperty("os.name").startsWith("NetWare") && path.length() >= 3 && path.indexOf(58) > 0;
    }

    protected void log(String msg) {
        System.err.println(msg);
    }
}

