/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.NSServletResponse;
import com.iplanet.server.http.servlet.NSServletSession;
import com.iplanet.server.http.servlet.WServletContext;
import com.iplanet.server.http.util.ResUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class NSHttpServletResponse
extends NSServletResponse
implements HttpServletResponse {
    private static ResUtil _res = ResUtil.getDefaultResUtil();

    public NSHttpServletResponse(WServletContext wServletContext, NSServletSession nSServletSession) {
        super(wServletContext, nSServletSession);
        this._session.setHttpServletResponse(this, wServletContext.getResponseCookieVersion(), wServletContext.shouldEncodeCookies());
    }

    void _addCookie(Cookie cookie) {
        this._session.addCookie(cookie);
    }

    void _sendError(int n, String string) throws IOException, IllegalStateException {
        if (this.isCommitted()) {
            throw new IllegalStateException(_res.getProp("servlet.NSHttpServletResponse.msg_illegalStateException"));
        }
        this.clearOutputStream();
        this.markOutputStreamClosed();
        this._session.setResponseStatus(n, null, string);
        this._session.setResponseError(true);
        this._context.incrementErrorCount();
    }

    public void addCookie(Cookie cookie) {
        if (!this._withinInclude) {
            this._addCookie(cookie);
        }
    }

    public void addDateHeader(String string, long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyy HH:mm:ss");
        this.addHeader(string, simpleDateFormat.format(new Date(l)));
    }

    public void addHeader(String string, String string2) {
        if (!this._withinInclude) {
            this._session.addHeader(string, string2);
        }
    }

    public void addIntHeader(String string, int n) {
        this.addHeader(string, Integer.toString(n));
    }

    public boolean containsHeader(String string) {
        return this._session.getResponseHeader(string) != null;
    }

    public String encodeRedirectURL(String string) {
        return this.encodeURL(string);
    }

    public String encodeRedirectUrl(String string) {
        return this.encodeRedirectURL(string);
    }

    public String encodeURL(String string) {
        if (string == null || this._session.getHttpServletRequest().isRequestedSessionIdFromCookie()) {
            return string;
        }
        String string2 = string;
        String string3 = null;
        int n = string.indexOf(63);
        if (n != -1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = null;
        try {
            HttpSession httpSession = this._session.getHttpServletRequest().getSession(false);
            if (httpSession != null) {
                string4 = httpSession.getId();
            }
        }
        catch (IllegalStateException illegalStateException) {}
        if (string4 != null) {
            stringBuffer.append(String.valueOf(string2) + ";jsessionid=" + string4);
        } else {
            stringBuffer.append(string2);
        }
        if (string3 != null) {
            stringBuffer.append("?" + string3);
        }
        return stringBuffer.toString();
    }

    public String encodeUrl(String string) {
        return this.encodeURL(string);
    }

    public void sendError(int n) throws IOException, IllegalStateException {
        this.sendError(n, null);
    }

    public void sendError(int n, String string) throws IOException, IllegalStateException {
        if (!this._withinInclude) {
            this._sendError(n, string);
        }
    }

    public void sendRedirect(String string) throws IOException, IllegalStateException {
        if (this.isCommitted()) {
            throw new IllegalStateException(_res.getProp("servlet.NSHttpServletResponse.msg_illegalStateException"));
        }
        if (string != null && !this._withinInclude) {
            if (string.indexOf("http") != -1) {
                this.setHeader("Location", string);
            } else {
                if (!string.startsWith("/")) {
                    int n;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(this._context.getContextPath());
                    String string2 = this._session.getServletPath();
                    if (string2 != null && (n = string2.lastIndexOf(47)) > 0) {
                        stringBuffer.append(string2.substring(0, n));
                    }
                    stringBuffer.append('/');
                    stringBuffer.append(string);
                    string = stringBuffer.toString();
                }
                this.setHeader("Location", this._session.getLocation(string));
            }
            this._session.setResponseStatus(302, null);
        }
    }

    public void setDateHeader(String string, long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyy HH:mm:ss");
        this.setHeader(string, simpleDateFormat.format(new Date(l)));
    }

    public void setHeader(String string, String string2) {
        if (!this._withinInclude) {
            this._session.setHeader(string, string2);
        }
    }

    public void setIntHeader(String string, int n) {
        this.setHeader(string, Integer.toString(n));
    }

    public void setStatus(int n) {
        if (!this._withinInclude) {
            this._session.setResponseStatus(n, null);
        }
    }

    public void setStatus(int n, String string) {
        if (!this._withinInclude) {
            this._session.setResponseStatus(n, string);
        }
    }
}

