/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.NSServletWrapper;
import com.iplanet.server.http.util.LogUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WrapperFilter
implements Filter {
    private NSServletWrapper sw;
    private FilterConfig filterConfig = null;

    public void destroy() {
        if (this.sw != null) {
            this.sw.release();
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            HttpServlet httpServlet = (HttpServlet)this.sw.getServlet();
            if (LogUtil.enableTrace) {
                LogUtil.TRACE((int)7, (String)("WrapperServlet -- Invoking servlet.service() for " + this.sw.getServletName()));
            }
            httpServlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (ClassCastException classCastException) {
            this.sw.getServlet().service(servletRequest, servletResponse);
        }
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public Servlet getServlet() {
        Servlet servlet = null;
        if (this.sw != null) {
            servlet = this.sw.getServlet();
        }
        return servlet;
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        if (filterConfig == null) {
            this.sw.release();
        }
    }

    public void setServlet(NSServletWrapper nSServletWrapper) {
        this.sw = nSServletWrapper;
        nSServletWrapper.acquire();
    }
}

