/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.logging.DSLogViewerModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.sun.java.swing.Box;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.EmptyBorder;
import com.sun.java.swing.event.TableModelEvent;
import com.sun.java.swing.event.TableModelListener;
import com.sun.java.swing.table.TableColumn;
import com.sun.java.swing.table.TableColumnModel;
import com.sun.java.swing.table.TableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class DSLogViewer
extends BlankPanel
implements TableModelListener {
    private JTable _table;
    private boolean _initialized = false;
    private int _y;
    private JTextField _tfLines;
    private JTextField _tfFilter;
    private JComboBox _cbFilename;
    private String _configDN;
    private String _configAttr;
    private String _configListAttr;
    private ResourceSet _resource = DSUtil._resource;
    private static final String _section = "logcontent";

    public DSLogViewer(IDSModel dsmodel, DSLogViewerModel model, String dn, String attrName, String listAttrName) {
        super(dsmodel, false);
        this._configDN = dn;
        this._configAttr = attrName;
        this._configListAttr = listAttrName;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        if (dn != null && attrName != null) {
            this.createFileSelectionArea(panel);
        }
        this.createLineCountArea(panel);
        this._table = this.createTable(model);
        this._table.setFont(new Font("Monospaced", 0, 10));
        JScrollPane jscrollpane = new JScrollPane((Component)this._table);
        jscrollpane.setMinimumSize(new Dimension(300, 200));
        jscrollpane.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        this._myPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = this.getGBC();
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        this._myPanel.add((Component)panel, gbc);
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this._myPanel.add((Component)jscrollpane, gbc);
        this.refreshFileSelector();
    }

    public DSLogViewer(IDSModel dsmodel, DSLogViewerModel model) {
        this(dsmodel, model, null, null, null);
    }

    protected void refreshFileSelector() {
        this._cbFilename.removeItemListener((ItemListener)((Object)this));
        this._cbFilename.removeAllItems();
        LDAPConnection ldc = this.getModel().getServerInfo().getLDAPConnection();
        String[] attrs = new String[]{this._configAttr, this._configListAttr};
        try {
            LDAPEntry entry = ldc.read(this._configDN, attrs);
            if (entry != null) {
                Enumeration en;
                LDAPAttribute attr = entry.getAttribute(attrs[0]);
                if (attr != null) {
                    en = attr.getStringValues();
                    while (en.hasMoreElements()) {
                        this._cbFilename.addItem((Object)((String)en.nextElement()));
                    }
                }
                if ((attr = entry.getAttribute(attrs[1])) != null) {
                    en = attr.getStringValues();
                    while (en.hasMoreElements()) {
                        this._cbFilename.addItem((Object)((String)en.nextElement()));
                    }
                }
            }
        }
        catch (LDAPException e) {
            Debug.println((String)("AccessLogContentPanel.refreshFileSelector: " + (Object)((Object)e)));
        }
        this._cbFilename.setSelectedIndex(0);
        if (this._table != null) {
            ((DSLogViewerModel)this._table.getModel()).setLogFileName((String)this._cbFilename.getSelectedItem());
        }
        this._cbFilename.addItemListener((ItemListener)((Object)this));
    }

    private void createFileSelectionArea(JPanel parent) {
        this._cbFilename = this.makeJComboBox();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel label = this.makeJLabel(_section, "selectlog");
        this._myPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = this.getGBC();
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 17;
        panel.add((Component)label, gbc);
        panel.add(Box.createHorizontalStrut((int)UIFactory.getComponentSpace()), gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        panel.add((Component)this._cbFilename, gbc);
        gbc = this.getGBC();
        gbc.gridheight = 1;
        gbc.gridx = 0;
        gbc.gridy = this._y++;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        parent.add((Component)panel, gbc);
    }

    private void createLineCountArea(JPanel parent) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int space = UIFactory.getComponentSpace();
        GridBagConstraints gbc = this.getGBC();
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(6, 0, 6, 0);
        gbc.anchor = 17;
        JLabel label = this.makeJLabel(_section, "lines");
        panel.add((Component)label, gbc);
        panel.add(Box.createHorizontalStrut((int)space), gbc);
        this._tfLines = this.makeJTextField(_section, "lines");
        gbc.fill = 2;
        gbc.weightx = 0.0;
        panel.add((Component)this._tfLines, gbc);
        panel.add(Box.createHorizontalStrut((int)space), gbc);
        panel.add(Box.createHorizontalStrut((int)space), gbc);
        label = this.makeJLabel(_section, "filter");
        gbc.fill = 0;
        gbc.weightx = 0.0;
        panel.add((Component)label, gbc);
        panel.add(Box.createHorizontalStrut((int)space), gbc);
        this._tfFilter = this.makeJTextField(_section, "filter");
        gbc.fill = 2;
        gbc.weightx = 1.0;
        panel.add((Component)this._tfFilter, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc = this.getGBC();
        gbc.gridheight = this._y + 1;
        gbc.gridx = 0;
        gbc.gridy = this._y++;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        parent.add((Component)panel, gbc);
    }

    private JTable createTable(DSLogViewerModel model) {
        JTable table = new JTable((TableModel)model);
        table.setAutoCreateColumnsFromModel(true);
        table.setAutoResizeMode(0);
        table.sizeColumnsToFit(true);
        table.getTableHeader().setReorderingAllowed(false);
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.getModel().addTableModelListener((TableModelListener)this);
        return table;
    }

    protected int getTotalColumnWidth(JTable table) {
        Enumeration en = table.getColumnModel().getColumns();
        int width = 0;
        while (en.hasMoreElements()) {
            TableColumn col = (TableColumn)en.nextElement();
            width += col.getWidth();
        }
        return width;
    }

    protected void setColumnPreferredWidth() {
        JTable table = this.getTable();
        TableModel model = table.getModel();
        TableColumnModel colModel = table.getColumnModel();
        int rowCnt = model.getRowCount();
        int colCnt = model.getColumnCount();
        int[] prefWidth = new int[colCnt];
        int col = 0;
        while (col < colCnt) {
            prefWidth[col] = 0;
            ++col;
        }
        int row = 0;
        while (row < rowCnt) {
            int col2 = 0;
            while (col2 < colCnt) {
                int strlen = model.getValueAt(row, col2).toString().length();
                if (strlen > prefWidth[col2]) {
                    prefWidth[col2] = strlen;
                }
                ++col2;
            }
            ++row;
        }
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(table.getFont());
        int chWidth = fm.stringWidth("m");
        int col3 = 0;
        while (col3 < colCnt) {
            colModel.getColumn(col3).setPreferredWidth(prefWidth[col3] * chWidth + chWidth);
            ++col3;
        }
    }

    public void tableChanged(TableModelEvent e) {
    }

    public JTable getTable() {
        return this._table;
    }

    public boolean refresh() {
        this.refreshFileSelector();
        return this.updateContents();
    }

    boolean updateContents() {
        DSLogViewerModel model = (DSLogViewerModel)this.getTable().getModel();
        Debug.println((String)("DSLogViewer.updateContents: " + model.getLogFileName()));
        String filter = this._tfFilter.getText();
        if (filter.length() < 1) {
            filter = null;
        }
        model.setFilter(filter);
        String countString = this._tfLines.getText();
        if (countString.length() > 0) {
            model.setLineCount(Integer.parseInt(countString));
        }
        model.updateNow();
        this.setColumnPreferredWidth();
        return true;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this._cbFilename)) {
            String name;
            int index = this._cbFilename.getSelectedIndex();
            if (index >= 0 && (name = (String)this._cbFilename.getItemAt(index)) != null && this._table != null) {
                DSLogViewerModel model = (DSLogViewerModel)this._table.getModel();
                model.setLogFileName(name);
                this.updateContents();
            }
        } else {
            super.itemStateChanged(e);
        }
    }
}

