/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv;

import com.netscape.management.admserv.AdminResourceModel;
import com.netscape.management.admserv.AdminResourcePage;
import com.netscape.management.admserv.AdminServer;
import com.netscape.management.admserv.panel.AdminConfigData;
import com.netscape.management.admserv.task.AdminTaskObject;
import com.netscape.management.client.FrameworkInitializer;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceModel;
import com.netscape.management.client.TaskObject;
import com.netscape.management.client.TaskPage;
import com.netscape.management.client.UIPermissions;
import com.netscape.management.client.console.Console;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.UITools;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Hashtable;

public class AdminFrameworkInitializer
extends FrameworkInitializer {
    private static String PERMID_SECURITY = "SecurityVisibility";
    public static boolean canAccessSecurity = false;

    public AdminFrameworkInitializer(ConsoleInfo consoleInfo) {
        Console.setConsoleInfo((ConsoleInfo)consoleInfo);
        UIPermissions uip = new UIPermissions(LDAPUtil.getAdminGlobalParameterEntry());
        canAccessSecurity = uip.hasPermission(PERMID_SECURITY);
        TaskPage taskPage = new TaskPage(consoleInfo);
        TaskObject root = (TaskObject)taskPage.getModel().getRoot();
        if (AdminConfigData.isWindowsNTPlatform(consoleInfo)) {
            this.removeTask(root, "SNMPSetup");
        }
        this.addPage((IPage)taskPage);
        String[] taskList = this.getTaskList(taskPage);
        this.setTaskConsoleInfo(taskPage, consoleInfo);
        this.addPage((IPage)new AdminResourcePage((IResourceModel)new AdminResourceModel(consoleInfo, taskList)));
        RemoteImage imageIcon = UITools.getOS().equals("Win32") ? new RemoteImage(AdminServer._resource.getString("admin", "smallIcon")) : new RemoteImage(AdminServer._resource.getString("admin", "largeIcon"));
        this.setMinimizedImage(imageIcon.getImage());
        this.setBannerImage(this.getBannerImage(consoleInfo));
        this.setFrameTitle(consoleInfo.getLDAPConnection(), consoleInfo.getCurrentDN());
        this.setBannerText(AdminServer._resource.getString("admin", "version"));
    }

    private Image getBannerImage(ConsoleInfo consoleInfo) {
        String imageBase = "com/netscape/management/admserv/images/";
        return new RemoteImage(imageBase + "admin51.gif").getImage();
    }

    private String[] getTaskList(TaskPage taskPage) {
        TaskObject root = (TaskObject)taskPage.getModel().getRoot();
        String[] tasks = new String[root.getChildCount()];
        int i = 0;
        while (i < root.getChildCount()) {
            tasks[i] = root.getChildAt(i).getClass().getName();
            ++i;
        }
        return tasks;
    }

    private void setTaskConsoleInfo(TaskPage taskPage, ConsoleInfo consoleInfo) {
        TaskObject root = (TaskObject)taskPage.getModel().getRoot();
        int i = 0;
        while (i < root.getChildCount()) {
            AdminTaskObject task = (AdminTaskObject)((Object)root.getChildAt(i));
            task.setConsoleInfo(new TaskConsoleInfo(task.getConsoleInfo(), consoleInfo));
            ++i;
        }
    }

    private void removeTask(TaskObject root, String taskName) {
        int i = 0;
        while (i < root.getChildCount()) {
            if (root.getChildAt(i).getClass().getName().endsWith(taskName)) {
                root.remove(i);
                break;
            }
            ++i;
        }
    }

    private static class TaskConsoleInfo
    extends ConsoleInfo {
        private ConsoleInfo serverNodeConsoleInfo;

        public TaskConsoleInfo(ConsoleInfo taskConsoleInfo, ConsoleInfo serverNodeConsoleInfo) {
            Enumeration eKey = taskConsoleInfo.keys();
            while (eKey.hasMoreElements()) {
                Object oKey = eKey.nextElement();
                Object oValue = taskConsoleInfo.get(oKey);
                ((Hashtable)((Object)this)).put(oKey, oValue);
            }
            this.serverNodeConsoleInfo = serverNodeConsoleInfo;
        }

        public String getAdminURL() {
            return this.serverNodeConsoleInfo.getAdminURL();
        }
    }
}

