/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.config;

import com.netscape.management.admserv.config.BaseConfigPanel;
import com.netscape.management.admserv.config.ButtonBar;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class ActionMonitorPanel
extends JPanel {
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.config.config");
    static String _i18nActionAborted = _resource.getString("actionmon", "ActionAborted");
    static String _i18nTooltipInterrupt = _resource.getString("actionmon", "TooltipInterrupt");
    ThreadGroup _actionTG;
    JPanel _mainPanel;
    JLabel _lblStatus;
    JTextArea _txtStatus;
    ButtonBar _buttonBar;
    JButton _btnStop;
    ActionListener _stopListener = null;
    private static ActionMonitorPanel _activeInstance;
    boolean _multilinedStatus;
    ActionListener _stopAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ActionMonitorPanel.this.monitorProgressStop(_i18nActionAborted);
            if (ActionMonitorPanel.this._stopListener != null) {
                ActionMonitorPanel.this._stopListener.actionPerformed(e);
            }
        }
    };

    public ActionMonitorPanel() {
        this(false);
    }

    public ActionMonitorPanel(boolean multilinedStatus) {
        this.setLayout(new BorderLayout(12, 12));
        this._multilinedStatus = multilinedStatus;
        this.createUILayout();
    }

    public static ActionMonitorPanel getActiveInstance() {
        return _activeInstance;
    }

    public boolean isMultilined() {
        return this._multilinedStatus;
    }

    private void createUILayout() {
        this.createButtonBar();
        this.createMainPanel();
        this.add((Component)this._mainPanel, "Center");
        this.add((Component)this._buttonBar, "South");
    }

    public void createMainPanel() {
        this._mainPanel = new JPanel(new BorderLayout());
        if (this._multilinedStatus) {
            this._txtStatus = new JTextArea(15, 40);
            this._txtStatus.setBackground(UIManager.getColor("Button.background"));
            this._txtStatus.setEditable(false);
            this._mainPanel.add(new JScrollPane(this._txtStatus));
            Dimension d = new Dimension(550, 250);
            this.setMinimumSize(d);
            this.setPreferredSize(d);
        } else {
            this._lblStatus = new JLabel(" ", 0);
            this._mainPanel.add(this._lblStatus);
            Dimension d = new Dimension(350, 250);
            this.setMinimumSize(d);
            this.setPreferredSize(d);
        }
    }

    private void createButtonBar() {
        this._buttonBar = new ButtonBar(new String[]{"cancel"}, new String[]{ButtonBar._i18nCancelButton}, true);
        this._btnStop = this._buttonBar.getButton("cancel");
        this._btnStop.setToolTipText(_i18nTooltipInterrupt);
        this._buttonBar.addActionListener(this._stopAction);
    }

    public void monitorProgressStart(String msg, ThreadGroup tg, ActionListener stopListener) {
        if (_activeInstance != null) {
            _activeInstance.monitorProgressStop("");
        }
        this._actionTG = tg;
        this._stopListener = stopListener;
        this._btnStop.setEnabled(true);
        this.setActionBusyCursor(true, msg, this._mainPanel);
        this.setStatusText(msg);
        _activeInstance = this;
    }

    public void setInterruptEnabled(boolean flag) {
        this._btnStop.setEnabled(flag);
    }

    public synchronized void monitorProgressStop(String msg) {
        if (this._actionTG != null && Thread.currentThread().getThreadGroup() != this._actionTG) {
            this.terminateActionThreadGroup();
        }
        this.setStatusText(msg);
        this._btnStop.setEnabled(false);
        this.setActionBusyCursor(false, msg, this._mainPanel);
        this._actionTG = null;
        _activeInstance = null;
    }

    public synchronized void monitorProgressWaitForClose() {
        this._btnStop.setLabel(ButtonBar._i18nCloseButton);
        JButtonFactory.initializeMnemonic((JButton)this._btnStop);
        this._btnStop.repaint();
        this._btnStop.setToolTipText(null);
        this.setActionBusyCursor(false, "", this._mainPanel);
        _activeInstance = null;
    }

    public void setStatusText(String text) {
        if (this._multilinedStatus) {
            this._txtStatus.append("\n");
            this._txtStatus.append(text);
        } else {
            this._lblStatus.setText(text);
        }
    }

    public void setStatusTextSameLIne(String text) {
        if (this._multilinedStatus) {
            this._txtStatus.append(text);
        } else {
            this._lblStatus.setText(text);
        }
    }

    private void terminateActionThreadGroup() {
        Debug.println((String)("Therminate Action Thread Group " + this._actionTG.activeCount()));
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._actionTG.stop();
    }

    public void setActionBusyCursor(boolean busy, String text, Component c) {
        Cursor cursor = null;
        if (busy) {
            BaseConfigPanel.setProgressIndicator(this, text, -1, 0);
            cursor = Cursor.getPredefinedCursor(3);
        } else {
            BaseConfigPanel.clearProgressIndicator(this);
            cursor = Cursor.getPredefinedCursor(0);
        }
        if (this._txtStatus != null) {
            this._txtStatus.setCursor(cursor);
        }
        if (this._lblStatus != null) {
            this._lblStatus.setCursor(cursor);
        }
        if (this._btnStop.getParent() != null) {
            this._btnStop.getParent().setCursor(cursor);
        }
    }
}

