/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.logging;

import com.netscape.management.admserv.AdminServer;
import com.netscape.management.client.comm.AbstractCommClient;
import com.netscape.management.client.comm.CommClient;
import com.netscape.management.client.comm.CommRecord;
import com.netscape.management.client.comm.HttpManager;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.logging.ILogViewerModel;
import com.netscape.management.client.logging.LogLengthCommClient;
import com.netscape.management.client.logging.LogViewerModel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.table.DefaultTableModel;

public class ErrorLogViewerModel
extends LogViewerModel {
    ConsoleInfo _consoleInfo;
    String _url;
    String _username;
    String _password;
    int _logLength = 0;
    private boolean _isInitialized = false;
    private boolean _logLengthAvailable = false;
    private boolean _logLengthCalculating = false;
    StringBuffer _logLengthStringBuffer = null;
    public static ResourceSet _resource = AdminServer._resource;

    public ErrorLogViewerModel(ConsoleInfo consoleInfo, String url) {
        this._consoleInfo = consoleInfo;
        this._url = this._consoleInfo.getAdminURL() + url;
        this._username = this._consoleInfo.getAuthenticationDN();
        this._password = this._consoleInfo.getAuthenticationPassword();
        ((DefaultTableModel)((Object)this)).addColumn(_resource.getString("log", "lineno"));
        ((DefaultTableModel)((Object)this)).addColumn(_resource.getString("log", "date"));
        ((DefaultTableModel)((Object)this)).addColumn(_resource.getString("log", "time"));
        ((DefaultTableModel)((Object)this)).addColumn(_resource.getString("log", "severity"));
        ((DefaultTableModel)((Object)this)).addColumn(_resource.getString("log", "details"));
        this._isInitialized = true;
    }

    public void populateRows(int rowStartIndex, int numRows) {
        Debug.println((int)6, (String)("ErrorLogViewer: populateRows " + rowStartIndex + " to " + (rowStartIndex + numRows)));
        try {
            URL url = new URL(this._url + "?op=read" + "&start=" + rowStartIndex + "&stop=" + (rowStartIndex + numRows) + "&" + URLEncoder.encode("name=../../../../admin-serv/logs/error"));
            HttpManager _httpManager = new HttpManager();
            ErrorLogDataClient commClient = new ErrorLogDataClient(this._username, this._password);
            _httpManager.get(url, (CommClient)commClient, (Object)this, 3);
        }
        catch (Exception e) {
            Debug.println((int)4, (String)("ErrorLogViewer: populateRows() " + e));
        }
    }

    public int getLogLength() {
        if (!this._isInitialized) {
            return -1;
        }
        long _currentTimeMillis = System.currentTimeMillis();
        if (_currentTimeMillis - this._lastLogLengthCheckTime > LogViewerModel.UPDATE_INTERVAL && !this._logLengthCalculating) {
            this._lastLogLengthCheckTime = _currentTimeMillis;
            try {
                this._logLengthCalculating = true;
                this._logLengthAvailable = false;
                this._logLengthStringBuffer = new StringBuffer();
                URL url = new URL(this._url + "?op=count" + "&" + URLEncoder.encode("name=../../../../admin-serv/logs/error"));
                HttpManager _httpManager = new HttpManager();
                ErrorLogLengthCommClient commClient = new ErrorLogLengthCommClient(this._username, this._password);
                _httpManager.get(url, (CommClient)commClient, (Object)this._logLengthStringBuffer, 3);
            }
            catch (Exception e) {
                this._logLengthCalculating = false;
                Debug.println((int)4, (String)("ErrorLogViewer: getLogLength(): " + e));
            }
        }
        if (this._logLengthAvailable) {
            try {
                this._logLength = Integer.parseInt(this._logLengthStringBuffer.toString());
                Debug.println((int)6, (String)("ErrorLogViewer: _logLength=" + this._logLength));
            }
            catch (NumberFormatException e) {
                Debug.println((int)4, (String)("ErrorLogViewer: Cannot convert log length: " + this._logLengthStringBuffer.toString()));
            }
        }
        return this._logLength;
    }

    public class ErrorLogLengthCommClient
    extends LogLengthCommClient {
        public ErrorLogLengthCommClient(String username, String password) {
            super(username, password);
            Debug.println((int)9, (String)"ErrorLogViewer: ErrorLogLengthCommClient.<init>");
        }

        public synchronized void finish() {
            super.finish();
            ErrorLogViewerModel.this._logLengthAvailable = true;
            ErrorLogViewerModel.this._logLengthCalculating = false;
            ErrorLogViewerModel.this.tableDataChanged();
            Debug.println((int)9, (String)"ErrorLogViewer: ErrorLogLengthCommClient.finish()");
        }
    }

    class ErrorLogDataClient
    extends AbstractCommClient {
        final int STATE_START = 0;
        final int STATE_DATE = 1;
        final int STATE_TIME = 2;
        final int STATE_SEVERITY = 3;
        final int STATE_DETAIL = 4;
        protected LogViewerModel _model;

        public ErrorLogDataClient(String username, String password) {
            super(username, password);
        }

        protected ErrorLogData parse(String logEntry) {
            StringBuffer buffer = new StringBuffer(logEntry);
            ErrorLogData data = new ErrorLogData();
            int bufferLength = buffer.length();
            int state = 0;
            int index = 0;
            while (index < bufferLength) {
                char character = buffer.charAt(index);
                switch (state) {
                    case 0: {
                        if (character != '[') break;
                        state = 1;
                        break;
                    }
                    case 1: {
                        if (character == ':') {
                            state = 2;
                            break;
                        }
                        data.date.append(character);
                        break;
                    }
                    case 2: {
                        if (character == ']') {
                            state = 3;
                            break;
                        }
                        data.time.append(character);
                        break;
                    }
                    case 3: {
                        if (character == ':') {
                            state = 4;
                            break;
                        }
                        if (character == ' ') break;
                        data.severity.append(character);
                        break;
                    }
                    case 4: {
                        data.detail.append(character);
                    }
                }
                ++index;
            }
            return data;
        }

        public void replyHandler(InputStream replyStream, CommRecord cr) {
            BufferedReader replyBuffer = new BufferedReader(new InputStreamReader(replyStream));
            ILogViewerModel model = (ILogViewerModel)cr.getArg();
            int rowOffset = model.getRowOffset();
            int bufferLength = model.getBufferLength();
            String logEntry = null;
            int rowIndex = 0;
            while (rowIndex < bufferLength) {
                try {
                    logEntry = replyBuffer.readLine();
                }
                catch (Exception e) {
                    Debug.println((int)4, (String)("ErrorLogViewer: repxlyHandler() " + e));
                }
                if (logEntry == null) break;
                ErrorLogData d = this.parse(logEntry);
                model.setValueAt(Integer.toString(rowOffset + rowIndex), rowIndex, 0);
                model.setValueAt(d.date, rowIndex, 1);
                model.setValueAt(d.time, rowIndex, 2);
                model.setValueAt(d.severity, rowIndex, 3);
                model.setValueAt(d.detail, rowIndex, 4);
                ++rowIndex;
            }
            this.finish();
        }

        public synchronized void finish() {
            super.finish();
            ErrorLogViewerModel.this.tableDataChanged();
        }

        class ErrorLogData {
            StringBuffer date = new StringBuffer();
            StringBuffer time = new StringBuffer();
            StringBuffer severity = new StringBuffer();
            StringBuffer detail = new StringBuffer();

            ErrorLogData() {
            }
        }
    }
}

