/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.GBC;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.CGISNMPSetup;
import com.netscape.management.admserv.panel.EditableList;
import com.netscape.management.admserv.panel.ManagerEditPanel;
import com.netscape.management.admserv.panel.SNMPManagerPanel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class ManagerList
extends EditableList {
    ManagerEditPanel _editPanel;
    JPanel _detailsPanel;
    JLabel _lblDetailsManager;
    JLabel _lblDetailsPort;
    JLabel _lblDetailsCommunity;
    Vector _managers;
    int _editEntryIdx = -1;
    static String _i18nEditMgr = EditableList._resource.getString("snmpmgr", "EditMgrToolTip");
    static String _i18nAddMgr = EditableList._resource.getString("snmpmgr", "AddMgrToolTip");
    static String _i18nRemoveMgr = EditableList._resource.getString("snmpmgr", "RemoveMgrToolTip");

    public ManagerList(Vector managers) {
        this.setManagers(managers);
    }

    public void setManagers(Vector managers) {
        this._managers = managers;
        this.setList(this.getManagerNames(this._managers));
    }

    Vector getManagerNames(Vector entryList) {
        Vector v = new Vector(entryList.size());
        int i = 0;
        while (i < entryList.size()) {
            Hashtable entry = (Hashtable)entryList.elementAt(i);
            v.addElement(entry.get("mananger"));
            ++i;
        }
        return v;
    }

    public JPanel getEditPanel() {
        this._editPanel = new ManagerEditPanel();
        JTextField[] txtComponents = this._editPanel.getTextComponents();
        this.setEditPanelInitalFocusComponent(txtComponents[0]);
        this.setEditPanelCommitOnEnterComponents(txtComponents);
        return this._editPanel;
    }

    public String getEditTitle() {
        return SNMPManagerPanel._i18nEditDialogTitle;
    }

    public String getAddTitle() {
        return SNMPManagerPanel._i18nAddDialogTitle;
    }

    public String getEditToolTip() {
        return _i18nEditMgr;
    }

    public String getAddToolTip() {
        return _i18nAddMgr;
    }

    public String getRemoveToolTip() {
        return _i18nRemoveMgr;
    }

    public ResourceSet getHelpResourceSet() {
        return SNMPManagerPanel._resource;
    }

    public String getHelpToken() {
        return "editSNMPManagerHelp";
    }

    public void validateEdit() throws ValidationException {
        String manager = this._editPanel.getManager();
        if (manager.length() == 0) {
            throw new ValidationException(SNMPManagerPanel._i18nManager, SNMPManagerPanel._i18nMsgEnterManager);
        }
        int idx = this.findManager(manager);
        if (idx >= 0) {
            if (this._editEntryIdx == -1) {
                throw new ValidationException(SNMPManagerPanel._i18nManager, SNMPManagerPanel._i18nMsgEntryExists);
            }
            if (idx != this._editEntryIdx) {
                throw new ValidationException(SNMPManagerPanel._i18nManager, SNMPManagerPanel._i18nMsgCanNotRename);
            }
        }
    }

    public JPanel getDetailsPanel() {
        this._detailsPanel = this.createDetailsPanel();
        return this._detailsPanel;
    }

    public String getDetailsTitle() {
        return SNMPManagerPanel._i18nDetailsGroupbox;
    }

    private JPanel createDetailsPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        GBC gbc = new GBC();
        JLabel lbl = new JLabel(SNMPManagerPanel._i18nManager);
        gbc.setInsets(0, 0, 0, 0);
        gbc.setGrid(0, 0, 1, 1);
        gbc.setSpace(0.0, 0.0, 18, 1);
        p.add((Component)lbl, gbc);
        this._lblDetailsManager = new JLabel(" ");
        gbc.setInsets(0, 10, 0, 0);
        gbc.setGrid(1, 0, 1, 1);
        gbc.setSpace(1.0, 0.0, 18, 2);
        p.add((Component)this._lblDetailsManager, gbc);
        lbl = new JLabel(SNMPManagerPanel._i18nPort);
        gbc.setInsets(10, 0, 0, 0);
        gbc.setGrid(0, 1, 1, 1);
        gbc.setSpace(0.0, 0.0, 18, 2);
        p.add((Component)lbl, gbc);
        this._lblDetailsPort = new JLabel(" ");
        gbc.setInsets(10, 10, 0, 0);
        gbc.setGrid(1, 1, 1, 1);
        gbc.setSpace(1.0, 0.0, 18, 2);
        p.add((Component)this._lblDetailsPort, gbc);
        lbl = new JLabel(SNMPManagerPanel._i18nCommunity);
        gbc.setInsets(10, 0, 0, 0);
        gbc.setGrid(0, 2, 1, 1);
        gbc.setSpace(0.0, 0.0, 18, 2);
        p.add((Component)lbl, gbc);
        this._lblDetailsCommunity = new JLabel(" ");
        gbc.setInsets(10, 10, 0, 0);
        gbc.setGrid(1, 2, 1, 1);
        gbc.setSpace(1.0, 0.0, 18, 2);
        p.add((Component)this._lblDetailsCommunity, gbc);
        return p;
    }

    public void setEditPanelParameters(String item) {
        if (item == null) {
            this._editPanel.setCommunity("public");
            this._editPanel.setPort("162");
            this._editPanel.setManager("");
            this._editEntryIdx = -1;
        } else {
            int idx = this.findManager(item);
            if (idx >= 0) {
                this._editEntryIdx = idx;
                Hashtable entry = (Hashtable)this._managers.elementAt(idx);
                String manager = (String)entry.get("mananger");
                String port = (String)entry.get("port");
                String community = (String)entry.get("community");
                this._editPanel.setManager(manager);
                this._editPanel.setPort(port);
                this._editPanel.setCommunity(community);
            } else {
                Debug.println((String)("ERROR: Manager not found: " + item));
            }
        }
    }

    public String getEditPanelItem() {
        return this._editPanel.getManager();
    }

    private int findManager(String name) {
        return CGISNMPSetup.findEntry(this._managers, "mananger", name);
    }

    public void createItem(String item) {
        this._managers.addElement(CGISNMPSetup.createManagerEntry(new String(item), new String(this._editPanel.getPort()), new String(this._editPanel.getCommunity())));
    }

    public void removeItem(String item) {
        int idx = this.findManager(item);
        if (idx >= 0) {
            this._managers.removeElementAt(idx);
        } else {
            Debug.println((String)("ERROR: Manager not found: " + item));
        }
    }

    public void updateItem(String item, boolean isRenamed) {
        int idx = this.findManager(item);
        if (idx >= 0) {
            Hashtable entry = CGISNMPSetup.createManagerEntry(new String(this._editPanel.getManager()), new String(this._editPanel.getPort()), new String(this._editPanel.getCommunity()));
            this._managers.setElementAt(entry, idx);
        } else {
            Debug.println((String)("ERROR: Manager not found: " + item));
        }
    }

    private void dumpData() {
        if (this._managers.size() == 0) {
            Debug.println((String)"No entries");
            return;
        }
        int i = 0;
        while (i < this._managers.size()) {
            Hashtable entry = (Hashtable)this._managers.elementAt(i);
            String manager = (String)entry.get("mananger");
            String port = (String)entry.get("port");
            String community = (String)entry.get("community");
            Debug.print((String)(i + "=[" + manager + " " + port + " " + community + "] "));
            ++i;
        }
        Debug.println((String)"");
    }

    public void selectItem(String item) {
        if (item == null) {
            this._lblDetailsManager.setText("");
            this._lblDetailsPort.setText("");
            this._lblDetailsCommunity.setText("");
            return;
        }
        int idx = this.findManager(item);
        if (idx >= 0) {
            Hashtable entry = (Hashtable)this._managers.elementAt(idx);
            String manager = (String)entry.get("mananger");
            String port = (String)entry.get("port");
            String community = (String)entry.get("community");
            this._lblDetailsManager.setText(manager);
            this._lblDetailsPort.setText(port);
            this._lblDetailsCommunity.setText(community);
        } else {
            Debug.println((String)("ERROR: Manager not found: " + item));
        }
    }
}

