/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.cosedit;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.propedit.NewAttributeDialog;
import com.netscape.management.client.components.DirBrowserDialog;
import com.netscape.management.client.ug.DefaultResEditorPage;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.ug.ResourcePageObservable;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import netscape.ldap.LDAPConnection;

public class ResEditorCosTemplate
extends DefaultResEditorPage
implements ActionListener,
SuiConstants,
Observer {
    ResourceEditor _resourceEditor;
    NewAttributeDialog _attributeDialog;
    ResourcePageObservable _observable;
    String _id;
    JRadioButton _pointerRadioButton;
    JRadioButton _indirectRadioButton;
    JRadioButton _classicRadioButton;
    JPanel _dnPane;
    JPanel _attrPane;
    JTextField _dnTextField;
    JTextField _attrTextField;
    JButton _dnBrowseButton;
    JButton _attrChangeButton;
    static final int POINTER_SUBTYPE = 0;
    static final int INDIRECT_SUBTYPE = 1;
    static final int CLASSIC_SUBTYPE = 2;
    static final String[] _subTypeNames = new String[]{"cosPointerDefinition", "cosIndirectDefinition", "cosClassicDefinition"};
    static ResourceSet _resource = DSUtil._resource;
    private static final String _section = "cosTemplatePage";

    public void initialize(ResourcePageObservable resourcePageObservable, ResourceEditor resourceEditor) {
        this._id = _resource.getString(_section, "id");
        this._resourceEditor = resourceEditor;
        this._observable = resourcePageObservable;
        if (this._pointerRadioButton == null) {
            this._pointerRadioButton = new JRadioButton(_resource.getString(_section, "pointerRadioButton"));
            this._indirectRadioButton = new JRadioButton(_resource.getString(_section, "indirectRadioButton"));
            this._classicRadioButton = new JRadioButton(_resource.getString(_section, "classicRadioButton"));
            this._pointerRadioButton.addActionListener(this);
            this._indirectRadioButton.addActionListener(this);
            this._classicRadioButton.addActionListener(this);
            this._dnPane = new JPanel();
            this._attrPane = new JPanel();
            this._dnTextField = new JTextField();
            this._attrTextField = new JTextField();
            this._dnBrowseButton = UIFactory.makeJButton(this, _section, "dnBrowseButton", _resource);
            this._attrChangeButton = UIFactory.makeJButton(this, _section, "attrChangeButton", _resource);
            this.layoutComponents();
        }
        this.loadFromObservable();
        this.updateComponentState();
    }

    void layoutComponents() {
        GroupPanel groupPanel = new GroupPanel(_resource.getString(_section, "label"), true);
        groupPanel.setLayout(new GridLayout(3, 1));
        groupPanel.add(this._pointerRadioButton);
        groupPanel.add(this._indirectRadioButton);
        groupPanel.add(this._classicRadioButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._pointerRadioButton);
        buttonGroup.add(this._indirectRadioButton);
        buttonGroup.add(this._classicRadioButton);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        jPanel.add(groupPanel);
        gridBagLayout.setConstraints(groupPanel, gridBagConstraints);
        jPanel.add(this._dnPane);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(12, 9, 0, 9);
        gridBagLayout.setConstraints(this._dnPane, gridBagConstraints);
        jPanel.add(this._attrPane);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(12, 9, 9, 9);
        gridBagLayout.setConstraints(this._attrPane, gridBagConstraints);
        Component component = Box.createGlue();
        jPanel.add(component);
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.layoutDnPane();
        this.layoutAttrPane();
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(null);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add("Center", jScrollPane);
    }

    void layoutDnPane() {
        String string = _resource.getString(_section, "DN");
        this._dnTextField.getAccessibleContext().setAccessibleDescription(string);
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(1), string);
        titledBorder.setTitleColor(BlankPanel.ORIG_COLOR);
        EmptyBorder emptyBorder = new EmptyBorder(6, 12, 6, 12);
        CompoundBorder compoundBorder = new CompoundBorder(titledBorder, emptyBorder);
        this._dnPane.setBorder(compoundBorder);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this._dnPane.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 1.0;
        this._dnPane.add(this._dnTextField);
        gridBagLayout.setConstraints(this._dnTextField, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this._dnPane.add(this._dnBrowseButton);
        gridBagLayout.setConstraints(this._dnBrowseButton, gridBagConstraints);
    }

    void layoutAttrPane() {
        String string = _resource.getString(_section, "attrName");
        this._attrTextField.getAccessibleContext().setAccessibleDescription(string);
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(1), string);
        EmptyBorder emptyBorder = new EmptyBorder(6, 12, 6, 12);
        CompoundBorder compoundBorder = new CompoundBorder(titledBorder, emptyBorder);
        titledBorder.setTitleColor(BlankPanel.ORIG_COLOR);
        this._attrPane.setBorder(compoundBorder);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this._attrPane.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 1.0;
        this._attrPane.add(this._attrTextField);
        gridBagLayout.setConstraints(this._attrTextField, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this._attrPane.add(this._attrChangeButton);
        gridBagLayout.setConstraints(this._attrChangeButton, gridBagConstraints);
    }

    public String getID() {
        return this._id;
    }

    public boolean save(ResourcePageObservable resourcePageObservable) throws Exception {
        String string = this._dnTextField.getText().trim();
        String string2 = this._attrTextField.getText().trim();
        int n = this.findSubTypeFromRadioButtons();
        this._observable.delete("cosTemplateDn");
        this._observable.delete("cosIndirectSpecifier");
        this._observable.delete("cosSpecifier");
        switch (n) {
            case 0: {
                if (string.length() < 1) break;
                this._observable.add("cosTemplateDn", string);
                break;
            }
            case 1: {
                if (string2.length() < 1) break;
                this._observable.add("cosIndirectSpecifier", string2);
                break;
            }
            case 2: {
                if (string.length() >= 1) {
                    this._observable.add("cosTemplateDn", string);
                }
                if (string2.length() < 1) break;
                this._observable.add("cosSpecifier", string2);
                break;
            }
            default: {
                Debug.println((String)"ResEditorCosTemplate.save: invalid subtype");
            }
        }
        this.changeObservableFromSubType(n);
        return true;
    }

    public boolean isComplete() {
        return true;
    }

    public String getDisplayName() {
        return this._id;
    }

    public void help() {
        DSUtil.help("configuration-cos-template-help");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._dnBrowseButton) {
            this.actionBrowseDirectory();
        } else if (object == this._attrChangeButton) {
            this.actionChangeAttribute();
        } else {
            this.updateComponentState();
        }
    }

    public void actionBrowseDirectory() {
        JFrame jFrame = this._resourceEditor.getFrame();
        LDAPConnection lDAPConnection = this._resourceEditor.getConsoleInfo().getLDAPConnection();
        DirBrowserDialog dirBrowserDialog = new DirBrowserDialog(jFrame, lDAPConnection);
        dirBrowserDialog.setLocationRelativeTo(this._dnBrowseButton);
        dirBrowserDialog.getAccessibleContext().setAccessibleDescription(_resource.getString(_section, "browse-description"));
        dirBrowserDialog.show();
        dirBrowserDialog.dispose();
        if (!dirBrowserDialog.isCancel()) {
            this._dnTextField.setText(dirBrowserDialog.getSelectedDN());
        }
    }

    public void actionChangeAttribute() {
        String[] stringArray;
        this._resourceEditor.setBusyCursor(true);
        if (this._attributeDialog == null) {
            this._attributeDialog = new NewAttributeDialog(this._resourceEditor.getFrame(), this._resourceEditor.getConsoleInfo());
            this._attributeDialog.setSingleSelection(true);
            ((Dialog)((Object)this._attributeDialog)).setTitle(_resource.getString(_section, "change-attribute-title"));
            ((JDialog)((Object)this._attributeDialog)).getAccessibleContext().setAccessibleDescription(_resource.getString(_section, "change-attribute-description"));
        }
        this._attributeDialog.show();
        this._attributeDialog.dispose();
        if (!this._attributeDialog.isCancel() && (stringArray = this._attributeDialog.getSelectedAttributes()) != null) {
            this._attrTextField.setText(stringArray[0]);
        }
        this._resourceEditor.setBusyCursor(false);
    }

    void updateComponentState() {
        switch (this.findSubTypeFromRadioButtons()) {
            case 0: {
                this._dnPane.setVisible(true);
                this._attrPane.setVisible(false);
                break;
            }
            case 1: {
                this._dnPane.setVisible(false);
                this._attrPane.setVisible(true);
                break;
            }
            case 2: {
                this._dnPane.setVisible(true);
                this._attrPane.setVisible(true);
                break;
            }
            default: {
                Debug.println((int)0, (String)"ResEditorCosTemplate.updateComponentState: invalid subtype");
                this._dnPane.setVisible(false);
                this._attrPane.setVisible(false);
            }
        }
    }

    public void update(Observable observable, Object object) {
    }

    void loadFromObservable() {
        String string;
        String string2;
        this.changeRadioButtonsFromSubType(this.findSubTypeFromObservable());
        String string3 = this._observable.get("cosTemplateDn", 0);
        if (string3 != null) {
            this._dnTextField.setText(string3);
        }
        if ((string2 = this._observable.get("cosSpecifier", 0)) != null && string2.length() >= 1) {
            this._attrTextField.setText(string2);
        }
        if ((string = this._observable.get("cosIndirectSpecifier", 0)) != null && string.length() >= 1) {
            this._attrTextField.setText(string);
        }
    }

    int findSubTypeFromObservable() {
        int n = -1;
        Vector vector = this._observable.get("objectclass");
        if (vector != null) {
            if (DSUtil.indexOfIgnoreCase(vector, _subTypeNames[0]) != -1) {
                n = 0;
            } else if (DSUtil.indexOfIgnoreCase(vector, _subTypeNames[1]) != -1) {
                n = 1;
            } else if (DSUtil.indexOfIgnoreCase(vector, _subTypeNames[2]) != -1) {
                n = 2;
            }
        } else {
            Debug.println((int)0, (String)"ResEditorCosTemplate.findSubTypeFromObservable: no object class");
        }
        Debug.println((String)("ResEditorCosTemplate.findSubTypeFromObservable: result = " + n));
        return n;
    }

    int findSubTypeFromRadioButtons() {
        int n = -1;
        if (this._pointerRadioButton.isSelected()) {
            n = 0;
        } else if (this._indirectRadioButton.isSelected()) {
            n = 1;
        } else if (this._classicRadioButton.isSelected()) {
            n = 2;
        } else {
            Debug.println((int)0, (String)"ResEditorCosTemplate.findSubTypeFromRadioButtons: ouah grave...");
        }
        return n;
    }

    void changeObservableFromSubType(int n) {
        Vector vector = this._observable.get("objectclass");
        int n2 = 0;
        while (n2 <= 2) {
            int n3 = DSUtil.indexOfIgnoreCase(vector, _subTypeNames[n2]);
            if (n3 != -1) {
                vector.removeElementAt(n3);
            }
            ++n2;
        }
        if (n == -1) {
            n = 0;
            Debug.println((String)"ResEditorCosTemplate.changeObservableFromSubType: using default");
        }
        vector.addElement(_subTypeNames[n]);
        this._observable.replace("objectclass", vector);
    }

    void changeRadioButtonsFromSubType(int n) {
        switch (n) {
            case 0: {
                this._pointerRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this._indirectRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this._classicRadioButton.setSelected(true);
                break;
            }
            default: {
                this._pointerRadioButton.setSelected(true);
                Debug.println((String)"ResEditorCosTemplate.changeRadioButtonsFromSubtype: using default");
            }
        }
    }

    void DebugDumpObservable(ResourcePageObservable resourcePageObservable) {
        Debug.println((String)"===========");
        Debug.println((String)("dn: " + resourcePageObservable.getDN()));
        Enumeration enumeration = resourcePageObservable.getAttributesList();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = resourcePageObservable.getValues(string);
            Debug.println((String)(string + ": " + string2));
        }
    }
}

