/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.node;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.node.DSResourceObject;
import com.netscape.admin.dirserv.node.MonitorDbResourceObject;
import com.netscape.admin.dirserv.panel.ForwardingContainerPanel;
import com.netscape.admin.dirserv.panel.MonitorServerPanel;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class MonitorResourceObject
extends DSResourceObject
implements ActionListener,
TreeExpansionListener {
    private boolean _isLeaf = false;
    private boolean _isLoaded = false;
    private boolean _monInitialized = false;
    private static final String monitorIconName = "monitors.gif";
    private static final String monitorIconNameL = "monitorsL.gif";
    private boolean _isInitiallyExpanded = false;

    public MonitorResourceObject(IDSModel iDSModel) {
        super(DSResourceObject._resource.getString("resourcepage", "PerformanceCounters"), DSUtil.getPackageImage(monitorIconName), DSUtil.getPackageImage(monitorIconNameL), iDSModel);
    }

    public Component getCustomPanel() {
        if (this._panel == null) {
            this._panel = new ForwardingContainerPanel(this._model, new MonitorServerPanel(this._model), true);
            ((ForwardingContainerPanel)this._panel).getOKButton().setVisible(false);
            ((ForwardingContainerPanel)this._panel).getCancelButton().setVisible(false);
        }
        return this._panel;
    }

    public boolean run(IPage iPage) {
        Debug.println((String)("MonitorResourceObject.run(" + iPage.getClass().getName() + ")"));
        this.reload();
        if (super.getChildCount() != 0) {
            this.expandPath((ResourcePage)iPage);
        }
        this.refreshTree();
        return true;
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        return this.run(iPage);
    }

    public void reload() {
        this.cleanTree();
        this._isLeaf = true;
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        try {
            LDAPEntry lDAPEntry = lDAPConnection.read("cn=monitor");
            if (lDAPEntry == null) {
                Debug.println((String)"MonitorResourceObject.reload: unable to read cn=monitor");
                return;
            }
            this._monInitialized = true;
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("backendmonitordn");
            int n = lDAPAttribute.size();
            Enumeration enumeration = lDAPAttribute.getStringValues();
            Debug.println((String)("MonitorResourceObject.reload en.hasMoreElements :" + enumeration.hasMoreElements()));
            while (enumeration.hasMoreElements()) {
                this._isLeaf = false;
                String string = (String)enumeration.nextElement();
                DN dN = new DN(string);
                if (dN.isDescendantOf(new DN("cn=ldbm database,cn=plugins,cn=config"))) {
                    MonitorDbResourceObject monitorDbResourceObject = new MonitorDbResourceObject(this._model, string);
                    ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)monitorDbResourceObject));
                    continue;
                }
                if (!dN.isDescendantOf(new DN("cn=chaining database,cn=plugins,cn=config"))) continue;
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("MonitorResourceObject.reload: " + (Object)((Object)lDAPException)));
        }
        this.refreshTree();
        this._isLoaded = true;
    }

    public void select(IPage iPage) {
        if (!this.isLoaded()) {
            this.reload();
        }
        super.select(iPage);
    }

    public boolean isLoaded() {
        return this._isLoaded;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("refresh")) {
            this.reload();
        }
    }

    void refreshTree() {
        this._model.fireTreeStructureChanged(this);
    }

    private void expandPath(ResourcePage resourcePage) {
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)((Object)this)).getPath());
        resourcePage.expandTreePath(treePath);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        IResourceObject iResourceObject = (IResourceObject)treeExpansionEvent.getPath().getLastPathComponent();
        if (this.equals(iResourceObject) && !this._isInitiallyExpanded) {
            this._isInitiallyExpanded = true;
            Debug.println((String)"MonitorResourceObject.treeExpanded: this");
            if (!this.isLoaded()) {
                this.reload();
            }
        }
    }

    public boolean isLeaf() {
        return this._isLeaf;
    }

    private void cleanTree() {
        ((DefaultMutableTreeNode)((Object)this)).removeAllChildren();
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }
}

