/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;

public class BackupPanel
extends BlankPanel {
    protected JLabel _filenameLabel;
    protected JButton _bAuto;
    protected JTextField _tfExport;
    protected JButton _bExport;
    protected JButton _browseButton;
    private String _baseDir = "";
    private static final String _section = "backup";

    public BackupPanel(IDSModel iDSModel) {
        super(iDSModel, _section);
        this._helpToken = "tasks-backup-help";
    }

    public void init() {
        String string = this.getInstanceDirectory();
        if (string != null) {
            this._baseDir = string + "/bak";
        }
        this._myPanel.setLayout(new GridBagLayout());
        this.createFileArea(this._myPanel);
        this.setDefaultDirectory();
        this.getSimpleDialog().setFocusComponent(this._tfExport);
    }

    protected void createFileArea(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = (Insets)gridBagConstraints.insets.clone();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this._filenameLabel = this.makeJLabel(_section, "filename");
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this._filenameLabel, gridBagConstraints);
        this._tfExport = this.makeJTextField(_section, "filename");
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this._tfExport, gridBagConstraints);
        this._filenameLabel.setLabelFor(this._tfExport);
        if (this.isLocal()) {
            this._bExport = this.makeJButton(_section, "browse-file");
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridwidth = 0;
            jPanel2.add((Component)this._bExport, gridBagConstraints);
            gridBagConstraints.insets.top = UIFactory.getDifferentSpace();
            this._bExport.setEnabled(true);
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add(Box.createGlue(), gridBagConstraints);
        }
        this._bAuto = this.makeJButton(_section, "autoName");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)this._bAuto, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        jPanel.add(Box.createGlue(), gridBagConstraints);
    }

    protected void checkOkay() {
        String string = this.getFilename();
        boolean bl = string != null && string.length() > 0;
        SimpleDialog simpleDialog = this.getSimpleDialog();
        if (simpleDialog != null) {
            simpleDialog.setOKButtonEnabled(bl);
        }
    }

    protected void setDefaultDirectory() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String string = this._baseDir + '/' + simpleDateFormat.format(date);
        this._tfExport.setText(string);
    }

    protected SimpleDialog getSimpleDialog() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof SimpleDialog) {
                return (SimpleDialog)((Object)container);
            }
            container = container.getParent();
        }
        return null;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        super.changedUpdate(documentEvent);
        this.checkOkay();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        super.removeUpdate(documentEvent);
        this.checkOkay();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        super.insertUpdate(documentEvent);
        this.checkOkay();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._bExport)) {
            String string = this.getFilename().trim();
            if (string != null && string.length() > 1) {
                File file = new File(string);
                if (!file.isAbsolute()) {
                    string = this._baseDir + File.separator + string;
                }
            } else {
                string = this._baseDir;
            }
            if ((string = DSFileDialog.getDirectoryName(string, true, this)) != null) {
                this._tfExport.setText(string.trim());
            }
        } else if (actionEvent.getSource().equals(this._bAuto)) {
            this.setDefaultDirectory();
            this.checkOkay();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void resetCallback() {
        this.clearDirtyFlag();
        this.hideDialog();
    }

    public void okCallback() {
        String string;
        if (this.isLocal() && (string = this.getFilename()) != null) {
            File file = new File(string);
            if (!file.isAbsolute()) {
                string = this._baseDir + File.separator + string;
            }
            this._tfExport.setText(string);
        }
        this.clearDirtyFlag();
        this.hideDialog();
    }

    public String getFilename() {
        return this._tfExport.getText().trim();
    }
}

