/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.ListChooserPanel;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class ChainingSettingPanel
extends BlankPanel
implements SuiConstants {
    private IDSModel _model = null;
    private JButton _bAddControl;
    private JButton _bDelControl;
    private JButton _bAddComponent;
    private JButton _bDelComponent;
    private JLabel _compListLabel;
    private JLabel _ctrlListLabel;
    private DefaultListModel _ctrlData;
    private JList _ctrlList;
    private DefaultListModel _compData;
    private JList _compList;
    private LDAPEntry _configEntry = null;
    private String _dnEntry;
    private String[] _possibleComponent;
    private String[] _activeComponent;
    private String[] _transControls;
    private String[] _possibleControls;
    private boolean _isCtrlDirty = false;
    private boolean _isCompDirty = false;
    private static final String TRANS_CONTROL_ATTR = "nsTransmittedControls";
    private static final String POSSIBLE_CTRL_ATTR = "supportedcontrol";
    private static final String ACTIVE_COMPONENT_ATTR = "nsActiveChainingComponents";
    private static final String POSSIBLE_COMPONENT_ATTR = "nsPossibleChainingComponents";
    private static final String CONFIG_PREFIX = "cn=config,";
    private static final String _section = "chaining-settings";
    private final int ROWS = 4;
    static final int DEFAULT_PADDING = 6;
    static final Insets DEFAULT_EMPTY_INSETS = new Insets(0, 0, 0, 0);
    static final Insets BOTTOM_INSETS = new Insets(6, 6, 6, 6);
    static final String DELETE_CTRL = "deleteControl";
    static final String ADD_CTRL = "addControl";
    static final String DELETE_COMP = "deleteComponent";
    static final String ADD_COMP = "addComponent";

    public ChainingSettingPanel(IDSModel iDSModel, LDAPEntry lDAPEntry) {
        super(iDSModel, _section, true);
        this._helpToken = "configuration-chaining-settings-help";
        this._dnEntry = lDAPEntry.getDN();
        this._configEntry = lDAPEntry;
        this._model = iDSModel;
        this._refreshWhenSelect = false;
    }

    public void init() {
        if (this._isInitialized) {
            return;
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 9, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this._myPanel.setLayout(gridBagLayout);
        this.prepData();
        this._ctrlListLabel = this.makeJLabel(_section, "ctrl-list");
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this._myPanel.add((Component)this._ctrlListLabel, gridBagConstraints);
        this._ctrlData = new DefaultListModel();
        this._ctrlList = new JList(this._ctrlData);
        this._ctrlListLabel.setLabelFor(this._ctrlList);
        this._ctrlList.setVisibleRowCount(4);
        this._ctrlList.setCellRenderer(new ControlCellRenderer());
        int n = 0;
        while (this._transControls != null && n < this._transControls.length) {
            this._ctrlData.addElement(this._transControls[n]);
            ++n;
        }
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this._ctrlList);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 9, 6, 0);
        this._myPanel.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 9, 6, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        this._myPanel.add((Component)jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.insets = new Insets(0, 9, 6, 0);
        gridBagConstraints2.ipadx = 0;
        gridBagConstraints2.ipady = 0;
        this._bAddControl = UIFactory.makeJButton(this, _section, "addctrl", null);
        this._bAddControl.setActionCommand(ADD_CTRL);
        this._bAddControl.setEnabled(true);
        jPanel.add((Component)this._bAddControl, gridBagConstraints2);
        this._bDelControl = UIFactory.makeJButton(this, _section, "delctrl", null);
        this._bDelControl.setActionCommand(DELETE_CTRL);
        this._bDelControl.setEnabled(false);
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this._bDelControl, gridBagConstraints2);
        this._compListLabel = this.makeJLabel(_section, "comp-list");
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this._myPanel.add((Component)this._compListLabel, gridBagConstraints);
        this._compData = new DefaultListModel();
        this._compList = new JList(this._compData);
        this._compListLabel.setLabelFor(this._compList);
        this._compList.setVisibleRowCount(4);
        this._compList.setCellRenderer(new ControlCellRenderer());
        int n2 = 0;
        while (this._activeComponent != null && n2 < this._activeComponent.length) {
            this._compData.addElement(this._activeComponent[n2]);
            ++n2;
        }
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.getViewport().setView(this._compList);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 9, 6, 0);
        this._myPanel.add((Component)jScrollPane2, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 9, 6, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        this._myPanel.add((Component)jPanel2, gridBagConstraints);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.gridheight = 1;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.weighty = 0.0;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.anchor = 10;
        gridBagConstraints3.insets = new Insets(0, 9, 6, 0);
        gridBagConstraints3.ipadx = 0;
        gridBagConstraints3.ipady = 0;
        this._bAddComponent = UIFactory.makeJButton(this, _section, "addcomponent", null);
        this._bAddComponent.setActionCommand(ADD_COMP);
        this._bAddComponent.setEnabled(true);
        jPanel2.add((Component)this._bAddComponent, gridBagConstraints3);
        this._bDelComponent = UIFactory.makeJButton(this, _section, "delcomponent", null);
        this._bDelComponent.setActionCommand(DELETE_COMP);
        this._bDelComponent.setEnabled(false);
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this._bDelComponent, gridBagConstraints3);
        this._isInitialized = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._bAddControl)) {
            String[] stringArray = this.addControls();
            if (stringArray != null) {
                int n = stringArray.length - 1;
                while (n >= 0) {
                    this._ctrlData.addElement(stringArray[n]);
                    --n;
                }
                this.checkCtrlDirty();
            }
        } else if (actionEvent.getSource().equals(this._bDelControl)) {
            int[] nArray = this._ctrlList.getSelectedIndices();
            int n = nArray.length - 1;
            while (n >= 0) {
                this._ctrlData.removeElementAt(nArray[n]);
                --n;
            }
            this.checkCtrlDirty();
        } else if (actionEvent.getSource().equals(this._bAddComponent)) {
            String[] stringArray = this.addComponents();
            if (stringArray != null) {
                int n = stringArray.length - 1;
                while (n >= 0) {
                    this._compData.addElement(stringArray[n]);
                    --n;
                }
                this.checkCompDirty();
            }
        } else if (actionEvent.getSource().equals(this._bDelComponent)) {
            int[] nArray = this._compList.getSelectedIndices();
            int n = nArray.length - 1;
            while (n >= 0) {
                this._compData.removeElementAt(nArray[n]);
                --n;
            }
            this.checkCompDirty();
        }
        super.actionPerformed(actionEvent);
    }

    private String[] addControls() {
        ListChooserPanel listChooserPanel = new ListChooserPanel(this._model, this._possibleControls, this.getAllItemInJList(this._ctrlList), "chaining-settings-ctrl");
        SimpleDialog simpleDialog = new SimpleDialog(this.getModel().getFrame(), listChooserPanel.getTitle(), 11, listChooserPanel);
        simpleDialog.setComponent(listChooserPanel);
        simpleDialog.setOKButtonEnabled(false);
        simpleDialog.setDefaultButton(1);
        ((JDialog)((Object)simpleDialog)).getAccessibleContext().setAccessibleDescription(DSUtil._resource.getString(_section, "ctrl-chooser-dbox-description"));
        simpleDialog.packAndShow();
        String[] stringArray = (String[])listChooserPanel.getSelectedItem();
        if (stringArray != null) {
            return stringArray;
        }
        return null;
    }

    private String[] addComponents() {
        ListChooserPanel listChooserPanel = new ListChooserPanel(this._model, this._possibleComponent, this.getAllItemInJList(this._compList), "chaining-settings-comp");
        SimpleDialog simpleDialog = new SimpleDialog(this.getModel().getFrame(), listChooserPanel.getTitle(), 11, listChooserPanel);
        simpleDialog.setComponent(listChooserPanel);
        simpleDialog.setOKButtonEnabled(false);
        simpleDialog.setDefaultButton(1);
        ((JDialog)((Object)simpleDialog)).getAccessibleContext().setAccessibleDescription(DSUtil._resource.getString(_section, "ctrl-chooser-dbox-description"));
        simpleDialog.packAndShow();
        String[] stringArray = (String[])listChooserPanel.getSelectedItem();
        if (stringArray != null) {
            return stringArray;
        }
        return null;
    }

    private void checkCtrlDirty() {
        String[] stringArray = this.getAllItemInJList(this._ctrlList);
        String[] stringArray2 = MappingUtils.whatsMoreInThisList(this._transControls, stringArray);
        String[] stringArray3 = MappingUtils.whatsMoreInThisList(stringArray, this._transControls);
        boolean bl = this._isCtrlDirty = stringArray2 != null && stringArray2.length > 0 || stringArray3 != null && stringArray3.length > 0;
        if (this._isCtrlDirty) {
            this.setChangeState(this._ctrlListLabel, 2);
        } else {
            this.setChangeState(this._ctrlListLabel, 1);
        }
        this.checkDirty();
    }

    private void checkCompDirty() {
        String[] stringArray = this.getAllItemInJList(this._compList);
        String[] stringArray2 = MappingUtils.whatsMoreInThisList(this._activeComponent, stringArray);
        String[] stringArray3 = MappingUtils.whatsMoreInThisList(stringArray, this._activeComponent);
        boolean bl = this._isCompDirty = stringArray2 != null && stringArray2.length > 0 || stringArray3 != null && stringArray3.length > 0;
        if (this._isCompDirty) {
            this.setChangeState(this._compListLabel, 2);
        } else {
            this.setChangeState(this._compListLabel, 1);
        }
        this.checkDirty();
    }

    private void checkDirty() {
        if (this._isCompDirty || this._isCtrlDirty) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
    }

    private String[] getAllItemInJList(JList jList) {
        Vector vector = new Vector();
        int n = 0;
        while (n < jList.getModel().getSize()) {
            vector.addElement(jList.getModel().getElementAt(n));
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    private void prepData() {
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        this._activeComponent = DSUtil.getAttrStringValueArray(lDAPConnection, CONFIG_PREFIX + this._dnEntry, "nsActiveChainingComponents=*", ACTIVE_COMPONENT_ATTR);
        this._possibleComponent = DSUtil.getAttrStringValueArray(lDAPConnection, CONFIG_PREFIX + this._dnEntry, "nsPossibleChainingComponents=*", POSSIBLE_COMPONENT_ATTR);
        if (this._possibleComponent == null || this._possibleComponent.length == 0) {
            this._possibleComponent = DSUtil.getAttrStringValueArray(lDAPConnection, "cn=plugins,cn=config", "objectclass=nsSlapdPlugin", "dn");
        }
        this._transControls = DSUtil.getAttrStringValueArray(lDAPConnection, CONFIG_PREFIX + this._dnEntry, "nsTransmittedControls=*", TRANS_CONTROL_ATTR);
        this._possibleControls = DSUtil.getAttrStringValueArray(lDAPConnection, "", POSSIBLE_CTRL_ATTR);
    }

    private void setOkay(boolean bl) {
        AbstractDialog abstractDialog = this.getAbstractDialog();
        if (abstractDialog != null) {
            abstractDialog.setOKButtonEnabled(bl);
        }
    }

    private void checkOkay() {
        this.setOkay(this._isCtrlDirty || this._isCompDirty);
        this.modelUpdate();
    }

    private void modelUpdate() {
        if (this._isCtrlDirty || this._isCompDirty) {
            this.setDirtyFlag();
            this.setValidFlag();
        }
    }

    public void resetCallback() {
        this.prepData();
        this.populateFromServerData();
        this.clearListChanges(this._compListLabel, this._compData, this._activeComponent);
        this.clearListChanges(this._ctrlListLabel, this._ctrlData, this._transControls);
        this._isCompDirty = false;
        this._isCtrlDirty = false;
        this.clearDirtyFlag();
    }

    private void populateFromServerData() {
        this._compData.clear();
        int n = 0;
        while (this._activeComponent != null && n < this._activeComponent.length) {
            this._compData.addElement(this._activeComponent[n]);
            ++n;
        }
        this._ctrlData.clear();
        int n2 = 0;
        while (this._transControls != null && n2 < this._transControls.length) {
            this._ctrlData.addElement(this._transControls[n2]);
            ++n2;
        }
    }

    public boolean refresh() {
        this.resetCallback();
        return true;
    }

    private void clearListChanges(JComponent jComponent, DefaultListModel defaultListModel, String[] stringArray) {
        int n = defaultListModel.getSize() - 1;
        while (n >= 0) {
            defaultListModel.removeElementAt(n);
            --n;
        }
        int n2 = 0;
        while (stringArray != null && n2 < stringArray.length) {
            Debug.println((String)("ChainingSettingPanel.clearListChanges()  add : " + stringArray[n2]));
            defaultListModel.addElement(stringArray[n2]);
            ++n2;
        }
        this.setChangeState(jComponent, 1);
    }

    public void okCallback() {
        if (this._isCtrlDirty || this._isCompDirty) {
            LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
            this.prepSaveCtrl(lDAPModificationSet);
            this.prepSaveComponents(lDAPModificationSet);
            LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
            try {
                Debug.println((String)(" +++++++++ dn = cn=config," + this._dnEntry));
                lDAPConnection.modify(CONFIG_PREFIX + this._dnEntry, lDAPModificationSet);
                this._activeComponent = this.getAllItemInJList(this._compList);
                this._transControls = this.getAllItemInJList(this._ctrlList);
                this.checkCtrlDirty();
                this.checkCompDirty();
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{this._configEntry.getDN(), lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "update-error", stringArray, _section);
            }
        }
    }

    private void prepSaveCtrl(LDAPModificationSet lDAPModificationSet) {
        String[] stringArray = this.getAllItemInJList(this._ctrlList);
        Debug.println((String)"ChainingSettingPanel.prepSaveCtrl :");
        String[] stringArray2 = MappingUtils.whatsMoreInThisList(this._transControls, stringArray);
        String[] stringArray3 = MappingUtils.whatsMoreInThisList(stringArray, this._transControls);
        if (stringArray2 != null && stringArray2.length != 0) {
            int n = 0;
            while (n < stringArray2.length) {
                Debug.println((String)(" ++ newCtrl[" + n + "]=" + stringArray2[n++]));
            }
            lDAPModificationSet.add(0, new LDAPAttribute(TRANS_CONTROL_ATTR, stringArray2));
        }
        if (stringArray3 != null && stringArray3.length != 0) {
            lDAPModificationSet.add(1, new LDAPAttribute(TRANS_CONTROL_ATTR, stringArray3));
        }
    }

    private void prepSaveComponents(LDAPModificationSet lDAPModificationSet) {
        int n;
        String[] stringArray = this.getAllItemInJList(this._compList);
        Debug.println((String)"ChainingSettingPanel.prepSaveComponents :");
        String[] stringArray2 = MappingUtils.whatsMoreInThisList(this._activeComponent, stringArray);
        String[] stringArray3 = MappingUtils.whatsMoreInThisList(stringArray, this._activeComponent);
        if (stringArray2 != null && stringArray2.length != 0) {
            n = 0;
            while (n < stringArray2.length) {
                Debug.println((String)(" add  newComp[" + n + "]=" + stringArray2[n]));
                ++n;
            }
            lDAPModificationSet.add(0, new LDAPAttribute(ACTIVE_COMPONENT_ATTR, stringArray2));
        }
        if (stringArray3 != null && stringArray3.length != 0) {
            n = 0;
            while (n < stringArray3.length) {
                Debug.println((String)(" delete  removeComp[" + n + "]=" + stringArray3[n]));
                ++n;
            }
            lDAPModificationSet.add(1, new LDAPAttribute(ACTIVE_COMPONENT_ATTR, stringArray3));
        }
    }

    class ControlCellRenderer
    extends DefaultListCellRenderer {
        ControlCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (jList == ChainingSettingPanel.this._ctrlList) {
                if (jList.isSelectionEmpty()) {
                    ChainingSettingPanel.this._bDelControl.setEnabled(false);
                } else {
                    ChainingSettingPanel.this._bDelControl.setEnabled(true);
                }
            } else if (jList == ChainingSettingPanel.this._compList) {
                if (jList.isSelectionEmpty()) {
                    ChainingSettingPanel.this._bDelComponent.setEnabled(false);
                } else {
                    ChainingSettingPanel.this._bDelComponent.setEnabled(true);
                }
            }
            ChainingSettingPanel.this.checkOkay();
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }
}

