/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.MappingNodeBckPanel;
import com.netscape.admin.dirserv.panel.MappingNodeRefPanel;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class MappingNodeSettingPanel
extends BlankPanel
implements SuiConstants {
    private JTextField _mappingNameText;
    private JLabel _mappingNameLabel;
    private JLabel _NodeText;
    private JLabel _NodeLabel;
    private JLabel _DadyNodeText;
    private JLabel _DadyNodeLabel;
    private IDSModel _model = null;
    private JRadioButton _rbBackend;
    private JRadioButton _rbReferral;
    private JRadioButton _rbRefUpdate;
    private boolean _isEnabledNode = false;
    private boolean _isBackendNode = false;
    private boolean _isReferral = false;
    private boolean _isRefUpdate = false;
    private boolean _isStateDirty = false;
    private String _saveStatus = null;
    private JCheckBox _cbEnableNode = null;
    private static final String _section = "mappingtree-setting";
    static final String CONFIG_BASEDN = "cn=plugins,cn=config";
    static final String CONFIG_MAPPING = "cn=mapping tree,cn=config";
    static final String DISABLE = "Disabled";
    static final String BACKEND = "Backend";
    static final String REFERRAL = "Referral";
    static final String REFERRAL_UPDATE = "Referral on Update";
    static final String[] STATUS_ENTRIES = new String[]{"Disabled", "Backend", "Referral", "Referral on Update"};
    private final int ROWS = 4;
    static final int DEFAULT_PADDING = 6;
    static final Insets DEFAULT_EMPTY_INSETS = new Insets(0, 0, 0, 0);
    static final Insets BOTTOM_INSETS = new Insets(6, 6, 6, 6);
    private LDAPEntry _entry = null;

    public MappingNodeSettingPanel(IDSModel iDSModel, LDAPEntry lDAPEntry) {
        super(iDSModel, _section);
        this._helpToken = "configuration-mapping-setting-help";
        this._model = iDSModel;
        this._entry = lDAPEntry;
        this._refreshWhenSelect = false;
    }

    public void init() {
        if (this._isInitialized) {
            return;
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this._myPanel.setLayout(gridBagLayout);
        this._NodeLabel = this.makeJLabel(_section, "suffix");
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this._myPanel.add((Component)this._NodeLabel, gridBagConstraints);
        this._NodeText = new JLabel();
        this._NodeText.setText(LDAPDN.explodeDN((String)this._entry.getDN(), (boolean)true)[0]);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        this._myPanel.add((Component)this._NodeText, gridBagConstraints);
        this._NodeLabel.setLabelFor(this._NodeText);
        this._DadyNodeText = new JLabel();
        this._DadyNodeText.setLabelFor(this);
        ++gridBagConstraints.gridy;
        if (this._entry.getAttribute("nsslapd-parent-suffix") == null) {
            this._DadyNodeText.setText(DSUtil._resource.getString(_section, "no-subordinate-label"));
        } else {
            this._DadyNodeText.setText(this._entry.getAttribute("nsslapd-parent-suffix").getStringValueArray()[0]);
            this._DadyNodeLabel = this.makeJLabel(_section, "subordination");
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 0;
            this._myPanel.add((Component)this._DadyNodeLabel, gridBagConstraints);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        this._myPanel.add((Component)this._DadyNodeText, gridBagConstraints);
        this._saveStatus = this._entry.getAttribute("nsslapd-state").getStringValueArray()[0];
        if (this._saveStatus.compareToIgnoreCase(DISABLE) == 0) {
            this._isEnabledNode = false;
            this._isBackendNode = false;
            this._isReferral = false;
            this._isRefUpdate = false;
        } else if (this._saveStatus.compareToIgnoreCase(BACKEND) == 0) {
            this._isEnabledNode = true;
            this._isBackendNode = true;
            this._isReferral = false;
            this._isRefUpdate = false;
        } else if (this._saveStatus.compareToIgnoreCase(REFERRAL) == 0) {
            this._isEnabledNode = true;
            this._isBackendNode = false;
            this._isReferral = true;
            this._isRefUpdate = false;
        } else if (this._saveStatus.compareToIgnoreCase(REFERRAL_UPDATE) == 0) {
            this._isEnabledNode = true;
            this._isBackendNode = false;
            this._isReferral = false;
            this._isRefUpdate = true;
        }
        this._cbEnableNode = new JCheckBox(DSUtil._resource.getString(_section, "state-enable-label"));
        this._cbEnableNode.setSelected(this._isEnabledNode);
        this._cbEnableNode.addItemListener(new CheckBoxListener());
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this._myPanel.add((Component)this._cbEnableNode, gridBagConstraints);
        this.createStateArea(this._myPanel);
        this.StateEnableFields();
        this.addBottomGlue();
        this._isInitialized = true;
    }

    public void reloadStatus(LDAPEntry lDAPEntry) {
        this._entry = lDAPEntry;
        this._saveStatus = this._entry.getAttribute("nsslapd-state").getStringValueArray()[0];
        if (this._saveStatus.compareToIgnoreCase(DISABLE) == 0) {
            this._isEnabledNode = false;
            this._isBackendNode = false;
            this._isReferral = false;
            this._isRefUpdate = false;
        } else if (this._saveStatus.compareToIgnoreCase(BACKEND) == 0) {
            this._isEnabledNode = true;
            this._isBackendNode = true;
            this._isReferral = false;
            this._isRefUpdate = false;
        } else if (this._saveStatus.compareToIgnoreCase(REFERRAL) == 0) {
            this._isEnabledNode = true;
            this._isBackendNode = false;
            this._isReferral = true;
            this._isRefUpdate = false;
        } else if (this._saveStatus.compareToIgnoreCase(REFERRAL_UPDATE) == 0) {
            this._isEnabledNode = true;
            this._isBackendNode = false;
            this._isReferral = false;
            this._isRefUpdate = true;
        }
        this._cbEnableNode.setSelected(this._isEnabledNode);
        this._rbRefUpdate.setSelected(this._isRefUpdate);
        this._rbReferral.setSelected(this._isReferral);
        this._rbBackend.setSelected(this._isBackendNode || !this._isEnabledNode);
        this.setChangeState(this._rbRefUpdate, 1);
        this.setChangeState(this._rbBackend, 1);
        this.setChangeState(this._rbReferral, 1);
        this._isStateDirty = false;
        this.clearDirtyFlag();
    }

    protected void createStateArea(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = this.getGBC();
        GroupPanel groupPanel = new GroupPanel(DSUtil._resource.getString(_section, "mapping-title"));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)groupPanel, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        this._rbBackend = new JRadioButton(DSUtil._resource.getString(_section, "state-backend-label"));
        this._rbBackend.setSelected(this._isBackendNode);
        this._rbBackend.addActionListener(new RadioListener());
        buttonGroup.add(this._rbBackend);
        groupPanel.add((Component)this._rbBackend, gridBagConstraints);
        this._rbReferral = new JRadioButton(DSUtil._resource.getString(_section, "state-referral-label"));
        this._rbReferral.setSelected(this._isReferral);
        this._rbReferral.addActionListener(new RadioListener());
        buttonGroup.add(this._rbReferral);
        groupPanel.add((Component)this._rbReferral, gridBagConstraints);
        this._rbRefUpdate = new JRadioButton(DSUtil._resource.getString(_section, "state-refupdate-label"));
        this._rbRefUpdate.setSelected(this._isRefUpdate);
        this._rbRefUpdate.addActionListener(new RadioListener());
        buttonGroup.add(this._rbRefUpdate);
        groupPanel.add((Component)this._rbRefUpdate, gridBagConstraints);
        this.addBottomGlue();
    }

    private String[] getReferralListInEntry() {
        Vector vector = new Vector(1);
        LDAPAttribute lDAPAttribute = this._entry.getAttribute("nsslapd-Referral");
        if (lDAPAttribute != null) {
            return lDAPAttribute.getStringValueArray();
        }
        return null;
    }

    private boolean isListEmpty(JList jList) {
        boolean bl = jList.getModel().getSize() == 0;
        return bl;
    }

    private void setOkay(boolean bl) {
        AbstractDialog abstractDialog = this.getAbstractDialog();
        if (abstractDialog != null) {
            abstractDialog.setOKButtonEnabled(bl);
        }
    }

    private void checkOkay() {
        this.setOkay(this._isStateDirty && (!this._isEnabledNode || this._isBackendNode || this._isReferral || this._isRefUpdate));
        this.modelUpdate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof AbstractButton) {
            this.StateEnableFields();
            super.actionPerformed(actionEvent);
        }
        this.checkOkay();
    }

    private void StateEnableFields() {
        if (this._cbEnableNode == null) {
            return;
        }
        this._rbRefUpdate.setEnabled(this._cbEnableNode.isSelected());
        this._rbReferral.setEnabled(this._cbEnableNode.isSelected());
        this._rbBackend.setEnabled(this._cbEnableNode.isSelected());
    }

    public void resetCallback() {
        this.reloadEntry();
        this.setChangeState(this._rbRefUpdate, 1);
        this.setChangeState(this._rbBackend, 1);
        this.setChangeState(this._rbReferral, 1);
        this._cbEnableNode.setSelected(this._isEnabledNode);
        this._rbRefUpdate.setSelected(this._isRefUpdate);
        this._rbReferral.setSelected(this._isReferral);
        this._rbBackend.setSelected(this._isBackendNode);
        this._isStateDirty = false;
        this.clearDirtyFlag();
    }

    public boolean refresh() {
        this.resetCallback();
        return true;
    }

    public void reloadEntry() {
        if (this._entry == null) {
            return;
        }
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        try {
            this._entry = lDAPConnection.read(this._entry.getDN());
            this._saveStatus = this._entry.getAttribute("nsslapd-state").getStringValueArray()[0];
            if (this._saveStatus.compareToIgnoreCase(DISABLE) == 0) {
                this._isEnabledNode = false;
                this._isBackendNode = false;
                this._isReferral = false;
                this._isRefUpdate = false;
            } else if (this._saveStatus.compareToIgnoreCase(BACKEND) == 0) {
                this._isEnabledNode = true;
                this._isBackendNode = true;
                this._isReferral = false;
                this._isRefUpdate = false;
            } else if (this._saveStatus.compareToIgnoreCase(REFERRAL) == 0) {
                this._isEnabledNode = true;
                this._isBackendNode = false;
                this._isReferral = true;
                this._isRefUpdate = false;
            } else if (this._saveStatus.compareToIgnoreCase(REFERRAL_UPDATE) == 0) {
                this._isEnabledNode = true;
                this._isBackendNode = false;
                this._isReferral = false;
                this._isRefUpdate = true;
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("MappingNodeSettingPanel.reloadEntry(): " + (Object)((Object)lDAPException)));
        }
    }

    public boolean write2server(MappingNodeBckPanel mappingNodeBckPanel, MappingNodeRefPanel mappingNodeRefPanel) {
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this._isStateDirty) {
            LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
            if (this._cbEnableNode.isSelected()) {
                if (this._rbBackend.isSelected()) {
                    if (mappingNodeBckPanel.nbBck() == 0) {
                        DSUtil.showErrorDialog((Component)this._model.getFrame(), "nobck-title", "nobck-msg", (String[])null, _section);
                        return false;
                    }
                    string = BACKEND;
                    bl = true;
                    bl2 = false;
                    bl3 = false;
                    bl4 = true;
                } else if (this._rbReferral.isSelected()) {
                    if (mappingNodeRefPanel.nbRef() == 0) {
                        DSUtil.showErrorDialog((Component)this._model.getFrame(), "noref-title", "noref-msg", (String[])null, _section);
                        return false;
                    }
                    string = REFERRAL;
                    bl = true;
                    bl2 = false;
                    bl3 = true;
                    bl4 = false;
                } else if (this._rbRefUpdate.isSelected()) {
                    if (mappingNodeRefPanel.nbRef() == 0) {
                        DSUtil.showErrorDialog((Component)this._model.getFrame(), "noref-title", "noref-msg", (String[])null, _section);
                        return false;
                    }
                    if (mappingNodeBckPanel.nbBck() == 0) {
                        DSUtil.showErrorDialog((Component)this._model.getFrame(), "nobck-title", "nobck-msg", (String[])null, _section);
                        return false;
                    }
                    string = REFERRAL_UPDATE;
                    bl = true;
                    bl2 = true;
                    bl3 = false;
                    bl4 = false;
                }
            } else {
                string = DISABLE;
                bl = false;
                bl2 = false;
                bl3 = false;
                bl4 = false;
            }
            lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-state", string));
            Debug.println((String)("------ " + string));
            LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
            try {
                lDAPConnection.modify(this._entry.getDN(), lDAPModificationSet);
                this._saveStatus = string;
                this._isEnabledNode = bl;
                this._isRefUpdate = bl2;
                this._isReferral = bl3;
                this._isBackendNode = bl4;
                this.resetCallback();
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{this._entry.getDN(), lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "update-error", stringArray, _section);
                return false;
            }
        }
        this.clearDirtyFlag();
        return true;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        super.changedUpdate(documentEvent);
        this.checkOkay();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        super.removeUpdate(documentEvent);
        this.checkOkay();
    }

    private void modelUpdate() {
        this.setDirtyFlag();
        this.setValidFlag();
    }

    private void addBackend() {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        super.insertUpdate(documentEvent);
        this.checkOkay();
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(MappingNodeSettingPanel.this._rbBackend)) {
                if (!MappingNodeSettingPanel.this._isBackendNode || !MappingNodeSettingPanel.this._isEnabledNode) {
                    MappingNodeSettingPanel.this.setDirtyFlag();
                    MappingNodeSettingPanel.this.setChangeState(MappingNodeSettingPanel.this._rbBackend, 2);
                    MappingNodeSettingPanel.this.setChangeState(MappingNodeSettingPanel.this._rbReferral, 1);
                    MappingNodeSettingPanel.this.setChangeState(MappingNodeSettingPanel.this._rbRefUpdate, 1);
                    MappingNodeSettingPanel.this._isStateDirty = true;
                } else {
                    MappingNodeSettingPanel.this.clearDirtyFlag();
                    MappingNodeSettingPanel.this._isStateDirty = false;
                    MappingNodeSettingPanel.this.setChangeState(MappingNodeSettingPanel.this._rbRefUpdate, 1);
                    MappingNodeSettingPanel.this.setChangeState(MappingNodeSettingPanel.this._rbBackend, 1);
                    MappingNodeSettingPanel.this.setChangeState(MappingNodeSettingPanel.this._rbReferral, 1);
                }
            } else if (actionEvent.getSource().equals(MappingNodeSettingPanel.this._rbReferral)) {
                if (!MappingNodeSettingPanel.this._isReferral || !MappingNodeSettingPanel.this._isEnabledNode) {
                    MappingNodeSettingPanel.this.setDirtyFlag();
                    MappingNodeSettingPanel.this.setChangeState(MappingNodeSettingPanel.this._rbReferral, 2);
                    MappingNodeSettingPanel.this.setChangeState(MappingNodeSettingPanel.this._rbBackend, 1);
                    MappingNodeSettingPanel.this.setChangeState(MappingNodeSettingPanel.this._rbRefUpdate, 1);
                    MappingNodeSettingPanel.this._isStateDirty = true;
                } else {
                    MappingNodeSettingPanel.this.clearDirtyFlag();
                    MappingNodeSettingPanel.this.setChangeState(MappingNodeSettingPanel.this._rbRefUpdate, 1);
                    MappingNodeSettingPanel.this.setChangeState(MappingNodeSettingPanel.this._rbBackend, 1);
                    MappingNodeSettingPanel.this.setChangeState(MappingNodeSettingPanel.this._rbReferral, 1);
                    MappingNodeSettingPanel.this._isStateDirty = false;
                }
            } else if (actionEvent.getSource().equals(MappingNodeSettingPanel.this._rbRefUpdate)) {
                if (!MappingNodeSettingPanel.this._isRefUpdate || !MappingNodeSettingPanel.this._isEnabledNode) {
                    MappingNodeSettingPanel.this.setDirtyFlag();
                    MappingNodeSettingPanel.this.setChangeState(MappingNodeSettingPanel.this._rbRefUpdate, 2);
                    MappingNodeSettingPanel.this.setChangeState(MappingNodeSettingPanel.this._rbBackend, 1);
                    MappingNodeSettingPanel.this.setChangeState(MappingNodeSettingPanel.this._rbReferral, 1);
                    MappingNodeSettingPanel.this._isStateDirty = true;
                } else {
                    MappingNodeSettingPanel.this.clearDirtyFlag();
                    MappingNodeSettingPanel.this.setChangeState(MappingNodeSettingPanel.this._rbRefUpdate, 1);
                    MappingNodeSettingPanel.this.setChangeState(MappingNodeSettingPanel.this._rbBackend, 1);
                    MappingNodeSettingPanel.this.setChangeState(MappingNodeSettingPanel.this._rbReferral, 1);
                    MappingNodeSettingPanel.this._isStateDirty = false;
                }
            }
            MappingNodeSettingPanel.this.checkOkay();
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            Debug.println((String)"MappingNodeSettingPanel.CheckBoxListener");
            if (itemSelectable == MappingNodeSettingPanel.this._cbEnableNode) {
                MappingNodeSettingPanel.this.StateEnableFields();
                if (MappingNodeSettingPanel.this._isEnabledNode != MappingNodeSettingPanel.this._cbEnableNode.isSelected() || MappingNodeSettingPanel.this._isStateDirty) {
                    MappingNodeSettingPanel.this.setDirtyFlag();
                    MappingNodeSettingPanel.this._isStateDirty = true;
                } else {
                    MappingNodeSettingPanel.this.clearDirtyFlag();
                    MappingNodeSettingPanel.this._isStateDirty = false;
                }
            }
            MappingNodeSettingPanel.this.checkOkay();
        }
    }
}

