/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;

public class NewChainingInstancePanel
extends BlankPanel
implements SuiConstants {
    private JTextField _instanceNameText;
    private JLabel _instanceNameLabel;
    private JTextField _mappingNameText;
    private JLabel _mappingNameLabel;
    private JTextField _NewNodeText;
    private JLabel _NewNodeLabel;
    private IDSModel _model = null;
    private JComboBox _comboMapping;
    private JLabel _comboLabel;
    private JButton _browseButton;
    private String _PluginLoc = "";
    private JRadioButton _rbExistingNode;
    private JRadioButton _rbNewNode;
    private JRadioButton _rbNoNode;
    private JCheckBox _cbUrlLdapSecureMode;
    private JTextField _urlLdapHostText;
    private JLabel _urlLdapHostLabel;
    private JTextField _urlLdapPortText;
    private JLabel _urlLdapPortLabel;
    private JTextField _urlAltHostText;
    private JLabel _urlAltHostLabel;
    private JTextField _urlAltPortText;
    private JLabel _urlAltPortLabel;
    private JLabel _bindDNLabel;
    private JTextField _bindDNText;
    private JLabel _bindPasswdLabel;
    private JTextField _bindPasswdText;
    private JComboBox _comboNewNodeMapping;
    private JLabel _comboNewNodeLabel;
    private JButton _bAddAlternateServer;
    private JButton _bDelAlternateServer;
    private JButton _bTestUrl;
    private JLabel _urlValue;
    private JLabel _urlValueLabel;
    private JList _urlAltList;
    private DefaultListModel _urlAltData;
    private boolean _isBindDNValid = true;
    private boolean _isNewMappingNodeValid = false;
    private boolean _bHostModified = false;
    private boolean _bAlterModified = false;
    private final int ROWS = 4;
    private StringBuffer _sURL;
    private String _sDefaultPort = "389";
    private static final String _section = "newchaining";
    static final String CONFIG_BASEDN = "cn=plugins, cn=config";
    static final String CONFIG_MAPPING = "cn=mapping tree, cn=config";
    static final String ROOT_MAPPING_NODE = "is root suffix";
    static final String HELP_REF = "helpReferral";
    static final int EXISTING_NODE = 0;
    static final int NEW_NODE = 1;
    static final int NO_NODE = 2;
    static final String ADD_ALT = "addAlternate";
    static final String DELETE_ALT = "deleteAlternate";
    static final String DEFAULT_LDAP_PORT = "389";
    static final String DEFAULT_LDAPS_PORT = "636";
    static final int DEFAULT_PADDING = 6;
    static final Insets DEFAULT_EMPTY_INSETS = new Insets(0, 0, 0, 0);
    static final Insets BOTTOM_INSETS = new Insets(6, 6, 6, 6);

    public NewChainingInstancePanel(IDSModel iDSModel) {
        super(iDSModel, _section);
        this._helpToken = "configuration-new-chaining-instance-dbox-help";
        this._model = iDSModel;
    }

    public void init() {
        this._myPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getGBC();
        this.createChainArea(this._myPanel);
        this.createMappingArea(this._myPanel);
        AbstractDialog abstractDialog = this.getAbstractDialog();
        if (abstractDialog != null) {
            abstractDialog.setOKButtonEnabled(false);
        }
        this._isInitialized = true;
    }

    protected void createChainArea(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = this.getGBC();
        GroupPanel groupPanel = new GroupPanel(DSUtil._resource.getString(_section, "new-chaining-title"), true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)groupPanel, gridBagConstraints);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.insets = new Insets(6, 6, 0, 6);
        gridBagConstraints2.ipadx = 0;
        gridBagConstraints2.ipady = 0;
        groupPanel.setLayout(gridBagLayout);
        this._instanceNameLabel = this.makeJLabel(_section, "instance-name");
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 13;
        groupPanel.add((Component)this._instanceNameLabel, gridBagConstraints2);
        this._instanceNameText = this.makeJTextField(_section, "instance-name");
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.fill = 2;
        this._instanceNameText.setColumns(10);
        this._instanceNameText.setText("New Chaining");
        groupPanel.add((Component)this._instanceNameText, gridBagConstraints2);
        this._bindDNLabel = this.makeJLabel(_section, "bind-DN");
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.anchor = 13;
        groupPanel.add((Component)this._bindDNLabel, gridBagConstraints2);
        this._bindDNText = this.makeJTextField(_section, "bind-DN");
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.weightx = 1.0;
        groupPanel.add((Component)this._bindDNText, gridBagConstraints2);
        this._bindPasswdLabel = this.makeJLabel(_section, "bind-Passwd");
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.anchor = 13;
        groupPanel.add((Component)this._bindPasswdLabel, gridBagConstraints2);
        this._bindPasswdText = this.makeJPasswordField(20);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 1.0;
        groupPanel.add((Component)this._bindPasswdText, gridBagConstraints2);
        this.createRemoteServers(groupPanel, gridBagConstraints2);
        this.createURLArea(groupPanel, gridBagConstraints2);
        this._bHostModified = false;
        this._bAlterModified = false;
    }

    private void createURLArea(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        GroupPanel groupPanel = new GroupPanel(DSUtil._resource.getString(_section, "new-url-title"), true);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)groupPanel, gridBagConstraints);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.insets = new Insets(6, 6, 0, 6);
        gridBagConstraints2.ipadx = 0;
        gridBagConstraints2.ipady = 0;
        groupPanel.setLayout(gridBagLayout);
        this._urlValueLabel = this.makeJLabel(_section, "ldap-url-value");
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 6);
        gridBagConstraints2.weightx = 0.0;
        groupPanel.add((Component)this._urlValueLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(0, 6, 0, 0);
        this._urlValue = new JLabel();
        this._sURL = new StringBuffer("ldap://");
        this._urlValue.setText(this._sURL.toString());
        groupPanel.add((Component)this._urlValue, gridBagConstraints2);
    }

    private void createRemoteServers(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        GroupPanel groupPanel = new GroupPanel(DSUtil._resource.getString(_section, "new-alternate-host-title"), true);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)groupPanel, gridBagConstraints);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.insets = new Insets(0, 9, 6, 0);
        gridBagConstraints2.ipadx = 0;
        gridBagConstraints2.ipady = 0;
        groupPanel.setLayout(gridBagLayout);
        this._cbUrlLdapSecureMode = this.makeJCheckBox(_section, "ldap-url-secu");
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.weightx = 0.0;
        this._cbUrlLdapSecureMode.setSelected(false);
        groupPanel.add((Component)this._cbUrlLdapSecureMode, gridBagConstraints2);
        this._urlLdapHostLabel = this.makeJLabel(_section, "ldap-url-host");
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints2.weightx = 0.0;
        groupPanel.add((Component)this._urlLdapHostLabel, gridBagConstraints2);
        this._urlLdapHostText = this.makeJTextField(_section, "ldap-url-host");
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(0, 6, 6, 9);
        this._urlLdapHostText.setColumns(12);
        groupPanel.add((Component)this._urlLdapHostText, gridBagConstraints2);
        this._urlLdapPortLabel = this.makeJLabel(_section, "ldap-url-port");
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(0, 0, 6, 0);
        groupPanel.add((Component)this._urlLdapPortLabel, gridBagConstraints2);
        this._urlLdapPortText = this.makeJTextField(_section, "ldap-url-port");
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 0.0;
        this._urlLdapPortText.setColumns(5);
        this._urlLdapPortText.setText(this._sDefaultPort);
        gridBagConstraints2.insets = new Insets(0, 6, 6, 0);
        groupPanel.add((Component)this._urlLdapPortText, gridBagConstraints2);
        this._urlAltHostLabel = this.makeJLabel(_section, "alt-url-host");
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints2.weightx = 0.0;
        groupPanel.add((Component)this._urlAltHostLabel, gridBagConstraints2);
        this._urlAltHostText = this.makeJTextField(_section, "alt-url-host");
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(0, 6, 6, 9);
        this._urlAltHostText.setColumns(12);
        groupPanel.add((Component)this._urlAltHostText, gridBagConstraints2);
        this._urlAltPortLabel = this.makeJLabel(_section, "alt-url-port");
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(0, 0, 6, 0);
        groupPanel.add((Component)this._urlAltPortLabel, gridBagConstraints2);
        this._urlAltPortText = this.makeJTextField(_section, "alt-url-port");
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(0, 6, 6, 0);
        this._urlAltPortText.setColumns(5);
        if (!this._bAlterModified) {
            this._urlAltPortText.setText(this._sDefaultPort);
        }
        groupPanel.add((Component)this._urlAltPortText, gridBagConstraints2);
        this._bAddAlternateServer = this.makeJButton(_section, "ldap-add-alternate");
        this._bAddAlternateServer.setActionCommand(ADD_ALT);
        this._bAddAlternateServer.setEnabled(false);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 4;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(0, 9, 6, 0);
        groupPanel.add((Component)this._bAddAlternateServer, gridBagConstraints2);
        this._urlAltData = new DefaultListModel();
        this._urlAltList = new JList(this._urlAltData);
        this._urlAltList.setVisibleRowCount(4);
        this._urlAltList.setCellRenderer(new AlternateCellRenderer());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this._urlAltList);
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        groupPanel.add((Component)jScrollPane, gridBagConstraints2);
        this._bDelAlternateServer = this.makeJButton(_section, "ldap-del-alternate");
        this._bDelAlternateServer.setActionCommand(DELETE_ALT);
        this._bDelAlternateServer.setEnabled(false);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 4;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(0, 9, 6, 0);
        groupPanel.add((Component)this._bDelAlternateServer, gridBagConstraints2);
    }

    protected void createMappingArea(JPanel jPanel) {
        String string;
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.insets.bottom = this._gbc.insets.top;
        gridBagConstraints.gridwidth = 0;
        String[] stringArray = MappingUtils.getMappingNode(this._model.getServerInfo().getLDAPConnection());
        GroupPanel groupPanel = new GroupPanel(DSUtil._resource.getString(_section, "new-mapping-title"));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)groupPanel, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        this._rbExistingNode = this.makeJRadioButton(_section, "existing-node", true);
        buttonGroup.add(this._rbExistingNode);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 3;
        groupPanel.add((Component)this._rbExistingNode, gridBagConstraints);
        this._rbNewNode = this.makeJRadioButton(_section, "new-node", false);
        buttonGroup.add(this._rbNewNode);
        groupPanel.add((Component)this._rbNewNode, gridBagConstraints);
        this._rbNoNode = this.makeJRadioButton(_section, "no-node", false);
        buttonGroup.add(this._rbNoNode);
        groupPanel.add((Component)this._rbNoNode, gridBagConstraints);
        this._rbNewNode.setSelected(true);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        groupPanel.add(Box.createGlue(), gridBagConstraints);
        this._comboMapping = new JComboBox();
        this._comboMapping.addItemListener(this);
        this._comboMapping.addActionListener(this);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this._comboMapping.addItem(stringArray[n]);
                ++n;
            }
            if (stringArray.length > 0) {
                this._comboMapping.setSelectedIndex(0);
            }
        }
        if ((string = DSUtil._resource.getString(_section, "select-Mapping-ttip")) != null) {
            this._comboMapping.setToolTipText(string);
        }
        this._comboLabel = this.makeJLabel(_section, "mapping-node");
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        groupPanel.add((Component)this._comboLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        groupPanel.add((Component)this._comboMapping, gridBagConstraints);
        this._NewNodeLabel = this.makeJLabel(_section, "node-suffix");
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        groupPanel.add((Component)this._NewNodeLabel, gridBagConstraints);
        this._NewNodeText = this.makeJTextField(_section, "node-suffix");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        groupPanel.add((Component)this._NewNodeText, gridBagConstraints);
        this._comboNewNodeMapping = new JComboBox();
        this._comboNewNodeMapping.addItemListener(this);
        this._comboNewNodeMapping.addActionListener(this);
        if (stringArray != null) {
            this._comboNewNodeMapping.addItem(ROOT_MAPPING_NODE);
            int n = 0;
            while (n < stringArray.length) {
                this._comboNewNodeMapping.addItem(stringArray[n]);
                ++n;
            }
            if (stringArray.length > 0) {
                this._comboNewNodeMapping.setSelectedIndex(0);
            }
        }
        this._comboNewNodeLabel = this.makeJLabel(_section, "new-node-subordination");
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        groupPanel.add((Component)this._comboNewNodeLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        groupPanel.add((Component)this._comboNewNodeMapping, gridBagConstraints);
        this.setMappingState();
    }

    private void getChainingLoc() {
        try {
            block4: {
                try {
                    this._model.setWaitCursor(true);
                    LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
                    LDAPSearchResults lDAPSearchResults = lDAPConnection.search(CONFIG_BASEDN, 1, "nsslapd-pluginid=chaining database", null, false);
                    if (!lDAPSearchResults.hasMoreElements()) break block4;
                    LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                    this._PluginLoc = lDAPEntry.getDN();
                    Debug.println((String)"NewChainingInstancePanel.getChainingLoc() {");
                    Debug.println((String)("*** plugin db: " + this._PluginLoc));
                }
                catch (LDAPException lDAPException) {
                    Debug.println((String)("NewChainingInstancePanel.getChainingLoc() " + (Object)((Object)lDAPException)));
                    Object var5_6 = null;
                    this._model.setWaitCursor(false);
                }
            }
            Object var5_5 = null;
            this._model.setWaitCursor(false);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this._model.setWaitCursor(false);
            throw throwable;
        }
    }

    private void setOkay(boolean bl) {
        AbstractDialog abstractDialog = this.getAbstractDialog();
        if (abstractDialog != null) {
            abstractDialog.setOKButtonEnabled(bl);
        }
    }

    private void checkOkay() {
        String string = this.getInstancename();
        String string2 = this._urlLdapHostText.getText();
        boolean bl = string != null && string.length() > 0 && this._isNewMappingNodeValid && this._isBindDNValid && string2 != null && string2.length() > 0;
        this.setOkay(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._rbExistingNode)) {
            this.setMappingState(0);
        } else if (actionEvent.getSource().equals(this._rbNewNode)) {
            this.setMappingState(1);
        } else if (actionEvent.getSource().equals(this._rbNoNode)) {
            this.setMappingState(2);
        } else if (actionEvent.getSource().equals(this._cbUrlLdapSecureMode)) {
            this._sDefaultPort = this._cbUrlLdapSecureMode.isSelected() ? DEFAULT_LDAPS_PORT : DEFAULT_LDAP_PORT;
            if (!this._bHostModified) {
                this._urlLdapPortText.setText(this._sDefaultPort);
            }
            if (!this._bAlterModified) {
                this._urlAltPortText.setText(this._sDefaultPort);
            }
        } else if (actionEvent.getSource().equals(this._bAddAlternateServer)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this._urlAltHostText.getText());
            if (this._urlAltPortText.getText() != null && this._urlAltPortText.getText().trim().length() > 0) {
                stringBuffer.append(":");
                stringBuffer.append(this._urlAltPortText.getText().trim());
            }
            this._urlAltData.addElement(stringBuffer.toString());
            this._urlAltHostText.setText("");
            this._bAddAlternateServer.setEnabled(false);
        } else if (actionEvent.getSource().equals(this._bDelAlternateServer)) {
            int[] nArray = this._urlAltList.getSelectedIndices();
            int n = nArray.length - 1;
            while (n >= 0) {
                this._urlAltData.removeElementAt(nArray[n]);
                --n;
            }
            this._bDelAlternateServer.setEnabled(false);
        }
        super.actionPerformed(actionEvent);
        this.checkUrl();
        this.checkOkay();
    }

    private String getUrlVal() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._cbUrlLdapSecureMode.isSelected()) {
            stringBuffer.append("ldaps://");
        } else {
            stringBuffer.append("ldap://");
        }
        if (this._urlLdapHostText.getText() != null && this._urlLdapHostText.getText().trim().length() > 0) {
            stringBuffer.append(this._urlLdapHostText.getText().trim());
            if (this._urlLdapPortText.getText() != null && this._urlLdapPortText.getText().trim().length() > 0) {
                stringBuffer.append(":");
                stringBuffer.append(this._urlLdapPortText.getText().trim());
            }
        }
        int n = 0;
        while (n < this._urlAltList.getModel().getSize()) {
            stringBuffer.append(" ");
            stringBuffer.append(this._urlAltList.getModel().getElementAt(n));
            ++n;
        }
        stringBuffer.append("/");
        return stringBuffer.toString();
    }

    private void checkUrl() {
        String string = this.getUrlVal();
        this._urlValue.setText(string);
        try {
            this.setChangeState(this._urlValue, 1);
            LDAPUrl lDAPUrl = new LDAPUrl(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.setChangeState(this._urlValue, 3);
        }
    }

    public int addChainingBackend(String string) {
        Object object;
        String[] stringArray;
        String string2 = this._instanceNameText.getText().trim();
        this.getChainingLoc();
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        Debug.println((String)"NewChainingInstancePanel.addChainingBackend()");
        String string3 = "cn=" + string2 + "," + this._PluginLoc;
        Debug.println((String)("****** dn = " + string3));
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        String[] stringArray2 = new String[]{"top", "extensibleObject", "nsBackendInstance"};
        LDAPAttribute lDAPAttribute = new LDAPAttribute("objectclass", stringArray2);
        lDAPAttributeSet.add(lDAPAttribute);
        String[] stringArray3 = new String[]{string2};
        lDAPAttributeSet.add(new LDAPAttribute("cn", stringArray3));
        String[] stringArray4 = new String[]{string};
        lDAPAttributeSet.add(new LDAPAttribute("nsslapd-suffix", stringArray4));
        String string4 = this._bindDNText.getText();
        if (string4 != null && string4.trim().length() > 0) {
            stringArray = new String[]{string4.trim()};
            lDAPAttributeSet.add(new LDAPAttribute("nsMultiplexorBindDn", stringArray));
            object = this._bindPasswdText.getText();
            if (object != null && ((String)object).trim().length() > 0) {
                Debug.println((String)("****** pass= " + (String)object));
                String[] stringArray5 = new String[]{((String)object).trim()};
                lDAPAttributeSet.add(new LDAPAttribute("nsMultiplexorCredentials", stringArray5));
            }
        }
        if ((stringArray = this.getUrlVal()) != null && stringArray.trim().length() > 0) {
            object = new String[]{stringArray.trim()};
            lDAPAttributeSet.add(new LDAPAttribute("nsFarmServerURL", (String[])object));
        }
        object = new LDAPEntry(string3, lDAPAttributeSet);
        this._model.setWaitCursor(true);
        try {
            try {
                lDAPConnection.add((LDAPEntry)object);
                Debug.println((String)("****** add:" + string3));
            }
            catch (LDAPException lDAPException) {
                String[] stringArray6;
                if (lDAPException.getLDAPResultCode() == 82) {
                    stringArray6 = new String[]{string3, this._bindDNText.getText().trim()};
                    DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "error-bad-user", stringArray6, _section);
                } else {
                    stringArray6 = new String[]{string3, lDAPException.toString()};
                    DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "error-add-mapping", stringArray6, _section);
                }
                Debug.println((String)("****** error adding " + string3 + ". Error is : " + lDAPException.toString()));
                int n = 0;
                Object var16_16 = null;
                this._model.setWaitCursor(false);
                return n;
            }
            Object var16_15 = null;
            this._model.setWaitCursor(false);
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            this._model.setWaitCursor(false);
            throw throwable;
        }
        return 1;
    }

    public boolean checkUnique() {
        this._model.setWaitCursor(true);
        try {
            try {
                String string = this._instanceNameText.getText();
                Debug.println((String)("NewChainingInstancePanel.checkUnique(). check if " + string + " is unique"));
                this._model.setWaitCursor(true);
                LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
                if (string != null) {
                    LDAPSearchResults lDAPSearchResults = lDAPConnection.search(CONFIG_BASEDN, 2, "(&(cn=" + string + ")(objectclass=nsBackendInstance))", null, false);
                    this._model.setWaitCursor(false);
                    if (lDAPSearchResults.hasMoreElements()) {
                        DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "backendname-exist", string);
                        this._instanceNameText.selectAll();
                        boolean bl = false;
                        Object var6_7 = null;
                        this._model.setWaitCursor(false);
                        return bl;
                    }
                }
                Object var6_8 = null;
                this._model.setWaitCursor(false);
            }
            catch (LDAPException lDAPException) {
                this._model.setWaitCursor(false);
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "backendname-can-create", lDAPException.toString());
                boolean bl = false;
                Object var6_9 = null;
                this._model.setWaitCursor(false);
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this._model.setWaitCursor(false);
            throw throwable;
        }
        return true;
    }

    public void resetCallback() {
        this.clearDirtyFlag();
        this.hideDialog();
    }

    private void setMappingState() {
        this.setMappingState(1);
    }

    private void setMappingState(int n) {
        switch (n) {
            case 0: {
                this._NewNodeText.setEnabled(false);
                this._NewNodeLabel.setEnabled(false);
                this._comboNewNodeMapping.setEnabled(false);
                this._comboNewNodeLabel.setEnabled(false);
                this._comboMapping.setEnabled(true);
                this._comboLabel.setEnabled(true);
                this._isNewMappingNodeValid = true;
                break;
            }
            case 1: {
                this._comboMapping.setEnabled(false);
                this._comboLabel.setEnabled(false);
                this._comboNewNodeMapping.setEnabled(true);
                this._comboNewNodeLabel.setEnabled(true);
                this._NewNodeText.setEnabled(true);
                this._NewNodeLabel.setEnabled(true);
                this._isNewMappingNodeValid = false;
                break;
            }
            case 2: {
                this._NewNodeText.setEnabled(false);
                this._NewNodeLabel.setEnabled(false);
                this._comboMapping.setEnabled(false);
                this._comboLabel.setEnabled(false);
                this._comboNewNodeMapping.setEnabled(false);
                this._comboNewNodeLabel.setEnabled(false);
                this._isNewMappingNodeValid = true;
            }
        }
        this.repaint();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void okCallback() {
        if (this.checkUnique()) {
            String[] stringArray;
            block13: {
                int n = 0;
                n = this._rbExistingNode.isSelected() ? this.addChainingBackend((String)this._comboMapping.getSelectedItem()) : (this._rbNewNode.isSelected() ? this.addChainingBackend(this._NewNodeText.getText()) : this.addChainingBackend(""));
                if (n == 0) {
                    return;
                }
                String[] stringArray2 = new String[]{this._instanceNameText.getText().trim()};
                if (this._rbNewNode.isSelected()) {
                    if (this._NewNodeText.getText() != null && this._NewNodeText.getText().trim().length() > 0) {
                        if (MappingUtils.addMappingNode(this._model.getServerInfo().getLDAPConnection(), _section, this._NewNodeText.getText(), (String)this._comboNewNodeMapping.getSelectedItem(), "backend", stringArray2, null)) {
                            return;
                        }
                        break block13;
                    } else {
                        DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "new-mapping-node", "");
                        return;
                    }
                }
                if (this._rbExistingNode.isSelected()) {
                    stringArray = "cn=" + MappingUtils.Quote((String)this._comboMapping.getSelectedItem()) + "," + CONFIG_MAPPING;
                    Debug.println((String)("okCallback updating :" + (String)stringArray));
                    LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
                    LDAPAttribute lDAPAttribute = new LDAPAttribute("nsslapd-backend", stringArray2);
                    lDAPModificationSet.add(0, lDAPAttribute);
                    this._model.setWaitCursor(true);
                    LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
                    try {
                        try {
                            lDAPConnection.modify((String)stringArray, lDAPModificationSet);
                        }
                        catch (LDAPException lDAPException) {
                            String[] stringArray3 = new String[]{stringArray, lDAPException.toString()};
                            DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "error-mod-mapping", stringArray3, _section);
                            Debug.println((String)("okCallback() error modifying " + (String)stringArray + ". Error is : " + lDAPException.toString()));
                            Object var10_8 = null;
                            this._model.setWaitCursor(false);
                            return;
                        }
                        Object var10_7 = null;
                        this._model.setWaitCursor(false);
                    }
                    catch (Throwable throwable) {
                        Object var10_9 = null;
                        this._model.setWaitCursor(false);
                        throw throwable;
                    }
                }
            }
            this.clearDirtyFlag();
            if (this._bindDNText.getText() == null || this._bindPasswdText.getText() == null || this._bindDNText.getText().trim().length() == 0 || this._bindPasswdText.getText().trim().length() == 0) {
                stringArray = new String[]{this._urlLdapHostText.getText()};
                DSUtil.showInformationDialog((Component)this.getModel().getFrame(), "refresh-console-anon", stringArray, _section);
            } else {
                stringArray = new String[]{this._bindDNText.getText(), this._urlLdapHostText.getText()};
                DSUtil.showInformationDialog((Component)this.getModel().getFrame(), "refresh-console-user", stringArray, _section);
            }
            this.hideDialog();
        }
    }

    private boolean isPortValid() {
        String string = this._urlLdapPortText.getText();
        boolean bl = true;
        if (string != null && string.trim().length() > 0) {
            try {
                int n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    private void checkLabels(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this._NewNodeText.getDocument()) {
            if (DN.isDN((String)this._NewNodeText.getText())) {
                this.setChangeState(this._NewNodeLabel, 1);
                this._isNewMappingNodeValid = true;
            } else {
                this.setChangeState(this._NewNodeLabel, 3);
                this._isNewMappingNodeValid = false;
            }
        } else if (documentEvent.getDocument() == this._bindDNText.getDocument()) {
            if (this._bindDNText.getText() != null && this._bindDNText.getText().trim().length() > 0) {
                if (DN.isDN((String)this._bindDNText.getText())) {
                    this.setChangeState(this._bindDNLabel, 1);
                    this._isBindDNValid = true;
                } else {
                    this.setChangeState(this._bindDNLabel, 3);
                    this._isBindDNValid = false;
                }
            } else {
                this.setChangeState(this._bindDNLabel, 1);
                this._isBindDNValid = true;
            }
        } else if (documentEvent.getDocument() == this._urlAltHostText.getDocument()) {
            boolean bl = false;
            if (this._urlAltHostText.getText() != null && this._urlAltHostText.getText().trim().length() > 0) {
                bl = true;
            }
            this._bAddAlternateServer.setEnabled(bl && this.isPortValid());
        } else if (documentEvent.getDocument() == this._urlAltPortText.getDocument()) {
            if (this.isPortValid()) {
                this.setChangeState(this._urlLdapPortLabel, 1);
            } else {
                this.setChangeState(this._urlLdapPortLabel, 3);
                this._bAddAlternateServer.setEnabled(false);
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (!this._isInitialized) {
            return;
        }
        this.checkLabels(documentEvent);
        this.checkUrl();
        super.changedUpdate(documentEvent);
        this.checkOkay();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (!this._isInitialized) {
            return;
        }
        this.checkLabels(documentEvent);
        this.checkUrl();
        super.removeUpdate(documentEvent);
        this.checkOkay();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this._isInitialized) {
            return;
        }
        this.checkLabels(documentEvent);
        this.checkUrl();
        super.insertUpdate(documentEvent);
        this.checkOkay();
    }

    public String getInstancename() {
        return this._instanceNameText.getText().trim();
    }

    class AlternateCellRenderer
    extends DefaultListCellRenderer {
        AlternateCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (jList == NewChainingInstancePanel.this._urlAltList) {
                if (jList.isSelectionEmpty()) {
                    NewChainingInstancePanel.this._bDelAlternateServer.setEnabled(false);
                } else {
                    NewChainingInstancePanel.this._bDelAlternateServer.setEnabled(true);
                }
            }
            NewChainingInstancePanel.this.checkOkay();
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }
}

