/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.PasswordDialog;
import com.netscape.admin.dirserv.browser.LDAPConnectionPool;
import com.netscape.admin.dirserv.panel.LDAPUrlDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPUrl;

public class ReferralEditor
extends AbstractDialog
implements DocumentListener,
ActionListener,
ListSelectionListener,
SuiConstants {
    boolean _errorDuringInit;
    boolean _isObjectModified = false;
    boolean _isAuthModified = false;
    JCheckBox _cbReferralsEnabled;
    JTextField _tfNewReferral;
    JButton _bConstruct;
    JButton _bAdd;
    JButton _bDelete;
    JButton _bChange;
    JButton _bAuthentication;
    JLabel _lReferrals;
    JLabel _lNewReferral;
    JLabel _lBindDN;
    JList _referralList;
    DefaultListModel _referralListData;
    ResourceSet _resource = DSUtil._resource;
    Vector _saveReferralValues;
    boolean _saveReferralsEnabled;
    boolean _hasReferralObjectclass = false;
    LDAPConnection _ldc;
    JFrame _frame;
    String _dn;
    boolean _save;
    LDAPConnectionPool _connectionPool;
    LDAPModificationSet _set;
    String _section = "ReferralEditor";
    static final int REFERRAL_LIST_ROWS = 5;

    public ReferralEditor(JFrame jFrame, LDAPConnection lDAPConnection, String string, LDAPConnectionPool lDAPConnectionPool) {
        super((Frame)jFrame, "", true, 11);
        this._frame = jFrame;
        this._ldc = lDAPConnection;
        this._dn = string;
        this._save = true;
        this._connectionPool = lDAPConnectionPool;
        this._errorDuringInit = false;
        this.init();
    }

    public void packAndShow() {
        if (!this._errorDuringInit) {
            this.pack();
            this.show();
        }
    }

    public boolean isObjectModified() {
        return this._isObjectModified;
    }

    public boolean isAuthModified() {
        return this._isAuthModified;
    }

    public LDAPModificationSet getModifications() {
        return this._set;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this._bConstruct)) {
            this.actionConstructReferral();
        } else if (object.equals(this._bAdd)) {
            this.actionAddOrChangeReferral(false);
        } else if (object.equals(this._bDelete)) {
            this.actionDeleteReferral();
        } else if (object.equals(this._bChange)) {
            this.actionAddOrChangeReferral(true);
        } else if (object.equals(this._bAuthentication)) {
            this.actionAuthentication();
        }
        this.checkEnablingState();
        if (object.equals(this._cbReferralsEnabled) && this._cbReferralsEnabled.isSelected()) {
            this._tfNewReferral.requestFocus();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkEnablingState();
    }

    protected void init() {
        ((Dialog)((Object)this)).setTitle(this._resource.getString(this._section, "title-label"));
        ((JDialog)((Object)this)).getAccessibleContext().setAccessibleDescription(this._resource.getString(this._section, "title-description"));
        this.layoutComponents();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ReferralEditor.this.initValuesFromServer();
            }
        });
        thread.start();
    }

    protected void layoutComponents() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.setComponent(jPanel);
        this._cbReferralsEnabled = UIFactory.makeJCheckBox(this, this._section, "enable", false, this._resource);
        this._lReferrals = new JLabel(this._resource.getString(this._section, "values-label"));
        this._lNewReferral = new JLabel(this._resource.getString(this._section, "new-value-label"));
        this._lBindDN = new JLabel();
        this._tfNewReferral = UIFactory.makeJTextField((Object)this, -1);
        this._bDelete = UIFactory.makeJButton(this, this._section, "delete", this._resource);
        this._bConstruct = UIFactory.makeJButton(this, this._section, "construct", this._resource);
        this._bAdd = UIFactory.makeJButton(this, this._section, "add", this._resource);
        this._bChange = UIFactory.makeJButton(this, this._section, "change", this._resource);
        this._bAuthentication = UIFactory.makeJButton(this, this._section, "authentication", this._resource);
        this._referralListData = new DefaultListModel();
        this._referralList = new JList(this._referralListData);
        this._lBindDN.setLabelFor(this._referralList);
        this._referralList.setVisibleRowCount(5);
        this._referralList.addListSelectionListener(this);
        this._lReferrals.setLabelFor(this._referralList);
        this._lNewReferral.setLabelFor(this._tfNewReferral);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this._referralList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        jPanel.add((Component)this._cbReferralsEnabled, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 0;
        jPanel.add((Component)this._lReferrals, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.bottom = 6;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)this._bDelete, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this._bChange, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.right = 6;
        jPanel.add((Component)this._lNewReferral, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this._tfNewReferral, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.bottom = 6;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)this._bAdd, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this._bConstruct, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.right = 6;
        jPanel.add((Component)this._lBindDN, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)this._bAuthentication, gridBagConstraints);
        this.setOKButtonEnabled(false);
        this.setDefaultButton(this._bAdd);
        this._cbReferralsEnabled.setEnabled(false);
        this._tfNewReferral.setEnabled(false);
        this._bConstruct.setEnabled(false);
    }

    protected void initValuesFromServer() {
        this._saveReferralsEnabled = false;
        this._saveReferralValues = new Vector();
        String[] stringArray = new String[]{"ref", "objectclass"};
        LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)this._ldc.getSearchConstraints().clone();
        lDAPSearchConstraints.setServerControls(new LDAPControl("2.16.840.1.113730.3.4.2", true, null));
        try {
            LDAPEntry lDAPEntry = this._ldc.read(this._dn, stringArray, lDAPSearchConstraints);
            if (lDAPEntry != null) {
                Enumeration enumeration;
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(stringArray[0]);
                if (lDAPAttribute != null) {
                    enumeration = lDAPAttribute.getStringValues();
                    if (enumeration.hasMoreElements()) {
                        this._saveReferralsEnabled = true;
                        this._hasReferralObjectclass = true;
                    }
                    while (enumeration.hasMoreElements()) {
                        this._saveReferralValues.addElement(enumeration.nextElement());
                    }
                }
                if (!this._saveReferralsEnabled && (lDAPAttribute = lDAPEntry.getAttribute(stringArray[1])) != null) {
                    enumeration = lDAPAttribute.getStringValues();
                    while (enumeration.hasMoreElements() && !this._hasReferralObjectclass) {
                        String string = (String)enumeration.nextElement();
                        if (!string.equalsIgnoreCase("referral")) continue;
                        this._hasReferralObjectclass = true;
                    }
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ReferralEditor.this._cbReferralsEnabled.setEnabled(true);
                    if (ReferralEditor.this._saveReferralsEnabled) {
                        ReferralEditor.this._cbReferralsEnabled.setSelected(true);
                        ReferralEditor.this._referralListData.clear();
                        int n = 0;
                        while (n < ReferralEditor.this._saveReferralValues.size()) {
                            ReferralEditor.this._referralListData.addElement(ReferralEditor.this._saveReferralValues.elementAt(n));
                            ++n;
                        }
                    }
                    ReferralEditor.this.checkEnablingState();
                }
            });
        }
        catch (LDAPException lDAPException) {
            final LDAPException lDAPException2 = lDAPException;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String[] stringArray = new String[]{ReferralEditor.this._dn, ReferralEditor.this.getLDAPErrorMessage(lDAPException2)};
                    ReferralEditor.this._errorDuringInit = true;
                    ((Component)((Object)ReferralEditor.this)).setVisible(false);
                    DSUtil.showErrorDialog((Component)ReferralEditor.this._frame, "reading-object-error-title", "reading-object-error-msg", stringArray, ReferralEditor.this._section);
                }
            });
        }
    }

    protected void okInvoked() {
        LDAPSearchConstraints lDAPSearchConstraints;
        LDAPAttribute lDAPAttribute;
        int n;
        boolean bl = !this._cbReferralsEnabled.isSelected() || this._referralListData.getSize() < 1;
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        if (!this._hasReferralObjectclass && !bl) {
            lDAPModificationSet.add(0, new LDAPAttribute("objectclass", "referral"));
        }
        if (bl) {
            n = 1;
            lDAPAttribute = new LDAPAttribute("ref");
        } else if (this._saveReferralsEnabled) {
            n = 2;
            lDAPAttribute = new LDAPAttribute("ref");
            lDAPSearchConstraints = this._referralListData.elements();
            while (lDAPSearchConstraints.hasMoreElements()) {
                lDAPAttribute.addValue((String)lDAPSearchConstraints.nextElement());
            }
        } else {
            n = 0;
            lDAPAttribute = new LDAPAttribute("ref");
            lDAPSearchConstraints = this._referralListData.elements();
            while (lDAPSearchConstraints.hasMoreElements()) {
                lDAPAttribute.addValue((String)lDAPSearchConstraints.nextElement());
            }
        }
        lDAPModificationSet.add(n, lDAPAttribute);
        if (this._hasReferralObjectclass && bl) {
            lDAPModificationSet.add(1, new LDAPAttribute("objectclass", "referral"));
        }
        if (this._save) {
            lDAPSearchConstraints = (LDAPSearchConstraints)this._ldc.getSearchConstraints().clone();
            lDAPSearchConstraints.setServerControls(new LDAPControl("2.16.840.1.113730.3.4.2", true, null));
            try {
                this._ldc.modify(this._dn, lDAPModificationSet, (LDAPConstraints)lDAPSearchConstraints);
                this._isObjectModified = true;
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{this._dn, this.getLDAPErrorMessage(lDAPException)};
                DSUtil.showErrorDialog((Component)((Object)this), "modifying-object-error-title", "modifying-object-error-msg", stringArray, this._section);
            }
        } else if (lDAPModificationSet.size() > 0) {
            this._isObjectModified = true;
            this._set = lDAPModificationSet;
        }
        super.okInvoked();
    }

    protected void helpInvoked() {
        DSUtil.help("configuration-set-referral");
    }

    protected void checkEnablingState() {
        if (this._cbReferralsEnabled.isSelected()) {
            this._tfNewReferral.setEnabled(true);
            this._bDelete.setEnabled(true);
            this._bConstruct.setEnabled(true);
            this._bAdd.setEnabled(true);
            this._tfNewReferral.setEnabled(true);
            boolean bl = !this._saveReferralsEnabled;
            boolean bl2 = this.isReferralListDirty();
            this._bAdd.setEnabled(!this._tfNewReferral.getText().trim().equals(""));
            boolean bl3 = bl || bl2 || this._isAuthModified;
            boolean bl4 = this._referralListData.getSize() > 0;
            this.setOKButtonEnabled(bl3 && bl4);
        } else {
            this._tfNewReferral.setEnabled(false);
            this._bDelete.setEnabled(false);
            this._bConstruct.setEnabled(false);
            this._bAdd.setEnabled(false);
            this._tfNewReferral.setEnabled(false);
            boolean bl = this._saveReferralsEnabled;
            this.setOKButtonEnabled(bl);
        }
        this._referralList.setBackground(this._tfNewReferral.getBackground());
        this.checkDeleteReferralButton();
        this.checkChangeReferralButton();
        this.checkAuthReferralButton();
    }

    private boolean isReferralListDirty() {
        boolean bl = false;
        if (this._referralList != null) {
            boolean bl2 = bl = this._referralListData.getSize() != this._saveReferralValues.size();
            if (!bl) {
                Enumeration enumeration = this._referralListData.elements();
                while (enumeration.hasMoreElements() && !bl) {
                    boolean bl3 = bl = !this._saveReferralValues.contains(enumeration.nextElement());
                }
            }
        }
        return bl;
    }

    private void actionDeleteReferral() {
        Object[] objectArray = this._referralList.getSelectedValues();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this._referralListData.removeElement(objectArray[n]);
                ++n;
            }
        }
        this._tfNewReferral.setText("");
    }

    private void actionAddOrChangeReferral(boolean bl) {
        int n;
        String string = this._tfNewReferral.getText().trim();
        boolean bl2 = true;
        if (!DSUtil.isValidLDAPUrl(string) && (n = DSUtil.showConfirmationDialog((Component)this._frame, "LDAPUrl-no-good", (String)null, "mappingtree-referral")) != 0) {
            bl2 = false;
        }
        if (bl2) {
            if (bl) {
                n = this._referralList.getSelectedIndex();
                this._referralListData.setElementAt(string, n);
            } else {
                this._referralListData.addElement(string);
            }
            this._tfNewReferral.setText("");
            this._bAdd.setEnabled(false);
            this._bChange.setEnabled(false);
        }
    }

    private void actionConstructReferral() {
        LDAPUrlDialog lDAPUrlDialog = new LDAPUrlDialog(this._frame);
        lDAPUrlDialog.packAndShow();
        LDAPUrl lDAPUrl = lDAPUrlDialog.getLDAPUrl();
        if (lDAPUrl != null) {
            this._tfNewReferral.setText(lDAPUrl.getUrl());
        }
    }

    private void actionAuthentication() {
        boolean bl;
        LDAPUrl lDAPUrl;
        int n = this._referralList.getSelectedIndex();
        String string = (String)this._referralListData.elementAt(n);
        try {
            lDAPUrl = new LDAPUrl(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException("This URL should be correct: " + string);
        }
        String string2 = this._connectionPool.getAuthDN(lDAPUrl);
        String string3 = this._connectionPool.getAuthPassword(lDAPUrl);
        do {
            PasswordDialog passwordDialog = new PasswordDialog(this._frame, string2, string3, this._resource.getString(this._section, "authentication-dialog-title"));
            passwordDialog.show();
            if (passwordDialog.isCancel()) {
                bl = false;
                continue;
            }
            this.setBusyCursor(true);
            try {
                this._connectionPool.registerAuth(lDAPUrl, passwordDialog.getUsername(), passwordDialog.getPassword(), true);
                bl = false;
                this._isAuthModified = true;
            }
            catch (LDAPException lDAPException) {
                bl = true;
                DSUtil.showLDAPErrorDialog(this._frame, lDAPException, "109-title");
            }
            this.setBusyCursor(false);
        } while (bl);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.checkNewReferralTextField();
        this.checkDeleteReferralButton();
        this.checkChangeReferralButton();
        this.checkAuthReferralButton();
    }

    protected void checkDeleteReferralButton() {
        this._bDelete.setEnabled(!this._referralList.isSelectionEmpty());
    }

    protected void checkChangeReferralButton() {
        int n = this._referralList.getMinSelectionIndex();
        int n2 = this._referralList.getMaxSelectionIndex();
        int n3 = n == -1 ? 0 : n2 - n + 1;
        int n4 = this._tfNewReferral.getText().trim().length();
        this._bChange.setEnabled(n3 == 1 && n4 >= 1);
    }

    protected void checkAuthReferralButton() {
        boolean bl;
        String string;
        int n;
        int n2 = this._referralList.getMinSelectionIndex();
        int n3 = this._referralList.getMaxSelectionIndex();
        int n4 = n = n2 == -1 ? 0 : n3 - n2 + 1;
        if (n == 1) {
            try {
                String string2 = (String)this._referralListData.elementAt(n2);
                LDAPUrl lDAPUrl = new LDAPUrl(string2);
                String string3 = this._connectionPool.getAuthDN(lDAPUrl);
                string = string3 == null ? this._resource.getString(this._section, "anonymous-dn-label") : this._resource.getString(this._section, "bind-dn-label", string3);
                bl = true;
            }
            catch (MalformedURLException malformedURLException) {
                bl = false;
                string = this._resource.getString(this._section, "non-standard-url-label");
            }
        } else {
            bl = false;
            string = "";
        }
        this._bAuthentication.setEnabled(bl);
        this._lBindDN.setText(string);
    }

    protected void checkNewReferralTextField() {
        int n = this._referralList.getMinSelectionIndex();
        int n2 = this._referralList.getMaxSelectionIndex();
        int n3 = n == -1 ? 0 : n2 - n + 1;
        String string = n3 == 1 ? (String)this._referralListData.elementAt(n) : "";
        this._tfNewReferral.setText(string);
    }

    private String getLDAPErrorMessage(LDAPException lDAPException) {
        String string = lDAPException.errorCodeToString();
        String string2 = lDAPException.getLDAPErrorMessage();
        if (string2 != null && string2.length() > 0) {
            string = string + ". " + string2;
        }
        return string;
    }
}

