/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSSchemaHelper;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GlobalConstants;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.OClassesCellRenderer;
import com.netscape.admin.dirserv.panel.ObjectClassDialog;
import com.netscape.admin.dirserv.panel.SchemaUtility;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.Framework;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.UITools;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSchemaElement;

public class SchemaObjectClassesPanel
extends BlankPanel
implements ListSelectionListener {
    private JLabel _parentLabel;
    private JList _ocListBox;
    private JList _reqListBox;
    private JList _allowListBox;
    private JTextField _oidText;
    private JTextField _parentText;
    private JButton _createButton;
    private JButton _deleteButton;
    private JButton _editButton;
    private JButton _helpButton;
    private DefaultListModel _ocModel;
    private DefaultListModel _reqAttrModel;
    private DefaultListModel _allowAttrModel;
    private LDAPConnection _ld;
    private LDAPObjectClassSchema _currOCEntry;
    private static String OID_UNKNOWN_STR = null;
    private static String PARENT_UNKNOWN_STR = null;
    private static final String _section = "objectclasses";

    public SchemaObjectClassesPanel(IDSModel iDSModel) {
        super(iDSModel, _section, false);
        this._helpToken = "configuration-schema-objclass-help";
        this._refreshWhenSelect = false;
    }

    public void init() {
        ((Framework)this.getModel().getFrame()).setBusyCursor(true);
        if (OID_UNKNOWN_STR == null) {
            OID_UNKNOWN_STR = DSUtil._resource.getString(_section, "unknown-label");
        }
        if (PARENT_UNKNOWN_STR == null) {
            PARENT_UNKNOWN_STR = DSUtil._resource.getString(_section, "noParent");
        }
        this._ocModel = new DefaultListModel();
        this._reqAttrModel = new DefaultListModel();
        this._allowAttrModel = new DefaultListModel();
        this._ld = this.getModel().getServerInfo().getLDAPConnection();
        this.updateTables();
        this.createLayout();
        ((Framework)this.getModel().getFrame()).setBusyCursor(false);
    }

    private void createLayout() {
        int n = UIFactory.getComponentSpace();
        int n2 = UIFactory.getDifferentSpace();
        this._myPanel.setBorder(new EmptyBorder(this.getBorderInsets()));
        this._myPanel.setLayout(new GridBagLayout());
        JLabel jLabel = this.makeJLabel(_section, "intro");
        jLabel.setLabelFor(this);
        EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 0);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(emptyBorder);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel2 = UIFactory.makeJLabel(_section, _section);
        jPanel.add(jLabel2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JLabel jLabel3 = UIFactory.makeJLabel(_section, "reqAttributesList");
        jPanel2.add(jLabel3);
        jPanel2.setBorder(emptyBorder);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JLabel jLabel4 = UIFactory.makeJLabel(_section, "allowAttributesList");
        jPanel3.add(jLabel4);
        jPanel3.setBorder(emptyBorder);
        this._ocListBox = this.createListBox(this._ocModel, 2);
        jLabel2.setLabelFor(this._ocListBox);
        this._ocListBox.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (DSUtil.isStandardSchema((LDAPSchemaElement)SchemaObjectClassesPanel.this._currOCEntry)) {
                    return;
                }
                if (mouseEvent.getClickCount() == 2) {
                    LDAPSchema lDAPSchema = SchemaObjectClassesPanel.this.getModel().getSchema();
                    ObjectClassDialog objectClassDialog = new ObjectClassDialog(SchemaObjectClassesPanel.this.getModel(), true, SchemaObjectClassesPanel.this._currOCEntry, lDAPSchema);
                    if (objectClassDialog != null) {
                        objectClassDialog.packAndShow();
                    }
                }
            }
        });
        this._ocListBox.clearSelection();
        this._reqListBox = this.createListBox(this._reqAttrModel, 1);
        jLabel3.setLabelFor(this._reqListBox);
        this._allowListBox = this.createListBox(this._allowAttrModel, 2);
        jLabel4.setLabelFor(this._allowListBox);
        this._ocListBox.addListSelectionListener(this);
        jPanel.add(this.createScrollPane(this._ocListBox));
        jPanel2.add(this.createScrollPane(this._reqListBox));
        jPanel3.add(this.createScrollPane(this._allowListBox));
        JPanel jPanel4 = this.createButtonsPanel();
        JPanel jPanel5 = this.createTextArea();
        JPanel jPanel6 = this.createAttrPanel(jPanel2, jPanel3);
        this.resetGBC();
        this._gbc.gridwidth = 0;
        this._gbc.weightx = 1.0;
        this._gbc.fill = 2;
        this._gbc.insets = new Insets(0, 0, n2, 0);
        this._myPanel.add((Component)jLabel, this._gbc);
        this._myPanel.add((Component)jPanel5, this._gbc);
        this._gbc.gridwidth = -1;
        this._gbc.weighty = 1.0;
        this._gbc.fill = 1;
        this._gbc.insets = new Insets(0, 0, 0, 0);
        this._myPanel.add((Component)jPanel, this._gbc);
        this._gbc.gridwidth = 0;
        this._gbc.insets.left = n2;
        this._myPanel.add((Component)jPanel6, this._gbc);
        this.resetGBC();
        this._gbc.weightx = 1.0;
        this._gbc.insets = new Insets(n2, 0, 0, 0);
        this._gbc.fill = 2;
        this._gbc.gridwidth = 0;
        this._myPanel.add((Component)jPanel4, this._gbc);
        this._ocListBox.setSelectedIndex(0);
    }

    public void select(IResourceObject iResourceObject, IPage iPage) {
        Debug.println((String)"SchemaObjectClassesPanel.select ");
        if (!this._isInitialized) {
            this.init();
            this._isInitialized = true;
            this.clearDirtyFlag();
        } else if (this.isDirty()) {
            return;
        }
    }

    public boolean refresh() {
        Debug.println((String)"SchemaObjectClasses.refresh");
        ((Framework)this.getModel().getFrame()).setBusyCursor(true);
        this.getModel().setSchema(null);
        this.updateTables();
        ((Framework)this.getModel().getFrame()).setBusyCursor(false);
        return true;
    }

    private void updateTables() {
        LDAPSchema lDAPSchema = this.getModel().getSchema();
        if (lDAPSchema == null) {
            Debug.println((String)"SchemaObjectClassesPanel.updateTables: no schema available");
            return;
        }
        this._ocModel.removeAllElements();
        Enumeration enumeration = lDAPSchema.getObjectClassNames();
        while (enumeration.hasMoreElements()) {
            SchemaUtility.InsertElement(this._ocModel, enumeration.nextElement());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = (String)this._ocListBox.getSelectedValue();
        ObjectClassDialog objectClassDialog = null;
        ((Framework)this.getModel().getFrame()).setBusyCursor(true);
        if (object.equals(this._createButton)) {
            LDAPSchema lDAPSchema = this.getModel().getSchema();
            objectClassDialog = new ObjectClassDialog(this.getModel(), false, lDAPSchema);
        } else if (object.equals(this._editButton) && string != null) {
            LDAPSchema lDAPSchema = this.getModel().getSchema();
            objectClassDialog = new ObjectClassDialog(this.getModel(), true, this._currOCEntry, lDAPSchema);
        } else if (object.equals(this._deleteButton) && string != null) {
            int n = 0;
            boolean bl = BlankPanel.requiresConfirmation(GlobalConstants.PREFERENCES_CONFIRM_DELETE_OBJECTCLASS);
            if (bl) {
                n = DSUtil.showConfirmationDialog((Component)this.getModel().getFrame(), "confirm-delete", string, _section);
            }
            while (n == 0) {
                try {
                    this.confirmUpdate(string);
                    this.refresh();
                    this._ocListBox.setSelectedIndex(0);
                    return;
                }
                catch (LDAPException lDAPException) {
                    ((Framework)this.getModel().getFrame()).setBusyCursor(false);
                    if (lDAPException.getLDAPResultCode() == 50) {
                        DSUtil.showPermissionDialog((Component)this.getModel().getFrame(), this._ld);
                        if (this.getModel().getNewAuthentication(false)) continue;
                        return;
                    }
                    DSUtil.showLDAPErrorDialog(this.getModel().getFrame(), lDAPException, "111-title");
                    return;
                }
            }
            this.getModel().notifyAuthChangeListeners();
        } else if (object.equals(this._helpButton)) {
            this.helpCallback();
        }
        if (objectClassDialog != null) {
            objectClassDialog.packAndShow();
            string = objectClassDialog.getObject();
            if (string == null) {
                ((Framework)this.getModel().getFrame()).setBusyCursor(false);
                return;
            }
            this.refresh();
            this._ocListBox.setSelectedValue("top", false);
            this._ocListBox.setSelectedValue(string, true);
        }
        ((Framework)this.getModel().getFrame()).setBusyCursor(false);
    }

    private void confirmUpdate(String string) throws LDAPException {
        Debug.println((String)("SchemaObjectClasses.confirmUpdate: deleting " + this._currOCEntry.getValue()));
        this._currOCEntry.remove(this._ld);
        DSUtil.showInformationDialog((Component)this.getModel().getFrame(), "deleted", string, _section);
        this._ocModel.removeElement(string);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object.equals(this._ocListBox)) {
            if (this._ocModel.size() < 1) {
                return;
            }
            String string = (String)this._ocListBox.getSelectedValue();
            if (string == null) {
                this._reqAttrModel.removeAllElements();
                this._allowAttrModel.removeAllElements();
                this._oidText.setText("");
                this._parentText.setText("");
                return;
            }
            LDAPSchema lDAPSchema = this.getModel().getSchema();
            this._currOCEntry = lDAPSchema.getObjectClass(string);
            this.enableButtons(!DSUtil.isStandardSchema((LDAPSchemaElement)this._currOCEntry));
            String string2 = this._currOCEntry.getID();
            String[] stringArray = this._currOCEntry.getSuperiors();
            if (string2.length() == 0) {
                string2 = OID_UNKNOWN_STR;
            }
            if (stringArray == null) {
                stringArray = new String[]{PARENT_UNKNOWN_STR};
            } else if (stringArray.length == 0) {
                stringArray = new String[]{PARENT_UNKNOWN_STR};
            } else if (stringArray[0] == null) {
                stringArray = new String[]{PARENT_UNKNOWN_STR};
            } else if (stringArray[0].length() == 0) {
                stringArray = new String[]{PARENT_UNKNOWN_STR};
            }
            String string3 = stringArray[0];
            int n = 1;
            while (n < stringArray.length) {
                string3 = ", " + stringArray[n];
                ++n;
            }
            if (stringArray.length > 1) {
                this._parentLabel.setText(DSUtil._resource.getString(_section, "parents-label"));
            } else {
                this._parentLabel.setText(DSUtil._resource.getString(_section, "parent-label"));
            }
            this._oidText.setText(string2);
            this._parentText.setText(string3);
            Hashtable hashtable = new Hashtable();
            DSSchemaHelper.allOptionalAttributesWithCase(this._currOCEntry, lDAPSchema, hashtable);
            Enumeration enumeration = hashtable.elements();
            hashtable = new Hashtable();
            DSSchemaHelper.allRequiredAttributesWithCase(this._currOCEntry, lDAPSchema, hashtable);
            Enumeration enumeration2 = hashtable.elements();
            this._reqAttrModel.removeAllElements();
            this._allowAttrModel.removeAllElements();
            while (enumeration2.hasMoreElements()) {
                SchemaUtility.InsertElement(this._reqAttrModel, enumeration2.nextElement());
            }
            while (enumeration.hasMoreElements()) {
                Object v = enumeration.nextElement();
                if (this._reqAttrModel.contains(v)) continue;
                SchemaUtility.InsertElement(this._allowAttrModel, v);
            }
        }
    }

    private void enableButtons(boolean bl) {
        this._editButton.setEnabled(bl);
        this._deleteButton.setEnabled(bl);
    }

    private JPanel createButtonsPanel() {
        this._createButton = this.makeJButton(_section, "create");
        this._editButton = this.makeJButton(_section, "edit");
        this._deleteButton = this.makeJButton(_section, "delete");
        this._helpButton = this.makeJButton("general", "Help");
        JButton[] jButtonArray = new JButton[]{this._createButton, this._editButton, this._deleteButton};
        UIFactory.resizeButtons(jButtonArray);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridwidth = 1;
        int n = UIFactory.getComponentSpace();
        int n2 = 0;
        while (n2 < jButtonArray.length) {
            jPanel.add((Component)jButtonArray[n2], gridBagConstraints);
            jPanel.add(Box.createHorizontalStrut(n));
            ++n2;
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this._helpButton, gridBagConstraints);
        return jPanel;
    }

    private JPanel createAttrPanel(JPanel jPanel, JPanel jPanel2) {
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        this.resetGBC();
        this._gbc.insets.top = 0;
        this._gbc.anchor = 11;
        this._gbc.fill = 1;
        this._gbc.weightx = 1.0;
        this._gbc.weighty = 1.0;
        jPanel3.add((Component)jPanel, this._gbc);
        this._gbc.insets.top = UIFactory.getDifferentSpace();
        this._gbc.gridx = 0;
        jPanel3.add((Component)jPanel2, this._gbc);
        return jPanel3;
    }

    private JPanel createTextArea() {
        int n = UIFactory.getComponentSpace();
        int n2 = UIFactory.getDifferentSpace();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = this.makeJLabel(_section, "oid");
        this._parentLabel = this.makeJLabel(_section, "parent");
        this._oidText = this.makeJTextField();
        jLabel.setLabelFor(this._oidText);
        this._oidText.setEditable(false);
        this._parentText = this.makeJTextField();
        this._parentLabel.setLabelFor(this._parentText);
        this._parentText.setEditable(false);
        this.resetGBC();
        this._gbc.gridx = 0;
        this._gbc.gridwidth = -1;
        this._gbc.weightx = 0.0;
        this._gbc.fill = 0;
        this._gbc.insets = new Insets(0, 0, 0, n);
        jPanel.add((Component)this._parentLabel, this._gbc);
        this._gbc.gridx = 1;
        this._gbc.gridwidth = 0;
        this._gbc.insets.right = 0;
        this._gbc.weightx = 1.0;
        this._gbc.fill = 2;
        jPanel.add((Component)this._parentText, this._gbc);
        this._gbc.gridx = 0;
        this._gbc.gridwidth = -1;
        this._gbc.weightx = 0.0;
        this._gbc.fill = 0;
        this._gbc.insets.right = n;
        this._gbc.insets.top = n2;
        jPanel.add((Component)jLabel, this._gbc);
        this._gbc.gridx = 1;
        this._gbc.gridwidth = 0;
        this._gbc.insets.right = 0;
        this._gbc.weightx = 1.0;
        this._gbc.fill = 2;
        jPanel.add((Component)this._oidText, this._gbc);
        return jPanel;
    }

    private JList createListBox(DefaultListModel defaultListModel, int n) {
        JList<String> jList = new JList<String>(defaultListModel);
        jList.setCellRenderer(new OClassesCellRenderer());
        jList.setPrototypeCellValue("1234567890 1234567890");
        jList.setVisibleRowCount(n);
        return jList;
    }

    private JScrollPane createScrollPane(JList jList) {
        JScrollPane jScrollPane = new JScrollPane(jList, 20, 30);
        jScrollPane.setAlignmentX(0.0f);
        jScrollPane.setAlignmentY(0.0f);
        jScrollPane.setBorder(UITools.createLoweredBorder());
        return jScrollPane;
    }
}

